<?php
include("../db/cn.php");
include("common/tx.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

if (isset($_GET['query'])) {
    $query = $connection->real_escape_string($_GET['query']);
    $sql = "SELECT product_id, product_name, retail_price, trade_price, t_perprice, tpperpack, supplier, company, product_unit, quantity 
            FROM products 
            WHERE product_name LIKE '%$query%'";

    $result = $connection->query($sql);

    $suggestions = "";
    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' 
            data-product-id='" . $row['product_id'] . "' 
            data-product-quantity='" . $row['quantity'] . "' 
            data-retail-price='" . $row['tpperpack'] . "' 
            data-trade-price='" . $row['tpperpack'] . "' 
            data-supplier='" . $row['supplier'] . "' 
            data-company='" . $row['company'] . "' 
            data-product-unit='" . $row['product_unit'] . "'>" 
            . $row['product_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}

if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT supplier_name, supplier_id, supplier_phone 
            FROM supplier 
            WHERE supplier_name LIKE '%$customerName%' LIMIT 5";
    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $crName = $row['supplier_name'];
        $crId = $row['supplier_id'];
        $phone = $row['supplier_phone'];

        $remainSql = "SELECT closing_balance 
                      FROM supplier_closing 
                      WHERE supplier_name = '$crName' 
                      ORDER BY id DESC LIMIT 1";
        $remainResult = $connection->query($remainSql);
        $remainBalance = "0";
        if ($remainResult && $remainResult->num_rows > 0) {
            $remainRow = $remainResult->fetch_assoc();
            $remainBalance = $remainRow['closing_balance'];
        }

        $suggestions .= "<div class='dropdown-item' 
            data-customer-name='$crName' 
            data-customer-id='$crId' 
            data-customer-phone='$phone' 
            data-remain-balance='$remainBalance'>$crName</div>";
    }

    echo $suggestions;
    exit;
}

$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;

if (isset($_GET['inv_id'])) {
    $order_id = $_GET['inv_id'];

    if (!empty($order_id)) {
        $stmt = $connection->prepare("SELECT inv_id FROM purchase WHERE inv_id LIKE ? GROUP BY inv_id");
        $like_order_id = "%" . $order_id . "%";
        $stmt->bind_param("s", $like_order_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo '<div class="dropdown-item" data-order-id="' . $row['inv_id'] . '">' . $row['inv_id'] . '</div>';
            }
        } else {
            echo '<div class="dropdown-item">No Invoice found</div>';
        }

        $stmt->close();
    }

    $connection->close();
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['inv_bill'])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);

    // ✅ Fetch last bill_no from purchase table
    $result = $connection->query("SELECT bill_no FROM purchase ORDER BY id DESC LIMIT 1");
    if ($result && $row = $result->fetch_assoc()) {
        $lastBillNo = (int)$row['bill_no'];
    } else {
        $lastBillNo = 0;
    }
    $billNo = str_pad($lastBillNo + 1, 4, "0", STR_PAD_LEFT);

    // ✅ Also generate inv_id separately
    $orderId = "INV" . rand(10000, 99999);
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $pre_amount = $_POST["pre_amount"];
    $grand_amount = $_POST["grand_amount"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $bacthNo = $product['bacthNo'];
        $Expiry = $product['Expiry'];
        $Exper = $product['Expercentage'];
        $Whper = $product['Whpercentage'];
        $Noofunit = $product['noofUnit'];
        $packQty = $product['packQty'];
        $bonusQty = $product['bonusQty'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = (int)$tradePrice * (int)$productQuantity;
        $tp = $productTotal / $productQuantity;

        $sql = "INSERT INTO purchase (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            noofunit,
            pack_quantity,
            bonus_quantity,
            product_total,
            bonus,
            discount,
            ex_percentage,
            wh_percentage,
            batch_no,
            expiry_d,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            pre_amount,
            grand_amount,
            cash_amount,
            change_amount,
            inv_id,
            bill_no,
            r_inv_id,
            status,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$Noofunit',
            '$packQty',
            '$bonusQty',
            '$productTotal',
            '',
            '$discount',
            '$Exper',
            '$Whper',
            '$bacthNo',
            '$Expiry',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$pre_amount',
            '$grand_amount',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$billNo',
            '',
            '',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";

        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        $updateSql = "UPDATE products 
                      SET total_quantity = total_quantity + $productQuantity, 
                          total_amount = total_amount + $netAmount, 
                          tpperpack = $tp  
                      WHERE product_name = '$productName'";
        if ($connection->query($updateSql) !== TRUE) {
            echo "Error updating product quantity: " . $connection->error;
            ob_end_flush();
            exit;
        }
        
         if ($paidBy=='Credit') {
    // Overwrite remain_balance (no addition)
    $updateCR = "UPDATE supplier_closing 
                 SET closing_balance = $change_amount
                 WHERE supplier_name = '$customerName'";

    if (!$connection->query($updateCR)) {
         ("Error updating Supplier Ledger: " . $connection->error);
    }
}
    }
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'purchase_n.php';</script>";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST'&& isset($_POST['return_bill'])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
	$r_inv_id = $_POST["r_inv_id"];
    $orderId = $r_inv_id ;
	$status = 'return';
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = $tradePrice * $productQuantity;
        $sql = "INSERT INTO purchase (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            noofunit,
            pack_quantity,
            bonus_quantity,
            product_total,
            bonus,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            pre_amount,
            grand_amount,
            cash_amount,
            change_amount,
            inv_id,
			r_inv_id,
			status,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$Noofunit',
            '$packQty',
            '$bonusQty',
            '$productTotal',
            '',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$pre_amount',
            '$grand_amount',
            '$cash_amount',
            '$change_amount',
            '$orderId',
			'$r_inv_id',
			'$status',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        $updateSql = "UPDATE products SET total_quantity = total_quantity - $productQuantity, total_amount = total_amount - $netAmount WHERE product_name = '$productName'";
        if ($connection->query($updateSql) !== TRUE) {
            echo "Error updating product quantity: " . $connection->error;
            ob_end_flush();
            exit;
        }
    }
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'purchase_n.php';</script>";
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $tx; ?></title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
 #table-container-wrapper {
    max-height: 590px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
.form-control{
    font-weight:700;
    color:#000;
}
.btn{
    font-weight:700;
}
.btn-primary{
    background:#0A4657;
    color:#fff;
    border:1px #0a4657 solid ;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:79px;">
            <img src="../img/logo231.png" width="66" height="66" style="background:#fff; border-radius:50px;margin-top:5px;"></a>
        </div>
        <div class="col-sm-6">
        <h3 style="color:#fff; font-weight:700; text-transform:uppercase; text-align:center; line-height:60px; font-size:33px;">
            <?php echo $tx; ?>
            </h3>
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php">
            <button type="button" class="btn btn-light mt-3" style="float:right;" >Back</button>
            </a>
        </div>
    </div>
</div>
<div class="container-fluid">
    <form action="purchase_n.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-3" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Product</span>
                    </div>
                    <input type="text" class="form-control" id="productInput" placeholder="Start typing a product name..." autocomplete="off">
                    <div class="dropdown-menu" id="suggestions"></div>
                </div>
                <hr>
            <div class="">
                <div class="input-group mb-3 ">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Batch</span>
                    </div>
                    <input type="text" id="batch_no" name="batch_no" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3 ">
                   <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Expiry</span>
                    </div>
                    <input type="date" id="expiry_d" name="expiry_d" class="form-control" placeholder="">
                     
                </div>
                </div>
                <hr>
            <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Pack Qty</span>
                    </div>
                    <input type="text" id="pack_quantity" name="pack_quantity" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3 col-6">
                   
                    <input type="text" id="noofunit" name="noofunit" class="form-control" placeholder="">
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">No of Unit</span>
                    </div>
                </div>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Loose.Qty</span>
                    </div>
                    <input type="text" id="lose_quantity" name="lose_quantity" class="form-control" placeholder="" >
                </div>
                <div class="input-group mb-3 col-6">
                   
                    <input type="text" id="bonus_quantity" name="bonus_quantity" class="form-control" placeholder="" >
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Bonus.Qty</span>
                    </div>
                </div>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">P.Qty</span>
                    </div>
                    <input type="text" id="quantity" name="quantity" class="form-control" placeholder="" readonly>
                </div>
                 <div class="input-group mb-3 col-6">
                    
                    <input type="text" id="total_quantity" name="total_quantity" class="form-control" 
                    placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">T.Qty</span>
                    </div>
                </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Price / Unit</span>
                    </div>
                    <input type="text" id="retail_price" name="retail_price" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="total_amount" name="total_amount" class="form-control" placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">-/ PKR</span>
                    </div>
                </div>
                <div class="row">
                    <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis %</span>
                    </div>
                    <input type="text" id="percentage" name="percentage" class="form-control"  placeholder="">
                </div>
                <div class="input-group mb-3 col-6">
                   
                    <input type="text" id="ex_percentage" name="ex_percentage" class="form-control"  
                    placeholder="">
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Ex.%</span>
                    </div>
                </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">WH TAX</span>
                    </div>
                    <input type="text" id="wh_percentage" name="wh_percentage" class="form-control"  placeholder="">
                </div>
                
                 <div>
                    <div>
                    </div>
                    <input type="hidden" id="tax_percentage" name="tax_percentage" class="form-control"  placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="trade_price" name="trade_price" class="form-control" placeholder="" readonly>
                </div>
                <br>
                <button type="button" class="form-control btn btn-dark" id="makeEntry" style="color:#fff;">Make Entry</button>
                <hr>
                <div class="row">
                     <div class="col-6">
                <a href="purchase_detail_v.php" class="btn btn-primary form-control text-white">View Purchase INV</a>
            </div>
                    <div class="col-6">
                        <button type="button" class="form-control btn btn-dark" style="color:#fff;" onclick="location.reload();">Refresh</button>
                    </div>
           
                    
                </div>
                
        </div>
            <div class="col-sm-9">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="">
                        <div class="form-group">
                            
                            <input type="hidden" class="form-control in_form" name="customer_type">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Supplier Name</label>
                            <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                            <div class="dropdown-menu" id="customer_suggestions"></div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Supplier Phone</label>
                            <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                        </div>
                    </div>
                    <div class="">
                        <div class="">
                      
                            <input type="hidden" id="customer_id" name="customer_id" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-4">
                    <div class="form-group">
                        <label>Return ID</label>
                        <input type="text" id="r_order_id" name="r_inv_id" class="form-control in_form">
                        <div id="order_suggestions" class="dropdown-menu" style="display: none;"></div>
                    </div>
                </div>
                </div>
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12 table-responsive" style="height:600px; overflow-y:auto;">
                        <table class="table table-borderless bg-white table-sm text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#0A4657;font-weight:700; font-size:13px;">
                                
                                <td>Item Code</td>
                                <td>Description</td>
                                <td>Pack Qty</td>
                                <td>No.of Unit</td>
                                <td>Bonus Qty</td>
                                <td>Total Qty</td>
                                <td>Unit Price</td>
                                <td>Amount</td>
                                <td>% Dis</td>
                                <td>Ex-Per</td>
                                <td>WH-Per</td>
                                <td>Tax</td>
                                <td>Batch#</td>
                                <td>Expiry</td>
                                <td>Net Amount</td>
                                <td>Action</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Total</label>
                                    <input type="number" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                             <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Previous</label>
                                    <input type="number" id="pre_amount" name="pre_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Grand Total</label>
                                    <input type="number" id="grand_amount" name="grand_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount" name="discount_amount" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                               
                                    <input type="hidden" id="discount_percent" name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Paid</label>
                                    <input type="number" id="cash_received" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Remaining</label>
                                    <input type="number" id="cash_return" step="0.01" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                
                                  
                                    <input type="hidden" value="0" id="tax" name="tax" class="form-control in_form input-height"  readonly>
                             
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method2" class="form-control in_form">
                                         <option>Credit</option>
                                        <option>Cash</option>
                                       
                                        <option value="bank1">Bank 1</option>
                                        <option value="bank2">Bank 2 </option>
                                        <option value="bank3">Bank 3</option>
                                        <option>Others</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-3">
                                <hr>
                                <button type="submit" class="btn btn-dark btn-sm" name="inv_bill">Generate Invoice</button>
                                 <button type="submit" class="btn btn-danger btn-sm" name="return_bill">Return Invoice</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const generateInvoiceButton = document.querySelector("button[name='inv_bill']");
    const returnInvoiceButton = document.querySelector("button[name='return_bill']");

    generateInvoiceButton.addEventListener("click", function(event) {
        const method = document.getElementById("method2").value;
        const supplierName = document.getElementById("customer_name").value.trim();

        // Check if method is "Credit" and supplier name is empty
        if (method === "Credit" && supplierName === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please fill in the Supplier Name for Credit method.");
        }
    });

    returnInvoiceButton.addEventListener("click", function(event) {
        const returnId = document.getElementById("r_order_id").value.trim();

        // Check if Return ID is empty when "Return Invoice" button is clicked
        if (returnId === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please enter a Return ID.");
        }
    });
});
</script>
<script>
    
document.addEventListener("DOMContentLoaded", function() {
    let currentFocus = -1;

    // Event listener for input field to trigger AJAX request
    document.getElementById("r_order_id").addEventListener("input", function() {
        var orderIdInput = this.value;
        if (orderIdInput.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?inv_id=" + encodeURIComponent(orderIdInput), true); // Sends request to the same page
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("order_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("order_suggestions").style.display = 'none';
        }
    });

    // Handle clicking on suggestion items
    document.getElementById("order_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectOrder(e.target);
        }
    });

    // Add keyboard navigation for dropdown items
    document.getElementById("r_order_id").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("order_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectOrder(items[currentFocus]);
                    }
                }
            }
        }
    });
    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectOrder(item) {
        var orderId = item.getAttribute('data-order-id');
        document.getElementById("r_order_id").value = orderId;
        document.getElementById("order_suggestions").style.display = 'none';
    }


       document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectCustomer(item) {
    var customerName = item.getAttribute('data-customer-name');
    var customerId = item.getAttribute('data-customer-id');
    var customerPhone = item.getAttribute('data-customer-phone');
    var remainBalance = item.getAttribute('data-remain-balance');

    document.getElementById("customer_name").value = customerName;
    document.getElementById("customer_phone").value = customerPhone;
    document.getElementById("customer_id").value = customerId;
    document.getElementById("pre_amount").value = remainBalance; // populate remain_balance

    document.getElementById("customer_suggestions").style.display = 'none';
}


function updateQuantity() {
    let packQty = parseFloat(document.getElementById("pack_quantity").value) || 0;
    let noOfUnit = parseFloat(document.getElementById("noofunit").value) || 0;
    let bonusQty = parseFloat(document.getElementById("bonus_quantity").value) || 0;
    let loseQty = parseFloat(document.getElementById("lose_quantity").value) || 0;

    let quantity = packQty * noOfUnit + loseQty;
    document.getElementById("quantity").value = quantity.toFixed(2);

    updateTotalQuantity(quantity, bonusQty);
    calculateTotalPrice();
}

function updateTotalQuantity(quantity, bonusQty = null) {
    if (bonusQty === null) {
        bonusQty = parseFloat(document.getElementById("bonus_quantity").value) || 0;
    }
    let totalQty = quantity + bonusQty;
    document.getElementById("total_quantity").value = totalQty.toFixed(2);
}

function calculateTotalPrice() {
    const quantity = parseFloat(document.getElementById("quantity").value) || 0;
    const pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
    const discountPercent = parseFloat(document.getElementById("percentage").value) || 0;
    const whPercent = parseFloat(document.getElementById("wh_percentage").value) || 0;
    const exPercent = parseFloat(document.getElementById("ex_percentage").value) || 0;

    // Step 1: Discount on retail price
    const afterDiscount = pricePerUnit - (discountPercent / 100) * pricePerUnit;

    // Step 2 & 3: Apply EX (minus) and WH (plus) both on afterDiscount
    const afterEx = afterDiscount - (exPercent / 100) * afterDiscount;
    const afterWh = afterEx + (whPercent / 100) * afterDiscount;

    // Step 4: Multiply by quantity
    const tradePrice = afterWh * quantity;

    // Base total without discounts
    const totalPrice = pricePerUnit * quantity;

    document.getElementById("total_amount").value = totalPrice.toFixed(2);
    document.getElementById("trade_price").value = Math.max(tradePrice, 0).toFixed(2);
}



// Bind updates
document.getElementById("pack_quantity").addEventListener("input", updateQuantity);
document.getElementById("noofunit").addEventListener("input", updateQuantity);
document.getElementById("lose_quantity").addEventListener("input", updateQuantity);
document.getElementById("bonus_quantity").addEventListener("input", () => {
    const quantity = parseFloat(document.getElementById("quantity").value) || 0;
    const bonusQty = parseFloat(document.getElementById("bonus_quantity").value) || 0;
    updateTotalQuantity(quantity, bonusQty);
});

document.getElementById("quantity").addEventListener("input", calculateTotalPrice);
document.getElementById("retail_price").addEventListener("input", calculateTotalPrice);
document.getElementById("percentage").addEventListener("input", calculateTotalPrice);
document.getElementById("tax_percentage").addEventListener("input", calculateTotalPrice);
document.getElementById("wh_percentage").addEventListener("input", calculateTotalPrice);
document.getElementById("ex_percentage").addEventListener("input", calculateTotalPrice);


    document.getElementById("suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectProduct(e.target);
        }
    });

    document.getElementById("productInput").addEventListener("input", function() {
        var query = this.value;
        if (query.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?query=" + query, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("suggestions").style.display = 'none';
        }
    });

    document.getElementById("productInput").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectProduct(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectProduct(item) {
        var selectedProduct = item.textContent;
        var retailPrice = item.getAttribute('data-retail-price');
        var productQuantity = item.getAttribute('data-product-quantity');
        var tradePrice = item.getAttribute('data-trade-price');
        var productId = item.getAttribute('data-product-id');
        var supplier = item.getAttribute('data-supplier');
        var company = item.getAttribute('data-company');
        var productUnit = item.getAttribute('data-product-unit');

        document.getElementById("productInput").value = selectedProduct;
        document.getElementById("retail_price").value = retailPrice;
        document.getElementById("productInput").setAttribute('data-product-id', productId);
        document.getElementById("productInput").setAttribute('data-product-quantity', productQuantity);
        document.getElementById("productInput").setAttribute('data-supplier', supplier);
        document.getElementById("productInput").setAttribute('data-company', company);
        document.getElementById("productInput").setAttribute('data-trade-price', tradePrice);
        document.getElementById("productInput").setAttribute('data-product-unit', productUnit);

        document.getElementById("suggestions").style.display = 'none';
        calculateTotalPrice();
    }

 document.getElementById("makeEntry").addEventListener("click", function() {
        var productInput = document.getElementById("productInput");
        var productId = productInput.getAttribute('data-product-id');
        var productQuantity = parseFloat(document.getElementById("quantity").value) || 0; // Parse the quantity and ensure it's a number
        var supplier = productInput.getAttribute('data-supplier');
        var company = productInput.getAttribute('data-company');

        var description = productInput.value;
        var quantity = productQuantity;
        var pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
        var bacthNo = document.getElementById("batch_no").value || 0;
        var Expiry = document.getElementById("expiry_d").value || 'No Exp.Date';
        var Expercentage = parseFloat(document.getElementById("ex_percentage").value) || 0;
        var Whpercentage = parseFloat(document.getElementById("wh_percentage").value) || 0;
        var packQty = parseFloat(document.getElementById("pack_quantity").value) || 0;
        var noofUnit = parseFloat(document.getElementById("noofunit").value) || 0;
        var bonusQty = parseFloat(document.getElementById("bonus_quantity").value) || 0;
        var totalPrice = parseFloat(document.getElementById("total_amount").value) || 0;
        var discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
        var netAmount = parseFloat(document.getElementById("trade_price").value) || 0;
        var tradePrice = productInput.getAttribute('data-trade-price');

        // Check if quantity is zero or negative before making the entry
        if (quantity <= 0) {
            alert("Product is not in stock. Cannot add entry.");
            return; // Stop execution if quantity is zero or negative
        }

        if (productId && description && quantity && pricePerUnit && totalPrice && netAmount) {
            var table = document.getElementById("productsTable");
            var row = table.insertRow();
            row.innerHTML = `
                <td style="display:none;">${quantity}</td>
                <td style="font-weight:700;">${productId}</td>
                <td style="color:#0A5064;font-weight:700;">${description}</td>
                <td style="font-weight:700;">${packQty}</td>
                <td style="font-weight:700;">${noofUnit}</td>
                <td style="font-weight:700;">${bonusQty}</td>
                <td style="font-weight:700;">${quantity}</td>
                <td style="font-weight:700;">${pricePerUnit}</td>
                <td style="font-weight:700;">${totalPrice}</td>
                <td style="font-weight:700;">${discountPercentage || '0.00'}</td>
                <td style="font-weight:700;">${Expercentage || '0.00'}</td>
                <td style="font-weight:700;">${Whpercentage || '0.00'}</td>
                <td style="font-weight:700;">0</td>
                <td style="font-weight:700;">${bacthNo}</td>
                <td style="font-weight:700;">${Expiry}</td>
                <td style="font-weight:700;">${netAmount}</td>
                <td style="display:none;">${supplier}</td>
                <td style="display:none;">${company}</td>
                <td style="display:none;">${tradePrice}</td>
                <td><button class="btn btn-danger btn-sm delete-row" style="font-weight:700;">X</button></td>
            `;

            row.querySelector(".delete-row").addEventListener("click", function() {
                row.remove();
                calculateTotalAmount();
            });

            calculateTotalAmount();

            var rows = document.querySelectorAll("#productsTable tr:not(:first-child)");
            var productData = [];
            rows.forEach(function(row) {
                var cells = row.querySelectorAll("td");
                var product = {
                    productId: cells[1].innerText,
                    description: cells[2].innerText,
                    packQty: cells[3].innerText,
                    noofUnit: cells[4].innerText,
                    bonusQty: cells[5].innerText,
                    quantity: cells[6].innerText,
                    pricePerUnit: cells[7].innerText,
                    totalPrice: cells[8].innerText,
                    discountPercentage: cells[9].innerText,
                    Expercentage: cells[10].innerText,
                    Whpercentage: cells[11].innerText,
                    tax: cells[12].innerText,
                    bacthNo: cells[13].innerText,
                    Expiry: cells[14].innerText,
                    netAmount: cells[15].innerText,
                    supplier: cells[16].innerText,
                    company: cells[17].innerText,
                    tradePrice: cells[18].innerText
                };
                productData.push(product);
            });

            document.getElementById("productData").value = JSON.stringify(productData);

            // Reset product fields after making an entry
            resetProductFields();
            
            
            productInput.focus();
            
        } else {
            alert("Some required fields are missing");
        }
    });

    function resetProductFields() {
        document.getElementById("productInput").value = '';
        document.getElementById("quantity").value = '';
        document.getElementById("pack_quantity").value = '';
        document.getElementById("bonus_quantity").value = '';
        document.getElementById("noofunit").value = '';
        document.getElementById("retail_price").value = '';
        document.getElementById("total_amount").value = '';
        document.getElementById("percentage").value = '';
        document.getElementById("trade_price").value = '';
        document.getElementById("ex_percentage").value = '';
        document.getElementById("wh_percentage").value = '';
        document.getElementById("lose_quantity").value = '';
        document.getElementById("total_quantity").value = '';
        document.getElementById("expiry_d").value = '';
        document.getElementById("batch_no").value = '';
        // Remove data attributes for the next product
        document.getElementById("productInput").removeAttribute('data-product-id');
        document.getElementById("productInput").removeAttribute('data-product-quantity');
        document.getElementById("productInput").removeAttribute('data-supplier');
        document.getElementById("productInput").removeAttribute('data-company');
        document.getElementById("productInput").removeAttribute('data-trade-price');
        document.getElementById("productInput").removeAttribute('data-product-unit');
    }

// Calculates total from table and updates bill & total inputs
function calculateTotalAmount() {
    var table = document.getElementById("productsTable");
    var rows = table.getElementsByTagName("tr");
    var total = 0;

    for (var i = 1; i < rows.length; i++) {
        var netAmountCell = rows[i].cells[15];
        var netAmount = parseFloat(netAmountCell.textContent.trim());
        if (!isNaN(netAmount)) {
            total += netAmount;
        }
    }

    var totalInput = document.getElementById("total-input");
    var billAmountInput = document.getElementById("bill-amount");

    totalInput.value = total.toFixed(2);
    billAmountInput.value = total.toFixed(2);

    updateDiscountAmount();
    updateGrandAmount();
}

// Updates discount amount and percent
function updateDiscountAmount() {
    var total = parseFloat(document.getElementById("total-input").value) || 0;
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var discountAmountInput = document.getElementById("discount_amount");
    var discountPercentInput = document.getElementById("discount_percent");

    if (!isNaN(billAmount) && !isNaN(total)) {
        var discountAmount = total - billAmount;
        discountAmountInput.value = Math.round(discountAmount);

        if (total > 0) {
            var discountPercent = (discountAmount / total) * 100;
            discountPercentInput.value = discountPercent.toFixed(2);
        } else {
            discountPercentInput.value = "0.00";
        }
    }
}

// Computes and updates grand total
function updateGrandAmount() {
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var preAmount = parseFloat(document.getElementById("pre_amount").value) || 0;
    var grandAmountInput = document.getElementById("grand_amount");

    var grandAmount = billAmount + preAmount;
    grandAmountInput.value = grandAmount.toFixed(2);

    calculateCashReturn();
}

// Calculates the change due
function calculateCashReturn() {
    var grandAmount = parseFloat(document.getElementById("grand_amount").value) || 0;
    var cashReceived = parseFloat(document.getElementById("cash_received").value) || 0;
    var cashReturnInput = document.getElementById("cash_return");

    if (!isNaN(grandAmount) && !isNaN(cashReceived)) {
        var cashReturn = grandAmount - cashReceived ;
        cashReturnInput.value = cashReturn.toFixed(2);
    }
}

// Event Listeners
function attachInputListener(id, callback) {
    var el = document.getElementById(id);
    if (el) {
        el.addEventListener("input", callback);
    }
}

attachInputListener("bill-amount", function() {
    updateDiscountAmount();
    updateGrandAmount();
});

attachInputListener("pre_amount", updateGrandAmount);
attachInputListener("cash_received", calculateCashReturn);

// Watch for programmatic changes to pre_amount value
(function watchPreAmount() {
    var preAmountEl = document.getElementById("pre_amount");
    var lastValue = preAmountEl ? preAmountEl.value : null;

    setInterval(function () {
        if (!preAmountEl) return;
        if (preAmountEl.value !== lastValue) {
            lastValue = preAmountEl.value;
            updateGrandAmount();
        }
    }, 300); // check every 300ms
})();

// Initial load
window.addEventListener("DOMContentLoaded", function () {
    calculateTotalAmount();
    updateGrandAmount();
});
});
</script>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>