<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include("db/cn.php");
include("common/tx.php");
ob_start();

if (
    isset($_SESSION['user_name']) &&
    isset($_SESSION['user_role']) &&
    isset($_SESSION['outlet_name']) &&
    isset($_SESSION['outlet_address'])
) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
} else {
    echo "Session variables not set. Please log in.";
    exit;
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        body {
            font-family: 'Quicksand', sans-serif;
        }

        .chart-container {
            position: relative;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
        }

        canvas {
            max-width: 100%;
            height: auto;
        }

        .bg-gradient-primary {
            background: #0A4657;
            color: #fff;
        }

        .btn-primary {
            background: #0A4657;
            color: #fff;
            border: 1px #0A4657 solid;
        }

        .btn-primary:hover {
            background: #fff;
            border: 1px #0A4657 solid;
            color: #0A4657;
        }

        .fa-download:hover {
            color: #953E39;
        }

        .btn {
            font-weight: 700;
        }
        tr{
            font-weight:600;
        }
    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <?php include("common/sd.php"); ?>

        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>
                    <?php include('common/log.php'); ?>
                </nav>

                <div class="container">
                    <div class="row">
                        <div class="col-sm-9">
                            <h3 style="color:#212529; font-weight:700;">Least Selling Product</h3>
                        </div>
                        <div class="col-sm-3"></div>
                    </div>
                </div>
                <div class="container-fluid">
                    <div class=" row">
                        <div class="col-1"></div>
                        <div class="col-10">
                            <br><br>
                         <form method="GET" class="mb-3">
                            <div class="row align-items-end g-2">
                                <div class="col-md-3">
                                    <label for="start_date" class="form-label">Start Date:</label>
                                    <input type="date" id="start_date" name="start_date" class="form-control" value="<?= $_GET['start_date'] ?? '' ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="end_date" class="form-label">End Date:</label>
                                    <input type="date" id="end_date" name="end_date" class="form-control" value="<?= $_GET['end_date'] ?? '' ?>">
                                </div>
                                <div class="col-md-6 d-flex gap-2">
                                    <div>
                                        <button type="submit" class="btn btn-dark">Filter</button>
                                    </div>&nbsp;
                                    <div>
                                        <button type="button" onclick="downloadPDF()" class="btn btn-danger">PDF</button>
                                    </div>&nbsp;
                                    <div>
                                        <a href="report_ls.php" class="btn btn-dark"><i class="fas fa-sync fa-1x"></i></a>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <div id="pdf-content">
                        <?php
                        $sr = 1;
                        $start = $_GET['start_date'] ?? '';
                        $end = $_GET['end_date'] ?? '';
                        
                        
                        
                        $sr = 1;
                        
                        $sql = "SELECT product_name, SUM(CAST(product_quantity AS UNSIGNED)) AS totalQty, COUNT(*) AS sale_count
                                FROM log_user_sales WHERE 1";
                        
                        if (!empty($start) && !empty($end)) {
                            $sql .= " AND DATE(date_time) BETWEEN '$start' AND '$end'";
                        }
                        
                        $sql .= " GROUP BY product_name HAVING sale_count < 5 ORDER BY sale_count ASC";
                        $leastResult = $connection->query($sql);
                        ?>
                        
                        
                        
                        <table class="table table-bordered text-center bg-white mt-2">
                            <thead style="background:#0A4657; color:#fff;">
                                <tr>
                                    <td>Sr#</td>
                                    <td>Product Name</td>
                                    <td>Product Qty</td>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($leastResult && $leastResult->num_rows > 0): ?>
                                    <?php while($row = $leastResult->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= $sr++; ?></td>
                                            <td><?= htmlspecialchars($row['product_name']); ?></td>
                                            <td><?= htmlspecialchars($row['totalQty']); ?></td>
                                        </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr><td colspan="3">No least selling product found in selected range.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        </div>
                        </div>
                         
                                <div class="col-1"></div>
                    </div>
                </div>

                <br><br><br>
            </div>

            <?php include("common/main_ft.php"); ?>
        </div>
    </div>

    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
function downloadPDF() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('p', 'mm', 'a4');

    html2canvas(document.querySelector("#pdf-content"), {
        scale: 2
    }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const imgProps = doc.getImageProperties(imgData);
        const pdfWidth = doc.internal.pageSize.getWidth();
        const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

        doc.text("Least Product Sales Report", 10, 10);
        doc.addImage(imgData, 'PNG', 10, 20, pdfWidth - 20, pdfHeight);
        doc.save("Least_product_sales_report.pdf");
    });
}
</script>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
</body>

</html>
