<?php
ob_start();
session_start(); // <-- important

include("../db/cn.php");
include("common/tx.php");

// Defensive: ensure $connection exists
if (!isset($connection)) {
    die("Database connection not found. Check db/cn.php");
}

// Get customer_name safely
$customer_name = "";
if (isset($_GET['customer_name'])) {
    $customer_name = trim($_GET['customer_name']);
    $customer_name = mysqli_real_escape_string($connection, $customer_name);
}

// initialize session variables safely
$userName = isset($_SESSION['user_name']) ? $_SESSION['user_name'] : '';
$userRole = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : '';
$outlet_address = isset($_SESSION['outlet_address']) ? $_SESSION['outlet_address'] : '';
$outlet_name = isset($_SESSION['outlet_name']) ? $_SESSION['outlet_name'] : '';

// Initialize totals to avoid undefined variables
$total_sales = 0;
$total_sales_return = 0;
$totalAmount = 0; // credit received (credit_paid)
$totalAmount_credit = 0; // opening amount
$pos_pass_get = 0;

// --------- compute totals using SUM in SQL (safer & simpler) ----------

// total credit sales (sum of discount_amount for credit sales, r_order_id blank)
$sql = "SELECT SUM(discount_amount) AS total_discount
        FROM log_user_sales
        WHERE customer_name = '$customer_name'
          AND paid_by = 'credit'
          AND (r_order_id = '' OR r_order_id IS NULL)";
$res = mysqli_query($connection, $sql);
if ($res) {
    $row = mysqli_fetch_assoc($res);
    $total_sales = isset($row['total_discount']) && $row['total_discount'] !== null ? (float)$row['total_discount'] : 0;
} else {
    // log or handle error
    error_log("Error (total sales): " . mysqli_error($connection));
}

// total credit sales return (status = 'refund')
$sql = "SELECT SUM(discount_amount) AS total_discount_return
        FROM log_user_sales
        WHERE customer_name = '$customer_name'
          AND paid_by = 'credit'
          AND status = 'refund'";
$res = mysqli_query($connection, $sql);
if ($res) {
    $row = mysqli_fetch_assoc($res);
    $total_sales_return = isset($row['total_discount_return']) && $row['total_discount_return'] !== null ? (float)$row['total_discount_return'] : 0;
} else {
    error_log("Error (total sales return): " . mysqli_error($connection));
}

// credit paid (cash out) SUM(amount) from credit_paid
$sql = "SELECT SUM(amount) AS total_amount1 FROM credit_paid WHERE cr_name = '$customer_name'";
$res = mysqli_query($connection, $sql);
if ($res) {
    $row = mysqli_fetch_assoc($res);
    $totalAmount = isset($row['total_amount1']) && $row['total_amount1'] !== null ? (float)$row['total_amount1'] : 0;
} else {
    error_log("Error (credit paid): " . mysqli_error($connection));
}

// opening credit SUM(open_amount)
$sql = "SELECT SUM(open_amount) AS total_amount FROM creditor_opening_amount WHERE creditor_name = '$customer_name'";
$res = mysqli_query($connection, $sql);
if ($res) {
    $row = mysqli_fetch_assoc($res);
    $totalAmount_credit = isset($row['total_amount']) && $row['total_amount'] !== null ? (float)$row['total_amount'] : 0;
} else {
    error_log("Error (creditor opening): " . mysqli_error($connection));
}

// POS credit received: sum cash_amount from log_user_sales where paid_by='credit'
$sql = "SELECT SUM(cash_amount) AS total_pos_credit FROM log_user_sales WHERE customer_name = '$customer_name' AND paid_by = 'credit'";
$res = mysqli_query($connection, $sql);
if ($res) {
    $row = mysqli_fetch_assoc($res);
    $pos_pass_get = isset($row['total_pos_credit']) && $row['total_pos_credit'] !== null ? (float)$row['total_pos_credit'] : 0;
} else {
    error_log("Error (pos credit): " . mysqli_error($connection));
}

// compute remaining credit
// interpretation: remaining = (credit sales) - (credit sales return) - (credit received from credit_paid) - (pos credit received) + (opening credit)
$remaining = $total_sales - $total_sales_return - $totalAmount - $pos_pass_get + $totalAmount_credit;

// ----------------- POST actions -----------------
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["creditor_paid"])) {
    $date_time = !empty($_POST['date_time']) ? mysqli_real_escape_string($connection, $_POST['date_time']) : date("Y-m-d");
    $cr_name = isset($_POST['cr_name']) ? mysqli_real_escape_string($connection, $_POST['cr_name']) : '';
    $cr_address = isset($_POST['cr_address']) ? mysqli_real_escape_string($connection, $_POST['cr_address']) : '';
    $amount = isset($_POST['amount']) ? (float)$_POST['amount'] : 0;
    $paid_by = isset($_POST['paid_by']) ? mysqli_real_escape_string($connection, $_POST['paid_by']) : '';
    $description = isset($_POST['description']) ? mysqli_real_escape_string($connection, $_POST['description']) : '';

    $stmt = mysqli_prepare($connection, "INSERT INTO credit_paid (cr_name, amount, paid_by, description, date_time, user_name, user_role, outlet_name, outlet_address) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "sdsssssss", $cr_name, $amount, $paid_by, $description, $date_time, $userName, $userRole, $outlet_name, $outlet_address);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    } else {
        error_log("Prepare failed (creditor_paid): " . mysqli_error($connection));
    }

    header("Location: creditor_detail.php?customer_name=" . urlencode($customer_name));
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["creditor_close"])) {
    $date_time_close = date("Y-m-d");
    $creditor_name = isset($_POST['creditor_name']) ? mysqli_real_escape_string($connection, $_POST['creditor_name']) : '';
    $open_amount = isset($_POST['opening_cash']) ? (float)$_POST['opening_cash'] : 0;
    $credit_sales = isset($_POST['credit_sales']) ? (float)$_POST['credit_sales'] : 0;
    $credit_received = isset($_POST['credit_recieved']) ? (float)$_POST['credit_recieved'] : 0;
    $remain_balance = isset($_POST['remian_balance']) ? (float)$_POST['remian_balance'] : 0;

    // check if exists, update else insert
    $check_sql = "SELECT * FROM creditor_closing WHERE creditor_name = '" . mysqli_real_escape_string($connection, $creditor_name) . "'";
    $result = mysqli_query($connection, $check_sql);
    if ($result && mysqli_num_rows($result) > 0) {
        $sql = "UPDATE creditor_closing SET 
                    opening_cash = '$open_amount', 
                    credit_sales = '$credit_sales',  
                    credit_recieved = '$credit_received',
                    remain_balance = '$remain_balance', 
                    date_time = '$date_time_close', 
                    login_user = '" . mysqli_real_escape_string($connection, $userName) . "', 
                    user_role = '" . mysqli_real_escape_string($connection, $userRole) . "', 
                    outlet_name = '" . mysqli_real_escape_string($connection, $outlet_name) . "', 
                    outlet_address = '" . mysqli_real_escape_string($connection, $outlet_address) . "' 
                WHERE creditor_name = '" . mysqli_real_escape_string($connection, $creditor_name) . "'";
    } else {
        $sql = "INSERT INTO creditor_closing (
                    creditor_name, opening_cash, credit_sales,
                    credit_recieved, remain_balance, date_time, 
                    login_user, user_role, outlet_name, outlet_address
                ) VALUES (
                    '" . mysqli_real_escape_string($connection, $creditor_name) . "',
                    '$open_amount', '$credit_sales', 
                    '$credit_received', '$remain_balance', '$date_time_close', 
                    '" . mysqli_real_escape_string($connection, $userName) . "', 
                    '" . mysqli_real_escape_string($connection, $userRole) . "',
                    '" . mysqli_real_escape_string($connection, $outlet_name) . "',
                    '" . mysqli_real_escape_string($connection, $outlet_address) . "'
                )";
    }

    if (mysqli_query($connection, $sql)) {
        header("Location: view_creditor.php");
        exit;
    } else {
        // fallback: show error
        $dbError = mysqli_error($connection);
        error_log("Error saving creditor_closing: " . $dbError);
        echo "Database error: " . htmlspecialchars($dbError);
        exit;
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["creditor_open"])) {
    $date_time32 = date("Y-m-d");
    $creditor = isset($_POST['creditor_name']) ? mysqli_real_escape_string($connection, $_POST['creditor_name']) : '';
    $open_amount = isset($_POST['open_amount']) ? (float)$_POST['open_amount'] : 0;
    $paid_by1 = isset($_POST['paid_by']) ? mysqli_real_escape_string($connection, $_POST['paid_by']) : '';

    $stmt = mysqli_prepare($connection, "INSERT INTO creditor_opening_amount (creditor_name, open_amount, paid_by, date_time, login_user, user_role, outlet_name, outlet_address) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "sdssssss", $creditor, $open_amount, $paid_by1, $date_time32, $userName, $userRole, $outlet_name, $outlet_address);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    } else {
        error_log("Prepare failed (creditor_open): " . mysqli_error($connection));
    }

    header("Location: creditor_detail.php?customer_name=" . urlencode($customer_name));
    exit;
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Title from included tx.php -->
    <title><?php echo isset($tx) ? htmlspecialchars($tx) : 'Receivable Detail'; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <!-- Bootstrap 4 CDN CSS -->
 

    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">

    <style>
        body { font-family: 'Quicksand', sans-serif; }
        .chart-container { position: relative; background: rgba(255,255,255,0.9); border-radius:10px; padding:15px; box-shadow:0 0 10px rgba(0,0,0,0.2);}
        canvas { max-width:100%; height:auto; }

        .bg-gradient-primary { background:#0A4657; color:#fff; }
        .btn-primary { background:#0A4657; color:#fff; border:1px #0A4657 solid; }
        .btn-primary:hover { background:#fff; color:#0A4657; border:1px #0A4657 solid; }

        .fa-download:hover { color:#953E39; }

        /* Basic styling for tabs */
        .tab { display: none; padding: 20px; }
        .tab.active { display: block; }
        .tab-buttons { display: flex; }
        .tab-button { cursor:pointer; padding:10px 10px; background:#fff; border:1px solid #0A5064; border-radius:5px 5px 0 0; margin-right:5px; color:#212529; font-weight:700; }
        .tab-button.active { background:#212529; color:#fff; }
        table tr { color:#353535; font-weight:700; background-color:#fff; }
        label { font-weight:700; color:#000; }
        h3,h4 { font-weight:700; color:#000; }
        .btn, .form-control { font-weight:700; }
    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <!-- Sidebar -->
        <?php include("common/sd.php"); ?>
        <!-- End of Sidebar -->

        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                 <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                     <?php include('common/log.php');  ?>
                </nav>
                <br><br>
                    <div class="container mt-3">
                <div class="row">
                    <div class="col-sm-9">
                        <h3 style="color:#212529;">Receivable Detail 
                            <span style="padding:10px;border-radius:7px;color:#fff;font-size:18px;border:1px solid #0A5064;background:#212529;text-transform:capitalize;">
                                <?php echo htmlspecialchars($customer_name); ?>
                            </span>
                        </h3>
                    </div>
                    <div class="col-sm-3 text-right">
                        <a href="view_creditor.php" class="btn btn-dark"><i class="fa fa-arrow-left"></i></a>
                        <button type="button" class="btn btn-dark btn-sm" data-toggle="modal" data-target="#addPurchaseModal">Get</button>
                        <button type="button" class="btn btn-dark btn-sm" data-toggle="modal" data-target="#addopenPurchaseModal">Add Open</button>
                    </div>
                </div>

                <br />

                <div class="tab-buttons">
                    <div class="tab-button active" data-target="tab1">Overview</div>
                    <div class="tab-button" data-target="tab3">Credit Sales</div>
                    <div class="tab-button" data-target="tab4">Credit Sales Return</div>
                    <div class="tab-button" data-target="tab2">Credit Received</div>
                </div>

                <?php
                    // display numbers nicely
                    function fmt($n) {
                        return number_format((float)$n, 2);
                    }
                ?>

                <div id="tab1" class="tab active">
                    <h4>Overview</h4>
                    <br />
                    <form method="post" action="creditor_detail.php?customer_name=<?php echo urlencode($customer_name); ?>">
                        <input type="hidden" name="creditor_name" value="<?php echo htmlspecialchars($customer_name); ?>" />
                        <div class="container">
                            <div class="row" style="padding:20px;background:#fff; box-shadow:0px 0px 5px 2px #CCC; border-radius:10px;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <table class="table table-hover">
                                        <tr style="color:#8A1218;padding:20px;">
                                            <td style="font-weight:600;">Opening Cash</td>
                                            <td style="text-align:right; font-size:19px; font-weight:600;">
                                                Rs <?php echo fmt($totalAmount_credit); ?>
                                                <input type="hidden" name="opening_cash" value="<?php echo (float)$totalAmount_credit; ?>" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-weight:600;">Credit Sales</td>
                                            <td style="text-align:right; font-size:19px; font-weight:600;">
                                                Rs <?php echo fmt($total_sales); ?>
                                                <input type="hidden" name="credit_sales" value="<?php echo (float)$total_sales; ?>" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-weight:600;">Credit Sales Return</td>
                                            <td style="text-align:right; font-size:19px; font-weight:600;">
                                                Rs <?php echo fmt($total_sales_return); ?>
                                                <input type="hidden" value="<?php echo (float)$total_sales_return; ?>" name="credit_sales_return" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-weight:600;">Credit Received</td>
                                            <td style="text-align:right; font-size:19px; font-weight:600;">
                                                Rs <?php echo fmt($totalAmount); ?>
                                                <input type="hidden" value="<?php echo (float)$totalAmount; ?>" name="credit_recieved" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-weight:600;">POS Credit Received</td>
                                            <td style="text-align:right; font-size:19px; font-weight:600;">
                                                Rs <?php echo fmt($pos_pass_get); ?>
                                                <input type="hidden" value="<?php echo (float)$pos_pass_get; ?>" name="pos_credit" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-weight:600;">Remaining Credit</td>
                                            <td style="text-align:right; font-size:19px; font-weight:600;">
                                                Rs <?php echo fmt($remaining); ?>
                                                <input type="hidden" value="<?php echo (float)$remaining; ?>" name="remian_balance" />
                                            </td>
                                        </tr>
                                    </table>
                                    <button type="submit" name="creditor_close" class="btn btn-dark">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                <div id="tab2" class="tab">
                    <h4>Credit Received</h4>
                    <div class="row mb-2">
                        <div class="col-sm-8">
                            <div class="form-row">
                                <div class="col">
                                    <label>Start Date:</label>
                                    <input class="form-control" id="startDateCR" type="date">
                                </div>
                                <div class="col">
                                    <label>End Date:</label>
                                    <input class="form-control" id="endDateCR" type="date">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 text-right">
                            <button class="btn btn-dark mt-4" onclick="downloadTableData('creditTableBody','Credit_Received.csv')">Download</button>
                        </div>
                    </div>

                    <table class="table table-striped table-sm text-center">
                        <thead>
                            <tr style="background:#212529; color:#fff;">
                                <td>Date</td>
                                <td>Amount(Rs)</td>
                                <td>Description</td>
                                <td>Method</td>
                                <td>Received By</td>
                            </tr>
                        </thead>
                        <tbody id="creditTableBody">
                            <?php
                            $rec31 = mysqli_query($connection, "SELECT * FROM credit_paid WHERE cr_name = '$customer_name' ORDER BY date_time DESC");
                            while ($row31 = mysqli_fetch_assoc($rec31)) {
                                echo "<tr>";
                                echo "<td>" . htmlspecialchars($row31['date_time']) . "</td>";
                                echo "<td>Rs. " . fmt($row31['amount']) . "</td>";
                                echo "<td class='text-capitalize'>" . htmlspecialchars($row31['description']) . "</td>";
                                echo "<td class='text-capitalize'>" . htmlspecialchars($row31['paid_by']) . "</td>";
                                echo "<td class='text-capitalize'>" . htmlspecialchars($row31['user_name']) . "</td>";
                                echo "</tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>

                <div id="tab3" class="tab">
                    <h4>Credit Sales</h4>
                    <div class="row mb-2">
                        <div class="col-sm-8">
                            <div class="form-row">
                                <div class="col">
                                    <label>Start Date:</label>
                                    <input class="form-control" id="startDateCS" type="date">
                                </div>
                                <div class="col">
                                    <label>End Date:</label>
                                    <input class="form-control" id="endDateCS" type="date">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 text-right">
                            <button class="btn btn-dark mt-4" onclick="downloadTableData('orderTableBody','Credit_Sales.csv')">Download</button>
                        </div>
                    </div>

                    <table class="table table-striped table-sm text-center">
                        <thead>
                            <tr style="background:#212529; color:#fff;">
                                <td>Date</td>
                                <td>Order-ID</td>
                                <td>Amount(Rs)</td>
                                <td>Method</td>
                                <td>By</td>
                            </tr>
                        </thead>
                        <tbody id="orderTableBody">
                            <?php
                            // query grouped by order_id but sum net_amount -> we show discount_amount per order (if you prefer net_amount change accordingly)
                            $rec1 = mysqli_query($connection, "SELECT order_id, date_time, paid_by, login_user, SUM(discount_amount) as total_discount_amount FROM log_user_sales WHERE customer_name = '$customer_name' AND paid_by = 'credit' GROUP BY order_id ORDER BY date_time DESC");
                            while ($row2 = mysqli_fetch_assoc($rec1)) {
                                echo "<tr>";
                                echo "<td>" . htmlspecialchars($row2['date_time']) . "</td>";
                                echo "<td style='font-weight:700;'>" . htmlspecialchars($row2['order_id']) . "</td>";
                                echo "<td>Rs " . fmt($row2['total_discount_amount']) . "</td>";
                                echo "<td style='text-transform:capitalize;'>" . htmlspecialchars($row2['paid_by']) . "</td>";
                                echo "<td style='text-transform:capitalize;'>" . htmlspecialchars($row2['login_user']) . "</td>";
                                echo "</tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>

                <div id="tab4" class="tab">
                    <h4>Credit Sales Return</h4>
                    <div class="row mb-2">
                        <div class="col-sm-8">
                            <div class="form-row">
                                <div class="col">
                                    <label>Start Date:</label>
                                    <input class="form-control" id="startDateRF" type="date">
                                </div>
                                <div class="col">
                                    <label>End Date:</label>
                                    <input class="form-control" id="endDateRF" type="date">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4 text-right">
                            <button class="btn btn-dark mt-4" onclick="downloadTableData('refundTableBody','Credit_Sales_Return.csv')">Download</button>
                        </div>
                    </div>

                    <table class="table table-striped table-sm text-center">
                        <thead>
                            <tr style="background:#212529; color:#fff;">
                                <td>Date</td>
                                <td>Order-ID</td>
                                <td>Sub-total(Rs)</td>
                                <td>Discount(Rs)</td>
                                <td>Amount(Rs)</td>
                                <td>Method</td>
                            </tr>
                        </thead>
                        <tbody id="refundTableBody">
                            <?php
                            // group by r_order_id (refunds). We sum net_amount and discount_amount
                            $rec3 = mysqli_query($connection, "SELECT r_order_id, date_time, paid_by, SUM(net_amount) AS netAmounts, SUM(discounted) AS total_discounted, SUM(discount_amount) AS total_discount_amount FROM log_user_sales WHERE customer_name = '$customer_name' AND status = 'refund' GROUP BY r_order_id ORDER BY date_time DESC");
                            while ($row3 = mysqli_fetch_assoc($rec3)) {
                                echo "<tr>";
                                echo "<td>" . htmlspecialchars($row3['date_time']) . "</td>";
                                echo "<td style='font-weight:700;'>" . htmlspecialchars($row3['r_order_id']) . "</td>";
                                echo "<td>Rs. " . fmt($row3['netAmounts']) . "</td>";
                                echo "<td>Rs. " . fmt($row3['total_discounted']) . "</td>";
                                echo "<td>Rs. " . fmt($row3['total_discount_amount']) . "</td>";
                                echo "<td class='text-capitalize'>" . htmlspecialchars($row3['paid_by']) . "</td>";
                                echo "</tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>

                <!-- Add Credit Received modal -->
                <div class="modal fade" id="addPurchaseModal" tabindex="-1" role="dialog" aria-labelledby="addPurchaseModalLabel" aria-hidden="true" style="margin-top:80px;">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header" style="background:#0A4657;">
                                <h5 class="modal-title text-capitalize text-white font-weight-bold" id="addPurchaseModalLabel">Add Credit Received</h5>
                                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="creditor_detail.php?customer_name=<?php echo urlencode($customer_name); ?>" enctype="multipart/form-data">
                                    <input type="text" name="cr_name" placeholder="Name" value="<?php echo htmlspecialchars($customer_name); ?>" class="form-control" />
                                    <br />
                                    <input type="number" step="0.01" name="amount" placeholder="Amount" class="form-control" required />
                                    <br />
                                    <select name="paid_by" class="form-control" required>
                                        <option value="">Select Method</option>
                                        <option value="cash">Cash</option>
                                        <option value="bank1">Bank 1</option>
                                        <option value="bank2">Bank 2</option>
                                        <option value="bank3">Bank 3</option>
                                        <option value="other">Other</option>
                                    </select>
                                    <br />
                                    <textarea name="description" class="form-control" placeholder="Enter description..." rows="3"></textarea>
                                    <br />
                                    <input class="form-control" type="date" name="date_time" />
                                    <br />
                                    <button type="submit" name="creditor_paid" class="btn btn-dark">Enter</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Opening Amount modal -->
                <div class="modal fade" id="addopenPurchaseModal" tabindex="-1" role="dialog" aria-labelledby="addPurchaseopenModalLabel" aria-hidden="true" style="margin-top:80px;">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header" style="background:#0A4657;">
                                <h5 class="modal-title text-capitalize text-white font-weight-bold" id="addPurchaseopenModalLabel">Add Opening Amount</h5>
                                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="creditor_detail.php?customer_name=<?php echo urlencode($customer_name); ?>" enctype="multipart/form-data">
                                    <input type="hidden" value="<?php echo htmlspecialchars($customer_name); ?>" name="creditor_name" />
                                    <input type="number" step="0.01" name="open_amount" placeholder="Amount" class="form-control" required />
                                    <br />
                                    <button type="submit" name="creditor_open" class="btn btn-dark">Enter</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div> <!-- container -->
            </div>

        

            <!-- Footer -->
            <?php include("common/main_ft.php"); ?>
        </div>
    </div>

    <a class="scroll-to-top rounded" href="#page-top"><i class="fas fa-angle-up"></i></a>

    <!-- Logout Modal (kept) -->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header"><h5 class="modal-title">Ready to Leave?</h5><button class="close" type="button" data-dismiss="modal">&times;</button></div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- scripts: ensure jQuery loads before Bootstrap 4 -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>

    <!-- SweetAlert (kept) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        // Simple tab switching using data-target
        document.addEventListener("DOMContentLoaded", function () {
            var buttons = document.querySelectorAll(".tab-button");
            buttons.forEach(function (btn) {
                btn.addEventListener("click", function (e) {
                    var target = btn.getAttribute("data-target");
                    // hide all tabs
                    document.querySelectorAll(".tab").forEach(function (t) {
                        t.classList.remove("active");
                    });
                    // remove active from all buttons
                    document.querySelectorAll(".tab-button").forEach(function (b) {
                        b.classList.remove("active");
                    });
                    // show target
                    var el = document.getElementById(target);
                    if (el) el.classList.add("active");
                    btn.classList.add("active");
                });
            });

            // safe DOM queries for sidebar toggling (if navbar-toggler exists)
            var navbarToggler = document.querySelector(".navbar-toggler");
            if (navbarToggler) {
                navbarToggler.addEventListener("click", function () {
                    var sidebar = document.getElementById("sidebar");
                    if (sidebar) sidebar.classList.toggle("hide");
                });
            }
        });

        // confirm delete wrapper used previously
        function confirmDelete(form) {
            event.preventDefault();
            Swal.fire({
                title: 'Are you sure?',
                text: "This record will be deleted permanently!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
            return false;
        }

        // simple CSV download for a table body id (basic)
        function downloadTableData(tbodyId, filename) {
            var tbody = document.getElementById(tbodyId);
            if (!tbody) { alert('Table not found'); return; }
            var rows = tbody.querySelectorAll('tr');
            var csv = [];
            for (var i = 0; i < rows.length; i++) {
                var cols = rows[i].querySelectorAll('td, th');
                var row = [];
                for (var j = 0; j < cols.length; j++) {
                    var text = cols[j].innerText.replace(/(\r\n|\n|\r)/gm, ' ').trim();
                    text = text.replace(/"/g, '""');
                    row.push('"' + text + '"');
                }
                csv.push(row.join(','));
            }
            var csvString = csv.join('\n');
            var blob = new Blob([csvString], { type: 'text/csv;charset=utf-8;' });
            var link = document.createElement("a");
            if (link.download !== undefined) {
                var url = URL.createObjectURL(blob);
                link.setAttribute("href", url);
                link.setAttribute("download", filename);
                link.style.visibility = 'hidden';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            } else {
                alert('Download not supported by your browser.');
            }
        }
    </script>
</body>

</html>
