<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_GET['order_id'])) {
    die("Order ID not provided.");
}

$orderId = $_GET['order_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantities = $_POST['quantities'];
    $prices     = $_POST['prices'];
    $discounts  = $_POST['discounts'];
    $saleCosts  = $_POST['discount_amount'];   // ✅ renamed from trade_prices

    $grandTotal = 0;

    foreach ($quantities as $id => $qty) {
        $price    = (float)$prices[$id];
        $discount = (float)$discounts[$id];
        $saleCost = (float)$saleCosts[$id];  // ✅

        // Get original data (with sale_cost)
        $originalQuery = mysqli_query(
            $connection,
            "SELECT * 
             FROM log_user_sales 
             WHERE id = '$id' AND order_id = '$orderId'"
        );
        if (!$originalQuery || mysqli_num_rows($originalQuery) === 0) continue;

        $originalData   = mysqli_fetch_assoc($originalQuery);
        $originalQty    = (int)$originalData['product_quantity'];
        $productId      = $originalData['product_id'];
        $productName    = $originalData['product_name'];
        $oldSaleCost    = (float)$originalData['discount_amount'];

        $qty = (int)$qty;
        $qtyDiff = $qty - $originalQty;

        // Adjust stock
        $stockUpdate = "
            UPDATE products 
            SET quantity = quantity - ($qtyDiff), 
                total_amount = total_amount - ($qtyDiff * $price) 
            WHERE product_id = '$productId'";
        mysqli_query($connection, $stockUpdate);

        // ✅ Per-unit sale cost
        $perUnitSaleCost = ($originalQty > 0) ? ($oldSaleCost / $originalQty) : 0;

        // ✅ Update sale cost proportional to new quantity
        $saleCost = $perUnitSaleCost * $qty;

        // Net amount (with % discount)
        $gross          = $qty * $price;
        $discountAmount = ($discount / 100) * $gross;
        $netAmount      = $gross - $discountAmount;

        $grandTotal += $netAmount;

        // ✅ Update order row
        $updateItem = "
            UPDATE log_user_sales 
            SET product_quantity = '$qty', 
                product_price    = '$price', 
                discount         = '$discount',
                discount_amount        = '$saleCost',
                net_amount       = '$netAmount'
            WHERE order_id = '$orderId' AND id = '$id'";

        if (!mysqli_query($connection, $updateItem)) {
            die("Update failed: " . mysqli_error($connection));
        }
    }

    // Update order total
    $updateDiscountAmount = "
        UPDATE log_user_sales 
        SET discount_amount = '$grandTotal'
        WHERE order_id = '$orderId'";

    if (!mysqli_query($connection, $updateDiscountAmount)) {
        die("Failed to update discount_amount: " . mysqli_error($connection));
    }

    echo "<script>alert('Order updated successfully!'); window.location.href='order_detail_v.php';</script>";
    exit();
}

// Fetch order details
$result = mysqli_query($connection, "SELECT * FROM log_user_sales WHERE order_id = '$orderId'");
if (mysqli_num_rows($result) == 0) {
    die("Order not found.");
}

$orderRows = [];
while ($row = mysqli_fetch_assoc($result)) {
    $orderRows[] = $row;
}
ob_end_flush();
?>


<!DOCTYPE html>
<html>
<head>
    <title>Edit Order</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
    <h3>Edit Order: <?php echo htmlspecialchars($orderId); ?></h3>
    <form method="POST" id="editForm">
        <table class="table text-center table-sm" style="font-size:14px;">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Price(Rs)</th>
                    <th>Discount(%)</th>
                    <th>Total(Rs)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orderRows as $row): ?>
                    <tr>
                        <td><?php echo $row['product_name']; ?></td>
                        <td>
                            <input type="number" 
                                   name="quantities[<?php echo $row['id']; ?>]" 
                                   class="form-control qty" 
                                   value="<?php echo $row['product_quantity']; ?>" 
                                   min="1"
                                   data-original-qty="<?php echo $row['product_quantity']; ?>"
                                   data-per-unit-sale="<?php echo $row['sale_cost'] / max($row['product_quantity'],1); ?>">
                        </td>
                        <td>
                            <input type="number" 
                                   name="prices[<?php echo $row['id']; ?>]" 
                                   class="form-control price" 
                                   value="<?php echo $row['product_price']; ?>" 
                                   step="0.01">
                        </td>
                        <td>
                            <input type="number" 
                                   name="discounts[<?php echo $row['id']; ?>]" 
                                   class="form-control discount" 
                                   value="<?php echo $row['discount']; ?>" 
                                   step="0.01">
                        </td>
                        <td class="total">0</td>

                        <!-- Hidden Sale Cost -->
                        <input type="hidden" 
                               name="sale_costs[<?php echo $row['id']; ?>]" 
                               class="sale_cost" 
                               value="<?php echo $row['discount_amount']; ?>">
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="text-end">
            <p><strong>Sub:</strong> Rs <span id="subtotal">0</span></p>
            <p><strong>Total:</strong> Rs <span id="grandtotal">0</span></p>
        </div>

        <button type="submit" class="btn btn-success" style="font-weight:700;">Update Order</button>
        <a href="order_detail_v.php" class="btn btn-secondary" style="font-weight:700;">Cancel</a>
    </form>

    <script>
        function calculateTotals() {
            let subtotal = 0;
    
            document.querySelectorAll('tbody tr').forEach(function(row) {
                const qtyInput = row.querySelector('.qty');
                const qty = parseFloat(qtyInput.value) || 0;
                const price = parseFloat(row.querySelector('.price').value) || 0;
                const discount = parseFloat(row.querySelector('.discount').value) || 0;
                const saleCostInput = row.querySelector('.sale_cost');

                // ✅ Per unit sale cost from data attribute
                const perUnitSale = parseFloat(qtyInput.dataset.perUnitSale) || 0;

                // ✅ Update sale cost proportional to quantity
                const updatedSaleCost = perUnitSale * qty;
                saleCostInput.value = updatedSaleCost.toFixed(2);

                // ✅ Gross & Discount calculation
                let gross = qty * price;
                let discountAmount = (discount / 100) * gross;
                let total = gross - discountAmount;

                // ✅ Update row total
                row.querySelector('.total').innerText = total.toFixed(2);

                subtotal += total;
            });
    
            // ✅ Update totals at bottom
            document.getElementById('subtotal').innerText = subtotal.toFixed(2);
            document.getElementById('grandtotal').innerText = subtotal.toFixed(2);
        }
    
        // Attach event listeners
        document.querySelectorAll('.qty, .price, .discount').forEach(el => {
            el.addEventListener('input', calculateTotals);
        });
    
        window.addEventListener('DOMContentLoaded', calculateTotals);
    </script>

</body>
</html>
