<?php
include("db/cn.php"); 
include("common/tx.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ob_start();
if (!empty($_SESSION['user_name']) && !empty($_SESSION['user_role']) && !empty($_SESSION['outlet_name']) && !empty($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ob_end_flush();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['filter'])) {
    $creditor = mysqli_real_escape_string($connection, $_POST['supplier']);
    $startDate = date('Y-m-d', strtotime($_POST['startDate']));
    $endDate = date('Y-m-d', strtotime($_POST['endDate']));

    // Fetch opening balance
    $openingQuery = "
        SELECT open_amount AS amount
        FROM creditor_opening_amount 
        WHERE creditor_name = ? 
        AND date_time BETWEEN ? AND ? 
        ORDER BY date_time LIMIT 1";
    
    $stmt = $connection->prepare($openingQuery);
    $stmt->bind_param('sss', $creditor, $startDate, $endDate);
    $stmt->execute();
    $result = $stmt->get_result();
    $openingBalance = ($row = $result->fetch_assoc()) ? $row['amount'] : 0;
    $stmt->close();

    $transactions = [];

    function fetchTransactions($connection, $query, $params, $description, $multiplier = 1) {
        $stmt = $connection->prepare($query);
        $stmt->bind_param(...$params);
        $stmt->execute();
        $result = $stmt->get_result();

        $transactions = [];
        while ($row = $result->fetch_assoc()) {
            $transactions[] = [
                'date' => $row['date'],
                'description' => $description,
                'product_price' => $row['product_price'] ?? 0,
                'product_quantity' => $row['product_quantity'] ?? 0,
                'bale' => $row['bale'] ?? 0,
                'tons' => $row['tons'] ?? 0,
                'mun' => $row['mun'] ?? 0,
                'amount' => $multiplier * floatval($row['amount']),
                'paid_by' => $row['paid_by']
            ];
        }
        $stmt->close();
        return $transactions;
    }

    // Queries with retail_price and quantity added
    $queries = [
        [
            'query' => "
                SELECT date_time AS date, discount_amount AS amount, paid_by, product_price, product_quantity, bale, tons, mun 
                FROM log_user_sales 
                WHERE customer_name = ? AND paid_by = 'credit' AND date_time BETWEEN ? AND ?
                GROUP BY order_id",
            'description' => 'Credit Sale',
            'multiplier' => 1
        ],
        [
            'query' => "
                SELECT date_time AS date, discount_amount AS amount, paid_by, product_price, product_quantity, bale, tons, mun, status 
                FROM log_user_sales 
                WHERE customer_name = ? AND status = 'refund' AND paid_by = 'credit' AND date_time BETWEEN ? AND ?
                GROUP BY r_order_id",
            'description' => 'Credit Sale Return',
            'multiplier' => -1
        ],
        [
            'query' => "
                SELECT date_time AS date, amount, paid_by, 0 AS product_price, 0 AS product_quantity, 0 AS bale, 0 AS tons, 0 AS mun
                FROM credit_paid 
                WHERE cr_name = ? AND date_time BETWEEN ? AND ?",
            'description' => 'Credit Received',
            'multiplier' => -1
        ]
    ];

    foreach ($queries as $queryConfig) {
        $params = ['sss', $creditor, $startDate, $endDate];
        $transactions = array_merge($transactions, fetchTransactions(
            $connection,
            $queryConfig['query'],
            $params,
            $queryConfig['description'],
            $queryConfig['multiplier']
        ));
    }

    usort($transactions, fn($a, $b) => strtotime($a['date']) - strtotime($b['date']));

    $balance = $openingBalance;
    foreach ($transactions as &$transaction) {
        $transaction['running_balance'] = $balance += $transaction['amount'];
    }
}

$creditorQuery = "SELECT DISTINCT cr_name FROM credit_note";
$creditorResult = mysqli_query($connection, $creditorQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $tx; ?></title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    <style>
        body { font-family: 'Quicksand', sans-serif; }
        .bg-gradient-primary { background:#0A4657; color:#fff; }
        .btn-primary { background:#0A4657; color:#fff; border:1px solid #0A4657; }
        .btn-primary:hover { background:#fff; color:#0A4657; border:1px solid #0A4657; }
        #table-container-wrapper { max-height:560px; overflow-y:auto; }
        .form-control, option{ color:#000; font-weight:700; }
        .btn{font-weight:700;}
    </style>
</head>

<body id="page-top">
<div id="wrapper">
    <?php include("common/sd.php"); ?>
    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">
                <?php include('common/log.php'); ?>
            </nav>

            <div class="container-fluid mt-5">
                <h3 style="color:#060606; font-weight:700;">Customer Ledger Report</h3><br>
                <form method="post">
                    <div class="row">
                        <div class="col-md-3">
                            <label>Customer Name:</label>
                            <select class="form-control" name="supplier" required>
                                <option value="">Select Customer</option>
                                <?php while ($row = mysqli_fetch_assoc($creditorResult)): ?>
                                    <option value="<?= $row['cr_name'] ?>"><?= $row['cr_name'] ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-3">
                            <label>Start Date:</label>
                            <input type="date" class="form-control" name="startDate" required>
                        </div>
                        <div class="col-md-3">
                            <label>End Date:</label>
                            <input type="date" class="form-control" name="endDate" required>
                        </div>
                        <div class="col-md-3" style="margin-top:32px;">
                            <button type="submit" class="btn btn-dark" name="filter">Filter</button>
                            <a href="report_recieve.php" class="btn btn-dark btn-lg"><i class="fas fa-sync-alt"></i></a>
                            <button id="downloadExcel" type="button" class="btn btn-dark">Download</button>
                            <button id="downloadPdf" type="button" class="btn btn-danger"><i class="fas fa-file"></i> PDF</button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="container-fluid" id="report">
                <?php if (isset($transactions)): ?>
                <h5 class="text-center" style="background:#0A4657;color:#fff;padding:20px;border-radius:10px;text-transform:capitalize;">
                    Customer Ledger Report: <strong><?= $creditor ?></strong>
                </h5>

                <div id="table-container-wrapper">
                    <table id="patientTable" class="table table-striped table-hover text-center table-sm bg-white">
                        <thead>
                            <tr class="bg-dark text-white">
                                <th>Date</th>
                                <th>Description</th>
                                
                                <th>KG</th>
                                <th>Bale</th>
                                <th>Tons</th>
                                <th>Mun</th>
                                <th>Paid By</th>
                                <th>Rate</th>
                                <th>Debit (Rs)</th>
                                <th>Credit (Rs)</th>
                                <th>Balance (Rs)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr style="color:#0A4657; font-weight:700;">
                                <td><?= $startDate ?></td>
                                <td>Opening Balance</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td><?= number_format($openingBalance, 2) ?></td>
                                <td></td>
                                <td><?= number_format($openingBalance, 2) ?></td>
                            </tr>
                            <?php 
                            $balance = $openingBalance;
                            foreach ($transactions as $transaction): 
                                $positiveAmount = $transaction['amount'] > 0 ? number_format($transaction['amount'], 2) : '';
                                $negativeAmount = $transaction['amount'] < 0 ? number_format(abs($transaction['amount']), 2) : '';
                                $balance += $transaction['amount'];
                            ?>
                            <tr style="color:#060606;">
                                <td><?= $transaction['date'] ?></td>
                                <td><?= $transaction['description'] ?></td>
                                
                                <td><?= $transaction['product_quantity'] ?></td>
                                <td><?= $transaction['bale'] ?></td>
                                <td><?= $transaction['tons'] ?></td>
                                <td><?= $transaction['mun'] ?></td>
                                <td><?= ucfirst($transaction['paid_by']) ?></td>
                                <td><?= $transaction['product_price'] ?></td>
                                <td><?= $positiveAmount ?></td>
                                <td><?= $negativeAmount ?></td>
                                <td><?= number_format($balance, 2) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <h4 style="color:#060606;font-weight:700;">Final Balance: <?= number_format($balance, 2) ?></h4>
                <?php endif; ?>
            </div>
        </div>
        <?php include("common/main_ft.php"); ?>
    </div>
</div>

<a class="scroll-to-top rounded" href="#page-top"><i class="fas fa-angle-up"></i></a>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
document.getElementById('downloadExcel').addEventListener('click', function() {
    var table = document.getElementById('patientTable');
    var clone = table.cloneNode(true);
    var workbook = XLSX.utils.table_to_book(clone, { sheet: "Customer Ledger" });
    XLSX.writeFile(workbook, 'Customer_Ledger_Report.xlsx');
});

document.getElementById("downloadPdf").addEventListener("click", function () {
    const { jsPDF } = window.jspdf;
    const report = document.getElementById("report");
    const now = new Date();
    const formattedDateTime = now.toLocaleDateString() + " " + now.toLocaleTimeString();

    html2canvas(report, { scale: 2 }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const pdf = new jsPDF("p", "mm", "a4");
        const pdfWidth = pdf.internal.pageSize.getWidth();
        const pdfHeight = (canvas.height * pdfWidth) / canvas.width;
        pdf.addImage(imgData, "PNG", 0, 30, pdfWidth, pdfHeight);
        pdf.setFont("helvetica", "bold");
        pdf.setFontSize(14);
        pdf.text("Customer Ledger Report", pdfWidth / 2, 12, { align: "center" });
        pdf.setFontSize(10);
        pdf.setFont("helvetica", "normal");
        pdf.text(`Printed: ${formattedDateTime}`, pdfWidth - 10, 20, { align: "right" });
        pdf.save("Customer_Ledger_Report.pdf");
    });
});
</script>

<script src="../vendor/jquery/jquery.min.js"></script>
<script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
<script src="../js/sb-admin-2.min.js"></script>
</body>
</html>
