<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

$start_date = $_GET['start_date'] ?? null;
$end_date = $_GET['end_date'] ?? null;

$query = "SELECT * FROM c_exp";
$totalSumQuery = "SELECT SUM(amount) as total_amount FROM c_exp";

if ($start_date && $end_date) {
    $query .= " WHERE date_time BETWEEN '$start_date' AND '$end_date'";
    $totalSumQuery .= " WHERE date_time BETWEEN '$start_date' AND '$end_date'";
}

$result = mysqli_query($connection, $query);
$totalSumResult = mysqli_query($connection, $totalSumQuery);

$totalSum = 0;
if ($totalSumRow = mysqli_fetch_assoc($totalSumResult)) {
    $totalSum = $totalSumRow['total_amount'];
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Company Expense Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Quicksand', sans-serif;
        }
        #table-container {
            max-height: 1190px; 
            overflow-y: auto; 
        }
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .text-bold {
            font-weight: 700;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3" style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
            <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Company Expense Report</h3>
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;">Back</a>
        </div>
    </div>
</div>

<div class="container" style="padding:50px;max-width:1300px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Company Expense Report</h3>
        </div>
    </div>
    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $start_date ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $end_date ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_cexp.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id="downloadExcel" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

    <!-- Total Sum -->
    <div class="row mb-3">
        <div class="col-sm-4">
            <table class="table table-bordered bg-white text-center">
                <tr>
                    <td style="background:#0A4657;color:#fff; font-weight:700;">Total Amount</td>
                    <td style="font-weight:700;"> <?= number_format((int)$totalSum, 2) ?> </td>
                </tr>
            </table>
            <h4 </h4>
        </div>
    </div>

    <!-- Table -->
    <div id="table-container">
        <table id="patientTable" class="table table-bordered table-striped text-center bg-white">
            <tr class="bg-dark text-white text-bold">
                <th>Date</th>
                <th>Description</th>
                <th>Amount</th>
            </tr>
            <?php while ($row = mysqli_fetch_array($result)) { ?>
                <tr style="color:#000;font-weight:700;">
                    <td><?= $row["date_time"] ?></td>
                    <td style="color:#0A4657;font-weight:800;"><?= $row["expence_name"] ?></td>
                    <td><?= $row["amount"] ?></td>
                </tr>
            <?php } ?>
        </table>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true);
        var rows = clone.querySelectorAll('tr');

        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Company Expenses" });

        try {
            XLSX.writeFile(workbook, 'Company_Expense_Report.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>
