<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Clearence Stock Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
    
    
 #table-container{
    max-height: 1190px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Clearence Stock Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>



<?php
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

// Query for Filtering and Total Calculation
$query = "SELECT SUM(palet_no) as total_pallet FROM cl_stock";

$condition = "";
if (!empty($start_date) && !empty($end_date)) {
    $condition = " WHERE date_time BETWEEN '$start_date' AND '$end_date'";
}

$query .= $condition;
$total_result = mysqli_query($connection, $query);
$total_row = mysqli_fetch_assoc($total_result);

// Fetching Filtered Data
$data_query = "SELECT * FROM cl_stock" . $condition;
$cl = mysqli_query($connection, $data_query);
?>

<div class="container-fluid" style="padding:50px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Clearance Stock Report</h3>
        </div>
    </div>

    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $start_date ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $end_date ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_clearence.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button id="downloadExcel" class="btn btn-dark" type="button" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

    <div id="table-container">
        <table id="patientTable" class="table table-bordered text-center bg-white">
            <tr class="bg-dark text-white text-bold">
                <th>Sr#</th>
                <th>Date</th>
                <th>Bility No#</th>
                <th>Vehicale No#</th>
                <th>Driver</th>
                <th>Location</th>
                <th>Pallet</th>
            </tr>
            
            <!-- Total Sum Row -->
            
            <?php
            $sr_no = 1;
            while($row = mysqli_fetch_array($cl)){
            ?>
            <tr>
                <td><?= $sr_no++ ?></td>
                <td><?= $row["date_time"] ?></td>
                <td><?= $row["bility_no"] ?></td>
                <td><?= $row["truck_no"] ?></td>
                <td><?= $row["driver_name"] ?></td>
                <td><?= $row["location"] ?></td>
                <td><?= $row["palet_no"] ?></td>
            </tr>
            <?php } ?>
            <tr class="bg-light text-bold">
                <td colspan="6"><strong>Total</strong></td>
                <td><strong><?= $total_row['total_pallet'] ?: 0 ?></strong></td>
            </tr>

        </table>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Clearence Stock" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Clearence Stock Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>