<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

ob_end_flush();

if (isset($_GET['company_name']) && isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $companyName = $_GET['company_name'];
    $startDate = $_GET['start_date'];
    $endDate = $_GET['end_date'];

    // Initialize variables
    $openingBalance = 0;
    $routeRentTotal = 0;
    $iblStockRentTotal = 0;
    $fixedVehicleRentTotal = 0;
    $clearanceRentTotal = 0;
    $amountReceivedTotal = 0;
    $closingBalance = 0;

    // Fetch Opening Balance
    $openingQuery = mysqli_query($connection, "SELECT SUM(amount) AS opening_balance FROM dist_open_amount WHERE dist_name = '$companyName' AND date_time BETWEEN '$startDate' AND '$endDate'");
    $openingResult = mysqli_fetch_assoc($openingQuery);
    $openingBalance = $openingResult['opening_balance'] ?? 0;

    // Fetch Route Rent
    $routeQuery = mysqli_query($connection, "SELECT route_com AS route_rent FROM dispatch WHERE  dispatch_date BETWEEN '$startDate' AND '$endDate' GROUP BY dispatch_id");
    while ($row = mysqli_fetch_assoc($routeQuery)) {
        $routeRentTotal += $row['route_rent'];
    }

    // Fetch IBL Stock Rent
    $iblQuery = mysqli_query($connection, "SELECT SUM(fre) AS ibl_stock_rent FROM ibl_stock WHERE  date_time BETWEEN '$startDate' AND '$endDate'");
    $iblStockRentTotal = mysqli_fetch_assoc($iblQuery)['ibl_stock_rent'] ?? 0;

    // Fetch Fixed Vehicle Rent
    $fixedVehicleQuery = mysqli_query($connection, "SELECT SUM(grand_total) AS fixed_vehicle_rent FROM fixed_v WHERE date_time BETWEEN '$startDate' AND '$endDate'");
    $fixedVehicleRentTotal = mysqli_fetch_assoc($fixedVehicleQuery)['fixed_vehicle_rent'] ?? 0;

    // Fetch Clearance Rent
    $clearanceQuery = mysqli_query($connection, "SELECT SUM(plt_total_amount) AS clearance_rent FROM cl_stock WHERE  date_time BETWEEN '$startDate' AND '$endDate'");
    $clearanceRentTotal = mysqli_fetch_assoc($clearanceQuery)['clearance_rent'] ?? 0;

    // Fetch Amount Received
    $amountReceivedQuery = mysqli_query($connection, "SELECT SUM(amount) AS amount_received FROM com_paid WHERE company_name = '$companyName' AND date_time BETWEEN '$startDate' AND '$endDate'");
    $amountReceivedTotal = mysqli_fetch_assoc($amountReceivedQuery)['amount_received'] ?? 0;

    // Calculate Closing Balance
    $closingBalance = $openingBalance + $routeRentTotal + $iblStockRentTotal + $fixedVehicleRentTotal + $clearanceRentTotal - $amountReceivedTotal;

    // Prepare data for the ledger table
    $ledgerData = [
        [
            'date' => $startDate,
            'description' => 'Opening Balance',
            'amount' => $openingBalance,
            'balance' => $openingBalance
        ],
        [
            'date' => $startDate,
            'description' => 'Route Rent',
            'amount' => $routeRentTotal,
            'balance' => $openingBalance + $routeRentTotal
        ],
        [
            'date' => $startDate,
            'description' => 'IBL Stock Rent',
            'amount' => $iblStockRentTotal,
            'balance' => $openingBalance + $routeRentTotal + $iblStockRentTotal
        ],
        [
            'date' => $startDate,
            'description' => 'Fixed Vehicle Rent',
            'amount' => $fixedVehicleRentTotal,
            'balance' => $openingBalance + $routeRentTotal + $iblStockRentTotal + $fixedVehicleRentTotal
        ],
        [
            'date' => $startDate,
            'description' => 'Clearance Rent',
            'amount' => $clearanceRentTotal,
            'balance' => $openingBalance + $routeRentTotal + $iblStockRentTotal + $fixedVehicleRentTotal + $clearanceRentTotal
        ],
        [
            'date' => $startDate,
            'description' => 'Amount Received',
            'amount' =>  -$amountReceivedTotal,
            'balance' => $closingBalance
        ],
        [
            'date' => $endDate,
            'description' => 'Closing Balance',
            'amount' => $closingBalance,
            'balance' => $closingBalance
        ]
    ];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Company Ledger Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
 #table-container{
    max-height: 1190px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Company Ledger Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>
<div class="container" style="padding:50px;max-width:1600px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Company Ledger Report</h3>
        </div>
    </div>

    <?php
    $tr = mysqli_query($connection, "SELECT * FROM company");
    ?>
    <form method="GET" action="">
        <div class="row">
           <div class="col-sm-3">
               <div class="form-group">
                   <label>Select Company Ledger</label>
                   <select class="form-control" name="company_name">
                       <option value="">Select</option>
                       <?php
                       while($r = mysqli_fetch_array($tr)){
                       ?>
                       <option value="<?php echo $r["company_name"]; ?>" <?php if(isset($_GET['company_name']) && $_GET['company_name'] == $r["company_name"]) echo 'selected'; ?>><?php echo $r["company_name"]; ?></option>
                       <?php
                       }
                       ?>
                   </select>
               </div>
           </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $_GET['start_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $_GET['end_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_company.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id="downloadExcel"  style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>
 
    <?php if (isset($ledgerData)) { ?>
<div id="table-container">
    <table id="patientTable" class="table table-bordered text-center bg-white">
        <thead>
            <tr class="bg-dark text-white text-bold">
                <th>Date</th>
                <th>Description</th>
                <th>Amount</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($ledgerData as $entry) { ?>
                <tr>
                    <td><?= $entry['date']; ?></td>
                    <td><?= $entry['description']; ?></td>
                    <td><?= number_format($entry['amount'], 2); ?></td>
                    <td><?= number_format($entry['balance'], 2); ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
<?php } ?>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Company" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Company Ledger_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>