<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : '';
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : '';
$dist = null;

if (!empty($start_date) && !empty($end_date)) {
    $dist = mysqli_query(
        $connection,
        "SELECT * FROM dispatch WHERE dispatch_date BETWEEN '$start_date' AND '$end_date'"
    );
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dispatch Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
        font-family: 'Quicksand', sans-serif;
    }

    #table-container {
        max-height: 870px;
        overflow-y: auto;
    }
    .bg {
        background: linear-gradient(270deg, #060606, #0A4657);
    }
    label {
        font-size: 13.5px;
        font-weight: 700;
    }
    .text-bold {
        font-weight: 700;
    }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3" style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
            <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Dispatch report</h3>
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;">Back</a>
        </div>
    </div>
</div>

<div class="container-fluid" style="padding:50px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Dispatch Report</h3>
        </div>
    </div>
    <form method="POST" action="">
        <!-- Date Filter Form -->
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Search</label>
                    <input type="text" name="search_in" class="form-control">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;font-weight:700;">Filter</button>
                <a href="report_dis.php" class="btn btn-dark" style="margin-top:30px;font-weight:700;">
                    <i class="fas fa-sync fa-1x"></i>
                </a>
                <button class="btn btn-dark" id="downloadExcel" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

    <!-- Report Table -->
    <div id="table-container">
        <table id="patientTable" class="table table-bordered text-center bg-white table-responsive">
            <thead>
                <tr class="bg-dark text-white text-bold">
                    <td>Sr#</td>
                    <td>Date</td>
         
                    <td>Bility#</td>
                    <td>Vehicle#</td>
                    <td>Driver</td>
                    <td>Distributor</td>
                    <td>Sale Order#</td>
                    <td>Pallet</td>
                    <td>250 ML STD</td>
                    <td>1500 ML PET</td>
                    <td>1000 ML PET</td>
                    <td>2250 ML PET</td>
                    <td>500 ML PET</td>
                    <td>345 ML PET</td>
                    <td>240 ML STING</td>
                    <td>1500 ML AQUAFINA</td>
                    <td>500 ML AQUAFINA</td>
                    <td>250 ML CAN</td>
                    <td>200 ML SLICE</td>
                    <td>Empty Slip#</td> <!-- Empty Slip Header -->
                    <td>250 ML EMPTY</td>
                    <td>240 ML EMPTY</td>
                    <td>GREEN SHEETS</td>
                    <td>BLUE SHEETS</td>
                    <td>RED SHEETS</td>
                    <td>P.PALLET</td>
                    <td>W.PALLET</td>
                </tr>
            </thead>
            <tbody>
          <?php
if ($dist && mysqli_num_rows($dist) > 0) {
    $sr_no = 1;
    $headers = [
        "250 ML STD", "1500 ML PET", "1000 ML PET", "2250 ML PET", "500 ML PET",
        "345 ML PET", "240 ML STING", "1500 ML AQUAFINA", "500 ML AQUAFINA",
        "250 ML CAN", "200 ML SLICE", "Empty Slip#", "250 ML EMPTY", "240 ML EMPTY",
        "GREEN SHEETS", "BLUE SHEETS", "RED SHEETS", "P.PALLET", "W.PALLET"
    ];

    $totals = array_fill_keys($headers, 0);
    $grouped_rows = [];
    
    while ($row = mysqli_fetch_array($dist)) {
        $dispatch_id = $row['dispatch_id'];
        $sale_order = $row['sale_order'];
        $empty_slip = $row['empty_slip'];
        
        $key = $dispatch_id . '-' . $empty_slip;
        
        if (!isset($grouped_rows[$key])) {
            $grouped_rows[$key] = [
                'sr_no' => $sr_no++,
                'dispatch_date' => $row['dispatch_date'],
                'dispatch_id' => $dispatch_id,
                'bility_no' => $row['bility_no'],
                'truck_no' => $row['truck_no'],
                'driver_name' => $row['driver_name'],
                'dist_name' => $row['dist_name'],
                'sale_orders' => [],
                'palet_no' => $row['palet_no'],
                'items' => array_fill_keys($headers, 0)
            ];
        }
        
        $grouped_rows[$key]['sale_orders'][] = $sale_order;
        $grouped_rows[$key]['items']["Empty Slip#"] = $empty_slip;

        foreach ($headers as $header) {
            if (strtolower($row['item_name']) == strtolower($header)) {
                $grouped_rows[$key]['items'][$header] += $row['quantity'];
                $totals[$header] += $row['quantity'];
            } elseif (strtolower($row['empty_case']) == strtolower($header)) {
                $grouped_rows[$key]['items'][$header] += $row['emp_quantity'];
                $totals[$header] += $row['emp_quantity'];
            }
        }
    }

    $total_pallet_no = 0;

    foreach ($grouped_rows as $row) {
        $total_pallet_no += $row['palet_no'];
        echo "<tr style='font-weight:700;'>";
        echo "<td>" . $row['sr_no'] . "</td>";
        echo "<td>" . $row['dispatch_date'] . "</td>";
        echo "<td>" . $row['bility_no'] . "</td>";
        echo "<td>" . $row['truck_no'] . "</td>";
        echo "<td>" . $row['driver_name'] . "</td>";
        echo "<td>" . $row['dist_name'] . "</td>";
        echo "<td style='background:#87B23F;color:#fff;'>" . implode(', ', array_unique($row['sale_orders'])) . "</td>";
        echo "<td style='background:#0A4657;color:#fff;'>" . $row['palet_no'] . "</td>";
        
        foreach ($headers as $header) {
            echo "<td>" . ($row['items'][$header] == 0 ? '' : $row['items'][$header]) . "</td>";
        }
        echo "</tr>";
    }

    echo "<tr class='bg-light'><td colspan='7'><strong>Total</strong></td>";
    echo "<td style='background:#0A4657;color:#fff;'><strong>" . $total_pallet_no . "</strong></td>";
    foreach ($headers as $header) {
        echo "<td>" . ($totals[$header] == 0 ? '' : $totals[$header]) . "</td>";
    }
    echo "</tr>";
} else {
    echo "<tr><td colspan='28' class='bg-light text-dark' style='font-weight:600 ; font-size:20px; padding:20px;'>No data available for the selected date range.</td></tr>";
}
?>

            </tbody>
        </table>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true);
        var rows = clone.querySelectorAll('tr');

        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Dispatch" });
        try {
            XLSX.writeFile(workbook, 'Dispatch Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $('input[name="search_in"]').on('keyup', function() {
            var searchValue = $(this).val().toLowerCase();
            $('#patientTable tbody tr').each(function() {
                var rowText = $(this).text().toLowerCase();
                $(this).toggle(rowText.indexOf(searchValue) > -1);
            });
        });
    });
</script>
</body>
</html>
