<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Vehicle Wise Expense Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Quicksand', sans-serif;
        }
        #table-container {
            max-height: 1190px;
            overflow-y: auto;
        }
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .text-bold {
            font-weight: 700;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3" style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
            <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Vehicle Wise Expense Report</h3>
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;">Back</a>
        </div>
    </div>
</div>
<?php
// Get filter parameters
$truck_no = $_GET['truck_no'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

$filters = [];

// Add date filters if set
if (!empty($start_date) && !empty($end_date)) {
    $filters[] = "date_time BETWEEN '$start_date' AND '$end_date'";
}

// Truck-specific filter
if (!empty($truck_no) && $truck_no != 'All') {
    $filters[] = "truck_no = '$truck_no'";
}

if (!empty($filters)) {
    $where = 'WHERE ' . implode(' AND ', $filters);
    $query = "SELECT * FROM expence $where";
} else {
    $query = "SELECT * FROM expence"; // fallback: show all if no filters
}

$dexp = mysqli_query($connection, $query);

// Initialize total
$total_amount = 0;
while ($row = mysqli_fetch_array($dexp)) {
    $total_amount += floatval($row["amount"]);
}
?>

<div class="container" style="padding:50px;max-width:1600px;">
    <div class="row">
        <div class="col-sm-8">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Vehicle Wise Expense Report</h3>
        </div>
        <div class="col-sm-4">
            <table class="table table-bordered bg-white text-center">
                <tr>
                    <td style="font-weight:700; color:#fff; background:#0A4657;">Total Amount</td>
                    <td class="text-bold"><?php echo number_format($total_amount, 2); ?></td>
                </tr>
            </table>
        </div>
    </div>

    <?php
    $tr = mysqli_query($connection, "SELECT * FROM truck");
    ?>
    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Select Vehicle Diesel Ledger</label>
                    <select class="form-control" name="truck_no">
                        <option value="">Select</option>
                        <option value="All">All</option>
                        <?php
                        while ($r = mysqli_fetch_array($tr)) {
                            ?>
                            <option value="<?php echo $r["truck_num"]; ?>" <?php if (isset($_GET['truck_no']) && $_GET['truck_no'] == $r["truck_num"]) echo 'selected'; ?>><?php echo $r["truck_num"]; ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $_GET['start_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $_GET['end_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_vexp.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id="downloadExcel" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>
  <!-- Display total amount -->
    <div class="row">
        <div class="col-sm-12 text-right mb-3">
        </div>
    </div>
    <div id="table-container">
        <table id="patientTable" class="table table-bordered text-center table-striped bg-white">
            <tr class="bg-dark text-white text-bold">
                <th>Date</th>
                <th>Vehicle</th>
                <th>Description</th>
                <th>Diesel Total</th>
            </tr>
            <?php
            mysqli_data_seek($dexp, 0); // Reset the pointer for reuse
            while ($ro = mysqli_fetch_array($dexp)) {
                ?>
                <tr>
                    <td><?php echo $ro["date_time"]; ?></td>
                    <td><?php echo $ro["truck_no"]; ?></td>
                    <td style="color:#0A4657;font-weight:700;"><?php echo $ro["expence_name"]; ?></td>
                    <td><?php echo $ro["amount"]; ?></td>
                </tr>
                <?php
            }
            ?>
        </table>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true); 
        var rows = clone.querySelectorAll('tr');
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Vehicle Wise Expense" });
        try {
            XLSX.writeFile(workbook, 'Vehicle Wise Expense Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>
