<?php
// Database connection
include("../db/cn.php");

// Check connection
if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

// Fetch distributors for the dropdown
$dist_query = "SELECT dist_name FROM dist WHERE account_type = 'no'";
$dist_result = $connection->query($dist_query);

// Get filter conditions
$filter_query = "";
if (!empty($_GET['start_date']) && !empty($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];
    $filter_query .= "AND dispatch_date BETWEEN '$start_date' AND '$end_date' ";
}

if (!empty($_GET['dist_name'])) {
    $selected_dist = $_GET['dist_name'];
    $filter_query .= "AND dist_name = '$selected_dist' ";
}

// Fetch dispatch data
$query = "SELECT dispatch_id, dist_name, truck_no, driver_name, 
                 DATE(dispatch_date) as report_date, palet_no, 
                 COUNT(DISTINCT dispatch_id) as dispatch_count 
          FROM dispatch 
          WHERE palet_no BETWEEN 6 AND 22 
          $filter_query 
          GROUP BY dispatch_id, palet_no";

$result = $connection->query($query);

// Process data
$data = [];
$grand_totals = array_fill(6, 17, 0); // Initialize grand totals for pallet numbers from 6 to 22

while ($row = $result->fetch_assoc()) {
    $dist_name = $row['dist_name'];
    $report_date = $row['report_date'];
    $palet_no = $row['palet_no'];
    $dispatch_count = $row['dispatch_count'];

    if (!isset($data[$dist_name])) {
        $data[$dist_name] = [];
    }
    if (!isset($data[$dist_name][$report_date])) {
        $data[$dist_name][$report_date] = [
            'pallets' => [],
        ];
    }
    if (!isset($data[$dist_name][$report_date]['pallets'][$palet_no])) {
        $data[$dist_name][$report_date]['pallets'][$palet_no] = 0;
    }

    // Sum pallet count
    $data[$dist_name][$report_date]['pallets'][$palet_no] += $dispatch_count;

    // Increment grand totals for the current pallet number
    if ($palet_no >= 6 && $palet_no <= 22) {
        $grand_totals[$palet_no] += $dispatch_count;
    }
}

// Generate table
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dispatch Report</title>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
  <style>
    body {
        font-family: 'Quicksand', sans-serif;
    }

    #table-container {
        max-height: 890px;
        overflow-y: auto;
    }
    .bg {
        background: linear-gradient(270deg, #060606, #0A4657);
    }
    label {
        font-size: 13.5px;
        font-weight: 700;
    }
    .text-bold {
        font-weight: 700;
    }
    </style>
<body class="">
    <div class="container-fluid">
        <div class="row bg">
            <div class="col-sm-3" style=" height:69px;">
                <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
            </div>
            <div class="col-sm-6">
                <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase; margin-top:20px;">Driver Wise Dispatch Report</h3>
            </div>
            <div class="col-sm-3">
                <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right; font-weight:700;">Back</a>
            </div>
        </div>
    </div>


<div class="container mt-4">
    
<h2 style="font-weight:700;">Distribution Wise Dispatch Report</h2>
<!-- Filter Form -->
<form method="GET" action="" class="row g-3 mb-3">
    <div class="col-md-3">
        <label for="dist_name" class="form-label">Distributor:</label>
        <select name="dist_name" id="dist_name" class="form-select">
            <option value="">All Distributors</option>
            <?php while ($dist_row = $dist_result->fetch_assoc()) { ?>
                <option value="<?php echo $dist_row['dist_name']; ?>" 
                    <?php echo (isset($_GET['dist_name']) && $_GET['dist_name'] == $dist_row['dist_name']) ? 'selected' : ''; ?>>
                    <?php echo $dist_row['dist_name']; ?>
                </option>
            <?php } ?>
        </select>
    </div>
    <div class="col-md-3">
        <label for="start_date" class="form-label">Start Date:</label>
        <input type="date" id="start_date" name="start_date" class="form-control" 
               value="<?php echo isset($_GET['start_date']) ? $_GET['start_date'] : ''; ?>">
    </div>
    <div class="col-md-3">
        <label for="end_date" class="form-label">End Date:</label>
        <input type="date" id="end_date" name="end_date" class="form-control" 
               value="<?php echo isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
    </div>
    <div class="col-md-3 ">
                  <button type="submit" class="btn btn-dark" style="margin-top:30px;font-weight:700;">Filter</button>
                <a href="test.php" class="btn btn-dark" style="margin-top:30px;font-weight:700;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id='downloadExcel' style="margin-top:30px;font-weight:700;">Download</button>
    </div>
</form>
<div id="table-container">
<!-- Dispatch Report Table -->
<table id="patientTable" class="table table-bordered table-striped">
    <thead class="table-light">
        <tr class="text-center">
            <th style="background:#0A4657;color:#fff; font-weight:700;" rowspan="2">Distributor</th>
            <th style="background:#0A4657;color:#fff; font-weight:700;" rowspan="2">Date</th>
            <th style="background:#0A4657;color:#fff; font-weight:700;" colspan="17">Pallets</th>
        </tr>
        <tr>
            <?php for ($i = 6; $i <= 22; $i++) { ?>
                <th class="text-center"><?php echo $i; ?></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($data as $dist_name => $dates) { ?>
            <?php foreach ($dates as $report_date => $info) { ?>
                <tr style="font-weight:600;" class="text-center">
                    <td><?php echo $dist_name; ?></td>
                    <td><?php echo $report_date; ?></td>
                    <?php for ($i = 6; $i <= 22; $i++) { ?>
                        <td><?php echo isset($info['pallets'][$i]) ? $info['pallets'][$i] : ""; ?></td>
                    <?php } ?>
                </tr>
            <?php } ?>
        <?php } ?>
    </tbody>
    <tfoot>
        <tr class="table-dark text-center">
            <th colspan="2">Grand Total</th>
            <?php for ($i = 6; $i <= 22; $i++) { ?>
                <th><?php echo isset($grand_totals[$i]) ? $grand_totals[$i] : ""; ?></th>
            <?php } ?>
        </tr>
    </tfoot>
</table>

</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true);
        var rows = clone.querySelectorAll('tr');

        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        var workbook = XLSX.utils.table_to_book(clone, { sheet: " Distribution Wise Dispatch" });
        try {
            XLSX.writeFile(workbook, 'Distribution Wise Dispatch Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php $connection->close(); ?>
