<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Vehicle Diesel Ledger Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
 #table-container{
    max-height: 1190px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Vehicle Diesel Ledger Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>
<div class="container" style="padding:50px;max-width:1600px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Vehicle Diesel Ledger Report</h3>
        </div>
    </div>

    <?php
    $tr = mysqli_query($connection, "SELECT * FROM add_pro");
    ?>
    <form method="GET" action="">
        <div class="row">
           <div class="col-sm-3">
               <div class="form-group">
                   <label>Select Diesel Ledger</label>
                   <select class="form-control" name="diesel_name">
                       <option value="">Select</option>
                       <?php
                       while($r = mysqli_fetch_array($tr)){
                       ?>
                       <option value="<?php echo $r["diesel_name"]; ?>" <?php if(isset($_GET['diesel_name']) && $_GET['diesel_name'] == $r["diesel_name"]) echo 'selected'; ?>><?php echo $r["diesel_name"]; ?></option>
                       <?php
                       }
                       ?>
                   </select>
               </div>
           </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $_GET['start_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $_GET['end_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_dieselt.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id="downloadExcel" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

   <?php
$diesel_name = $_GET['diesel_name'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

$query_condition = " WHERE 1=1 ";
$filter_applied = false;

if (!empty($diesel_name)) {
    $query_condition .= " AND dis_name = '$diesel_name'";
    $filter_applied = true;
}
if (!empty($start_date) && !empty($end_date)) {
    $query_condition .= " AND date_time BETWEEN '$start_date' AND '$end_date'";
    $filter_applied = true;
}

if ($filter_applied) {
    // Fetch Opening Balance
    $opening_query = "SELECT SUM(amount) as opening, MIN(date_time) as date_time FROM diesel_open_amount $query_condition";
    $opening_result = mysqli_query($connection, $opening_query);
    $opening_row = mysqli_fetch_assoc($opening_result);
    $opening = $opening_row['opening'] ?? 0;
    $opening_date = $opening_row['date_time'] ?? '-';

    // Fetch Diesel Expenses
    $expense_query = "SELECT SUM(diesel_total) as total_expense, MIN(date_time) as date_time FROM diesel_exp $query_condition";
    $expense_result = mysqli_query($connection, $expense_query);
    $expense_row = mysqli_fetch_assoc($expense_result);
    $total_expense = $expense_row['total_expense'] ?? 0;
    $expense_date = $expense_row['date_time'] ?? '-';

    // Fetch Paid Amounts
    $paid_query = "SELECT SUM(amount) as total_paid, MIN(date_time) as date_time FROM disel_paid $query_condition";
    $paid_result = mysqli_query($connection, $paid_query);
    $paid_row = mysqli_fetch_assoc($paid_result);
    $total_paid = $paid_row['total_paid'] ?? 0;
    $paid_date = $paid_row['date_time'] ?? '-';

    // Fetch Net Cash
    $net_cash_query = "SELECT SUM(amount) as net_cash, MIN(date_time) as date_time FROM diesel_net $query_condition";
    $net_cash_result = mysqli_query($connection, $net_cash_query);
    $net_cash_row = mysqli_fetch_assoc($net_cash_result);
    $net_cash = $net_cash_row['net_cash'] ?? 0;
    $net_cash_date = $net_cash_row['date_time'] ?? '-';

    // Calculate Closing Balance
    $closing = $opening + $total_expense - $total_paid + $net_cash;

    echo '<div id="table-container">';
    echo '<table id="patientTable" class="table table-bordered text-center bg-white">';
    echo '<tr class="bg-dark text-white text-bold">';
    echo '<th>Date</th><th>Description</th><th>Amount</th><th>Balance</th>';
    echo '</tr>';

    echo "<tr><td>$opening_date</td><td>Opening Balance</td><td>$opening</td><td>$opening</td></tr>";
    echo "<tr><td>$expense_date</td><td>Diesel Expense</td><td>$total_expense</td><td>" . ($opening + $total_expense) . "</td></tr>";
    echo "<tr><td>$paid_date</td><td>Paid Amount</td><td>$total_paid</td><td>" . ($opening + $total_expense - $total_paid) . "</td></tr>";
    echo "<tr><td>$net_cash_date</td><td>Net Cash</td><td>$net_cash</td><td>" . ($closing ) . "</td></tr>";
    echo "<tr class='bg-dark text-white'><td>-</td><td>Closing Balance</td><td>$closing</td><td>$closing</td></tr>";

    echo '</table></div>';
} else {
    echo '<p class="text-center bg-light" style="padding:20px; font-size:20px;">Please apply filters to view the report.</p>';
}
?>
    </div>




</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Vehicle Diesel Ledger" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Vehicle Diesel Ledger Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>