<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Vehicle Wise Diesel Expense Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Quicksand', sans-serif; }
        #table-container { max-height: 1190px; overflow-y: auto; }
        .bg { background: linear-gradient(270deg, #060606, #0A4657); }
        label { font-size: 13.5px; font-weight: 700; }
        .text-bold { font-weight: 700; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3" style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
            <h3 class="mb-4 text-white font-weight-bold text-center text-uppercase mt-3">Vehicle Wise Diesel Expense Report</h3>
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light mt-3 float-right font-weight-bold">Back</a>
        </div>
    </div>
</div>

<div class="container" style="padding:50px; max-width:1600px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 class="font-weight-bold text-dark" style="font-size:35px;">Vehicle Wise Diesel Expense Report</h3>
        </div>
    </div>

    <?php
    $tr = mysqli_query($connection, "SELECT * FROM truck");
    ?>
    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Select Vehicle Diesel Ledger</label>
                    <select class="form-control" name="truck_no">
                        <option value="">Select</option>
                        <option value="All">ALL</option>
                        <?php while ($r = mysqli_fetch_array($tr)) { ?>
                            <option value="<?php echo $r["truck_num"]; ?>" <?php if (isset($_GET['truck_no']) && $_GET['truck_no'] == $r["truck_num"]) echo 'selected'; ?>>
                                <?php echo $r["truck_num"]; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $_GET['start_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $_GET['end_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark mt-4" type="submit">Filter</button>
                <a href="report_expv.php" class="btn btn-dark mt-4"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark mt-4" id="downloadExcel">Download</button>
            </div>
        </div>
    </form>

    <?php
    // Get filter parameters
    $truck_no = $_GET['truck_no'] ?? '';
    $start_date = $_GET['start_date'] ?? '';
    $end_date = $_GET['end_date'] ?? '';

    // Initialize flag to determine whether to display the table
    $show_table = false;

    // Build the query
    $query = "SELECT * FROM diesel_exp";
    $conditions = [];

    // Check if a specific vehicle or 'All' is selected
    if ($truck_no === "All" || ($truck_no && $truck_no !== "Select")) {
        $show_table = true;
        if ($truck_no !== "All") {
            $conditions[] = "truck_no = '$truck_no'";
        }
    }

    // Check if dates are provided
    if (!empty($start_date) && !empty($end_date)) {
        $conditions[] = "date_time BETWEEN '$start_date' AND '$end_date'";
    }

    if (count($conditions) > 0) {
        $query .= " WHERE " . implode(' AND ', $conditions);
    }

    $dexp = mysqli_query($connection, $query);

    // Now apply the same conditions for total diesel qty and amount calculation
    $total_qty_query = "SELECT SUM(diesel_qty) as total_qty, SUM(diesel_total) as total_amount FROM diesel_exp";
    if (count($conditions) > 0) {
        $total_qty_query .= " WHERE " . implode(' AND ', $conditions);
    }

    $total_result = mysqli_query($connection, $total_qty_query);
    $totals = mysqli_fetch_assoc($total_result);
    $total_qty = $totals['total_qty'] ?? 0;
    $total_amount = $totals['total_amount'] ?? 0;
    ?>

    <!-- Display total amount -->
    <div class="row">
        <div class="col-sm-4 text-right mb-3">
            <table class="table table-bordered bg-white text-center">
                <tr>
                    <td style="background:#0A4657;color:#fff; font-weight:700;">Total Diesel Qty:</td>
                    <td class="font-weight:700;"><?php echo number_format((float)$total_qty, 2); ?></td>
                </tr>
            </table>
        </div>
        <div class="col-sm-4 text-right mb-3">
             <table class="table table-bordered bg-white text-center">
                <tr>
                    <td style="background:#0A4657;color:#fff; font-weight:700;">Total Diesel Amount:</td>
                    <td class="font-weight:700;"><?php echo number_format((float)$total_amount, 2); ?></td>
                </tr>
            </table>
        </div>
    </div>

    <div id="table-container">
        <?php if ($show_table): ?>
        <table id="patientTable" class="table table-bordered text-center bg-white">
            <tr class="bg-dark text-white text-bold">
                <th>Date</th>
                <th>Company</th>
                <th>Vehicle</th>
                <th>Diesel Qty</th>
                <th>Diesel Rate</th>
                <th>Diesel Total</th>
            </tr>
            <?php
            if (mysqli_num_rows($dexp) > 0) {
                while ($ro = mysqli_fetch_array($dexp)) {
            ?>
                <tr>
                    <td><?php echo $ro["date_time"]; ?></td>
                    <td><?php echo $ro["dis_name"]; ?></td>
                    <td><?php echo $ro["truck_no"]; ?></td>
                    <td><?php echo $ro["diesel_qty"]; ?></td>
                    <td><?php echo $ro["diesel_rate"]; ?></td>
                    <td><?php echo $ro["diesel_total"]; ?></td>
                </tr>
            <?php 
                } 
            } else {
                echo '<tr><td colspan="6" class="text-center text-dark bg-light" style="padding:20px; font-size:20px;">No Entries Found.</td></tr>';
            }
            ?>
        </table>
        <?php endif; ?>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Vehicle Wise Diesel Expense" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Vehicle Wise Diesel Expense Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>
