<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Truck Expense Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
    
    
 #table-container{
    max-height: 1190px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/logo231.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Truck Expense Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>



<div class="container" style="padding:50px;max-width:1600px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Truck Expense Report</h3>
        </div>
    </div>

    <?php
    $tr = mysqli_query($connection, "SELECT * FROM truck");
    ?>
    <form method="GET" action="">
        <div class="row">
           <div class="col-sm-3">
               <div class="form-group">
                   <label>Select Vehicle</label>
                   <select class="form-control" name="truck_no">
                       <option value="">Select</option>
                       <?php
                       while($r = mysqli_fetch_array($tr)){
                       ?>
                       <option value="<?php echo $r["truck_num"]; ?>"><?php echo $r["truck_num"]; ?></option>
                       <?php
                       }
                       ?>
                   </select>
               </div>
           </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $_GET['start_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $_GET['end_date'] ?? '' ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_truckexp.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
            </div>
        </div>
    </form>

    <?php
    $truck_no = $_GET['truck_no'] ?? '';
    $start_date = $_GET['start_date'] ?? '';
    $end_date = $_GET['end_date'] ?? '';

    // Check if vehicle and date are selected
    if (!empty($truck_no) && (!empty($start_date) || !empty($end_date))) {
        // Construct the WHERE clause based on input
        $whereClauses = [];
        if (!empty($truck_no)) {
            $whereClauses[] = "truck_no = '$truck_no'";
        }
        if (!empty($start_date) && !empty($end_date)) {
            $whereClauses[] = "date_time BETWEEN '$start_date' AND '$end_date'";
        } elseif (!empty($start_date)) {
            $whereClauses[] = "date_time >= '$start_date'";
        } elseif (!empty($end_date)) {
            $whereClauses[] = "date_time <= '$end_date'";
        }

        $whereSQL = '';
        if (count($whereClauses) > 0) {
            $whereSQL = 'WHERE ' . implode(' AND ', $whereClauses);
        }

        $cexpQuery = "SELECT * FROM expence $whereSQL";
        $cexp = mysqli_query($connection, $cexpQuery);
        $totalAmount = 0;
    ?>

    <div id="table-container">
        <table class="table table-bordered text-center bg-white">
            <tr class="bg-dark text-white text-bold">
                <th>Date</th>
                <th>Description</th>
                <th>Amount</th>
            </tr>

            <?php
            while($row = mysqli_fetch_array($cexp)){
                $totalAmount += $row["amount"];
            ?>
                <tr>
                    <td><?php echo $row["date_time"]; ?></td>
                    <td><?php echo $row["expence_name"]; ?></td>
                    <td><?php echo $row["amount"]; ?></td>
                </tr>
            <?php
            }
            ?>
            <tr>
                <td colspan="2"><strong>Total Amount</strong></td>
                <td><strong><?php echo $totalAmount; ?></strong></td>
            </tr>
        </table>
    </div>

    <?php
    } else {
        // Show a message when the filter is not applied
        echo "<p class='bg-light text-dark' style='padding:30px;font-size:20px;'>Please select both a vehicle and at least one date to run the report.</p>";
    }
    ?>
</div>






<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>