<?php
// Database connection
include("../db/cn.php");

// Check connection
if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

// Fetch drivers for the dropdown
$driver_query = "SELECT DISTINCT driver_name FROM dispatch";
$driver_result = $connection->query($driver_query);

// Fetch trucks for the dropdown
$truck_query = "SELECT DISTINCT truck_no FROM dispatch";
$truck_result = $connection->query($truck_query);

// Get filter conditions
$filter_query = "WHERE palet_no BETWEEN 6 AND 22";

if (!empty($_GET['start_date']) && !empty($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];
    $filter_query .= " AND dispatch_date BETWEEN '$start_date' AND '$end_date'";
}

if (!empty($_GET['driver_name'])) {
    $selected_driver = $_GET['driver_name'];
    $filter_query .= " AND driver_name = '$selected_driver'";
}

if (!empty($_GET['truck_no'])) {
    $selected_truck = $_GET['truck_no'];
    $filter_query .= " AND truck_no = '$selected_truck'";
}

// Fetch dispatch data, including dist_name
$query = "SELECT truck_no, driver_name, dist_name, DATE(dispatch_date) as report_date, palet_no, 
                 COUNT(DISTINCT dispatch_id) as dispatch_count 
          FROM dispatch 
          $filter_query 
          GROUP BY truck_no, driver_name, dist_name, report_date, palet_no";

$result = $connection->query($query);

// Process data
$data = [];
$grand_totals = array_fill(6, 17, 0); // Initialize grand totals for pallet numbers from 6 to 22

while ($row = $result->fetch_assoc()) {
    $truck_no = $row['truck_no'];
    $driver_name = $row['driver_name'];
    $dist_name = $row['dist_name'];  // Added dist_name
    $report_date = $row['report_date'];
    $palet_no = $row['palet_no'];
    $dispatch_count = $row['dispatch_count'];

    if (!isset($data[$truck_no])) {
        $data[$truck_no] = [];
    }
    if (!isset($data[$truck_no][$driver_name])) {
        $data[$truck_no][$driver_name] = [];
    }
    if (!isset($data[$truck_no][$driver_name][$dist_name])) {  // Added dist_name to structure
        $data[$truck_no][$driver_name][$dist_name] = [];
    }
    if (!isset($data[$truck_no][$driver_name][$dist_name][$report_date])) {
        $data[$truck_no][$driver_name][$dist_name][$report_date] = [
            'pallets' => [],
        ];
    }
    if (!isset($data[$truck_no][$driver_name][$dist_name][$report_date]['pallets'][$palet_no])) {
        $data[$truck_no][$driver_name][$dist_name][$report_date]['pallets'][$palet_no] = 0;
    }

    // Sum pallet count
    $data[$truck_no][$driver_name][$dist_name][$report_date]['pallets'][$palet_no] += $dispatch_count;

    // Increment grand totals for the current pallet number
    if ($palet_no >= 6 && $palet_no <= 22) {
        $grand_totals[$palet_no] += $dispatch_count;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dispatch Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Quicksand', sans-serif;
        }
        #table-container {
            max-height: 790px; 
            overflow-y: auto; 
        }
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .text-bold {
            font-weight: 700;
        }
    </style>
</head>
<body class="">
    <div class="container-fluid">
        <div class="row bg">
            <div class="col-sm-3" style=" height:69px;">
                <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
            </div>
            <div class="col-sm-6">
                <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase; margin-top:20px;">Driver Wise Dispatch Report</h3>
            </div>
            <div class="col-sm-3">
                <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right; font-weight:700;">Back</a>
            </div>
        </div>
    </div>

    <div class="container" style="width:1490px;">
        <h2 class="mt-4" style="font-weight:700;">Driver Wise Dispatch Report</h2>

        <!-- Filter Form -->
        <form method="GET" action="" class="row g-3">
            <div class="col-md-2">
                <label for="driver_name" class="form-label">Driver:</label>
                <select name="driver_name" id="driver_name" class="form-select">
                    <option value="">All Drivers</option>
                    <?php while ($driver_row = $driver_result->fetch_assoc()) { ?>
                        <option value="<?php echo $driver_row['driver_name']; ?>" 
                            <?php echo (isset($_GET['driver_name']) && $_GET['driver_name'] == $driver_row['driver_name']) ? 'selected' : ''; ?>>
                            <?php echo $driver_row['driver_name']; ?>
                        </option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-md-2">
                <label for="truck_no" class="form-label">Truck No:</label>
                <select name="truck_no" id="truck_no" class="form-select">
                    <option value="">All Trucks</option>
                    <?php while ($truck_row = $truck_result->fetch_assoc()) { ?>
                        <option value="<?php echo $truck_row['truck_no']; ?>" 
                            <?php echo (isset($_GET['truck_no']) && $_GET['truck_no'] == $truck_row['truck_no']) ? 'selected' : ''; ?>>
                            <?php echo $truck_row['truck_no']; ?>
                        </option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-md-2">
                <label for="start_date" class="form-label">Start Date:</label>
                <input type="date" id="start_date" name="start_date" class="form-control" 
                       value="<?php echo isset($_GET['start_date']) ? $_GET['start_date'] : ''; ?>">
            </div>

            <div class="col-md-2">
                <label for="end_date" class="form-label">End Date:</label>
                <input type="date" id="end_date" name="end_date" class="form-control" 
                       value="<?php echo isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
            </div>

            <div class="col-md-4  ">
                <button type="submit" class="btn btn-dark" style="margin-top:30px;font-weight:700;">Filter</button>
                <a href="test2.php" class="btn btn-dark" style="margin-top:30px;font-weight:700;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id='downloadExcel' style="margin-top:30px;font-weight:700;">Download</button>
            </div>
        </form>

        <!-- Dispatch Report Table -->
        <div id="table-container">
        <table id="patientTable" class="table table-bordered mt-4">
            <thead class="" >
                <tr class="text-center" >
                    <th style="background:#0A4657; color:#fff; font-weight:700;" rowspan="2">Truck No</th>
                    <th style="background:#0A4657; color:#fff; font-weight:700;" rowspan="2">Driver</th>
                    <th style="background:#0A4657; color:#fff; font-weight:700;" rowspan="2">Dist Name</th> <!-- Added Dist Name -->
                    <th style="background:#0A4657; color:#fff; font-weight:700;" rowspan="2">Date</th>
                    <th style="background:#0A4657; color:#fff; font-weight:700;" colspan="17">Pallets</th>
                </tr>
                <tr>
                    <?php for ($i = 6; $i <= 22; $i++) { ?>
                        <th><?php echo $i; ?></th>
                    <?php } ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data as $truck_no => $drivers) { ?>
                    <?php foreach ($drivers as $driver_name => $dist_names) { ?>
                        <?php foreach ($dist_names as $dist_name => $dates) { ?> <!-- Added dist_name level -->
                            <?php foreach ($dates as $report_date => $info) { ?>
                                <tr style="font-weight:600;">
                                    <td><?php echo $truck_no; ?></td>
                                    <td><?php echo $driver_name; ?></td>
                                    <td><?php echo $dist_name; ?></td> <!-- Display dist_name -->
                                    <td><?php echo $report_date; ?></td>
                                    <?php for ($i = 6; $i <= 22; $i++) { ?>
                                        <td><?php echo isset($info['pallets'][$i]) ? $info['pallets'][$i] : ""; ?></td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    <?php } ?>
                <?php } ?>
            </tbody>
            <tfoot class="table-dark text-white">
                <tr>
                    <th colspan="4">Grand Total</th> <!-- Adjusted colspan to 4 -->
                    <?php for ($i = 6; $i <= 22; $i++) { ?>
                        <th><?php echo isset($grand_totals[$i]) ? $grand_totals[$i] : ""; ?></th>
                    <?php } ?>
                </tr>
            </tfoot>
        </table>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true);
        var rows = clone.querySelectorAll('tr');

        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        var workbook = XLSX.utils.table_to_book(clone, { sheet: " Driver Wise Dispatch" });
        try {
            XLSX.writeFile(workbook, 'Driver Wise Dispatch Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
</body>
</html>

<?php $connection->close(); ?>
