<?php
include("../db/cn.php");  // Database connection
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Get Gate Pass No. from URL (example: gatepass.php?gate_pass=1234)
$gatePassNo = isset($_GET['order_id']) ? $_GET['order_id'] : '';

$query = "SELECT id, product_name, product_quantity, customer_name, truck_no, gate_pass, customer_phone 
          FROM log_user_sales 
          WHERE order_id = '" . mysqli_real_escape_string($connection, $gatePassNo) . "'";

$result = mysqli_query($connection, $query);

// Fetch first row for header info
$header = mysqli_fetch_assoc($result);
mysqli_data_seek($result, 0); // reset pointer for table loop
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Gate Pass</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Times New Roman', serif;
      background: #f8f9fa;
    }
    .gate-pass {
      max-width: 700px;
      margin: 20px auto;
      padding: 40px;
      border: 2px solid #000;
      background: #fff;
      min-height: 1100px;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }
    .company-title {
      text-align: center;
      font-size: 36px;
      font-weight: bold;
      letter-spacing: 6px;
    }
    .company-details {
      text-align: center;
      font-size: 15px;
      margin-bottom: 10px;
    }
    .gate-pass-title {
      text-align: center;
      font-size: 22px;
      font-weight: bold;
      text-decoration: underline;
      margin: 20px 0;
    }
    .info-row label {
      font-weight: bold;
      margin-right: 10px;
    }
    .table-bordered th,
    .table-bordered td {
      vertical-align: middle;
      text-align: center;
      height: 42px;
      border: 1px solid #000 !important;
    }
    .table thead th {
      background: #f1f1f1;
      font-weight: bold;
    }
    .footer-signatures {
      margin-top: 100px;
      display: flex;
      justify-content: space-between;
    }
    .footer-signatures .footer-col {
      flex: 1;
      text-align: center;
      font-weight: bold;
      font-size: 14px;
    }
    .footer-line {
      border-top: 1px solid #000;
      margin-top: 40px;
      padding-top: 5px;
    }
  </style>
</head>
<body>
  <div class="gate-pass">
    <div>
      <div class="company-title">AL GHANI TRADERS</div>
      <div class="company-details">
        <h4>Mumtazabad Vehari Road, Multan</h4>
        <h5>Cell: 0307-7386664</h5>
      </div>
      <div class="gate-pass-title">Gate Pass</div>

      <div class="row mb-2 info-row">
        <div class="col-md-6">
          <label>GatePass No.</label> <?php htmlspecialchars($header['gate_pass'] ?? '') ?>
        </div>
        <div class="col-md-6 text-end">
          <label>Vehicle No.</label> <?php htmlspecialchars($header['truck_no'] ?? '') ?>
        </div>
      </div>

      <div class="row mb-2 info-row">
        <div class="col-md-6">
          <label>Customer Name:</label> <?php htmlspecialchars($header['customer_name'] ?? '') ?>
        </div>
        <div class="col-md-6 text-end">
          <label>Phone:</label> <?php htmlspecialchars($header['customer_phone'] ?? '') ?>
        </div>
      </div>

      <table class="table table-bordered">
        <thead>
          <tr>
            <th style="width:20%">S.No.</th>
            <th style="width:50%">Product</th>
            <th style="width:30%">Quantity</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result && mysqli_num_rows($result) > 0): ?>
            <?php $sno = 1; ?>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
              <tr>
                <td><?= $sno++; ?></td>
                <td><?= htmlspecialchars($row['product_name']); ?></td>
                <td><?= htmlspecialchars($row['product_quantity']); ?></td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr><td colspan="3">No records found</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="footer-signatures">
      <div class="footer-col">
        <div class="footer-line">Prepared By:</div>
      </div>
      <div class="footer-col">
        <div class="footer-line">Head of Deptt.</div>
      </div>
      <div class="footer-col">
        <div class="footer-line">Authorized By:</div>
      </div>
      <div class="footer-col">
        <div class="footer-line">Received</div>
      </div>
    </div>
  </div>
</body>
</html>
