<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);

ini_set('display_startup_errors', 1);

error_reporting(E_ALL);

 
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}


// Fetch order details from the database
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $desc_name = $order["desc_name"];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
        $gatePass = $order['gate_pass'];
    }
}


?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Invoice - Al Ghani Traders</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @page { size: A5; margin: 5mm; }
    body { font-size: 12px; font-family: "Arial", sans-serif; }
    .invoice-box { border: 1px solid #000; padding: 6px; }
    .title { font-size: 18px; font-weight: bold; text-align: center; margin: 0; }
    .subtitle { font-size: 14px; text-align: center; margin: -2px 0 4px 0; }
    .table th, .table td {
      border: 1px solid #000 !important;
      padding: 3px 4px;
      text-align: center;
      font-size: 12px;
    }
    .table thead th {
      background: #f8f8f8;
      font-weight: bold;
    }
    .totals-box {
      border: 1px solid #000;
      padding: 3px 6px;
      line-height: 1.2;
      font-size: 12px;
      height: 100%;
    }
    .signature-box { margin-top: 10px; font-size: 12px; }
    .footer { font-size: 10px; text-align: center; margin-top: 5px; }
    .contact-box { border-top: 1px solid #000; padding-top: 3px; }
    @media print {
            
            .no-print {
                display: none;
            }
         
           
        }
  </style>
</head>
<body onload="window.print()">

<div class="invoice-box container-fluid">

  <!-- Header -->
  <div class="row align-items-center mb-1">
    <div class="col-3">
      <img src="logo.png" alt="Logo" style="max-width:90px;">
    </div>
    <div class="col-6 text-center">
      <p class="title">Al Ghani Traders</p>
      <p class="subtitle">Sale Invoice</p>
    </div>
    <div class="col-3 text-end">
      <p class="mb-0"><b>Invoice:</b> <?php echo htmlspecialchars($orderId); ?></p>
      <p class="mb-0"><b>Date:</b> <?php echo htmlspecialchars($dateTime); ?></p>
    </div>
  </div>

  <!-- Customer Info -->
  <div class="row">
    <div class="col-6">
      <p class="mb-0"><b>Name:</b> <?php echo htmlspecialchars($customerName); ?></p>
      <p class="mb-0"><b>Phone:</b><?php echo htmlspecialchars($customerPhone); ?></p>
    </div>
    <div class="col-6 text-end">
      <p class="mb-0"><b>Truck No:</b>  <?php echo htmlspecialchars($truck_no); ?></p>
      <p class="mb-0"><b>Gate-Pass:</b> <?php echo $gatePass; ?></p>
    </div>
  </div>

  <!-- Items Table -->
  <table class="table table-bordered mt-2">
    <thead>
       <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Dis</th>
                    <th>PKR</th>
                </tr>
    </thead>
    <tbody>
      <?php foreach ($orderDetails as $order): ?>
                <tr>
                    <td><?php echo htmlspecialchars($order['product_name']); ?></td>
                    <td><?php echo htmlspecialchars($order['product_quantity']); ?></td>
                    <td><?php echo htmlspecialchars($order['product_price']); ?></td>
                    <td><?php echo htmlspecialchars($order['discount']); ?></td>
                    <td><?php echo htmlspecialchars($order['net_amount']); ?></td>
                </tr>
                <?php endforeach; ?>
    </tbody>
  </table>
    <?php
    $sub = mysqli_query($connection, "SELECT SUM(remain_balance) AS rm FROM creditor_closing WHERE creditor_name = '$customerName'");
    $rowSub = mysqli_fetch_array($sub);
    $pre = $rowSub["rm"];
    $close = $discountedAmount + $pre;
    
    ?>
  <!-- Totals -->
  <div class="row mt-1">
    <div class="col-6">
      <div class="totals-box">
        <p class="mb-0">Total Value: <?php echo htmlspecialchars($discountedAmount); ?> </p>
        <p class="mb-0">Discount in Rs: <?php echo htmlspecialchars($discounted); ?></p>
        <p class="mb-0">Trade Offer: 0</p>
        <p class="mb-0">Sale Tax: 0</p>
        <p class="mb-0">Special Discount: 0</p>
        <p class="mb-0"><b>Net Value: <?php echo htmlspecialchars($discountedAmount) . ".00"; ?></b></p>
      </div>
    </div>
    <div class="col-6 text-end">
      <div class="totals-box">
        <p class="mb-0">Previous Balance: <?php echo (int)$pre . ".00"; ?></p>
        <p class="mb-0"><b>Total Balance: <?php echo htmlspecialchars($close) . ".00"; ?></b></p>
      </div>
    </div>
  </div>

  <!-- Signatures -->
  <div class="row signature-box">
    <div class="col-6">
      <p><b>Salesman:</b> ______________________</p>
    </div>
    <div class="col-6 text-end">
      <p><b>Signature & Stamp:</b> ______________________</p>
    </div>
  </div>
  <?php
// Get the current date and time
$date = new DateTime();

// Format the date and time to match the required format
$formattedDate = $date->format('l, F j, Y g:i:s A');

// Output the formatted date
echo $formattedDate;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['exit'])) {
    if (!empty($customerName) && is_numeric($changeAmount)) {
        $checkQuery = "SELECT 1 FROM creditor_closing WHERE creditor_name = '$customerName' LIMIT 1";
        $checkResult = mysqli_query($connection, $checkQuery);

        if (mysqli_num_rows($checkResult) > 0) {
            // Record exists: update
            $updateQuery = "UPDATE creditor_closing SET remain_balance = $changeAmount WHERE creditor_name = '$customerName'";
            $updateResult = mysqli_query($connection, $updateQuery);

            if ($updateResult) {
                   echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
                exit;
            } else {
                echo "<p style='color:red;'>Update failed: " . mysqli_error($connection) . "</p>";
            }
        } else {
            // Record doesn't exist: insert
            $insertQuery = "INSERT INTO creditor_closing (
                creditor_name, opening_cash, credit_sales, credit_recieved,
                remain_balance, date_time, login_user, user_role,
                outlet_name, outlet_address
            ) VALUES (
                '$customerName', 0, 0, 0, $changeAmount, NOW(), '$userName', '$useRole', '$outlet_name', '$outlet_address'
            )";

            $insertResult = mysqli_query($connection, $insertQuery);

            if ($insertResult) {
           echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
                exit;
            } else {
                echo "<p style='color:red;'>Insert failed: " . mysqli_error($connection) . "</p>";
            }
        }
    }
}
?>
  <!-- Footer -->
  <div class="footer">
    <p><b>THANK YOU FOR YOUR BUSINESS</b></p>
    <div class="contact-box">
      <p class="mb-0">Contact Us: Hamid Basheer 0307-7386664 | Haji M. Afzal 0301-7604667</p>
      <p class="mb-0">Email: alghanitraders000@gmail.com</p>
      <p class="mb-0">Awan Street Vehani Road Backside Total Parco Petrol Pump New Mumtazabad, Multan</p>
      <p class="mb-0">Developed By: Muzamil Hussain | Contact: 0308-2711294</p>
    </div>
  </div>
</div>
 <div class="text-center no-print">
        <button class="no-print btn btn-primary" onclick="window.print()">Print</button>
        <!--<button class="no-print btn btn-success" onclick="downloadPDF()">Download PDF</button>-->
         <a href="gate_pass.php?order_id=<?php echo $orderId; ?>" target="_blank" class="btn btn-secondary no-print">Gate Pass</a>
     <form method="post" style="display:inline;">
            <button type="submit" name="exit" class="btn btn-secondary no-print">Exit</button>
        </form>
    </div>
</body>
</html>
