 <?php
include("../db/cn.php");
ob_start();
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'] ?? 'admin';
    $userRole = $_SESSION['user_role'] ?? 'superadmin';
    $outlet_address = $_SESSION['outlet_address'] ?? 'burewala';
    $outlet_name = $_SESSION['outlet_name'] ?? 'admin';
}
if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}
if (isset($_GET['query'])) {
    $query = $connection->real_escape_string($_GET['query']);
    $sql = "SELECT product_id, product_name, retail_prices, rpperpack, tpperpack, trade_price, supplier, company, product_unit, expiry, noofunit, total_quantity, flavour FROM products WHERE product_name LIKE '%$query%' GROUP BY product_name";
    $result = $connection->query($sql);

    $suggestions = "";
    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-product-id='" . $row['product_id'] . "' data-product-quantity='" . $row['total_quantity'] . "' data-noofunit='" . $row['noofunit'] . "' data-retail-price='" . $row['retail_prices'] . "' data-trade-price='" . $row['trade_price'] . "'  data-flavour='" . $row['flavour'] . "' data-supplier='" . $row['supplier'] . "' data-company='" . $row['company'] . "' data-product-unit='" . $row['product_unit'] . "'>" . $row['product_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}
if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT cr_name, shop_name, route, cr_address, phone_number FROM credit_note WHERE shop_name LIKE '%$customerName%' LIMIT 5";

    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-customer-name='" . $row['shop_name'] . "' data-customer-id='" . $row['route'] . "' data-customer-phone='" . $row['phone_number'] . "'>" . $row['shop_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}
// // Handle AJAX request
// if (isset($_GET['batch_no']) && isset($_GET['productInput'])) {
//     $batch_no = $_GET['batch_no'];
//     $query = $_GET['productInput'];

//     // Use a prepared statement to prevent SQL injection
//     $stmt = $connection->prepare("SELECT batch_no, expiry, rpperpack, product_name FROM products WHERE batch_no = ? AND product_name = ?");
//     $stmt->bind_param("ss", $batch_no, $query);
//     $stmt->execute();
//     $result = $stmt->get_result();

//     if ($result->num_rows > 0) {
//         echo json_encode($result->fetch_assoc());
//     } else {
//         echo json_encode(["error" => "Batch not found"]);
//     }
//     $stmt->close();

//     exit;
// }

if (isset($_GET['order_id'])) {
   
    // Get the search term
    $order_id = $_GET['order_id'];

    if (!empty($order_id)) {
        // Query to search for order_ids in the log_user_sales table
        $stmt = $connection->prepare("SELECT order_id FROM log_user_sales WHERE order_id LIKE ? GROUP BY order_id");
        $like_order_id = "%" . $order_id . "%";
        $stmt->bind_param("s", $like_order_id);
        $stmt->execute();
        $result = $stmt->get_result();

        // Generate HTML output
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo '<div class="dropdown-item" data-order-id="' . $row['order_id'] . '">Order #' . $row['order_id'] . '</div>';
            }
        } else {
            echo '<div class="dropdown-item">No orders found</div>';
        }

        $stmt->close();
    }

    $connection->close();
    exit; // End the PHP processing for AJAX request here
}

$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["bill"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $orderId = "OR-" . str_pad(mt_rand(0, 99999), 5, '0', STR_PAD_LEFT);
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $desc_name = $_POST["desc_name"];
    $truck_no = $_POST["truck_no"];
    $fri = $_POST["frieght"] ?? '0.00';
    $gate_pass = $_POST["gate_pass"];
    $customer_id = $_POST["customer_id"];
	$r_order_id = $_POST["r_order_id"];
	$SStax = $_POST["SStax"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $BQuantity = $product['Bquantity'];
        $Lqty = $product['Lqty'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $saleT = $product['tax'];
        $Noofunit = $product['noofunit'];
        $batchNo = $product['BatchNo'];
        $Exp = $product['EXp'];
        $PrUnit = $product['productUnit'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $flv = $product['flavour'];
        $company = $product['company'];
        $sale_cost = $tradePrice * $productQuantity;
        $Tqty = $productQuantity * $Noofunit;
        $tQty = $Tqty + $Lqty + $BQuantity;
		$tp = $sale_cost;
        $sql = "INSERT INTO log_user_sales (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            loose,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            desc_name,
            truck_no,
            gate_pass,
            discount_per,
            cash_amount,
            change_amount,
            frieght,
            order_id,
			r_order_id,
			status,
			sale_tax,
			batch_no,
			expiry,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time,
            product_unit,
            flavour
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '$BQuantity',
            '$Lqty',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$desc_name',
            '$truck_no',
            '$gate_pass',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$fri',
            '$orderId',
			'$r_order_id',
			'',
			'$SStax',
			'$batchNo',
			'$Exp',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time',
            '$PrUnit',
            '$flv'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }
 // Update product quantity based on payment type
            
                $updateSql = "UPDATE products SET total_quantity = total_quantity - $tQty, total_amount = total_amount - $tp  WHERE product_name = '$productName' AND flavour = '$flv'";
          
            if ($connection->query($updateSql) !== TRUE) {
                throw new Exception("Error updating product quantity: " . $connection->error);
            }
        }

    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'printpos3.php?order_id=$orderId';</script>";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["refund"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $paidBy = $_POST["method"];
    $status = 'Refund';
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $desc_name = $_POST["desc_name"];
    $customer_id = $_POST["customer_id"];
    $r_order_id = $_POST["r_order_id"];
     $SStax = $_POST["SStax"];
    $date_time = date("Y-m-d");
    $orderId = $r_order_id;

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $BQuantity = $product['Bquantity'];
        $Lqty = $product['Lqty'];
        $tax = $product['tax'];
        $batchNo = $product['BatchNo'];
        $Exp = $product['EXp'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        
        // Calculate the sale cost to add to total_amount on refund
        $refundAmount = $tradePrice * $productQuantity; // Total amount for the refund
        $Tqty = $productQuantity + $BQuantity;
        // Insert refund entry into log_user_sales
        $sql = "INSERT INTO log_user_sales (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            loose,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            desc_name,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            r_order_id,
            status,
            sale_tax,
			batch_no,
			expiry,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time,
            product_unit
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '-$productQuantity', /* Negative quantity for logging refund in log_user_sales */
            '$productTotal',
            '$BQuantity',
            '$Lqty',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$refundAmount',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$desc_name',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$r_order_id',
            '$status',
            '$SStax',
			'$batchNo',
			'$Exp',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time',
            '$PrUnit'
        )";

        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        // Update the products table to increase both quantity and total_amount for the refund
        $updateSql = "UPDATE products 
                      SET quantity = quantity + $productQuantity, 
                          total_amount = total_amount + $refundAmount 
                      WHERE product_id = '$productId'";

        if ($connection->query($updateSql) !== TRUE) {
            throw new Exception("Error updating product quantity: " . $connection->error);
        }
    }

    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}



if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["hold"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $orderId = uniqid("ORDER");
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    
	$r_order_id = $_POST["r_order_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
          $BQuantity = $product['Bquantity'];
        $Lqty = $product['Lqty'];
        $tax = $product['tax'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = (int)$tradePrice * (int)$productQuantity;
       
        $sql = "INSERT INTO pay_hold (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            loose,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '$BQuantity',
            '$Lqty',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }
            
        }
   
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["creditor_open"])) {
    $date_time  = !empty($_POST["date_time"]) ? $_POST["date_time"] : date("d-m-Y");
    $cr_name    = $_POST["cr_name"];
    $amount     = $_POST["amount"];
    $paid_by    = $_POST["paid_by"];
    $description= $_POST["description"];
    $shop_name  = $_POST["shop_name"];
    $route      = $_POST["route"];
    $booker     = $_POST["booker"];

    mysqli_query($connection, "INSERT INTO credit_paid 
        (cr_name, amount, paid_by, shop_name, route, booker, date_time, user_name, user_role, outlet_name, outlet_address, description)
        VALUES (
            '".$cr_name."','".$amount."','".$paid_by."','".$shop_name."',
            '".$route."','".$booker."','".$date_time."',
            '".$userName."','".$userRole."','".$outlet_name."','".$outlet_address."','".$description."'
        )");

    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>AL GHANI TRADERS
</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}

    
 #table-container-wrapper {
    max-height: 520px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
.btn-primary{
    background:#0A4657;
    color:#fff;
    border:1px solid #0A4657;
}
.btn-primary:hover{
    background:#fff;
    color:#0A4657;
    border:1px solid #0A4657;
}

.form-control, option{
    font-weight:700;
    color:#000;
}
.btn{
    font-weight:700;
}
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row bg align-items-center" style="height:86px;">
        <div class="col-sm-2 d-flex justify-content-start">
            <img src="../img/btt.png" 
                 style="margin-top:5px; background:#fff; border-radius:70px;" 
                 width="58" height="58">
        </div>
        <div class="col-sm-5 text-right">
            <h3 class="mb-0 text-white fw-bold font-weight-bold text-uppercase" style="line-height:60px;">
                AL GHANI TRADERS
            </h3>
        </div>
        <div class="col-sm-5 d-flex justify-content-end gap-2">
            <button type="button" id="get_button" 
                    class="btn btn-primary text-white"
                    data-bs-toggle="modal" 
                    data-bs-target="#addPurchaseModal">
                Receiving
            </button>

            <a href="addproduct.php" class="btn btn-light">Back</a>
        </div>
    </div>
</div>

<div class="container-fluid">
    <form id="myForm" action="mainpos.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-3" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Product</span>
                    </div>
                    <input type="text" class="form-control" id="productInput" placeholder="Start typing a product name..." autocomplete="off" 
                    style="font-weight:700;" >
                    <div class="dropdown-menu" id="suggestions"></div>
                </div>
                <hr>
                <div class="row">
                <div class="">
                    
                    <input type="hidden" id="batch_no" name="batch_no" value='0' class="form-control" placeholder="" style="font-weight:700;">
                </div>
                <div class="">
                    
                    <input type="hidden" id="expiry" name="expiry" value='0' class="form-control" placeholder=""
                    style="font-weight:700;" readonly>
                    
                </div>
                </div>
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <span class="input-group-text bg-dark text-white">FLV.</span>
                  </div>
                  <select id="flavour" name="flavour" class="form-control" style="font-weight:700;">
                    <option value="">-- Select Flavour --</option>
                  </select>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6" >
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">P.Qty</span>
                    </div>
                    <input type="text" id="quantity" name="quantity" class="form-control" placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3 col-6" >
                    <input type="text" id="noofunit" name="noofunit" 
                    class="form-control" placeholder="" style="font-weight:700;">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">No.of.Unit</span>
                    </div>
                </div>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">B.Qty</span>
                    </div>
                    <input type="text" id="bonus_quantity" name="bonus_quantity" class="form-control" 
                    placeholder="" style="font-weight:700;" >
                </div>
                <div class="input-group mb-3 col-6">
                    <input type="text" id="loose_quantity" name="loose_quantity" class="form-control" 
                    placeholder="" style="font-weight:700;" >
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">L.Qty</span>
                    </div>
                </div>
                <div class="input-group mb-3 col-12">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">T.Qty</span>
                    </div>
                    <input type="text" id="total_quantity" name="total_quantity" class="form-control" 
                    placeholder="" style="font-weight:700;" readonly>
                </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Price-Unit</span>
                    </div>
                    <input type="text" id="retail_price" name="retail_price" class="form-control" placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="total_amount" name="total_amount" class="form-control" placeholder="" readonly style="font-weight:700;">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">-/ PKR</span>
                    </div>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis %</span>
                    </div>
                    <input type="text" id="percentage" name="percentage" class="form-control"  placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3 col-6">
                    <input type="text" id="disc_amount" name="disc_amount"
                    class="form-control"  placeholder="" style="font-weight:700;">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis PKR</span>
                    </div>
                </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">S.Tax %</span>
                    </div>
                    <input type="text" id="sale_tax" name="sale_tax" class="form-control"  placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="trade_price" name="trade_price" class="form-control" placeholder="" readonly style="font-weight:700;">
                </div>
               
                <button type="button" class="form-control btn btn-dark" id="makeEntry" style="font-weight:700;color:#fff;">Make Entry</button>
                    <hr>
                    <button type="button" class="form-control btn btn-dark text-white" onclick="location.reload();">Refresh</button>
                    <hr>
                     <div class="">
                        <div class="form-group">
                        <label>Gate Pass</label>
                            <input type="text"  id="gate_pass" name="gate_pass" class="form-control in_form">
                        </div>
                    </div>
                    <div class="">
                     <div class="form-group">
                    <label>Description</label>
                    <input type="text" class="form-control in_form"  name="desc_name" >
             
                    </div>
                   </div>
    <!--            <h3 class="text-center" style="font-size:18px; font-weight:700; padding:7px; width:100%; background:#0A4657;color:#fff;">History</h3>-->
    <!--             <div class="form-group position-relative">-->
    <!--               <label for="customer_name2">Customer Name:</label>-->
    <!--               <input type="text" id="customer_name2" class="form-control" placeholder="Type customer name..." style="font-weight:700; color:#000;">-->
    <!--               <div id="customerSuggestions" class="dropdown-menu"></div>-->
    <!--             </div>-->

    <!-- Product Input -->
    <!--<div class="form-group position-relative">-->
    <!--    <label for="productInput2">Product Name:</label>-->
    <!--    <input type="text" id="productInput2" class="form-control" placeholder="Type product name..." style="font-weight:700; color:#000;">-->
    <!--    <div id="productSuggestions" class="dropdown-menu"></div>-->
    <!--</div>-->

    <!-- Product Details Table -->
    <!--<table class="table table-bordered mt-4 table-sm text-center bg-white">-->
    <!--    <thead>-->
    <!--    <tr class="bg-dark text-white">-->
    <!--        <th>Order ID</th>-->
    <!--        <th>Product</th>-->
    <!--        <th>Price</th>-->
    <!--    </tr>-->
    <!--    </thead>-->
        <tbody id="productTableBody"></tbody>
    <!--</table>-->
                <!--<a href="view_hold.php"><button type="button" class="form-control btn btn-dark" >View Hold Bill</button></a>
                <hr>-->
                
                  
            </div>
            <?php
            $b = mysqli_query($connection,"select * from booker");
            ?>
            <div class="col-sm-9">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-3">
                        <div class="form-group">
                         <label>Booker</label>
                            <select style="font-weight:700;" class="form-control in_form" name="customer_type">
                            <option value="">Select</option>
                            <?php
                            while($br = mysqli_fetch_array($b)){
                            ?>
                            <option valu="<?php echo $br["name"];?>"><?php echo $br["name"]; ?></option>
                            <?php
                            }
                            ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Name</label>
                            <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                            <div class="dropdown-menu" id="customer_suggestions"></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Phone</label>
                            <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Address</label>
                            <input type="text" id="customer_id" name="customer_id" class="form-control in_form">
                        </div>
                    </div>
                     <div class="col-sm-3">
                        <div class="form-group">
                            <label>Refund ID</label>
                            <input type="text" id="r_order_id" name="r_order_id" class="form-control in_form">
                            <div id="order_suggestions" class="dropdown-menu" style="display: none;"></div>
                        </div>
                    </div>
                    
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Vehicle No.</label>
                            <input type="text" id="truck_no" name="truck_no" class="form-control in_form">
                        </div>
                    </div>
                   
                </div>
                <div class="row" style="background:#fff; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12" style="height:580px;">
                        <table class="table table-borderless table-sm text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#0A4657;font-weight:700;">
                                <td>R.Qty</td>
                                <td>Item Code</td>
                                <td>Description</td>
                                <td>P.Qty</td>
                                <td>B.Qty</td>
                                <td>L.Qty</td>
                                <td>Unit Price</td>
                                <td>Amount</td>
                                <td>Dis%</td>
                                <td>Dis PKR</td>
                                <td>Tax</td>
                                <td>Net Amount</td>
                                <td>.FLV</td>
                                <td>Action</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Total</label>
                                    <input type="number" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Frieght</label>
                                    <input type="text" id="frieght" name="frieght" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount"
                                    name="discount_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount %</label>
                                    <input type="number" id="discount_percent"
                                    name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                           
                                    <input type="hidden" value="0" id="cash_received" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                                    
                                    <input type="hidden"  id="cash_return" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                                    
                                    <input type="hidden" id="SStax" name="SStax" class="form-control in_form input-height"  >
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method" class="form-control in_form">
                                         <option value="credit">Credit</option>
                                         <!--<option value="cash">Cash</option>-->
                                         <!--<option value="bank1">Easy Paisa</option>-->
                                         <!--<option value="bank2">Jazz cash</option>-->
                                         <!--<option value="bank3">Allied bank</option>-->
                                         <!--<option value="bank4">Hbl</option>-->
                                         <!--<option value="bank5">Bank Al-Habib</option>-->
                                         <!--<option value="bank6">Meezan Bank</option>-->
                                         <!--<option value="others">Others</option>-->
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-3">
                                <hr>
                                <button type="submit" name="bill" id="submitBtn" class="btn btn-dark btn-sm">Generate Invoice</button>
                                <!--<button type="submit" name="hold" class="btn btn-success btn-sm">Hold Bill</button>-->
                                <button type="submit" name="refund" class="btn btn-danger btn-sm">Refund</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const productInput = document.getElementById("productInput");
  const flavourSelect = document.getElementById("flavour");

  flavourSelect.addEventListener("focus", function() {
    const productName = productInput.value.trim();
    if (productName === "") {
      alert("Please select a product first.");
      return;
    }

    fetch(`fetch_flavours.php?product_name=${encodeURIComponent(productName)}`)
      .then(res => res.json())
      .then(data => {
        flavourSelect.innerHTML = '<option value="">-- Select Flavour --</option>';
        if (data.length === 0) {
          flavourSelect.innerHTML += '<option value="">No flavours found</option>';
        } else {
          data.forEach(flv => {
            const opt = document.createElement("option");
            opt.value = flv;
            opt.textContent = flv;
            flavourSelect.appendChild(opt);
          });
        }
      })
      .catch(err => console.error("Error loading flavours:", err));
  });
});
</script>

<script>
// 1. Disable form submit on Enter key
document.getElementById("myForm").addEventListener("keydown", function(event) {
    if (event.key === "Enter") {
        event.preventDefault(); // stops Enter from submitting
    }
});

// 2. Ensure only button triggers submit
document.getElementById("submitBtn").addEventListener("click", function() {
    document.getElementById("myForm").submit();
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const generateInvoiceButton = document.querySelector("button[name='bill']");
    const refundButton = document.querySelector("button[name='refund']");

    generateInvoiceButton.addEventListener("click", function(event) {
        const method = document.getElementById("method").value;
        const customerName = document.getElementById("customer_name").value.trim();

        // Check if method is "credit" and customer name is empty
        if (method === "credit" && customerName === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please fill in the Customer Name for Credit method.");
        }
    });

    refundButton.addEventListener("click", function(event) {
        const refundId = document.getElementById("r_order_id").value.trim();

        // Check if Refund ID is empty when "Refund" button is clicked
        if (refundId === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please enter a Refund ID.");
        }
    });
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    let currentFocus = -1;

   
    // Event listener for input field to trigger AJAX request
    document.getElementById("r_order_id").addEventListener("input", function() {
        var orderIdInput = this.value;
        if (orderIdInput.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?order_id=" + encodeURIComponent(orderIdInput), true); // Sends request to the same page
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("order_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("order_suggestions").style.display = 'none';
        }
    });

    // Handle clicking on suggestion items
    document.getElementById("order_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectOrder(e.target);
        }
    });

    // Add keyboard navigation for dropdown items
    document.getElementById("r_order_id").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("order_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectOrder(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectOrder(item) {
        var orderId = item.getAttribute('data-order-id');
        document.getElementById("r_order_id").value = orderId;
        document.getElementById("order_suggestions").style.display = 'none';
    }

    document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectCustomer(item) {
        var customerName = item.getAttribute('data-customer-name');
        var customerId = item.getAttribute('data-customer-id');
        var customerPhone = item.getAttribute('data-customer-phone');

        document.getElementById("customer_name").value = customerName;
        document.getElementById("customer_phone").value = customerPhone;
        document.getElementById("customer_id").value = customerId;

        document.getElementById("customer_suggestions").style.display = 'none';
    }
    
function calculateTotalPrice(triggeredBy = null) {
    let baseQuantity = parseFloat(document.getElementById("quantity").value) || 0;

    // noofunit from selected product
    let noOfUnit = parseFloat(document.getElementById("quantity").getAttribute("data-noofunit")) || 1;

    // effective quantity = quantity * noofunit
    let effectiveQuantity = baseQuantity ;

    // bonus quantity (default 0 if not provided)
    let bonusQuantity = parseFloat(document.getElementById("bonus_quantity")?.value) || 0;
    let looseQuantity = parseFloat(document.getElementById("loose_quantity")?.value) || 0;

    // total quantity = effectiveQuantity + bonusQuantity
    let totalQuantity = effectiveQuantity * noOfUnit + bonusQuantity + looseQuantity;

    let pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
    let discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
    let discountAmount = parseFloat(document.getElementById("disc_amount").value) || 0;
    let saleTaxPercentage = parseFloat(document.getElementById("sale_tax").value) || 0;

    let totalPrice = effectiveQuantity * pricePerUnit;

    if (triggeredBy === "percentage") {
        discountAmount = (totalPrice * discountPercentage) / 100;
        document.getElementById("disc_amount").value = discountAmount.toFixed(2);
    } else if (triggeredBy === "disc_amount") {
        discountPercentage = totalPrice > 0 ? (discountAmount / totalPrice) * 100 : 0;
        document.getElementById("percentage").value = discountPercentage.toFixed(2);
    } else {
        discountAmount = (totalPrice * discountPercentage) / 100;
        document.getElementById("disc_amount").value = discountAmount.toFixed(2);
    }

    let discountedPrice = totalPrice - discountAmount;
    let saleTaxAmount = (discountedPrice * saleTaxPercentage) / 100;
    let finalPrice = discountedPrice + saleTaxAmount;

    document.getElementById("total_amount").value = totalPrice.toFixed(2);
    document.getElementById("trade_price").value = finalPrice.toFixed(2);

    // show total quantity (effective + bonus)
    if (document.getElementById("total_quantity")) {
        document.getElementById("total_quantity").value = totalQuantity;
    }
}

// Event listeners
document.getElementById("quantity").addEventListener("input", () => calculateTotalPrice());
document.getElementById("retail_price").addEventListener("input", () => calculateTotalPrice());
document.getElementById("percentage").addEventListener("input", () => calculateTotalPrice("percentage"));
document.getElementById("disc_amount").addEventListener("input", () => calculateTotalPrice("disc_amount"));
document.getElementById("sale_tax").addEventListener("input", () => calculateTotalPrice());
document.getElementById("bonus_quantity")?.addEventListener("input", () => calculateTotalPrice());
document.getElementById("loose_quantity")?.addEventListener("input", () => calculateTotalPrice());



    document.getElementById("suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectProduct(e.target);
        }
    });

    document.getElementById("productInput").addEventListener("input", function() {
        var query = this.value;
        if (query.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?query=" + query, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("suggestions").style.display = 'none';
        }
    });
    
    
//  document.getElementById("batch_no").addEventListener("input", function() {
//             var batchNo = this.value.trim();
//             var productQuery = document.getElementById("productInput").value.trim(); // Get product name correctly

//             if (batchNo.length > 2 && productQuery.length > 2) {
//                 var xhr = new XMLHttpRequest();
//                 xhr.open("GET", "?batch_no=" + encodeURIComponent(batchNo) + "&productInput=" + encodeURIComponent(productQuery), true);
//                 xhr.onreadystatechange = function() {
//                     if (xhr.readyState == 4 && xhr.status == 200) {
//                         try {
//                             var response = JSON.parse(xhr.responseText);
//                             if (!response.error) {
//                                 document.getElementById("expiry").value = response.expiry;
//                                 document.getElementById("retail_price").value = response.rpperpack;
//                             } else {
//                                 alert("Batch not found!");
//                             }
//                         } catch (e) {
//                             alert("Invalid response from server.");
//                         }
//                     }
//                 };
//                 xhr.send();
//             }
//         });


    document.getElementById("productInput").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectProduct(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

function selectProduct(item) {
    var selectedProduct = item.textContent;
    var eXpiry = item.getAttribute('data-expiry-date');
    var productQuantity = item.getAttribute('data-product-quantity');
    var tradePrice = item.getAttribute('data-trade-price');
    var retailPrice = item.getAttribute('data-retail-price');
    var productId = item.getAttribute('data-product-id');
    var supplier = item.getAttribute('data-supplier');
    var company = item.getAttribute('data-company');
    var productUnit = item.getAttribute('data-product-unit');
    var NoofUnit = item.getAttribute('data-noofunit');
    // var flavour = item.getAttribute('data-flavour');

    document.getElementById("productInput").value = selectedProduct;

    document.getElementById("expiry").value = eXpiry;
    document.getElementById("noofunit").value = NoofUnit;
    document.getElementById("retail_price").value = retailPrice;
    document.getElementById("productInput").setAttribute('data-product-id', productId);
    document.getElementById("productInput").setAttribute('data-product-quantity', productQuantity);
    document.getElementById("productInput").setAttribute('data-supplier', supplier);
    document.getElementById("productInput").setAttribute('data-company', company);
    document.getElementById("productInput").setAttribute('data-trade-price', tradePrice);
    document.getElementById("productInput").setAttribute('data-product-unit', productUnit);
    // document.getElementById("productInput").setAttribute('data-flavour', flavour);
     document.getElementById("productInput").setAttribute('data-retail-price', retailPrice);


    // yaha noofunit quantity field me attach kar rahe hain
    document.getElementById("quantity").setAttribute('data-noofunit', NoofUnit);
    document.getElementById("retail_price").setAttribute('data-retail-price', retailPrice);

    document.getElementById("suggestions").style.display = 'none';
    calculateTotalPrice();
}

 document.getElementById("makeEntry").addEventListener("click", function() {
        var productInput = document.getElementById("productInput");
        var productId = productInput.getAttribute('data-product-id');
        var productQuantity =  productInput.getAttribute('data-product-quantity'); // Parse the quantity and ensure it's a number
        var supplier = productInput.getAttribute('data-supplier');
        var company = productInput.getAttribute('data-company');
        var productUnit = productInput.getAttribute('data-product-unit');
        // var flavour = productInput.getAttribute('data-flavour');

        var description = productInput.value;
        var quantity = parseFloat(document.getElementById("quantity").value) || 0;
        var noofunit = parseFloat(document.getElementById("noofunit").value) || 0;
        var flavour = document.getElementById("flavour").value || 0;
        var Bquantity = parseFloat(document.getElementById("bonus_quantity").value) || 0;
        var pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
        var EXp = document.getElementById("expiry").value || 0;
        var Lqty = document.getElementById("loose_quantity").value || 0;
        var Stax = parseFloat(document.getElementById("sale_tax").value) || 0;
        var BatchNo = document.getElementById("batch_no").value || 0;
        var totalPrice = parseFloat(document.getElementById("total_amount").value) || 0;
        var discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
        var discountAmount = parseFloat(document.getElementById("disc_amount").value) || 0;
        var netAmount = parseFloat(document.getElementById("trade_price").value) || 0;
        var tradePrice = productInput.getAttribute('data-trade-price');

        // Check if quantity is zero or negative before making the entry
        if (quantity > productQuantity) {
            alert("Product is not in stock. Cannot add entry.");
            return; // Stop execution if quantity is zero or negative
        }

        if (productId && description && quantity && pricePerUnit && totalPrice && netAmount) {
            var table = document.getElementById("productsTable");
            var row = table.insertRow();
            row.innerHTML = `
                <td style="font-weight:700;">${productQuantity}</td>
                <td style="font-weight:700;">${productId}</td>
                <td style="color:#0A5064;font-weight:700;">${description}</td>
                <td style="font-weight:700; display:none;">${BatchNo}</td>
                <td style="font-weight:700;">${quantity}</td>
                <td style="font-weight:700;">${Bquantity}</td>
                <td style="font-weight:700;">${Lqty}</td>
                <td style="font-weight:700;">${pricePerUnit}</td>
                <td style="font-weight:700;">${totalPrice}</td>
                <td style="font-weight:700;">${discountPercentage || '0.00'}</td>
                <td style="font-weight:700;">${discountAmount || '0.00'}</td>
                <td style="font-weight:700;">${Stax || '0.00'}</td>
                <td style="font-weight:700; display:none;">${EXp || '0.00'}</td>
                <td style="font-weight:700;">${netAmount}</td>
                <td style="display:none;">${supplier}</td>
                <td style="display:none;">${company}</td>
                <td style="display:none;">${tradePrice}</td>
                <td style="display:none;">${productUnit}</td>
                <td style="display:none;">${noofunit}</td>
                <td style="font-weight:700;">${flavour}</td>
                <td><button class="btn btn-danger btn-sm delete-row">X</button></td>
            `;

            row.querySelector(".delete-row").addEventListener("click", function() {
                row.remove();
                calculateTotalAmount();
            });

            calculateTotalAmount();

            var rows = document.querySelectorAll("#productsTable tr:not(:first-child)");
            var productData = [];
            rows.forEach(function(row) {
                var cells = row.querySelectorAll("td");
                var product = {
                    productId: cells[1].innerText,
                    description: cells[2].innerText,
                    BatchNo: cells[3].innerText,
                    quantity: cells[4].innerText,
                    Bquantity: cells[5].innerText,
                    Lqty: cells[6].innerText,
                    pricePerUnit: cells[7].innerText,
                    totalPrice: cells[8].innerText,
                    discountPercentage: cells[9].innerText,
                    discountAmount: cells[10].innerText,
                    tax: cells[11].innerText,
                    EXp: cells[12].innerText,
                    netAmount: cells[13].innerText,
                    supplier: cells[14].innerText,
                    company: cells[15].innerText,
                    tradePrice: cells[16].innerText,
                    productUnit: cells[17].innerText,
                    noofunit: cells[18].innerText,
                    flavour: cells[19].innerText,
                };
                productData.push(product);
            });

            document.getElementById("productData").value = JSON.stringify(productData);

            // Reset product fields after making an entry
            resetProductFields();
            
            // Automatically focus back to the productInput field
        productInput.focus();
        
        } else {
            alert("Some required fields are missing");
        }
    });

    function resetProductFields() {
        document.getElementById("productInput").value = '';
        document.getElementById("quantity").value = '';
        document.getElementById("bonus_quantity").value = '';
        document.getElementById("loose_quantity").value = '';
        document.getElementById("total_quantity").value = '';
        document.getElementById("noofunit").value = '';
        document.getElementById("flavour").value = '';
        document.getElementById("retail_price").value = '';
        document.getElementById("total_amount").value = '';
        document.getElementById("percentage").value = '';
        document.getElementById("disc_amount").value = '';
        document.getElementById("trade_price").value = '';
        document.getElementById("sale_tax").value = '';
        document.getElementById("batch_no").value = '';
         document.getElementById("expiry").value = '';
        // Remove data attributes for the next product
        document.getElementById("productInput").removeAttribute('data-product-id');
        document.getElementById("productInput").removeAttribute('data-product-quantity');
        document.getElementById("productInput").removeAttribute('data-supplier');
        document.getElementById("productInput").removeAttribute('data-company');
        document.getElementById("productInput").removeAttribute('data-trade-price');
        document.getElementById("productInput").removeAttribute('data-product-unit');
    }

function calculateTotalAmount() {
    var table = document.getElementById("productsTable");
    var rows = table.getElementsByTagName("tr");
    var total = 0;

    for (var i = 1; i < rows.length; i++) {
        var netAmountCell = rows[i].cells[13];
        var netAmount = parseFloat(netAmountCell.textContent.trim());
        if (!isNaN(netAmount)) {
            total += netAmount;
        }
    }

    var totalInput = document.getElementById("total-input");
    var billAmountInput = document.getElementById("bill-amount");
    var frieghtInput = document.getElementById("frieght");

    var frieght = parseFloat(frieghtInput.value) || 0;
    var finalBill = total - frieght;

    totalInput.value = total.toFixed(2);
    billAmountInput.value = finalBill.toFixed(2);

    updateDiscountAmount();
}

function updateDiscountAmount() {
    var total = parseFloat(document.getElementById("total-input").value) || 0;
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var discountAmountInput = document.getElementById("discount_amount");
    var discountPercentInput = document.getElementById("discount_percent");

    if (!isNaN(billAmount) && !isNaN(total)) {
        var discountAmount = total - billAmount;
        discountAmountInput.value = Math.round(discountAmount);

        if (total > 0) {
            var discountPercent = (discountAmount / total) * 100;
            discountPercentInput.value = discountPercent.toFixed(2);
        } else {
            discountPercentInput.value = "0.00";
        }
    }
}

function calculateCashReturn() {
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var cashReceived = parseFloat(document.getElementById("cash_received").value) || 0;
    var cashReturnInput = document.getElementById("cash_return");

    if (!isNaN(billAmount) && !isNaN(cashReceived)) {
        var cashReturn = cashReceived - billAmount;
        cashReturnInput.value = cashReturn.toFixed(2);
    }
}

document.getElementById("bill-amount").addEventListener("input", updateDiscountAmount);
document.getElementById("cash_received").addEventListener("input", calculateCashReturn);
document.getElementById("frieght").addEventListener("input", calculateTotalAmount);

calculateTotalAmount();
});
</script>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="modal fade" id="addPurchaseModal" tabindex="-1" role="dialog" 
     aria-labelledby="addPurchaseModalLabel" aria-hidden="true" style="margin-top:80px;">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background:#0A4657;">
                <h5 class="modal-title text-capitalize text-white font-weight-bold" id="addPurchaseModalLabel">Receiving Amount</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="mainpos.php" enctype="multipart/form-data">

                    <!-- Customer dropdown -->
                    <div class="form-group">
                        <label>Select Customer</label>
                        <select name="cr_name" class="form-control" required>
                            <option value="">-- Select Customer --</option>
                            <?php
                            $cust_query = mysqli_query($connection, "SELECT DISTINCT cr_name FROM credit_note ORDER BY cr_name ASC");
                            while($cust = mysqli_fetch_array($cust_query)){
                            ?>
                                <option value="<?php echo $cust['cr_name']; ?>">
                                    <?php echo $cust['cr_name']; ?>
                                </option>
                            <?php
                            }
                            ?>
                        </select>
                    </div>

                    <input type="text" name="amount" placeholder="Amount" class="form-control" required />
                    <br />

                    <textarea name="description" class="form-control" rows="3" placeholder="Enter description"></textarea>
                    <br />

                    <select name="paid_by" class="form-control" required>
                        <option value="">Select Method</option>
                        <option value="cash">Cash</option>
                        <option value="bank1">Easy Paisa</option>
                        <option value="bank2">Jazz Cash</option>
                        <option value="bank3">Allied Bank</option>
                        <option value="bank4">HBL</option>
                        <option value="bank5">Bank Al-Habib</option>
                        <option value="bank6">Meezan Bank</option>
                        <option value="other">Other</option>
                    </select>
                    <br />

                    <input class="form-control" type="date" name="date_time" value="<?php echo date('Y-m-d'); ?>" />
               
                    <input class="form-control" type="hidden" name="shop_name" value="<?php echo $rc['shop_name']; ?>" />
                    <input class="form-control" type="hidden" name="route" value="<?php echo $rc['route']; ?>" />
                    <input class="form-control" type="hidden" name="booker" value="<?php echo $rc['booker']; ?>" />
                    <br>
                    <button type="submit" name="creditor_open" class="btn btn-dark">Enter</button>
                </form>
            </div>
        </div>
    </div>
</div>




</body>
</html>