<?php
include("../db/cn.php");
//session_start(); // Start the session
ob_start();

if (!$connection) {
    die("Database connection failed: " . mysqli_connect_error());
}

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($_POST) {
    // Sanitize and validate input data
    $product_id = $_POST['product_id'];
    $product_name = $_POST['product_name'];
    $company = $_POST['company'];
    $quantity = $_POST['quantity'];
    $retail_price = $_POST['retail_price'];
    $percentage = $_POST['percentage'];
    $trade_price = $_POST['trade_price'];
    $total_amount = $_POST['total_amount'];
    $supplier = $_POST['supplier'];
    $product_unit = $_POST['product_unit'];
    $vehicle = $_POST['size'];
    $category = $_POST['category'];
    $flavour = $_POST['flavour'];
        $batch_no = mysqli_real_escape_string($connection, $_POST['batch_no']);
    $expiry = mysqli_real_escape_string($connection, $_POST['expiry']);
    $date_time = date("Y-m-d");

   
    // Prepared statement to insert data into 'products' table
    $stmt = $connection->prepare("INSERT INTO products (product_id, product_name, size, category, flavour, company, quantity, retail_price, percentage, trade_price, total_amount, total_purchase, product_unit, supplier,
    batch_no, expiry,date_time, login_user, user_role, outlet_name, outlet_address)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '', ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    if ($stmt === false) {
        die("Error preparing the SQL query: " . $connection->error);
    }

    // Bind parameters (s = string, i = integer, d = double)
    $stmt->bind_param("ssssssiddiddssssssss", $product_id, $product_name, $vehicle, $category, $flavour, $company, $quantity, $retail_price, $percentage, $trade_price, $total_amount, $product_unit, $supplier, $batch_no, $expiry, $date_time, $userName, $userRole, $outlet_name, $outlet_address);

    // Execute the prepared statement
    if ($stmt->execute()) {
        echo "";
    } else {
        echo "Error inserting product: " . $stmt->error;
    }

    // Close the statement
    $stmt->close();
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>AL GHANI TRADERS</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
     
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.text-primary{
	  	
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                   <div class="container">
        <div class="row">
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;"> Add New Product</h3>
                
            </div>
            <div class="col-sm-3">
                <a href="addproduct.php"><button type="button" class="btn btn-dark" style="float:left;"><i class="fa fa-arrow-left"></i></button></a>
            </div>
        </div>
        <div class="row">
          <div class="col-sm-2"></div>
          <div class="col-sm-8">
           
          </div>
          <div class="col-sm-2"></div>
        </div>
    </div>
    <br />
    <br />
    <div class="container">
        <div class="row">
            <div class="col-sm-1"></div>
            <div class="col-sm-5">
                <form method="post" action="new_product.php" enctype="multipart/form-data">
                    <div class="form-group">
                        <label>Product ID</label>
                        <input type="text" name="product_id" class="form-control" value="<?php
			  $pr_id2 = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
			   echo $pr_id2; ?>" readonly> 
                    </div>
                    <div class="form-group">
                        <label>Product Name</label>
                        <input type="text" name="product_name" class="form-control" />
                    </div>
                    <div class="">
                
                <div class="form-group ">
                    <label>Category</label>
                    <input type="text" name="category"   class="form-control" />
                </div>
                <div class="form-group ">
                    <label>Flavour</label>
                    <input type="text" name="flavour"   class="form-control" />
                </div>
                
                </div>
                    
                    <div class="">
                        
                        <input type="hidden" name="quantity" value="0" class="form-control" />
                    </div>
                    <div class="">
                        
                        <input type="hidden" value="0" name="retail_price" id="retail_price" class="form-control" />
                    </div>
                    
                </div>
                <div class="col-sm-5">
                    <div class="form-group ">
                    <label>Company</label>
                    <input type="text" name="company"  id="company" class="form-control" />
                </div>
                    <div class="">
                        
                        <input type="hidden" value="0" name="percentage" id="percentage" class="form-control" readonly />
                    </div>
                    <div class="f">
                        
                        <input type="hidden" value="0" name="trade_price" id="trade_price" class="form-control" />
                    </div>
                    <div class="">
                       
                        <input type="hidden" name="total_amount" id="total_amount" class="form-control" value="0" readonly />
                    </div>
                     <div class="row">
                    <div class="form-group col-6">
                        <label>Supplier</label>
                        <input type="text" name="supplier" class="form-control" />
                    </div> 
                    <div class="form-group col-6">
                        <label>Expiry</label>
                        <input type="date" name="expiry" class="form-control" />
                    </div> 
                    </div>
                    <div class="row">
                    <div class=" col-6 form-group">
                        <label>Batch</label>
                        <input type="hidden" value="0" name="size"  class="form-control" />
                        <input type="text"  name="batch_no"  class="form-control" />
                    </div>
                    <div class="col-6 form-group">
                        <label>Product Unit</label>
                        <select name="product_unit" class="form-control">
                        <option value="">Select Unit</option>
                       <option value="carton">Carton</option>
                        <option value="pack">Pack</option>
                        <option value="pcs">Pcs</option>
                        <option value="gram">Gram</option>
                        
                        
                        </select>
                    </div> 
                    </div>
                    <hr />
                    <button class="btn btn-dark form-control" type="submit">Add Product</button>
                </div>
                </form>
            </div>
            <div class="col-sm-1">
            </div>
        </div>
    </div> 

            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

      <script>
    function calculateTradePercentage() {
        let retail_price = parseFloat(document.getElementById("retail_price").value) || 0;
        let trade_price = parseFloat(document.getElementById("trade_price").value) || 0;

        if (retail_price > 0 && trade_price > 0) {
            let percentage = ((retail_price - trade_price) * 100 / retail_price).toFixed(2);
            document.getElementById("percentage").value = percentage;
        } else {
            document.getElementById("percentage").value = '';
        }
    }

    document.addEventListener('DOMContentLoaded', (event) => {
        document.getElementById("retail_price").addEventListener('input', calculateTradePercentage);
        document.getElementById("trade_price").addEventListener('input', calculateTradePercentage);
    });

    document.addEventListener("DOMContentLoaded", function () {
        var sidebar = document.getElementById("sidebar");
        var overlay = document.createElement("div");
        overlay.classList.add("overlay");
        document.body.appendChild(overlay);

        function toggleSidebar() {
            sidebar.classList.toggle("hide");
            overlay.classList.toggle("hide");

            var mainContent = document.querySelector(".main-content");
            if (sidebar.classList.contains("hide")) {
                mainContent.style.marginLeft = "0";
            } else {
                mainContent.style.marginLeft = "100px";
            }
        }

        overlay.addEventListener("click", function () {
            toggleSidebar();
        });

        var navbarToggler = document.querySelector(".navbar-toggler");
        navbarToggler.addEventListener("click", function () {
            toggleSidebar();
        });

        function checkScreenSize() {
            if (window.innerWidth > 768) {
                sidebar.classList.remove("hide");
                overlay.classList.remove("hide");
            } else {
                sidebar.classList.add("hide");
                overlay.classList.add("hide");
            }
        }

        checkScreenSize();
        window.addEventListener("resize", checkScreenSize);
    });

    function toggleSubMenu(element) {
        $(element).next('.sub-menu').slideToggle();
    }
</script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>