<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
// Fetch order details from the database
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerId = $order['customer_id'];
        $customerName = $order['customer_name'];
        $desc_name = $order["desc_name"];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
        $gatePass = $order['gate_pass'];
    }
}
$content = ob_get_clean(); // Capture HTML content
// Function to send data to the printer
function sendToPrinter($result) {
    $printerName = "EPSON_TM_T88V_Receipt"; // Change to your printer's name
    $handle = @fopen("USB", "w"); // LPT1 is commonly used for parallel port printers, change if necessary
    if (!$handle) {
        echo "Error opening printer on Windows. Check the printer port and connection.";
        return;
    }
    fwrite($handle, $result);
    fclose($handle);
    echo "";
}
// Call the print function
sendToPrinter($content);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <title>Al Ghani Traders</title>

    <style>
        body {
            font-family: 'Quicksand', sans-serif;
        }
        @media print {
            .no-print {
                display: none;
            }
            .text-center {
                text-align: center;
            }
            table {
                width: 100%;
                border-collapse: collapse;
            }
            th, td {
                border: 1px solid #000;
                padding: 5px;
                text-align: center;
            }
        }
    </style>
</head>
<body>
<div class="container" id="invoice" style="width:800px;">
    <div class="row">
        <div class="col-sm-3">
            
        </div>
        <div class="col-sm-4 text-center">
            <img src="../img/bt.png" class="img-fluid" style="width:100px; height:100px;">
        </div>
        <div class="col-sm-5 text-right">
            <h3 style="font-weight:700;">Al Ghani Traders</h3>
            <h6>0301-7604667</h6>
            <h6>0307-7386664</h6><h6> Address: Mumtazabad Vehari Road Multan</h6>
        </div>
    </div>
    
<br>
<?php
$etclose = mysqli_query($connection,"select * from empty_closing where shop = '$customerName' ");
$rclose = mysqli_fetch_array($etclose);
$emptyClose = $rclose['empty'];
?>
    <div class="row">
        <div class="col-sm-4">
            <strong>Sale Invoice No:</strong> <?php echo htmlspecialchars($orderId); ?><br>
            <strong>Customer:</strong> <?php echo htmlspecialchars($customerName); ?> <br>
            <strong>Address:</strong> <?php echo htmlspecialchars($customerId); ?> <br>
            <strong>Description:</strong> <?php echo htmlspecialchars($desc_name); ?><br>
            <strong>Gate-Pass:</strong> <?php echo htmlspecialchars($gatePass); ?>
        </div>
        <div class="col-sm-4">
           <strong>Sale Date:</strong> <?php echo htmlspecialchars(date("Y-m-d")); ?><br>
           <strong>Cel:</strong> <?php echo htmlspecialchars($customerPhone); ?><br>
            <strong>Total Empty:</strong> <?php echo (int)$emptyClose; ?><br>
        </div>
    </div>
<br>
    <div>
        <table class="table table-sm" style="font-size:13.5px;">
            <thead>
                <tr>
                    <th>Sr.No</th>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Sale Rate</th>
                    <th>Discount</th>
                    <th>Amount</th>
                     <th>Flavour</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sr_no = 1;
                foreach ($orderDetails as $order): ?>
                <tr style="font-weight:700; color:#000;">
                    <td><?php echo $sr_no++; ?></td>
                    <td><?php echo htmlspecialchars($order['product_name']); ?></td>
                    <td><?php echo htmlspecialchars($order['product_quantity']); ?></td>
                    <td><?php echo htmlspecialchars($order['product_price']); ?></td>
                    <td><?php echo htmlspecialchars($order['discount']); ?>%</td>
                    <td><?php echo htmlspecialchars($order['net_amount']); ?></td>
                    <td><?php echo htmlspecialchars($order['flavour']); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php
    $sub = mysqli_query($connection, "SELECT SUM(remain_balance) AS rm FROM creditor_closing WHERE creditor_name = '$customerName'");
    $rowSub = mysqli_fetch_array($sub);
    $pre = $rowSub["rm"];
    $close = $discountedAmount + $pre;
    ?>
    <div class="row">
        <div class="col-sm-8"></div>
        <div class="col-sm-4">
            <table class="table table-bordered text-center table-sm" style="font-size:13px;">
                <tr>
                    <td style="font-weight:700;">Total Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo htmlspecialchars($discountedAmount + $discounted) . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Discount Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo htmlspecialchars($discounted) . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Previous Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo htmlspecialchars((int)$pre) . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Grand Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo htmlspecialchars($close) . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Amount Recieved:</td>
                    <td style="font-weight:700;">Rs <?php echo htmlspecialchars($cashAmount) . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Balance Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo htmlspecialchars($changeAmount) . ""; ?></td>
                    
                </tr>
            </table>
            
        </div>
        
    </div>

    <div>
        
    </div>

    <div class="row">
        <div class="col-sm-3" style="font-weight:600;">
            <br>
            <?php
// Get the current date and time
$date = new DateTime();

// Format the date and time to match the required format
$formattedDate = $date->format('l, F j, Y g:i:s A');

// Output the formatted date
echo $formattedDate;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['exit'])) {
    if (!empty($customerName) && is_numeric($changeAmount)) {
        $checkQuery = "SELECT 1 FROM creditor_closing WHERE creditor_name = '$customerName' LIMIT 1";
        $checkResult = mysqli_query($connection, $checkQuery);

        if (mysqli_num_rows($checkResult) > 0) {
            // Record exists: update
            $updateQuery = "UPDATE creditor_closing SET remain_balance = $changeAmount WHERE creditor_name = '$customerName'";
            $updateResult = mysqli_query($connection, $updateQuery);

            if ($updateResult) {
                   echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
                exit;
            } else {
                echo "<p style='color:red;'>Update failed: " . mysqli_error($connection) . "</p>";
            }
        } else {
            // Record doesn't exist: insert
            $insertQuery = "INSERT INTO creditor_closing (
                creditor_name, opening_cash, credit_sales, credit_recieved,
                remain_balance, date_time, login_user, user_role,
                outlet_name, outlet_address
            ) VALUES (
                '$customerName', 0, 0, 0, $changeAmount, NOW(), '$userName', '$useRole', '$outlet_name', '$outlet_address'
            )";

            $insertResult = mysqli_query($connection, $insertQuery);

            if ($insertResult) {
           echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
                exit;
            } else {
                echo "<p style='color:red;'>Insert failed: " . mysqli_error($connection) . "</p>";
            }
        }
    }
}
?>
        </div>
        <div class="col-sm-5">
            <p style="font-weight:600; font-size:15px;">
            </p>
            <br>
            <h3 style="text-align:center;">Thanks For Visiting.</h3>
        </div>
        <div class="col-sm-4"></div>
      
      
       
        
    </div>

    <div class="text-center no-print">
        <button class="btn btn-secondary no-print" onclick="window.print()">Print</button>
        <!--<button class="btn btn-secondary no-print" onclick="downloadPDF()">Download PDF</button>-->
        <!--<a href="gate_pass.php?order_id=<?php echo $orderId; ?>" target="_blank" class="btn btn-secondary no-print">Gate Pass</a>-->
       
            <a href="order_detail_v.php"><button type="button" class="btn btn-secondary no-print">Exit</button></a>
      
    </div>
</div>


</body>

</html>

