<?php
include("../db/cn.php");
ob_start();

// Fetch order details
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId' && status='' && r_order_id = ''";
    $result = mysqli_query($connection, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $truck_no = $order['truck_no'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
    }
}

$content = ob_get_clean();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice - Corporate Format</title>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
body {
    font-family: 'Quicksand', sans-serif;
    background: #f5f6fa;
    margin: 40px;
}
.container {
    max-width: 850px;
    background: #fff;
    padding: 40px 50px;
    margin: auto;
    border: 1px solid #ddd;
    border-radius: 8px;
}
.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #000;
    padding-bottom: 10px;
}
.header img {
    width: 120px;
}
.company-info {
    text-align: right;
}
.company-info h2 {
    margin: 0;
    font-weight: 700;
    text-transform: uppercase;
}
.company-info p {
    margin: 2px 0;
    font-size: 13px;
}
.invoice-meta {
    margin-top: 20px;
    display: flex;
    justify-content: space-between;
}
.invoice-meta p {
    margin: 4px 0;
    font-size: 14px;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 25px;
}
th, td {
    border: 1px solid #999;
    padding: 8px;
    text-align: center;
    font-size: 13px;
}
th {
    background-color: #f2f2f2;
    font-weight: 600;
}
.summary {
    margin-top: 25px;
    width: 100%;
    display: flex;
    justify-content: flex-end;
}
.summary-table {
    border-collapse: collapse;
    width: 40%;
}
.summary-table td {
    border: 1px solid #ccc;
    padding: 6px 10px;
    font-size: 13px;
}
.notes {
    margin-top: 30px;
}
.signature {
    margin-top: 50px;
    display: flex;
    justify-content: space-between;
}
.signature div {
    width: 40%;
    text-align: center;
    border-top: 1px solid #000;
    padding-top: 5px;
    font-size: 13px;
}
footer {
    margin-top: 40px;
    text-align: center;
    font-size: 12px;
    color: #666;
    border-top: 1px solid #ccc;
    padding-top: 10px;
}
@media print {
    body { margin: 0; background: #fff; }
    .no-print { display: none; }
}
</style>
</head>
<body>
<div class="container" id="invoice">
    <div class="header">
        <img src="../img/bt.png" alt="Company Logo">
        <div class="company-info">
            <h2>Al Ghani Traders</h2>
            <p>Main Bazar Chakswari, Mirpur AJK</p>
            <p>Phone: 0344-2001244</p>
            <p>Email: info@alghanitraders.com</p>
        </div>
    </div>
<?php
$etclose = mysqli_query($connection,"select * from empty_closing where shop = '$customerName' ");
$rclose = mysqli_fetch_array($etclose);
$emptyClose = $rclose['empty'];
?>
    <div class="invoice-meta">
        <div>
            <p><strong>Customer:</strong> <?php echo htmlspecialchars($customerName); ?></p>
            <p><strong>Phone:</strong> <?php echo htmlspecialchars($customerPhone); ?></p>
            <p><strong>Truck No.:</strong> <?php echo htmlspecialchars($truck_no); ?></p>
            <p><strong>Total Empty.:</strong> <?php echo (int)$emptyClose; ?></p>
        </div>
        <div>
            <p><strong>Order ID:</strong> <?php echo htmlspecialchars($orderId); ?></p>
            <p><strong>Date:</strong> <?php echo htmlspecialchars($dateTime); ?></p>
            <p><strong>Payment:</strong> <?php echo htmlspecialchars($paidBy); ?></p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Product</th>
                <th>Qty</th>
                <th>Unit Price</th>
                <th>Discount</th>
                <th>Total (PKR)</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($orderDetails as $order): ?>
            <tr>
                <td><?php echo htmlspecialchars($order['product_name']); ?></td>
                <td><?php echo htmlspecialchars($order['product_quantity']); ?></td>
                <td><?php echo htmlspecialchars($order['product_price']); ?></td>
                <td><?php echo htmlspecialchars($order['discount']); ?></td>
                <td><?php echo htmlspecialchars($order['net_amount']); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <?php
    $sub = mysqli_query($connection, "SELECT SUM(net_amount) AS sub FROM log_user_sales WHERE order_id = '$orderId'");
    $rowSub = mysqli_fetch_array($sub);
    ?>

    <div class="summary">
        <table class="summary-table">
            <tr><td><strong>Subtotal</strong></td><td>Rs <?php echo htmlspecialchars($rowSub["sub"]); ?></td></tr>
            <tr><td><strong>Discount</strong></td><td>Rs <?php echo htmlspecialchars($discounted); ?></td></tr>
            <tr><td><strong>Tax</strong></td><td>Rs <?php echo htmlspecialchars($taxAmount); ?></td></tr>
            <tr><td><strong>Total</strong></td><td>Rs <?php echo htmlspecialchars($discountedAmount) . ".00"; ?></td></tr>
            <tr><td><strong>Cash</strong></td><td>Rs <?php echo htmlspecialchars($cashAmount) . ".00"; ?></td></tr>
            <tr><td><strong>Change</strong></td><td>Rs <?php echo htmlspecialchars($changeAmount); ?></td></tr>
        </table>
    </div>

    <div class="notes">
        <h3>Notes</h3>
        <p>1. Exchanges are accepted within 7 days from the date of purchase.</p>
        <p>2. Items must be in original condition with all tags attached.</p>
        <p>3. A valid receipt is required for all exchanges.</p>
    </div>

    <div class="signature">
        <div>Customer Signature</div>
        <div>Authorized Signature</div>
    </div>

    <footer>
        Generated by ATR Software | 0334-8739892<br>
        <strong>Thank you for your business!</strong>
    </footer>

    <div class="text-center no-print" style="margin-top:20px;">
        <button onclick="window.print()">Print</button>
        <button onclick="downloadPDF()">Download PDF</button>
        <button onclick="window.location.href='mainpos.php'">Exit</button>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
<script>
function downloadPDF() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('p', 'mm', 'a4');
    doc.html(document.querySelector('#invoice'), {
        callback: function (pdf) {
            pdf.save('Invoice_<?php echo htmlspecialchars($orderId); ?>.pdf');
        },
        x: 10, y: 10, width: 190
    });
}
</script>
</body>
</html>
