<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);

ini_set('display_startup_errors', 1);

error_reporting(E_ALL);

 
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}


// Fetch order details from the database
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $desc_name = $order["desc_name"];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
        $gatePass = $order['gate_pass'];
    }
}

$content = ob_get_clean(); // Capture HTML content

// Function to send data to the printer
function sendToPrinter($result) {
    $printerName = "EPSON_TM_T88V_Receipt"; // Change to your printer's name
    $handle = @fopen("USB", "w"); // LPT1 is commonly used for parallel port printers, change if necessary
    if (!$handle) {
        echo "Error opening printer on Windows. Check the printer port and connection.";
        return;
    }
    fwrite($handle, $result);
    fclose($handle);
    echo "";
}

// Call the print function
sendToPrinter($content);


?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <title>Al Ghani Traders</title>

    <style>
        body {
            font-family: 'Quicksand', sans-serif;
        }
        @media print {
            .no-print {
                display: none;
            }
            .text-center {
                text-align: center;
            }
            table {
                width: 100%;
                border-collapse: collapse;
            }
            th, td {
                border: 1px solid #000;
                padding: 5px;
                text-align: center;
            }
        }
        .btn{
            font-weight:700;
        }
    </style>
</head>
<body>
<div class="container" id="invoice" style="width:800px;padding:15px;">
    <div id="pdfContent">
    <div class="row">
        <div class="col-sm-3">
            
        </div>
        <div class="col-sm-5 text-center">
            <img src="../img/bt.png" class="img-fluid" style="width:100px; height:100px;">
        </div>
        <div class="col-sm-4 text-right">
            <h2 style="font-weight:700;">Al Ghani Traders</h2>
            <h6>0301-7604667</h6><h4> Address:Mumtazabad Vehari Road Multan</h4>
        </div>
    </div>
    
<br>
    <div class="row">
        <div class="col-sm-4">
            <strong>Sale Invoice No:</strong> <?php echo $orderId; ?><br>
            <strong>Customer:</strong> <?php echo $customerName; ?> <br>
        </div>
        <div class="col-sm-4">
           <strong>Sale Date:</strong> <?php echo date("Y-m-d"); ?><br>
           <strong>Cel:</strong> <?php echo $customerPhone; ?><br>
           
        </div>
       
    </div>
<br>
    <div>
        <table class="table table-sm" style="font-size:13.5px;">
            <thead>
                <tr>
                    <th>Sr.No</th>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Loose</th>
                    <th>Sale Rate</th>
                    <th>Discount</th>
                    <th>Amount</th>
                     <th>Flavour</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sr_no = 1;
                foreach ($orderDetails as $order): ?>
                <tr style="font-weight:700; color:#000;">
                    <td><?php echo $sr_no++; ?></td>
                    <td><?php echo $order['product_name']; ?></td>
                    <td><?php echo $order['product_quantity']; ?></td>
                    <td><?php echo $order['loose']; ?></td>
                    <td><?php echo $order['product_price']; ?></td>
                    <td><?php echo $order['discount']; ?>%</td>
                    <td><?php echo $order['net_amount']; ?></td>
                    <td><?php echo $order['flavour']; ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php
    $sub = mysqli_query($connection, "SELECT SUM(remain_balance) AS rm FROM creditor_closing WHERE creditor_name = '$customerName'");
    $rowSub = mysqli_fetch_array($sub);
    $pre = $rowSub["rm"];
    $close = $discountedAmount + $pre;
    
    ?>
    <div class="row">
        <div class="col-sm-4"></div>
        <div class="col-sm-4"></div>
        <div class="col-sm-4">
            <table class="table table-bordered text-center table-sm" style="font-size:13px;">
                <tr>
                    <td style="font-weight:700;">Total Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo $discountedAmount . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Previous Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo (int)$pre . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Grand Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo $close . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Amount Recieved:</td>
                    <td style="font-weight:700;">Rs <?php echo $cashAmount . ".00"; ?></td>
                    
                </tr>
                <tr>
                    <td style="font-weight:700;">Balance Amount:</td>
                    <td style="font-weight:700;">Rs <?php echo $changeAmount . ""; ?></td>
                    
                </tr>
            </table>
            
        </div>
        
    </div>

    <div>
        
    </div>

    <div class="row">
        <div class="col-sm-3" style="font-weight:600;">
            <br>
<?php
// Get the current date and time
$date = new DateTime();

// Format the date and time to match the required format
$formattedDate = $date->format('l, F j, Y g:i:s A');

// Output the formatted date
echo $formattedDate;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['exit'])) {
    if (!empty($customerName) && is_numeric($changeAmount)) {
        $checkQuery = "SELECT 1 FROM creditor_closing WHERE creditor_name = '$customerName' LIMIT 1";
        $checkResult = mysqli_query($connection, $checkQuery);

        if (mysqli_num_rows($checkResult) > 0) {
            // Record exists: update
            $updateQuery = "UPDATE creditor_closing SET remain_balance = $changeAmount WHERE creditor_name = '$customerName'";
            $updateResult = mysqli_query($connection, $updateQuery);

            if ($updateResult) {
                echo "<script>window.location.href='mainpos.php';</script>";
                exit;
            } else {
                echo "<p style='color:red;'>Update failed: " . mysqli_error($connection) . "</p>";
            }
        } else {
            // Record doesn't exist: insert
            $insertQuery = "INSERT INTO creditor_closing (
                creditor_name, opening_cash, credit_sales, credit_recieved,
                remain_balance, date_time, login_user, user_role,
                outlet_name, outlet_address
            ) VALUES (
                '$customerName', 0, 0, 0, $changeAmount, NOW(), '$userName', '$useRole', '$outlet_name', '$outlet_address'
            )";

            $insertResult = mysqli_query($connection, $insertQuery);

            if ($insertResult) {
                echo "<script>window.location.href='mainpos.php';</script>";
                exit;
            } else {
                echo "<p style='color:red;'>Insert failed: " . mysqli_error($connection) . "</p>";
            }
        }
    } else {
        // Even if no values, still redirect back to mainpos
        echo "<script>window.location.href='mainpos.php';</script>";
        exit;
    }
}
?>
        </div>
        <div class="col-sm-5">
            <p style="font-weight:600; font-size:15px;">
            </p>
            <br>
            <h3 style="text-align:center;">Thanks For Visiting.</h3>
        </div>
        <div class="col-sm-4"></div>
      
      
       
        
    </div>

 
</div>
   <div class="text-center no-print">
    <button class="btn btn-secondary no-print" onclick="window.print()">Print</button>
    <button class="btn btn-secondary no-print" onclick="downloadPDF()">Download PDF</button>
    <a href="gate_pass.php?order_id=<?php echo $orderId; ?>" target="_blank" class="btn btn-secondary no-print">Gate Pass</a>
    <form method="post" style="display:inline;">
        <button type="submit" name="exit" class="btn btn-secondary no-print">Exit</button>
    </form>
</div>
</div>
<!-- Scripts for html2canvas + jsPDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
async function downloadPDF() {
    const { jsPDF } = window.jspdf;

    // Capture the content
    const content = document.getElementById("pdfContent");
    const canvas = await html2canvas(content, { scale: 2 });
    const imgData = canvas.toDataURL("image/png");

    // Create PDF
    const pdf = new jsPDF("p", "mm", "a4");
    const imgProps = pdf.getImageProperties(imgData);
    const pdfWidth = pdf.internal.pageSize.getWidth();
    const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

    pdf.addImage(imgData, "PNG", 0, 0, pdfWidth, pdfHeight);
    pdf.save("Sale_Invoice.pdf");
}
</script>

</body>

</html>

