<?php
include("../db/cn.php");
ob_start();

// Fetch order details from the database
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
    }
}

date_default_timezone_set('Asia/Karachi');

// Get the current time
$currentTime = date('H:i:s');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <title>Print Order</title>
    <style>
     body {
               
                 font-family: 'Quicksand', sans-serif;
            }
        @media print {
           
            .no-print {
                display: none;
            }
            .text-center {
                text-align: center;
            }
            table {
                width: 100%;
                border-collapse: collapse;
            }
            th, td {
                border: 1px solid #000;
                padding: 4px;
                text-align: left;
                font-size: 12px;
            }
        }
 .invoice-header {
            font-size: 28px;
            font-weight: bold;
        }
        .invoice-details {
            font-size: 17px;
        }
        .table-bordered tr, .table-bordered th, .table-bordered td {
            border: 1px solid black !important;
        }
        .amount-in-words {
            font-size: 14px;
        }
        .footer-text {
            font-size: 12px;
            text-align: right;
        }
    </style>
</head>
<body>
<div class="container my-4">
        <div class="text-center mb-4">
            <h4 class="invoice-header">Burhan Traders 
</h4>
            <p class="invoice-details" style="font-weight:600;">Address: Main Bazar Chakswari Mirpur Azad Kashmir<br>Phone #: 03442001244</p>
        </div>
        <div class="row">
            <div class="col-6">
                <p class="invoice-details">
                    <strong>Zone:</strong> Azad Kashmir<br>
                    <strong>Sector:</strong> <br>
                    <strong>Customer:<?php echo $customerName; ?></strong> <br>
                   
                    <strong>Bill Date:</strong><?php echo date("Y-m-d"); ?>
                </p>
            </div>
            <div class="col-6 text-end">
                <p class="invoice-details">
                    <strong style="font-size:28px;">Sale Invoice</strong><br>
                    <strong>Print Date:</strong> <?php echo date("Y-m-d"); ?><br>
                    <strong>Print Time:</strong> <?php echo $currentTime;?><br>
                    <strong>Bill ID:<?php echo $orderId; ?></strong> <br>
                    
                </p>
            </div>
        </div>

   
    <table class="table table-bordered text-center">
        <thead>
        <tr>
            <th>Sr#</th>
            <th>Item Code</th>
            <th>Product</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Dis</th>
            <th>Amount</th>
        </tr>
        </thead>
        <tbody>
        <?php
        $sr_no = 1;
        foreach ($orderDetails as $order): ?>
            <tr>
                <td><?php echo $sr_no++; ?></td>
                <td><?php echo htmlspecialchars($order['product_id']); ?></td>
                <td><?php echo htmlspecialchars($order['product_name']); ?></td>
                <td><?php echo htmlspecialchars($order['product_quantity']); ?></td>
                <td><?php echo htmlspecialchars($order['product_price']); ?></td>
                <td><?php echo htmlspecialchars($order['discount']); ?></td>
                <td><?php echo htmlspecialchars($order['net_amount']); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php
function numberToWords($number) {
    $words = array(
        '0' => '', '1' => 'One', '2' => 'Two', '3' => 'Three',
        '4' => 'Four', '5' => 'Five', '6' => 'Six', '7' => 'Seven',
        '8' => 'Eight', '9' => 'Nine', '10' => 'Ten', '11' => 'Eleven',
        '12' => 'Twelve', '13' => 'Thirteen', '14' => 'Fourteen', '15' => 'Fifteen',
        '16' => 'Sixteen', '17' => 'Seventeen', '18' => 'Eighteen', '19' => 'Nineteen',
        '20' => 'Twenty', '30' => 'Thirty', '40' => 'Forty', '50' => 'Fifty',
        '60' => 'Sixty', '70' => 'Seventy', '80' => 'Eighty', '90' => 'Ninety'
    );

    $units = array('', 'Thousand', 'Million', 'Billion', 'Trillion');
    
    if ($number == 0) {
        return 'Zero';
    }

    $output = '';
    $unitIndex = 0;

    while ($number > 0) {
        $part = $number % 1000;
        $number = (int)($number / 1000);

        if ($part > 0) {
            $partWords = '';
            if ($part > 99) {
                $partWords .= $words[(int)($part / 100)] . ' Hundred ';
                $part %= 100;
            }
            if ($part > 0) {
                if ($part < 20) {
                    $partWords .= $words[$part] . ' ';
                } else {
                    $partWords .= $words[10 * (int)($part / 10)];
                    if ($part % 10 > 0) {
                        $partWords .= '-' . $words[$part % 10];
                    }
                    $partWords .= ' ';
                }
            }
            $output = $partWords . $units[$unitIndex] . ' ' . $output;
        }
        $unitIndex++;
    }

    return trim($output);
}

// Convert the discounted amount to words

$discountedAmountInWords = numberToWords($discountedAmount);

?>
    <?php
    $sub = mysqli_query($connection, "SELECT SUM(remain_balance) AS sub FROM creditor_closing WHERE creditor_name = '$customerName'");
    $rowSub = mysqli_fetch_array($sub);
    ?>
    <div class="container">
       <div class="row">
           <div class="col-sm-5">
              <p style="font-weight:600;">
                  
<span style="background:#000; color:#fff; font-weight:700; padding:7px; width:100px;">Warranty</span><br><br>
We do hereby give warranty that the medicines described in this invoice as sold by us are Herbal Medicines and do not contravene any provision
of the drug ordinance 1976 and rules made thereunder.
              </p> 
               
           </div>
           <div class="col-sm-4"></div>
           <div class="col-sm-3">
        <p><strong>Total:</strong> Rs <?php echo htmlspecialchars($discountedAmount); ?>/-<br>
        <strong>Previous Receivable:</strong> Rs <?php echo htmlspecialchars($rowSub['sub']); ?>/-<br>
        <strong>Total Receivable:</strong> Rs <?php echo (int)$rowSub['sub'] + (int)$discountedAmount ; ?>/-</p>
        </div>
      </div>
    </div>
    <br><br>
<div class="container">
    <div class="row">
        <h6>Amount in Words : <?php echo "Rupees $discountedAmountInWords Only"; ?></h6>
        <br>
        <div class="col-sm-5">
            <p>----------------------------------</p>
            <h4 style="margin-top:-20px;">Signature</h4>
        </div>
        <div class="col-sm-1 text-left">
            
        </div>
        <div class="col-sm-5 text-end text-bold">
            <p style="font-weight:700; font-size:25px;">نوٹ</p>
           <br> <p style="font-weight:500; font-size:20px;margin-top:-30px;"> ایکسپائر ادویات ناقابل واپسی ہیں اپنی ڈیمانڈ کے مطابق سٹاک منگوائے
        </p></div>
    </div>
</div>
    <div class="text-center mt-3">
        <p class="fw-bold">Thank you for your kind visit!</p>
    </div>

    <div class="text-center no-print mt-3">
        <button class="btn btn-primary" onclick="window.print()">Print</button>
        <button class="btn btn-secondary" onclick="window.location.href='mainpos.php'">Exit</button>
    </div>
</div>
</body>
</html>
