<?php
include("../db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start();

if (isset($_SESSION['user_name'], $_SESSION['user_role'], $_SESSION['outlet_name'], $_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

$id = isset($_GET["product_id"]) ? $_GET["product_id"] : null; // Ensure ID exists

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["submit2"])) {
    $id = isset($_POST["id"]) ? $_POST["id"] : null; // Ensure ID from form

    if (!$id) {
        die("Error: ID is missing.");
    }

    // Sanitize input
    $product_id = mysqli_real_escape_string($connection, $_POST['product_id']);
    $product_name = mysqli_real_escape_string($connection, $_POST['product_name']);
    $company = mysqli_real_escape_string($connection, $_POST['company']);
    $quantity = mysqli_real_escape_string($connection, $_POST['quantity']);
    $retail_price = mysqli_real_escape_string($connection, $_POST['retail_price']);
    $percentage = mysqli_real_escape_string($connection, $_POST['percentage']);
    $trade_price = mysqli_real_escape_string($connection, $_POST['trade_price']);
    $total_amount = mysqli_real_escape_string($connection, $_POST['total_amount']);
    $supplier = mysqli_real_escape_string($connection, $_POST['supplier']);
    $product_unit = mysqli_real_escape_string($connection, $_POST['product_unit']);
    $vehicle = mysqli_real_escape_string($connection, $_POST['size']);
    $category = mysqli_real_escape_string($connection, $_POST['category']);
    $flavour = mysqli_real_escape_string($connection, $_POST['flavour']);
    $bonus_quantity = mysqli_real_escape_string($connection, $_POST['bonus_quantity']);
    $tpperpack = mysqli_real_escape_string($connection, $_POST['tpperpack']);
    $rpperpack = mysqli_real_escape_string($connection, $_POST['rpperpack']);
    $total_quantity = mysqli_real_escape_string($connection, $_POST['total_quantity']);
    $noofunit = mysqli_real_escape_string($connection, $_POST['noofunit']);
    $batch_no = mysqli_real_escape_string($connection, $_POST['batch_no']);
    $expiry = mysqli_real_escape_string($connection, $_POST['expiry']);
    $total_purchase = $trade_price * $quantity;
    $date_time = date("Y-m-d");

    // Check if the product ID exists in the database
    $check_query = "SELECT * FROM products WHERE product_id = '$id'";
    $check_result = mysqli_query($connection, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        // Update the existing product record
        $update_product_query = "UPDATE products 
            SET product_name = '$product_name', 
                size = '$vehicle', 
                category = '$category',
                flavour = '$flavour', 
                company = '$company', 
                quantity = '$quantity', 
                retail_price = '$retail_price', 
                percentage = '$percentage', 
                trade_price = '$trade_price', 
                total_amount = '$total_amount', 
                total_purchase = '$total_purchase', 
                noofunit = '$noofunit', 
                tpperpack = '$tpperpack', 
                rpperpack = '$rpperpack', 
                bonus_quantity = '$bonus_quantity', 
                total_quantity = '$total_quantity', 
                product_unit = '$product_unit', 
                supplier = '$supplier', 
                batch_no = '$batch_no', 
                expiry = '$expiry', 
                date_time = '$date_time', 
                login_user = '$userName', 
                user_role = '$userRole', 
                outlet_name = '$outlet_name', 
                outlet_address = '$outlet_address' 
            WHERE product_id = '$id'";

        if (!mysqli_query($connection, $update_product_query)) {
            die("Error updating product: " . mysqli_error($connection)); // Debugging Output
        } else {
            echo '<script>alert("Product updated successfully!"); window.location.href="addproduct.php";</script>';
        }
    } else {
        echo "<script>alert('Error: Product ID $product_id does not exist.');</script>";
    }
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>AL GHANI TRADERS</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}

.form-control{
    
    font-weight:600;
    
}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
 <div class="container">
        <div class="row">
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;"> Product Update</h3>
                
            </div>
            <div class="col-sm-3">
               <a href="addproduct.php" class="btn btn-dark" style="float:right;"><i class="fas fa-arrow-left fa-1x"></i></a>
            </div>
        </div>
    </div><br />
    <br />
    <br />
    <?php
    $rec = mysqli_query($connection,"select * from products where product_id = '$id' ");
    $row = mysqli_fetch_array($rec);
    ?>
    <div class="container">
        <div class="row">
            <div class="col-sm-1"></div>
            <div class="col-sm-5">
                <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
                    
                    <input type="hidden" name="id" value="<?php echo $row['product_id']; ?>">

                    <div class="form-group">
                        <label>Product ID</label>
                        <input type="text" name="product_id" class="form-control" value="<?php echo $row["product_id"];  ?>" readonly> 
                    </div>
                    <div class="form-group">
                        <label>Product Name</label>
                        <input type="text" name="product_name" class="form-control" value="<?php echo $row["product_name"];  ?>" />
                    </div>
                    <div class="">
                
                <div class="form-group ">
                    <label>Category</label>
                    <input type="text" name="category" value="<?php echo $row["category"];  ?>"   class="form-control" />
                </div>
                <div class="form-group ">
                    <label>Flavour</label>
                    <input type="text" name="flavour" value="<?php echo $row["flavour"];  ?>"   class="form-control" />
                </div>
                <div class="form-group ">
                    <label>Company</label>
                    <input type="text" name="company"  id="company" class="form-control" value="<?php echo $row["company"];  ?>" />
                </div>
                </div>
                    <div class="row">
                    <div class="form-group col-6">
                        <label>Box Quantity</label>
                        <input type="text" name="quantity" class="form-control" value="<?php echo $row["quantity"];  ?>" />
                    </div>
                     <div class="form-group col-6">
                        <label>Bonus Quantity</label>
                        <input type="text" name="bonus_quantity" class="form-control" value="<?php echo $row["bonus_quantity"];  ?>" />
                    </div>
                    </div>
                    <div class="form-group">
                        <label>T.P Per Box</label>
                        <input type="text" name="retail_price" id="retail_price" class="form-control" value="<?php echo $row["retail_price"];  ?>" />
                    </div>
                    <div class="form-group">
                        <label>% Apply</label>
                        <input type="text" name="percentage" id="percentage" class="form-control" value="<?php echo $row["percentage"];  ?>" />
                    </div>
                </div>
                <div class="col-sm-5">
              
                    <div class="form-group">
                        <label>Purchase Price Per Box</label>
                        <input type="text" name="trade_price" id="trade_price" class="form-control" value="<?php echo $row["trade_price"];  ?>"  />
                    </div>
                    <div class="form-group">
                        <label>No of Unit Per Box</label>
                        <input type="text" name="noofunit" class="form-control" value="<?php echo $row["noofunit"];  ?>" />
                    </div>
                    <div class="row">
                        <div class="form-group col-6">
                        <label>T.P Per Unit</label>
                        <input type="text" name="rpperpack" class="form-control" value="<?php echo $row["rpperpack"];  ?>" />
                    </div>
                    <div class="form-group col-6">
                        <label>Purchase Price Per Unit</label>
                        <input type="text" name="tpperpack" class="form-control" value="<?php echo $row["tpperpack"];  ?>" />
                    </div>
                    </div>
                    <div class="form-group">
                        <label>Total Qunatity</label>
                        <input type="text" name="total_quantity" id="total_amount" class="form-control" readonly value="<?php echo $row["total_quantity"];  ?>" />
                    </div>
                    <div class="form-group">
                        <label>Total Amount</label>
                        <input type="text" name="total_amount" id="total_amount" class="form-control" readonly value="<?php echo $row["total_amount"];  ?>" />
                    </div>
                    <div class="row">
                    <div class="form-group col-6">
                        <label>Supplier</label>
                        <input type="text" name="supplier" class="form-control"  value="<?php echo $row["supplier"];  ?>"/>
                    </div> 
                    <div class="form-group col-6">
                        <label>Expiry</label>
                        <input type="date" name="expiry" class="form-control"  value="<?php echo $row["expiry"];  ?>"/>
                    </div> 
                    </div> 
                    
                    <div class="row">
                    <div class="col-6 form-group">
                        <label>Bacth</label>
                        <input type="text" name="batch_no" value="<?php echo $row["batch_no"]; ?>" class="form-control" />
                    </div>
                    <div class="col-6 form-group">
                        <label>Product Unit</label>
                        <select name="product_unit" class="form-control">
                        <option value="">Select Unit</option>
                        <option value="carton">Carton</option>
                        <option value="box">Box</option>
                        <option value="pcs">Pcs</option>
                        <option value="gram">Gram</option>
                        
                        </select>
                    </div> 
                    </div>
                    <hr />
                    <button class="btn btn-dark form-control" name="submit2" type="submit">Update Product</button>
                </div>
                </form>
            </div>
            <div class="col-sm-1">
            </div>
        </div>
           
    
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
<script>
    function calculateValues() {
        let boxQuantity = parseFloat(document.querySelector('input[name="quantity"]').value) || 0;
        let bonusQuantity = parseFloat(document.querySelector('input[name="bonus_quantity"]').value) || 0;
        let noOfUnitsPerBox = parseFloat(document.querySelector('input[name="noofunit"]').value) || 1;
        let tPPerBox = parseFloat(document.getElementById("retail_price").value) || 0;
        let percentage = parseFloat(document.getElementById("percentage").value) || 0;

        // Calculate Total Quantity
        let totalQuantity = (boxQuantity + bonusQuantity) * noOfUnitsPerBox;
        document.querySelector('input[name="total_quantity"]').value = totalQuantity;

        // Calculate Purchase Price Per Box
        let purchasePricePerBox = tPPerBox - (tPPerBox * percentage / 100);
        document.getElementById("trade_price").value = purchasePricePerBox.toFixed(2);

        // Calculate Total Amount
        let totalAmount = boxQuantity * purchasePricePerBox;
        document.querySelector('input[name="total_amount"]').value = totalAmount.toFixed(2);

        // Calculate T.P Per Unit
        let tPPerUnit = tPPerBox / noOfUnitsPerBox;
        document.querySelector('input[name="rpperpack"]').value = tPPerUnit.toFixed(2);

        // Calculate Purchase Price Per Unit
        let purchasePricePerUnit = purchasePricePerBox / noOfUnitsPerBox;
        document.querySelector('input[name="tpperpack"]').value = purchasePricePerUnit.toFixed(2);
    }

    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('input').forEach(input => {
            input.addEventListener('input', calculateValues);
        });
    });
</script>

      
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>