<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

if (isset($_GET['query'])) {
    $query = $connection->real_escape_string($_GET['query']);
    $sql = "SELECT product_id, product_name, retail_price, rpperpack, trade_price, flavour, supplier, noofunit, company, product_unit, total_quantity FROM products WHERE product_name LIKE '%$query%' GROUP BY product_name";

    $result = $connection->query($sql);

    $suggestions = "";
    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-product-id='" . $row['product_id'] . "' data-noofunit='" . $row['noofunit'] . "' data-flavour='" . $row['flavour'] . "' data-product-quantity='" . $row['total_quantity'] . "' data-retail-price='" . $row['trade_price'] . "' data-trade-price='" . $row['trade_price'] . "' data-supplier='" . $row['supplier'] . "' data-company='" . $row['company'] . "' data-product-unit='" . $row['product_unit'] . "'>" . $row['product_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}

// if (isset($_GET['batch_no'])) {
//     $batch_no = $connection->real_escape_string($_GET['batch_no']);
//     $sql = "SELECT batch_no, expiry, rpperpack FROM products WHERE batch_no = '$batch_no'";
    
//     $result = $connection->query($sql);

//     if ($result->num_rows > 0) {
//         $row = $result->fetch_assoc();
//         echo json_encode($row);
//     } else {
//         echo json_encode(["error" => "Batch not found"]);
//     }
//     exit;
// }

if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT supplier_name, supplier_id, supplier_phone, supplier_company FROM supplier WHERE supplier_company LIKE '%$customerName%' LIMIT 5";

    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-customer-name='" . $row['supplier_company'] . "' data-customer-id='" . $row['supplier_id'] . "' data-customer-phone='" . $row['supplier_phone'] . "'>" . $row['supplier_company'] . "</div>";
    }

    echo $suggestions;
    exit;
}

$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;

if (isset($_GET['inv_id'])) {
   

    // Get the search term
    $order_id = $_GET['inv_id'];

    if (!empty($order_id)) {
        // Query to search for order_ids in the log_user_sales table
        $stmt = $connection->prepare("SELECT inv_id FROM purchase WHERE inv_id LIKE ? GROUP BY inv_id");
        $like_order_id = "%" . $order_id . "%";
        $stmt->bind_param("s", $like_order_id);
        $stmt->execute();
        $result = $stmt->get_result();

        // Generate HTML output
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo '<div class="dropdown-item" data-order-id="' . $row['inv_id'] . '">' . $row['inv_id'] . '</div>';
            }
        } else {
            echo '<div class="dropdown-item">No Invoice found</div>';
        }

        $stmt->close();
    }

    $connection->close();
    exit; // End the PHP processing for AJAX request here
}


if ($_SERVER['REQUEST_METHOD'] === 'POST'&& isset($_POST['inv_bill'])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
	
    $orderId = uniqid("inv_id");
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $desc_name = $_POST["desc_name"];
    $fri = $_POST["frieght"] ?? '0.00';
    $truck_no = $_POST["truck_no"];
    $gate_pass = $_POST['gate_pass'];
    $customer_id = $_POST["customer_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $BQuantity = $product['Bquantity'];
        $Lqty = $product['Lqty'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $batchNo = $product['BatchNo'];
        $flv = $product['flavour'];
        $productUnit = $product['productUnit'];
        $Exp = $product['EXp'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = (int)$tradePrice * (int)$productQuantity;
		$tp = (floatval($productQuantity) > 0) ? (floatval($productTotal) / floatval($productQuantity)) : 0;

		
        $sql = "INSERT INTO purchase (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            loose,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            desc_name,
            truck_no,
            gate_pass,
            discount_per,
            cash_amount,
            change_amount,
            frieght,
            inv_id,
			r_inv_id,
			status,
			batch_no,
			expiry,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time,
            product_unit,
            flavour
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '$BQuantity',
            '$Lqty',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$desc_name',
            '$truck_no',
            '$gate_pass',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$fri',
            '$orderId',
			'',
			'',
			'$batchNo',
			'$Exp',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time',
            '$productUnit',
            '$flv'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        $updateSql = "UPDATE products SET total_quantity = total_quantity + $productQuantity, total_amount = total_amount + $netAmount, trade_price =  $tp  WHERE product_name = '$productName' AND batch_no = '$batchNo'";
        if ($connection->query($updateSql) !== TRUE) {
            echo "Error updating product quantity: " . $connection->error;
            ob_end_flush();
            exit;
        }
    }
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'purchase_n.php';</script>";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST'&& isset($_POST['return_bill'])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
	$r_inv_id = $_POST["r_inv_id"];
    $orderId = $r_inv_id ;
	$status = 'return';
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_type = $_POST["desc_name"];
    $customer_id = $_POST["customer_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $BQuantity = $product['Bquantity'];
        $Lqty = $product['Lqty'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $batchNo = $product['BatchNo'];
        $Exp = $product['EXp'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = (int)$tradePrice * (int)$productQuantity;
        $sql = "INSERT INTO purchase (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            loose,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            desc_name,
            discount_per,
            cash_amount,
            change_amount,
            inv_id,
			r_inv_id,
			status,
			batch_no,
			expiry,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '$BQuantity',
            '$Lqty',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$desc_name',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
			'$r_inv_id',
			'$status',
			'$batchNo',
			'$Exp',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        $updateSql = "UPDATE products SET quantity = quantity - $productQuantity, total_amount = total_amount - $netAmount WHERE product_name = '$productName'";
        if ($connection->query($updateSql) !== TRUE) {
            echo "Error updating product quantity: " . $connection->error;
            ob_end_flush();
            exit;
        }
    }
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'purchase_n.php';</script>";
}

if($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["supplier_paid"])){
$date_time = $_POST["date_time"];
	$supplier = $_POST["supplier_name"];
	$amount = $_POST["supplier_amount"];
	$status = $_POST["status"];
	$description     = $_POST['description'];
	
	
	 mysqli_query($connection,"insert into supplier_paid(supplier_name,supplier_amount,status,description,date_time,user_name,user_role,outlet_name,outlet_address)
values('".$supplier."','".$amount."','".$status."','".$description."','".$date_time."','".$userName."','".$userRole."','".$outlet_name."','".$outlet_address."')");

 echo "<script type='text/javascript'>window.location.href = 'purchase_n.php';</script>";

}
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>AL GHANI TRADERS
</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
 #table-container-wrapper {
    max-height: 390px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
.form-control{
    font-weight:700;
    color:#000;
}
.btn, .text-white{
    font-weight:700;
}
.btn-primary{
    background:#0A4657;
    color:#fff;
    border:1px solid #0A4657;
    
}
.btn-primary:hover{
    background:#fff;
    color:#0A4657;
    border:1px solid #0A4657; 
}

    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/btt.png" style="margin-top:5px;" width="58" height="60"></a>
        </div>
        <div class="col-sm-6">
        <h3 style="color:#fff; font-weight:700; text-transform:uppercase; text-align:center; line-height:60px; font-size:33px;">
           AL GHANI TRADERS
</h3>
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php">
            <button type="button" class="btn btn-light mt-3" style="float:right;" >Back</button>
            </a>
        </div>
    </div>
</div>
<div class="container-fluid">
    <form action="purchase_n.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-3" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Product</span>
                    </div>
                    <input type="text" class="form-control" id="productInput" placeholder="Start typing a product name..." autocomplete="off">
                    <div class="dropdown-menu" id="suggestions"></div>
                </div>
                <hr>
                 <div class="">
                    
                    <input type="hidden" id="batch_no" name="batch_no" class="form-control" placeholder="" style="font-weight:700;">
                </div>
                <div class="">
                  
                    <input type="hidden" id="expiry" name="expiry" class="form-control" placeholder="" style="font-weight:700;" readonly>
                </div>
                 <div class="input-group mb-3 " >
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">FLV.</span>
                    </div>
                    <input type="text" id="flavour" name="flavour" class="form-control" placeholder=""
                    style="font-weight:700;" readonly>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6" >
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">P.Qty</span>
                    </div>
                    <input type="text" id="quantity" name="quantity" class="form-control" placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3 col-6" >
                    <input type="text" id="noofunit" name="noofunit" 
                    class="form-control" placeholder="" style="font-weight:700;">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">No.of.Unit</span>
                    </div>
                </div>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">B.Qty</span>
                    </div>
                    <input type="text" id="bonus_quantity" name="bonus_quantity" class="form-control" 
                    placeholder="" style="font-weight:700;" >
                </div>
                <div class="input-group mb-3 col-6">
                    <input type="text" id="loose_quantity" name="loose_quantity" class="form-control" 
                    placeholder="" style="font-weight:700;" >
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">L.Qty</span>
                    </div>
                </div>
                <div class="input-group mb-3 col-12 ">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">T.Qty</span>
                    </div>
                    <input type="text" id="total_quantity" name="total_quantity" class="form-control" 
                    placeholder="" style="font-weight:700;" readonly>
                     
                </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Price / Unit</span>
                    </div>
                    <input type="text" id="retail_price" name="retail_price" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="total_amount" name="total_amount" class="form-control" placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">-/ PKR</span>
                    </div>
                </div>
                <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis %</span>
                    </div>
                    <input type="text" id="percentage" name="percentage" class="form-control"  placeholder="">
                </div>
                
                <div class="input-group mb-3 col-6">
                    
                    <input type="text" id="disc_amount" name="disc_amount" class="form-control"  placeholder="">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis PKR</span>
                    </div>
                </div>
             </div>
                <div class="input-group mb-3 ">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">S.Tax %</span>
                    </div>
                    <input type="text" id="sale_tax" name="sale_tax" class="form-control"  placeholder="" style="font-weight:700;">
                </div>
               
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="trade_price" name="trade_price" class="form-control" placeholder="" readonly>
                </div>
                
                <br>
                <button type="button" class="form-control text-white btn btn-dark" id="makeEntry">Make Entry</button>
                <hr>
                <button type="button" class="form-control text-white btn btn-dark" onclick="location.reload();">Refresh</button>
              
                <div class="form-group">
            <label>Description</label>
                    <input type='text' class="form-control" name="desc_name">
          
                    </div>
                 
            </div>
            <div class="col-sm-9">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="">
                        <div class="form-group">
                            
                            <input type="hidden" class="form-control in_form" name="customer_type">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Supplier Name</label>
                            <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                            <div class="dropdown-menu" id="customer_suggestions"></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Supplier Phone</label>
                            <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                        </div>
                    </div>
                    <div class="">
                        <div class="">
                           
                            <input  type="hidden" id="customer_id"  name="customer_id" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-3">
                    <div class="form-group">
                        <label>Return ID</label>
                        <input type="text" id="r_order_id" name="r_inv_id" class="form-control in_form">
                        <div id="order_suggestions" class="dropdown-menu" style="display: none;"></div>
                    </div>
                </div>
                
                
                <div class="col-sm-3">
                        <div class="form-group">
                            <label>Vehicle No.</label>
                            <input type="text" id="truck_no" name="truck_no" class="form-control in_form">
                        </div>
                    </div>
                <div class="col-3">
                        <div class="form-group">
                          <label>Gate Pass</label>
                            <input type="text"  id="gate_pass" name="gate_pass" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <button type="button" style="margin-top:30px;" class="btn btn-primary " data-toggle="modal" data-target="#addPurchaseModal">
              Cash Paid Amount
            </button>
                    </div>
                </div>
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12" style="height:550px;">
                        <table class="table table-borderless table-sm bg-white text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#0A4657;font-weight:700;">
                                    
                                <td>Item Code</td>
                                <td>Description</td>
                                <td>Batch No.</td>
                                <td>P.Qty</td>
                                <td>B.Qty</td>
                                <td>L.Qty</td>
                                <td>Unit Price</td>
                                <td>Amount</td>
                                <td>Dis %</td>
                                <td>Dis PKR</td>
                                <td>Tax</td>
                                <td>Exp</td>
                                <td>Net Amount</td>
                                <td>.FLV</td>
                                <td>Action</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Total</label>
                                    <input type="number" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                             <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Frieght</label>
                                    <input type="text" id="frieght" name="frieght" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount" 
                                    name="discount_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount %</label>
                                    <input type="number" id="discount_percent" name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                               
                                    <input type="hidden" id="cash_received" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                        
                                    <input type="hidden" id="cash_return" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                                  
                                    <input type="hidden" id="tax" name="tax" class="form-control in_form input-height"  readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method2" class="form-control in_form">
                                        <option>Credit</option>
                                        <option>Cash</option>
                                        <option value="bank1">Easy Paisa</option>
                                        <option value="bank2">Jazz cash</option>
                                        <option value="bank3">Allied bank</option>
                                         <option value="bank4">Hbl</option>
                                        <option value="bank5">Bank Al-Habib</option>
                                        <option value="bank6">Meezan Bank</option>
                                        <option>Others</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-3">
                                <hr>
                                <button type="submit" class="btn btn-dark btn-sm" name="inv_bill">Generate Invoice</button>
                                 <button type="submit" class="btn btn-dark btn-sm" name="return_bill">Return Invoice</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const generateInvoiceButton = document.querySelector("button[name='inv_bill']");
    const returnInvoiceButton = document.querySelector("button[name='return_bill']");

    generateInvoiceButton.addEventListener("click", function(event) {
        const method = document.getElementById("method2").value;
        const supplierName = document.getElementById("customer_name").value.trim();

        // Check if method is "Credit" and supplier name is empty
        if (method === "Credit" && supplierName === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please fill in the Supplier Name for Credit method.");
        }
    });

    returnInvoiceButton.addEventListener("click", function(event) {
        const returnId = document.getElementById("r_order_id").value.trim();

        // Check if Return ID is empty when "Return Invoice" button is clicked
        if (returnId === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please enter a Return ID.");
        }
    });
});
</script>
<script>
    
document.addEventListener("DOMContentLoaded", function() {
    let currentFocus = -1;

    // Event listener for input field to trigger AJAX request
    document.getElementById("r_order_id").addEventListener("input", function() {
        var orderIdInput = this.value;
        if (orderIdInput.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?inv_id=" + encodeURIComponent(orderIdInput), true); // Sends request to the same page
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("order_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("order_suggestions").style.display = 'none';
        }
    });

    // Handle clicking on suggestion items
    document.getElementById("order_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectOrder(e.target);
        }
    });

    // Add keyboard navigation for dropdown items
    document.getElementById("r_order_id").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("order_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectOrder(items[currentFocus]);
                    }
                }
            }
        }
    });
    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectOrder(item) {
        var orderId = item.getAttribute('data-order-id');
        document.getElementById("r_order_id").value = orderId;
        document.getElementById("order_suggestions").style.display = 'none';
    }


       document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectCustomer(item) {
        var customerName = item.getAttribute('data-customer-name');
        var customerId = item.getAttribute('data-customer-id');
        var customerPhone = item.getAttribute('data-customer-phone');

        document.getElementById("customer_name").value = customerName;
        document.getElementById("customer_phone").value = customerPhone;
        document.getElementById("customer_id").value = customerId;

        document.getElementById("customer_suggestions").style.display = 'none';
    }


function calculateTotalPrice(triggeredBy = null) {
    let baseQuantity = parseFloat(document.getElementById("quantity").value) || 0;

    // noofunit from selected product
    let noOfUnit = parseFloat(document.getElementById("noofunit").value) || 0;

    // effective quantity = quantity * noofunit
    let effectiveQuantity = baseQuantity ;

    // bonus quantity (default 0 if not provided)
    let bonusQuantity = parseFloat(document.getElementById("bonus_quantity")?.value) || 0;
    let looseQuantity = parseFloat(document.getElementById("loose_quantity")?.value) || 0;

    // total quantity = effectiveQuantity + bonusQuantity
    let totalQuantity = effectiveQuantity * noOfUnit + bonusQuantity + looseQuantity ;

    let pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
    let discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
    let discountAmount = parseFloat(document.getElementById("disc_amount").value) || 0;
    let saleTaxPercentage = parseFloat(document.getElementById("sale_tax").value) || 0;

    let totalPrice = effectiveQuantity * pricePerUnit;

    if (triggeredBy === "percentage") {
        discountAmount = (totalPrice * discountPercentage) / 100;
        document.getElementById("disc_amount").value = discountAmount.toFixed(2);
    } else if (triggeredBy === "disc_amount") {
        discountPercentage = totalPrice > 0 ? (discountAmount / totalPrice) * 100 : 0;
        document.getElementById("percentage").value = discountPercentage.toFixed(2);
    } else {
        discountAmount = (totalPrice * discountPercentage) / 100;
        document.getElementById("disc_amount").value = discountAmount.toFixed(2);
    }

    let discountedPrice = totalPrice - discountAmount;
    let saleTaxAmount = (discountedPrice * saleTaxPercentage) / 100;
    let finalPrice = discountedPrice + saleTaxAmount;

    document.getElementById("total_amount").value = totalPrice.toFixed(2);
    document.getElementById("trade_price").value = finalPrice.toFixed(2);

    // show total quantity (effective + bonus)
    if (document.getElementById("total_quantity")) {
        document.getElementById("total_quantity").value = totalQuantity;
    }
}

// Event listeners
document.getElementById("quantity").addEventListener("input", () => calculateTotalPrice());
document.getElementById("retail_price").addEventListener("input", () => calculateTotalPrice());
document.getElementById("percentage").addEventListener("input", () => calculateTotalPrice("percentage"));
document.getElementById("disc_amount").addEventListener("input", () => calculateTotalPrice("disc_amount"));
document.getElementById("sale_tax").addEventListener("input", () => calculateTotalPrice());
document.getElementById("bonus_quantity")?.addEventListener("input", () => calculateTotalPrice());
document.getElementById("loose_quantity")?.addEventListener("input", () => calculateTotalPrice());


    document.getElementById("suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectProduct(e.target);
        }
    });

    document.getElementById("productInput").addEventListener("input", function() {
        var query = this.value;
        if (query.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?query=" + query, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("suggestions").style.display = 'none';
        }
    });



//     document.getElementById("batch_no").addEventListener("input", function() {
//     var batchNo = this.value;
//     if (batchNo.length > 2) {
//         var xhr = new XMLHttpRequest();
//         xhr.open("GET", "?batch_no=" + batchNo, true);
//         xhr.onreadystatechange = function() {
//             if (xhr.readyState == 4 && xhr.status == 200) {
//                 var response = JSON.parse(xhr.responseText);
//                 if (!response.error) {
//                     document.getElementById("expiry").value = response.expiry;
//                     document.getElementById("retail_price").value = response.rpperpack;
//                 } else {
//                     alert("Batch not found!");
//                 }
//             }
//         };
//         xhr.send();
//     }
// });


    document.getElementById("productInput").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectProduct(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectProduct(item) {
        var selectedProduct = item.textContent;
       
        var productQuantity = item.getAttribute('data-product-quantity');
        var tradePrice = item.getAttribute('data-trade-price');
        var productId = item.getAttribute('data-product-id');
        var supplier = item.getAttribute('data-supplier');
        var company = item.getAttribute('data-company');
        var productUnit = item.getAttribute('data-product-unit');
        var NoofUnit = item.getAttribute('data-noofunit');
        var retailPrice = item.getAttribute('data-retail-price');
        var flavour = item.getAttribute('data-flavour');

        document.getElementById("productInput").value = selectedProduct;
        document.getElementById("noofunit").value = NoofUnit ;
        document.getElementById("retail_price").value = retailPrice;
        document.getElementById("flavour").value = flavour;
        document.getElementById("productInput").setAttribute('data-product-id', productId);
        document.getElementById("productInput").setAttribute('data-product-quantity', productQuantity);
        document.getElementById("productInput").setAttribute('data-supplier', supplier);
        document.getElementById("productInput").setAttribute('data-company', company);
        document.getElementById("productInput").setAttribute('data-trade-price', tradePrice);
           document.getElementById("productInput").setAttribute('data-flavour', flavour);
        document.getElementById("productInput").setAttribute('data-product-unit', productUnit);

        document.getElementById("suggestions").style.display = 'none';
        calculateTotalPrice();
    }

 document.getElementById("makeEntry").addEventListener("click", function() {
        var productInput = document.getElementById("productInput");
        var productId = productInput.getAttribute('data-product-id');
        var productQuantity = productInput.getAttribute('data-product-quantity'); // Parse the quantity and ensure it's a number
        var supplier = productInput.getAttribute('data-supplier');
        var company = productInput.getAttribute('data-company');
        var flavour = productInput.getAttribute('data-flavour');
        var productUnit = productInput.getAttribute('data-product-unit');

        var description = productInput.value;
        var quantity = parseFloat(document.getElementById("quantity").value) || 0;
        var Bquantity = parseFloat(document.getElementById("bonus_quantity").value) || 0;
        var pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
        var Lqty = document.getElementById("loose_quantity").value || 0;
        var EXp = document.getElementById("expiry").value || 0;
        var Stax = parseFloat(document.getElementById("sale_tax").value) || 0;
        var BatchNo = document.getElementById("batch_no").value || 0;
        var totalPrice = parseFloat(document.getElementById("total_amount").value) || 0;
        var discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
        var discountAmount = parseFloat(document.getElementById("disc_amount").value) || 0;
        var netAmount = parseFloat(document.getElementById("trade_price").value) || 0;
        var tradePrice = productInput.getAttribute('data-trade-price');

        // Check if quantity is zero or negative before making the entry
        if (quantity <= 0) {
            alert("Product is not in stock. Cannot add entry.");
            return; // Stop execution if quantity is zero or negative
        }

        if (productId && description && quantity && pricePerUnit && totalPrice && netAmount) {
            var table = document.getElementById("productsTable");
            var row = table.insertRow();
            row.innerHTML = `
                <td style="display:none;">${productQuantity}</td>
                <td style="font-weight:700;">${productId}</td>
                <td style="color:#0A5064;font-weight:700;">${description}</td>
                <td style="font-weight:700; ">${BatchNo || '0.00'}</td>
                <td style="font-weight:700;">${quantity}</td>
                <td style="font-weight:700;">${Bquantity}</td>
                <td style="font-weight:700;">${Lqty}</td>
                <td style="font-weight:700;">${pricePerUnit}</td>
                <td style="font-weight:700;">${totalPrice}</td>
                <td style="font-weight:700;">${discountPercentage || '0.00'}</td>
                <td style="font-weight:700;">${discountAmount || '0.00'}</td>
                <td style="font-weight:700;">${Stax || '0.00'}</td>
                <td style="font-weight:700;">${EXp || '0.00'}</td>
                <td style="font-weight:700;">${netAmount}</td>
                <td style="display:none;">${supplier}</td>
                <td style="display:none;">${company}</td>
                <td style="display:none;">${tradePrice}</td>
                  <td style="font-weight:700;">${flavour}</td>
                  <td style="display:none;">${productUnit}</td>
                <td style="font-weight:700;"><button class="btn btn-danger btn-sm delete-row">X</button></td>
            `;

            row.querySelector(".delete-row").addEventListener("click", function() {
                row.remove();
                calculateTotalAmount();
            });

            calculateTotalAmount();

            var rows = document.querySelectorAll("#productsTable tr:not(:first-child)");
            var productData = [];
            rows.forEach(function(row) {
                var cells = row.querySelectorAll("td");
                var product = {
                    productId: cells[1].innerText,
                    description: cells[2].innerText,
                    BatchNo: cells[3].innerText,
                    quantity: cells[4].innerText,
                    Bquantity: cells[5].innerText,
                    Lqty: cells[6].innerText,
                    pricePerUnit: cells[7].innerText,
                    totalPrice: cells[8].innerText,
                    discountPercentage: cells[9].innerText,
                    discountPercentage: cells[10].innerText,
                    tax: cells[11].innerText,
                    EXp: cells[12].innerText,
                    netAmount: cells[13].innerText,
                    supplier: cells[14].innerText,
                    company: cells[15].innerText,
                    tradePrice: cells[16].innerText,
                    flavour: cells[17].innerText,
                    productUnit: cells[18].innerText
                };
                productData.push(product);
            });

            document.getElementById("productData").value = JSON.stringify(productData);

            // Reset product fields after making an entry
            resetProductFields();
            
            
            productInput.focus();
            
        } else {
            alert("Some required fields are missing");
        }
    });

    function resetProductFields() {
        document.getElementById("productInput").value = '';
        document.getElementById("quantity").value = '';
        document.getElementById("bonus_quantity").value = '';
        document.getElementById("loose_quantity").value = '';
        document.getElementById("noofunit").value = '';
        document.getElementById("total_quantity").value = '';
        document.getElementById("retail_price").value = '';
        document.getElementById("total_amount").value = '';
        document.getElementById("percentage").value = '';
        document.getElementById("disc_amount").value = '';
        document.getElementById("trade_price").value = '';
         document.getElementById("sale_tax").value = '';
        document.getElementById("batch_no").value = '';
         document.getElementById("expiry").value = '';
         document.getElementById("flavour").value = '';
        // Remove data attributes for the next product
        document.getElementById("productInput").removeAttribute('data-product-id');
        document.getElementById("productInput").removeAttribute('data-product-quantity');
        document.getElementById("productInput").removeAttribute('data-supplier');
        document.getElementById("productInput").removeAttribute('data-company');
        document.getElementById("productInput").removeAttribute('data-trade-price');
        document.getElementById("productInput").removeAttribute('data-product-unit');
    }

function calculateTotalAmount() {
    var table = document.getElementById("productsTable");
    var rows = table.getElementsByTagName("tr");
    var total = 0;

    for (var i = 1; i < rows.length; i++) {
        var netAmountCell = rows[i].cells[13];
        var netAmount = parseFloat(netAmountCell.textContent.trim());
        if (!isNaN(netAmount)) {
            total += netAmount;
        }
    }

    var totalInput = document.getElementById("total-input");
    var billAmountInput = document.getElementById("bill-amount");
    var frieghtInput = document.getElementById("frieght");

    var frieght = parseFloat(frieghtInput.value) || 0;
    var finalBill = total + frieght;

    totalInput.value = total.toFixed(2);
    billAmountInput.value = finalBill.toFixed(2);

    updateDiscountAmount();
}

function updateDiscountAmount() {
    var total = parseFloat(document.getElementById("total-input").value) || 0;
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var discountAmountInput = document.getElementById("discount_amount");
    var discountPercentInput = document.getElementById("discount_percent");

    if (!isNaN(billAmount) && !isNaN(total)) {
        var discountAmount = total - billAmount;
        discountAmountInput.value = Math.round(discountAmount);

        if (total > 0) {
            var discountPercent = (discountAmount / total) * 100;
            discountPercentInput.value = discountPercent.toFixed(2);
        } else {
            discountPercentInput.value = "0.00";
        }
    }
}

function calculateCashReturn() {
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var cashReceived = parseFloat(document.getElementById("cash_received").value) || 0;
    var cashReturnInput = document.getElementById("cash_return");

    if (!isNaN(billAmount) && !isNaN(cashReceived)) {
        var cashReturn = cashReceived - billAmount;
        cashReturnInput.value = cashReturn.toFixed(2);
    }
}

document.getElementById("bill-amount").addEventListener("input", updateDiscountAmount);
document.getElementById("cash_received").addEventListener("input", calculateCashReturn);
document.getElementById("frieght").addEventListener("input", calculateTotalAmount);

calculateTotalAmount();


});
</script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="modal fade" id="addPurchaseModal" tabindex="-1" role="dialog" 
            aria-labelledby="addPurchaseModalLabel" aria-hidden="true" style="margin-top:80px;">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header" style="background:#0A4657;">
                            <h5 class="modal-title text-capitalize text-white font-weight-bold" id="addPurchaseModalLabel">Supplier Paid</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <!-- Form for adding purchase -->
                            <form method="post" action="" enctype="multipart/form-data">
                                <select name="supplier_name" style="background:#0A4657;" class="form-control text-white">
    <?php
    $cust_query = mysqli_query($connection, "SELECT * FROM supplier");
    while ($cust = mysqli_fetch_array($cust_query)) {
    ?>
        <option value="<?php echo htmlspecialchars($cust['supplier_name']); ?>">
            <?php echo htmlspecialchars($cust['supplier_name']); ?>
        </option>
    <?php
    }
    ?>
</select>

                                <br />
                            
                                <input type="text" name="supplier_amount" placeholder="Amount" class="form-control" />
                                <br />
                            
                                <select name="status" class="form-control">
                                    <option value="">Select Method</option>
                                    <option value="cash">Cash</option>
                                    <option value="bank1">Easy Paisa</option>
                                    <option value="bank2">Jazz cash</option>
                                    <option value="bank3">Allied bank</option>
                                    <option value="bank4">HBL</option>
                                    <option value="bank5">Bank Al-Habib</option>
                                    <option value="bank6">Meezan Bank</option>
                                    <option value="other">Other</option>
                                </select>
                                <br />
                            
                                <!-- Description field -->
                                <textarea name="description" placeholder="Enter description" class="form-control" rows="3"></textarea>
                                <br />
                            
                                <input type="date" name="date_time" class="form-control" />
                                <br />
                            
                                <button type="submit" name="supplier_paid" class="btn btn-dark">Enter</button>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
</body>
</html>