<?php
include("db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Capture filter input
$customer_name = $_POST['customer_name'] ?? '';
$start_date = $_POST['start_date'] ?? '';
$end_date = $_POST['end_date'] ?? '';

$data = [];

if ($customer_name != "") {
    $where = " AND shop = '" . mysqli_real_escape_string($connection, $customer_name) . "' ";
    if ($start_date != "" && $end_date != "") {
        $where .= " AND DATE(date_time) BETWEEN '$start_date' AND '$end_date' ";
    }

    //$data = [];

    // --- Fetch add_opening_empty ---
    $q1 = mysqli_query($connection, "
        SELECT shop, empty_value, date_time 
        FROM add_opening_empty 
        WHERE 1=1 $where
    ");

    // --- Fetch get_empty ---
    $q2 = mysqli_query($connection, "
        SELECT shop, empty_value, date_time 
        FROM get_empty 
        WHERE 1=1 $where
    ");

    // --- Fetch log_user_sales (count product_unit rgb) ---
    $q3 = mysqli_query($connection, "
        SELECT customer_name AS shop, SUM(product_quantity) AS empty_value, date_time 
        FROM log_user_sales 
        WHERE product_unit='rgb' 
        AND customer_name='" . mysqli_real_escape_string($connection, $customer_name) . "' 
        GROUP BY customer_name, date_time
    ");

    $opening_total = 0;
    $get_total = 0;
    $sales_total = 0;

    while ($r = mysqli_fetch_assoc($q1)) {
        $opening_total += $r['empty_value'];
        $data[] = ["date" => $r['date_time'], "desc" => "Opening Empty", "empty" => $r['empty_value']];
    }
    while ($r = mysqli_fetch_assoc($q2)) {
        $get_total += $r['empty_value'];
        $data[] = ["date" => $r['date_time'], "desc" => "Get Empty", "empty" => $r['empty_value']];
    }
    while ($r = mysqli_fetch_assoc($q3)) {
        $sales_total += $r['empty_value'];
        $data[] = ["date" => $r['date_time'], "desc" => "RGB Sales Count", "empty" => $r['empty_value']];
    }

    // Sort by date
    usort($data, function ($a, $b) {
        return strtotime($a['date']) - strtotime($b['date']);
    });

    // Closing formula
    $closing = ($opening_total + $sales_total) - $get_total;
}
?>


<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>AL GHANI TRADERS</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
        <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>


body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.btn, .form-control{
	  	font-weight:700;
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>
  <?php include('common/log.php');  ?>
                </nav>
                
<div class="container">
    <h3 class="mt-3 mb-3 font-weight-bold" style="color:#000;">Empty Ledger Report</h3>
    <br>
    <form method="POST" action="report_empty.php">
        <div class="row">
            <div class="col-3">
                <label>Select Customer</label>
                <select name="customer_name" class="form-control" required>
                    <option value="">Select Customer</option>
                    <?php
                    $s = mysqli_query($connection, "SELECT DISTINCT shop FROM add_empty");
                    while ($r = mysqli_fetch_array($s)) {
                        $selected = ($customer_name == $r['shop']) ? "selected" : "";
                        echo "<option value='{$r['shop']}' $selected>{$r['shop']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-3">
                <label>Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
            </div>
            <div class="col-3">
                <label>End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
            </div>
            <div class="col-3">
                <button type="submit" class="btn btn-dark font-weight-bold mt-4">Show Report</button>
                <a href="report_empty.php" class="btn btn-dark mt-4"><i class="fas fa-sync"></i></a>
            </div>
        </div>
    </form>

    <br>
    <?php if ($customer_name != "") { ?>
        <table class="table table-bordered text-center font-weight-bold">
            <tr class="bg-dark text-white">
                <td>Sr#</td>
                <td>Date</td>
                <td>Description</td>
                <td>Empty</td>
            </tr>
            <?php
            $i = 1;
            foreach ($data as $row) {
                echo "<tr>
                        <td>{$i}</td>
                        <td>{$row['date']}</td>
                        <td>{$row['desc']}</td>
                        <td>{$row['empty']}</td>
                      </tr>";
                $i++;
            }

            if (empty($data)) {
                echo "<tr><td colspan='4'>No records found</td></tr>";
            } else {
                echo "<tr class='bg-dark text-white font-weight-bold'>
                        <td colspan='3' class='text-right'>Closing Empty</td>
                        <td>{$closing}</td>
                      </tr>";
            }
            ?>
        </table>
    <?php } ?>
</div>
            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>


   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>


</body>

</html>