<?php
include("../db/cn.php");
ob_start();
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AL GHANI TRADERS</title>
    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="css/custom_css.css" />
         <!-- jsPDF and AutoTable -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.20/jspdf.plugin.autotable.min.js"></script>
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
 #table-container-wrapper {
    max-height: 760px; /* Adjust the maximum height as needed */
    overflow-y: auto; /* Enable vertical scroll when content overflows */
}
.bg {
       background: linear-gradient(270deg, #060606, #0A4657);
        }
    .btn-dark:hover {
        background: #fff;
        color: #567043;
        border: 1px solid #567043;
    }

    .bg-dark2 {
        background: #567043;
        color: #fff;
    }

	.in_h{
	height:31px;
	font-size:12px;
		
		}
	.btn-dark{
	    background:#567043;
	    color:#fff;
	    border:1px #567043 solid;
	    font-weight:700;
	}	
	
</style>
<body>

<?php

// Initialize variables
$supplierOptions = '';
$shopOptions = '';
$routeOptions = '';
$bookerOptions = '';
$reportData = [];

try {
    // Fetch options for the dropdowns
    $suppliers = $pdo->query("SELECT * FROM supplier")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($suppliers as $supplier) {
        $supplierOptions .= "<option value='{$supplier['supplier_name']}'>{$supplier['supplier_name']}</option>";
    }

    $shops = $pdo->query("SELECT * FROM shop_u")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($shops as $shop) {
        $shopOptions .= "<option value='{$shop['shop_name']}'>{$shop['shop_name']}</option>";
    }

    $routes = $pdo->query("SELECT * FROM u_route")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($routes as $route) {
        $routeOptions .= "<option value='{$route['route']}'>{$route['route']}</option>";
    }

    $bookers = $pdo->query("SELECT * FROM booker")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($bookers as $booker) {
        $bookerOptions .= "<option value='{$booker['name']}'>{$booker['name']}</option>";
    }

    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['product'])) {
        $reportType = $_GET['product'];
        $supplierId = $_GET['supplier_name'] ?? '';
        $shopId = $_GET['shop_name'] ?? '';
        $routeId = $_GET['customer_id'] ?? '';
        $bookerId = $_GET['customer_type'] ?? '';
        $startDate = $_GET['start_date'] ?? '';
        $endDate = $_GET['end_date'] ?? '';

        // Build the SQL query based on the selected report type
        $sql = "SELECT * FROM log_user_sales WHERE 1=1";
        $params = [];

       if ($supplierId) {
    $sql .= " AND supplier_name = :supplier_name";
    $params[':supplier_name'] = $supplierId;
}
if ($shopId) {
    $sql .= " AND customer_name = :shop_name";
    $params[':shop_name'] = $shopId;
}
if ($routeId) {
    $sql .= " AND customer_id = :customer_id"; // Ensure consistency
    $params[':customer_id'] = $routeId;
}
if ($bookerId) {
    $sql .= " AND customer_type = :customer_type"; // Ensure consistency
    $params[':customer_type'] = $bookerId;
}
if ($startDate) {
    $sql .= " AND date_time >= :start_date";
    $params[':start_date'] = $startDate;
}
if ($endDate) {
    $sql .= " AND date_time <= :end_date";
    $params[':end_date'] = $endDate;
}

        switch ($reportType) {
            case 'Product Wise':
                $sql .= " GROUP BY product_name ORDER BY product_name";
                break;
            case 'Sale Invoice Wise':
    $sql = "SELECT order_id, customer_type, customer_name, date_time, product_price,
                   GROUP_CONCAT(product_name SEPARATOR '<br>') AS product_name,
                   GROUP_CONCAT(product_quantity SEPARATOR '<br>') AS product_quantity,
                   GROUP_CONCAT(product_price SEPARATOR '<br>') AS product_price,
                   SUM(net_amount) AS total_amount
            FROM log_user_sales WHERE 1=1";
    if ($supplierId) {
        $sql .= " AND supplier_name = :supplier_name";
    }
    if ($shopId) {
        $sql .= " AND customer_name = :shop_name";
    }
    if ($routeId) {
        $sql .= " AND customer_id = :customer_id";
    }
    if ($bookerId) {
        $sql .= " AND customer_type = :customer_type";
    }
    if ($startDate) {
        $sql .= " AND date_time >= :start_date";
    }
    if ($endDate) {
        $sql .= " AND date_time <= :end_date";
    }
    $sql .= " GROUP BY order_id ORDER BY date_time";
    break;
           case 'Shop Sale Wise':
    $sql = "SELECT customer_name, 
                   GROUP_CONCAT(product_name SEPARATOR '<br>') AS products,
                   GROUP_CONCAT(product_quantity SEPARATOR '<br>') AS quantities,
                   GROUP_CONCAT(product_price SEPARATOR '<br>') AS product_price,
                   SUM(net_amount) AS total_amount
            FROM log_user_sales WHERE 1=1";
    if ($supplierId) {
        $sql .= " AND supplier_name = :supplier_name";
    }
    if ($shopId) {
        $sql .= " AND customer_name = :shop_name";
    }
    if ($routeId) {
        $sql .= " AND customer_id = :customer_id";
    }
    if ($bookerId) {
        $sql .= " AND customer_type = :customer_type";
    }
    if ($startDate) {
        $sql .= " AND date_time >= :start_date";
    }
    if ($endDate) {
        $sql .= " AND date_time <= :end_date";
    }
    $sql .= " GROUP BY customer_name ORDER BY customer_name, product_name";
    break;
            case 'Booker Wise':
                $sql .= " ORDER BY customer_type";
                break;
            case 'Route Wise':
                $sql .= " ORDER BY customer_id";
                break;
            default:
                $sql .= " ORDER BY date_time";
                break;
        }


        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        $reportData = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        
    }
} catch (PDOException $e) {
    echo 'Query failed: ' . $e->getMessage();
}
?>


<body>

<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/btt.png" style="margin-top:5px; background:#fff; border-radius:70px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; 
        text-transform:uppercase;line-height:60px;">Al GHANI TRADERS</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php" class="btn btn-light" style="margin-top:20px; float:right;" >Back</a>
        </div>
    </div>
</div>
<br>
<div class="">
    <div class="container-fluid">
        
        <div class="row">
            <div class="col-md-3" style="background:#0A4657; padding:20px; border-radius:10px; border:4px solid #567043; color:#fff; ">
                <h5>Filter Options</h5>
                <form method="GET" action="">
                    <div class="form-group">
                        <label for="product">Report</label>
                        <select id="product" name="product" class="form-control in_h" >
                            <option value="">- Select Report Type -</option>
                            <option value="Product Wise">Product Wise</option>
                            <option value="Sale Invoice Wise">Sale Invoice Wise</option>
                            <option value="Shop Sale Wise">Shop Sale Wise</option>
                            <!--<option value="Booker Wise">Booker Wise</option>
                            <option value="Route Wise">Route Wise</option>-->
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="order_booker">Booker</label>
                        <select id="order_booker" name="customer_type" class="form-control in_h">
                            <option value="">- Select Booker -</option>
                            <?= $bookerOptions ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="customer">Shop</label>
                        <select id="shop_name" name="shop_name" class="form-control in_h">
                            <option value="">- Select Shop -</option>
                            <?= $shopOptions ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="area">Route</label>
                        <select id="customer_id" name="customer_id" class="form-control in_h">
                            <option value="">- Select Route -</option>
                            <?= $routeOptions ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="supplier">Supplier</label>
                        <select id="supplier" name="supplier_name" class="form-control in_h">
                            <option value="">- Select Supplier -</option>
                            <?= $supplierOptions ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="brand">Company</label>
                        <select id="brand" name="brand" class="form-control in_h">
                            <option value="">- Select Company -</option>
                            <!-- Company options should be added similarly -->
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Start Date</label>
                        <input type="date" name="start_date" class="form-control in_h">
                    </div>
                    <div class="form-group">
                        <label>End Date</label>
                        <input type="date" name="end_date" class="form-control in_h">
                    </div>
                    <button type="submit" class="btn btn-dark btn-block">Apply Filters</button>
                    <hr style="border:2px #fff solid ">
                    <a href="report_s2.php"><button type="button" class="btn btn-dark btn-block"><i class="fas fa-sync fa-1x"></i></button></a>
                    
                </form>
            </div>
            <div class="col-md-9" id="table-container-wrapper" >
                <h4 style="background:#0A4657;color:#fff; padding:12px; border-radius:10px; width:120px; text-align:center; ">Report</h4>
                <button class="btn btn-dark" style="font-weight:700; float:right;margin-top:-40px;" onclick="downloadXLSX()">Download Report</button>

                <table class="table table-stripped mt-4 text-center" style="font-size:17px;font-weight:600;" >
                    <thead class="table-header bg-dark text-white" style="font-size:15px;">
                        <?php if (@$reportType == 'Product Wise'): ?>
                            <tr>
                                <th>Sr.</th>
                                   <th>Product</th>
                                
                                <th>Detail</th>
                            </tr>
                        <?php elseif (@$reportType == 'Sale Invoice Wise'): ?>
                            <tr>
                                <th>Sr.</th>
                                <th>Invoice Date</th>
                                <th>Shop Name</th>
                                <th>Booker</th>
                                <th>Invoice#</th>
                                
                                
                                <th>Total Amount</th>
                                <th> Details</th>
                            </tr>
                        <?php elseif (@$reportType == 'Shop Sale Wise'): ?>
                            <tr>
                                <th>Sr.</th>
                                <th>Shop Name</th>
                                <th>Total Amount</th>
                                <th>Detail</th>
                            </tr>
                        <?php elseif (@$reportType == 'Booker Wise'): ?>
                            <tr>
                                <th>Sr.</th>
                                <th>Booker</th>
                                <th>Product</th>
                                <th>Invoice Date</th>
                                <th>Quantity</th>
                                <th>Total Amount</th>
                            </tr>
                        <?php elseif (@$reportType == 'Route Wise'): ?>
                            <tr>
                                <th>Sr.</th>
                                <th>Route</th>
                                <th>Product</th>
                                <th>Invoice Date</th>
                                <th>Quantity</th>
                                <th>Total Amount</th>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <th>Sr.</th>
                                <th>Date</th>
                                <th>Details</th>
                            </tr>
                        <?php endif; ?>
                    </thead>
                    <tbody>
    <?php if (!empty($reportData)): ?>
        <?php $i = 1; foreach ($reportData as $row): ?>
        <?php if ($reportType == 'Product Wise'): ?>
            <!-- Product Wise Report Formatting -->
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($row['product_name']) ?></td>
                <td>
                    <button class="btn btn-dark btn-sm toggle-details" style="" data-target="#details-<?= $i ?>"
                    style="border-radius:20px;">+</button>
                </td>
            </tr>
            <tr id="details-<?= $i ?>" class="details-row bg-dark2 " style="display: none;">
                    <td colspan="6">
                        <ol>
                            <?php
                            $products = explode('<br>', $row['customer_name']);
                            $quantities = explode('<br>', $row['product_quantity']);
                            $prices = explode('<br>', $row['total_amount']);
                            foreach ($products as $index => $product) {
                                echo "<li>" ."Shop Name -". htmlspecialchars(trim($product)) . "   -   Qty: " . htmlspecialchars(trim($quantities[$index])) . "  -    Price: Rs     " . htmlspecialchars(trim($prices[$index])) . "</li><hr />";
                            }
                            ?>
                        </ol>
                    </td>
                </tr>
           
        
            <?php elseif ($reportType == 'Sale Invoice Wise'): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><?= htmlspecialchars($row['date_time']) ?></td>
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                    <td><?= htmlspecialchars($row['customer_type']) ?></td>
                    <td><?= htmlspecialchars($row['order_id']) ?></td>
                    
                    <td>Rs <?= htmlspecialchars($row['total_amount']) ?></td>
                    <td>
                        <button class="btn btn-dark btn-sm toggle-details" data-target="#details-<?= $i ?>"
                        style="border-radius:20px;">+</button>
                    </td>
                </tr>
                <tr id="details-<?= $i ?>" class="details-row bg-dark2 " style="display: none;">
                    <td colspan="6">
                        <ol>
                            <?php
                            $products = explode('<br>', $row['product_name']);
                            $quantities = explode('<br>', $row['product_quantity']);
                            $prices = explode('<br>', $row['product_price']);
                            foreach ($products as $index => $product) {
                                echo "<li>" . htmlspecialchars(trim($product)) . "   -   Qty: " . htmlspecialchars(trim($quantities[$index])) . "  -    Price: Rs     " . htmlspecialchars(trim($prices[$index])) . "</li><hr />";
                            }
                            ?>
                        </ol>
                    </td>
                </tr>
           
          <?php elseif ($reportType == 'Shop Sale Wise'): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                   
                    <td>Rs <?= htmlspecialchars($row['total_amount']) ?></td>
                    <td>
                        <button class="btn btn-dark btn-sm toggle-details" data-target="#details-<?= $i ?>"
                        style="border-radius:20px;">+</button>
                    </td>
                </tr>
                <tr id="details-<?= $i ?>" class="details-row bg-dark2  " style="display: none; font-size:13px;">
                    <td colspan="6">
                        <ol>
                            <?php
                            $products = explode('<br>', $row['products']);
                            $quantities = explode('<br>', $row['quantities']);
                            $prices = explode('<br>', $row['product_price']);
                            foreach ($products as $index => $product) {
                                echo "<li>" . htmlspecialchars(trim($product)) . "   -   Qty:   " . htmlspecialchars(trim($quantities[$index])) . "    -   Price: Rs " . htmlspecialchars(trim($prices[$index])) . "</li><hr />";
                            }
                            ?>
                        </ol>
                    </td>
                </tr>
        <?php elseif ($reportType == 'Booker Wise'): ?>
            <!-- Booker Wise Report Formatting -->
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($row['customer_type']) ?></td>
                <td><?= htmlspecialchars($row['product_name']) ?></td>
                <td><?= htmlspecialchars($row['date_time']) ?></td>
                <td><?= htmlspecialchars($row['product_quantity']) ?></td>
                <td><?= htmlspecialchars($row['net_amount']) ?></td>
            </tr>
        <?php elseif ($reportType == 'Route Wise'): ?>
            <!-- Route Wise Report Formatting -->
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($row['customer_id']) ?></td>
                <td><?= htmlspecialchars($row['product_name']) ?></td>
                <td><?= htmlspecialchars($row['date_time']) ?></td>
                <td><?= htmlspecialchars($row['product_quantity']) ?></td>
                <td><?= htmlspecialchars($row['net_amount']) ?></td>
            </tr>
        <?php else: ?>
            <td colspan="6">No data available</td>
        <?php endif; ?>
    <?php endforeach; ?>
<?php else: ?>
    <tr>
        <td colspan="6">No data available</td>
    </tr>
<?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

</body>
</html>
    </div>
<script>
// Toggle additional details
document.querySelectorAll('.toggle-details').forEach(function(button) {
    button.addEventListener('click', function() {
        var target = document.querySelector(button.getAttribute('data-target'));
        if (target.style.display === 'none') {
            target.style.display = '';
            button.textContent = '-'; // Change to minus sign when expanded
        } else {
            target.style.display = 'none';
            button.textContent = '+'; // Change back to plus sign when collapsed
        }
    });
});

// Download report as XLSX
function downloadXLSX() {
    // Create a new workbook
    var wb = XLSX.utils.book_new();
    wb.Props = {
        Title: "Sales Report",
        Subject: "Sales",
        Author: "Your Company",
        CreatedDate: new Date()
    };

    // Create data array for XLSX
    var table = document.querySelector('table');
    var data = [];

    // Add headers
    var headers = [];
    table.querySelectorAll('thead th').forEach(th => {
        headers.push(th.textContent);
    });
    data.push(headers);

    // Add rows and expand details if they are visible
    table.querySelectorAll('tbody tr').forEach(function(row) {
        var rowData = [];
        row.querySelectorAll('td').forEach(td => {
            rowData.push(td.textContent);
        });
        data.push(rowData);

        // Check if details row is visible and add that too
        var detailsRow = document.querySelector(row.getAttribute('data-target'));
        if (detailsRow && detailsRow.style.display !== 'none') {
            var detailRowData = [];
            detailsRow.querySelectorAll('li').forEach(li => {
                detailRowData.push(li.textContent);
            });
            data.push(detailRowData);
        }
    });

    // Convert the data array to a sheet
    var ws = XLSX.utils.aoa_to_sheet(data);
    XLSX.utils.book_append_sheet(wb, ws, "Report");

    // Save the XLSX file
    XLSX.writeFile(wb, 'Sales_Report.xlsx');
}
</script>


</body>
</html>