<?php
include("db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Get filters from the request
$supplier_name = isset($_GET['supplier_name']) ? trim($_GET['supplier_name']) : '';
$date = isset($_GET['date']) ? trim($_GET['date']) : '';

$filters_applied = !empty($supplier_name) || !empty($date);
$supplier_data = [];

if ($filters_applied) {
    // Opening Amount Query
    $sql_opening = "SELECT supplier_name, DATE(date_time) AS date_time, SUM(open_amount) AS opening_amount 
                    FROM supplier_opening_amount 
                    WHERE 1=1";

    if (!empty($supplier_name)) {
        $sql_opening .= " AND supplier_name = '" . mysqli_real_escape_string($connection, $supplier_name) . "'";
    }
    if (!empty($date)) {
        $sql_opening .= " AND DATE(date_time) = '" . mysqli_real_escape_string($connection, $date) . "'";
    }
    $sql_opening .= " GROUP BY supplier_name";

    $result_opening = mysqli_query($connection, $sql_opening);
    while ($row = mysqli_fetch_assoc($result_opening)) {
        $supplier_data[$row['supplier_name']] = [
            'date_time' => $row['date_time'],
            'opening_amount' => $row['opening_amount'],
            'paid_amount' => 0,
            'closing_balance' => 0
        ];
    }

    // Paid Amount Query (using supplier_amount column)
    $sql_paid = "SELECT supplier_name, SUM(supplier_amount) AS paid_amount FROM supplier_paid WHERE 1=1";
    if (!empty($supplier_name)) {
        $sql_paid .= " AND supplier_name = '" . mysqli_real_escape_string($connection, $supplier_name) . "'";
    }
    if (!empty($date)) {
        $sql_paid .= " AND DATE(date_time) = '" . mysqli_real_escape_string($connection, $date) . "'";
    }
    $sql_paid .= " GROUP BY supplier_name";

    $result_paid = mysqli_query($connection, $sql_paid);
    while ($row = mysqli_fetch_assoc($result_paid)) {
        if (isset($supplier_data[$row['supplier_name']])) {
            $supplier_data[$row['supplier_name']]['paid_amount'] = $row['paid_amount'];
        }
    }

    // Closing Balance Calculation (no discount column)
    foreach ($supplier_data as $name => $data) {
        $supplier_data[$name]['closing_balance'] = 
            $data['opening_amount'] - $data['paid_amount'];
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>AL GHANI TRADERS </title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    <style>
    #wrapper #accordionSidebar {
        background-color: #0A4657 !important;
        background-image: none !important; 
    }
</style>
</head>
<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include("common/sd.php"); ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 shadow">
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>
                    <?php include("common/log.php"); ?>
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container">
                    <h3 style="font-weight:700;color:#000;">Supplier Closing Report</h3>
                    <br>
                    <?php
                    $s = mysqli_query($connection,"SELECT * FROM supplier_paid GROUP BY supplier_name");
                    ?>
                    <form action="report_sup.php" method="GET">
                        <div class="row">
                            <div class="col-sm-4">
                                <label>Select Supplier</label>
                                <select class="form-control" name="supplier_name">
                                    <option value="">Select</option>
                                    <?php while($sp = mysqli_fetch_array($s)){ ?>
                                        <option value="<?php echo $sp["supplier_name"]; ?>">
                                            <?php echo $sp["supplier_name"]; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="col-sm-4">
                                <label>Date</label>
                                <input type="date" class="form-control" name="date">
                            </div>
                            <div class="col-sm-4 mt-4">
                                <button type="submit" class="btn btn-dark">Filter</button>
                                <a href="report_sup.php" class="btn btn-dark"><i class="fas fa-sync"></i></a>
                            </div>
                        </div>
                    </form>

                    <br>
                    <table class="table table-striped table-hover text-center">
                        <thead class="bg-dark text-white">
                            <tr>
                                <th>Date</th>
                                <th>Supplier</th>
                                <th>Closing Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($supplier_data as $name => $data) { ?>
                                <tr>
                                    <td><?php echo $data['date_time']; ?></td>
                                    <td><?php echo $name; ?></td>
                                    <td><strong><?php echo number_format($data['closing_balance'], 2); ?></strong></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <!-- End Page Content -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php"); ?>
            <!-- End of Footer -->

        </div>
        <!-- End Content Wrapper -->

    </div>
    <!-- End Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>

</body>
</html>
