<?php
// Database connection
include("../db/cn.php");

// Check for connection errors
if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

// Handle AJAX request
if (isset($_GET['batch_no']) && isset($_GET['productInput'])) {
    $batch_no = $_GET['batch_no'];
    $query = $_GET['productInput'];

    // Use a prepared statement to prevent SQL injection
    $stmt = $connection->prepare("SELECT batch_no, expiry, rpperpack, product_name FROM products WHERE batch_no = ? AND product_name = ?");
    $stmt->bind_param("ss", $batch_no, $query);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo json_encode($result->fetch_assoc());
    } else {
        echo json_encode(["error" => "Batch not found"]);
    }
    $stmt->close();
    $connection->close();
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Batch Lookup</title>
</head>
<body>

    <label for="query">Product Name:</label>
    <input type="text" id="productInput" placeholder="Enter product name">

    <label for="batch_no">Batch No:</label>
    <input type="text" id="batch_no" placeholder="Enter batch number">

    <label for="expiry">Expiry Date:</label>
    <input type="text" id="expiry" readonly>

    <label for="retail_price">Retail Price:</label>
    <input type="text" id="retail_price" readonly>

    <script>
        document.getElementById("batch_no").addEventListener("input", function() {
            var batchNo = this.value.trim();
            var productQuery = document.getElementById("query").value.trim(); // Get product name

            if (batchNo.length > 0 && productQuery.length > 0) {
                var xhr = new XMLHttpRequest();
                xhr.open("GET", "?batch_no=" + encodeURIComponent(batchNo) + "&query=" + encodeURIComponent(productQuery), true);
                xhr.onreadystatechange = function() {
                    if (xhr.readyState == 4 && xhr.status == 200) {
                        try {
                            var response = JSON.parse(xhr.responseText);
                            if (!response.error) {
                                document.getElementById("expiry").value = response.expiry;
                                document.getElementById("retail_price").value = response.rpperpack;
                            } else {
                                alert("Batch not found!");
                            }
                        } catch (e) {
                            alert("Invalid response from server.");
                        }
                    }
                };
                xhr.send();
            }
        });
    </script>

</body>
</html>
