<?php
ob_start();
include("../db/cn.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$dateTime = $customerName = $customerPhone = $paidBy = "";
$totalAmount = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = 0;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];

        $dateTime = $order['date_time'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $customerType =$order['customer_type'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['exit'])) {
    header("Location: mainpos.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ur" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>علی زین آٹوز</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Nastaliq+Urdu&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Noto Nastaliq Urdu', serif;
            text-align: right;
            direction: rtl;
            margin: 0;
            padding: 0;
        }
        @media print {
            body {
                width: 80mm;
                margin: 0;
                padding: 0;
            }
            .no-print { display: none; }
        }
        .container {
            width: 80mm;
            margin: auto;
            padding: 5px;
            direction: rtl;
        }
        .text-center { text-align: center; }
        .header {
            border-bottom: 1px dashed #000;
            margin-bottom: 5px;
            padding-bottom: 5px;
        }
        .header h2 {
            font-size: 22px;
            margin: 0;
            font-weight: bold;
        }
        .header p {
            margin: 0;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-family: 'Quicksand', sans-serif;
            direction: ltr;
        }
        th, td {
            border: 1px solid #000;
            font-size: 12px;
            text-align: center;
            padding: 3px;
        }
        .totals {
            font-size: 14px;
            margin-top: 5px;
            text-align: left;
            direction: ltr;
        }
        .footer {
            text-align: center;
            margin-top: 8px;
            border-top: 1px dashed #000;
            padding-top: 5px;
        }
        .footer p {
            font-family: 'Noto Nastaliq Urdu', serif;
            font-size: 14px;
            margin: 3px 0;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header text-center">
        <h2>علی زین آٹوز</h2>
        <p>طفیل شہید روڈ، ساہیوال</p>
        <p dir="rtl" style="text-align: center;">
  فون:
  <span dir="ltr">0308-6535222 / 0309-6535222</span>
</p>
    </div>

    <div class="text-center" style="font-family:'Quicksand', sans-serif;direction:ltr;">
        <h3 style="margin:0;font-weight:bold;">Sales Invoice</h3>
        <p style="margin:0;">Date: <?= $dateTime ?> &nbsp;&nbsp; Inv #: <?= htmlspecialchars($orderId) ?></p>
    </div>

    <div style="font-family:'Quicksand', sans-serif;direction:ltr;margin-top:5px;text-align: left;">
        <?php
        $displayCustomer = '';
        
        if (!empty($customerName)) {
            $displayCustomer = $customerName;
        } elseif (!empty($customerType)) {
            $displayCustomer = $customerType;
        }
        ?>
        <p style="margin:0;"><strong>Customer:</strong> <?= htmlspecialchars($displayCustomer) ?></p>
        <p style="margin:0;"><strong>Ph:</strong> <?= htmlspecialchars($customerPhone) ?></p>
    </div>

    <table style="margin-top:5px;">
        <thead>
            <tr>
                <th>Sr#</th>
                <th>Description</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sr = 1;
            $totalQty = 0;
            $totalValue = 0;
            foreach ($orderDetails as $item):
                $qty = (float)$item['product_quantity'];
                $price = (float)$item['product_price'];
                $value = $qty * $price;
                $totalQty += $qty;
                $totalValue += $value;
            ?>
            <tr>
                <td><?= $sr++ ?></td>
                <td><?= htmlspecialchars($item['product_name']) ?></td>
                <td><?= number_format($qty, 2) ?></td>
                <td><?= number_format($price, 2) ?></td>
                <td><?= number_format($value, 2) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div style="direction:ltr;margin-top:5px;font-family:'Quicksand', sans-serif;">
        <p><strong>Total Quantity:</strong> <?= number_format($totalQty, 2) ?></p>
        <p><strong>Total Amount:</strong> Rs <?= number_format($totalValue, 2) ?> /-</p>
        <p><strong>Discount:</strong> Rs <?= number_format($discounted, 2) ?> /-</p>
        <p><strong>Total:</strong> Rs <?= number_format($discountedAmount, 2) ?> /-</p>
    </div>

    <div class="footer">
        <p>ہر قسم کے سامان کی واپسی قابلِ قبول نہیں ہے</p>
        <p style="direction:ltr;font-family:'Quicksand',sans-serif;">Thank you</p>
    </div>

    <div class="text-center no-print" style="margin-top:10px;direction:ltr;">
        <button onclick="window.print()">Print</button>
        <form method="post" style="display:inline;">
            <button type="submit" name="exit">Exit</button>
        </form>
    </div>
</div>
</body>
</html>
