<?php
include("../db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$order_id = mysqli_real_escape_string($connection, $_GET['order_id']);

$query = "
    SELECT o.order_id, o.product_id, o.quantity, o.retail_price, p.product_name
    FROM log_user_sales o
    LEFT JOIN products p ON o.product_id = p.product_id
    WHERE o.order_id = '$order_id'
";
$result = mysqli_query($connection, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Refund Items - Order #<?php echo $order_id; ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="card shadow-lg p-4">
        <h3 class="mb-4 text-center text-dark">Refund Items for Order #<?php echo $order_id; ?></h3>

        <form method="post" action="process_partial_refund.php">
            <input type="hidden" name="order_id" value="<?php echo $order_id; ?>">

            <table class="table table-bordered text-center align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Select</th>
                        <th>Product</th>
                        <th>Qty</th>
                        <th>Price (Rs)</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = mysqli_fetch_assoc($result)) { ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="refund_items[]" value="<?php echo $row['product_id']; ?>">
                        </td>
                        <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                        <td><?php echo $row['quantity']; ?></td>
                        <td><?php echo number_format($row['retail_price'], 2); ?></td>
                        <td><?php echo number_format($row['quantity'] * $row['retail_price'], 2); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>

            <div class="text-center mt-4">
                <button type="submit" class="btn btn-danger px-4">
                    Process Selected Refunds
                </button>
                <a href="javascript:history.back()" class="btn btn-secondary px-4">Cancel</a>
            </div>
        </form>
    </div>
</div>
</body>
</html>
