<?php
include("../db/cn.php"); // your connection file

$update_success = false; // Flag for JS redirect

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_all'])) {
    foreach ($_POST['product_name'] as $index => $product_name) {
        $add_qty = (int)$_POST['add_qty'][$index];

        if ($add_qty > 0) {
            // Get current quantity
            $query = "SELECT quantity FROM products WHERE product_name = '$product_name'";
            $result = mysqli_query($connection, $query);
            if ($row = mysqli_fetch_assoc($result)) {
                $new_qty = $row['quantity'] + $add_qty;
                // Update quantity
                $update_query = "UPDATE products SET quantity = '$new_qty' WHERE product_name = '$product_name'";
                mysqli_query($connection, $update_query);
            }
        }
    }

    // Mark success (for JavaScript redirect)
    $update_success = true;
}

// Fetch products data for table
$query = "SELECT product_name, quantity, product_unit FROM products";
$result = mysqli_query($connection, $query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Product Quantity Update</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-light p-3">

<div class="container">
    <h3 class="mb-3 text-center">🧾 Product Quantity Update</h3>

    <form method="POST">
        <table class="table table-bordered table-striped align-middle text-center">
            <thead class="table-dark">
                <tr>
                    <th>Sr#</th>
                    <th>Product Name</th>
                    <th>Current Quantity</th>
                    <th>Unit</th>
                    <th>Add Quantity</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (mysqli_num_rows($result) > 0) {
                    $sr = 1;
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>{$sr}</td>";
                        echo "<td><input type='hidden' name='product_name[]' value='{$row['product_name']}'>{$row['product_name']}</td>";
                        echo "<td>{$row['quantity']}</td>";
                        echo "<td>{$row['product_unit']}</td>";
                        echo "<td><input type='number' name='add_qty[]' class='form-control' placeholder='Enter qty'></td>";
                        echo "</tr>";
                        $sr++;
                    }
                } else {
                    echo "<tr><td colspan='5'>No products found</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <div class="text-center mt-3">
            <button type="submit" name="update_all" class="btn btn-success px-4">Update</button>
        </div>
    </form>
</div>

<?php if ($update_success): ?>
<script>
    // ✅ Show success alert then redirect
    Swal.fire({
        icon: 'success',
        title: 'Updated Successfully!',
        text: 'Product quantities have been updated.',
        showConfirmButton: false,
        timer: 1500
    }).then(() => {
        window.location.href = "addproduct.php";
    });
</script>
<?php endif; ?>

</body>
</html>
