<?php
ob_start();
include("db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Invalid request.");
}

$id = intval($_GET['id']);

// Fetch existing category
$sql = "SELECT * FROM category WHERE id = $id LIMIT 1";
$result = mysqli_query($connection, $sql);

if (mysqli_num_rows($result) !== 1) {
    die("Category not found.");
}

$category = mysqli_fetch_assoc($result);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newCategory = trim($_POST['category']);
    $status = trim($_POST['active']);

    if (empty($newCategory)) {
        $error = "Category name cannot be empty.";
    } else {
        $escaped = mysqli_real_escape_string($connection, $newCategory);

        // Purana category name nikal lo
        $result = mysqli_query($connection, "SELECT category FROM category WHERE id = $id");
        $oldData = mysqli_fetch_assoc($result);
        $oldCategory = $oldData['category'];

        mysqli_begin_transaction($connection);

        try {
            // Category table update
            $updateCategory = "UPDATE category 
                               SET category = '$escaped', status = '$status' 
                               WHERE id = $id";
            if (!mysqli_query($connection, $updateCategory)) {
                throw new Exception("Category update failed: " . mysqli_error($connection));
            }

            // Products table update
            $updateProducts = "UPDATE products 
                               SET category = '$escaped' 
                               WHERE category = '$oldCategory'";
            if (!mysqli_query($connection, $updateProducts)) {
                throw new Exception("Products update failed: " . mysqli_error($connection));
            }

            // Commit
            mysqli_commit($connection);

            // JS Redirect instead of header()
            echo "<script>window.location.href = 'category.php';</script>";
            exit;

        } catch (Exception $e) {
            mysqli_rollback($connection);
            $error = $e->getMessage();
        }
    }
}


ob_end_flush();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Category</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <h3>Edit Category</h3>
    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>
    <form method="POST">
        <div class="mb-3">
            <label class="form-label">Category Name</label>
            <input type="text" name="category"
            class="form-control" value="<?php echo htmlspecialchars($category['category']); ?>" >
        </div>
        <div class="form-group">
                        <label>Category Active</label><br>
                        <label>
                            <input type="radio" name="active" value="Yes" <?php if ($category["status"] === "Yes") echo "checked"; ?>> Yes
                        </label>
                        <label>
                            <input type="radio" name="active" value="No" <?php if ($category["status"] === "No") echo "checked"; ?>> No
                        </label>
                    </div>
        <button type="submit" class="btn btn-success">Update Category</button>
        <a href="category.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
