<?php
include("db/cn.php");
ob_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

if (!isset($_GET['order_id'])) {
    die("Order ID not provided.");
}

$orderId = $_GET['order_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantities = $_POST['quantities'];
    $prices = $_POST['prices'];
    $note = $_POST['note'];
    $paidBy = $_POST['paid_by'];
    $delivery = $_POST['delivery'];
    $discount = $_POST['discounts'] ?? 0;
    $grandTotalFromForm = $_POST['grandtotal_input'] ?? 0;

    foreach ($quantities as $id => $qty) {
        $qty = (int)$qty;
        $price = (float)$prices[$id];

        $saleRes = mysqli_query($connection, "SELECT * FROM log_user_sale WHERE id = '$id'");
        $sale = mysqli_fetch_assoc($saleRes);
        if (!$sale) continue;
        
        $oldQty = (int)$sale['product_quantity'];
        $productId = $sale['product_id'];
        
        $productRes = mysqli_query($connection, "SELECT * FROM products WHERE id = '$productId'");
        $product = mysqli_fetch_assoc($productRes);
        if (!$product) continue;
        
        $stockQty = (int)$product['quantity'];
        $diff = $qty - $oldQty;
        $newStock = $stockQty - $diff;
        
        if ($newStock < 0) {
            die("Not enough stock for product: " . $product['product_name']);
        }
        
        mysqli_query($connection, "UPDATE products SET quantity = '$newStock' WHERE id = '$productId'");
    }

    foreach ($quantities as $id => $qty) {
        $price = (float)$prices[$id];
        $gross = $price * $qty;

        $updateItem = "UPDATE log_user_sale 
            SET product_quantity = '$qty', 
                product_price = '$price', 
                delivery_amount = '$delivery',
                note = '$note',
                disc_amount = '$discount',
                paid_by = '$paidBy',
                total_amount = '$gross'
            WHERE id = '$id' AND order_id = '$orderId'";

        mysqli_query($connection, $updateItem);
    }

    echo "<script>alert('Order updated successfully!'); window.location.href='order_detail_v1.php';</script>";
    exit();
}

$result = mysqli_query($connection, "SELECT * FROM log_user_sale WHERE order_id = '$orderId'");
$orderRows = [];
while ($row = mysqli_fetch_assoc($result)) {
    $orderRows[] = $row;
}
ob_end_flush();
?>

<!DOCTYPE html>
<html>
<head>
<title>SNAPPY FOODS & MORE</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<style>
body{
    font-family: 'Quicksand', sans-serif;
}
label, .btn, .form-control, td, h3{
    font-weight:700;
}
</style>
<body class="container mt-5">
<h3>Edit Order: <?php echo htmlspecialchars($orderId); ?></h3>
<form method="POST" id="editForm">
<input type="hidden" name="grandtotal_input" id="grandtotal_input">

<table class="table table-bordered table-sm" style="font-size:14px; ">
<thead>
<tr>
<th>Product</th>
<th>Quantity</th>
<th>Price(Rs)</th>
<th style="text-align:right">Total(Rs)</th>
</tr>
</thead>
<tbody>
<?php 
$subtotal = 0;
foreach ($orderRows as $row): 
    $rowTotal = $row['product_quantity'] * $row['product_price'];
    $subtotal += $rowTotal;
?>
<tr>
<td><?php echo $row['product_name']; ?></td>
<td>
<input type="text" name="quantities[<?php echo $row['id']; ?>]" 
       class="form-control qty" value="<?php echo $row['product_quantity']; ?>" min="1">
</td>
<td>
    <input type="text" 
           name="prices[<?php echo $row['id']; ?>]" 
           class="form-control price" 
           value="<?php echo htmlspecialchars($row['product_price'] ?? 0); ?>" 
           step="0.01" min="0">
</td>
<td class="total" style="text-align:right;"><?php echo number_format($rowTotal, 2); ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<div class="row">
    <div class="col-4"></div>
    <div class="col-3"></div>
    <div class="col-5">
        <table class="table table-bordered ">
            <tr>
                <td>
                    <label>Delivery:</label>
                    <input type="text" name="delivery" class="form-control">
                </td>
                <td>
                    <label>Discount:</label>
                    <input type="text" name="discounts" class="form-control" value="<?php echo htmlspecialchars($row['disc_amount'] ?? 0); ?>" >
                </td>
            </tr>
            <tr>
                <td>
                    <label>Note:</label>
                    <textarea name="note" class="form-control"></textarea>
                </td>
                <td>
                    <label>Payment Method</label>
                    <select class="form-control form-control-sm" name="paid_by" style="height:40px; font-weight:700;" required>
                        <option value="cash">Cash</option>
                        <option value="cod">Cash On Delivery</option>
                        <option value="bank">Bank Transfer</option>
                        <option value="easypaisa">Easy Paisa</option>
                        <option value="jazzcash">Jazz Cash</option>
                        <option value="foodpanda">Foodpanda</option>
                        <option value="account">On Account</option>
                    </select>
                </td>
            </tr>
        </table>
        <div class="text-end">
            <p><strong>Subtotal:</strong> Rs <span id="subtotal"><?php echo number_format($subtotal, 2); ?></span></p>
            <p><strong>Grand Total:</strong> Rs <span id="grandtotal">0</span></p>
        </div>
        <button type="submit" class="btn btn-success">Update Order</button>
        <a href="order_detail_v1.php" class="btn btn-secondary">Cancel</a>
    </div>
</div>
</form>

<script>

function calculateTotals() {
    let subtotal = 0;
    document.querySelectorAll('tbody tr').forEach(function(row) {
        const qtyEl   = row.querySelector('.qty');
        const priceEl = row.querySelector('.price');

        const qty   = qtyEl ? parseFloat(qtyEl.value) || 0 : 0;
        const price = priceEl ? parseFloat(priceEl.value) || 0 : 0;

        const total = qty * price;
        const totalCell = row.querySelector('.total');
        if (totalCell) {
            totalCell.textContent = total.toFixed(2);
        }
        subtotal += total;
    });
    const deliveryInput = document.querySelector('input[name="delivery"]');
    const discountInput = document.querySelector('input[name="discounts"]');

    let delivery = deliveryInput ? parseFloat(deliveryInput.value) || 0 : 0;
    let discount = discountInput ? parseFloat(discountInput.value) || 0 : 0;

    let grandtotal = subtotal - discount + delivery;
    document.getElementById('subtotal').textContent   = subtotal.toFixed(2);
    document.getElementById('grandtotal').textContent = grandtotal.toFixed(2);
    document.getElementById('grandtotal_input').value = grandtotal.toFixed(2);
}

document.addEventListener("input", function(e) {
    if (e.target.matches(".qty, .price, input[name='delivery'], input[name='discounts']")) {
        calculateTotals();
    }
});
window.addEventListener("load", calculateTotals);
</script>

</body>
</html>
