<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}



if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT cr_name, cr_id, phone_number FROM credit_note WHERE cr_name LIKE '%$customerName%' LIMIT 5";

    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-customer-name='" . $row['cr_name'] . "' data-customer-id='" . $row['cr_id'] . "' data-customer-phone='" . $row['phone_number'] . "'>" . $row['cr_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}

$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bill'])) {
  include 'db_connection.php'; // your DB file
  $products = json_decode($_POST['productData'], true);
  $orderId = uniqid("ORDER_");
  $netAmount = $_POST['total_input'];
  $billAmount = $_POST['bill_amount'];
  $discountAmount = $_POST['discount_amount'];
  $discountPercent = $_POST['discount_percent'];
  $cashReceived = $_POST['cash_received'];
  $cashReturn = $_POST['cash_return'];
  $method = $_POST['method'];
  $customerName = $_POST['customer_name'];
  $customerPhone = $_POST['customer_phone'];
  $customerId = $_POST['customer_id'];
  $tableG = $_POST['table_g'];
  $dateTime = date("Y-m-d H:i:s");

  // Optional static/fixed values
  $loginUser = 'admin'; // use $_SESSION if needed
  $userRole = 'cashier';
  $outletName = 'Default Outlet';
  $outletAddress = 'Outlet Address';

  foreach ($products as $id => $item) {
    $productId = $id;
    $productName = $item['name'];
    $productQty = $item['qty'];
    $productPrice = $item['price'];
    $productTotal = $productQty * $productPrice;

    $categoryQ = mysqli_query($connection, "SELECT category FROM products WHERE id = '$productId'");
    $catRow = mysqli_fetch_assoc($categoryQ);
    $category = $catRow['category'];

    mysqli_query($connection, "
      INSERT INTO log_user_sale (
        product_id, product_name, product_quantity, product_price, product_total,
        net_amount, discount_amount, discount_per, cash_amount, change_amount,
        paid_by, customer_name, customer_phone, customer_id, table_n,
        order_id, date_time, category, login_user, user_role, outlet_name, outlet_address
      ) VALUES (
        '$productId', '$productName', '$productQty', '$productPrice', '$productTotal',
        '$netAmount', '$discountAmount', '$discountPercent', '$cashReceived', '$cashReturn',
        '$method', '$customerName', '$customerPhone', '$customerId', '$tableG',
        '$orderId', '$dateTime', '$category', '$loginUser', '$userRole', '$outletName', '$outletAddress'
      )
    ");
  }

  echo "<script>alert('Invoice saved. Order ID: $orderId'); window.location='pos_r.php';</script>";
}

    
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>AL-ZARA FAMILY RESTURANT</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
#table-cont {
  max-height: 600px;
  overflow-y: auto;
}
    
    
 #table-container-wrapper {
    max-height: 390px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #951E12);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
tr{
    font-weight:700;
}
.form-control{
    font-weight:700;
}
#table-category1 {
    overflow-x: auto;
    max-width: 510px;
    white-space: nowrap;
    padding: 10px;
    font-weight:700;
}

#table-category1 button {
    display: inline-block;
    margin-right: 10px;
}

.btn-outline-dark{
    background:#951E12;
    color:#fff;
    border:1px solid #951E12;
    font-weight:700;
    font-size:18px;
    max-width:40px;
    height:40px;
    border-radius:70px;
}
.btn-outline-dark:hover{
    background:#fff;
    color:#951E12;
    border:1px solid #951E12;
    font-weight:700;
    font-size:18px;
}

    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/logo231.png" style="margin-top:5px;" width="62" height="58">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;line-height:60px;">
            AL-ZARA FAMILY RESTURANT</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php" class="btn btn-light" style="margin-top:20px; float:right;" >Back</a>
          
        </div>
    </div>
</div>
<div class="container-fluid">
    <form action="pos_r.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-4" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <label style="width:100% ; padding:10px; background:#A10300; color:#fff; text-align:center;"> Product Category</label>
                
                <div id="table-category1">
  <a href="pos_r.php"><button type="button" class="btn btn-outline-dark text-uppercase me-2" 
  data-bs-toggle="tooltip"
  data-bs-placement="top"
  title="Refresh Category List"
  id="refresh-categories" style="font-weight:700;">
    <i class="fas fa-sync fa-1x"></i>
  </button></a>

  <?php
  $re = mysqli_query($connection, "SELECT * FROM category");
  while ($r = mysqli_fetch_array($re)) {
  ?>
    <button type="button" class="btn btn-dark text-uppercase category-btn" style="font-weight:700;" data-category="<?php echo $r['category']; ?>">
      <?php echo $r["category"]; ?>
    </button>
  <?php } ?>
</div>


<div>
  <label style="width:100%; padding:10px; background:#A10300; color:#fff; text-align:center;">Product</label>
  <div>
    <div class="row g-4 mt-4" id="product-list">
      <?php
      $rec = mysqli_query($connection, "SELECT * FROM products");
      while ($pro = mysqli_fetch_array($rec)) {
      ?>
        <div class="col-md-6 product-item" data-category="<?php echo $pro['category']; ?>">
          <div class="card shadow-sm border-0 h-100">
            <div class="card-body text-center">
              <img src="<?php echo $pro['img_upload']; ?>" class="rounded-circle mb-3" width="80" height="80" alt="Product Image">
              <h6 class="card-title text-truncate text-capitalize"><?php echo $pro['product_name']; ?></h6>
              <p class="card-text fw-bold text-success">Rs <?php echo $pro['retail_price']; ?></p>
              <button class="btn btn-outline-dark w-100 add-item-btn" style="background" 
                data-id="<?php echo $pro['id']; ?>" 
                data-name="<?php echo $pro['product_name']; ?>" 
                data-price="<?php echo $pro['retail_price']; ?>">
               +
              </button>
            </div>
          </div>
        </div>
      <?php } ?>
    </div>
  </div>
</div>
            </div>

            <div class="col-sm-8">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="">
                        <div class="form-group">
                         
                            <input type="hidden" class="form-control in_form" name="customer_type">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Name</label>
                            <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                            <div class="dropdown-menu" id="customer_suggestions"></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Phone</label>
                            <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer ID</label>
                            <input type="text" id="customer_id" name="customer_id" class="form-control in_form">
                        </div>
                    </div>
                    <?php
                    $t = mysqli_query($connection,"select * from table_a");
                    ?>
                     <div class="col-sm-3">
                    <div class="form-group">
                        <label>Table</label>
                       <select name="table_g" class="form-control in_form">
                           <option value="">Select Table</option>
                           <?php
                           while($tr = mysqli_fetch_array($t)){
                           ?>
                           <option value="<?php  echo $tr["table_n"]; ?>"><?php  echo $tr["table_n"]; ?></option>
                           <?php
                           }
                           ?>
                       </select>
                    </div>
</div>
                </div>
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12" style="height:600px;">
                        <table class="table table-borderless bg-white table-sm text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#951E12;">
                                <td>R.Qty</td>
                                <td>Item Code</td>
                                <td>Description</td>
                                <td>Qty</td>
                                <td>Unit Price</td>
                                <td>Net Amount</td>
                                <td>Action</td>
                            </tr>
                            
                            <tbody id="cart-body"></tbody>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Total</label>
                                    <input type="number" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount" name="discount_amount" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount %</label>
                                    <input type="number" id="discount_percent" name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Received</label>
                                    <input type="number" id="cash_received" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Return</label>
                                    <input type="number" id="cash_return" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>S.Tax(0%)</label>
                                    <input type="number" id="tax" name="tax" class="form-control in_form input-height"  readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method" class="form-control in_form">
                                        <option value="cash">Cash</option>
                                        <option value="credit">Credit</option>
                                        <option value="bank1">Bank 1</option>
                                    <option value="bank2">Bank 2 </option>
                                    <option value="bank3">Bank 3</option>
                                       
                                        <option value="others">Others</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-5">
                                <hr>
                                <button type="submit" name="bill" class="btn btn-dark btn-sm" style='font-weight:700;'>Generate Invoice</button>
                                <!--<button type="submit" name="hold" class="btn btn-success btn-sm">Hold Bill</button>
                                <button type="submit" name="refund" class="btn btn-danger btn-sm">Refund</button>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
  const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.forEach(function (tooltipTriggerEl) {
    new bootstrap.Tooltip(tooltipTriggerEl);
  });
}); 

document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectCustomer(item) {
        var customerName = item.getAttribute('data-customer-name');
        var customerId = item.getAttribute('data-customer-id');
        var customerPhone = item.getAttribute('data-customer-phone');

        document.getElementById("customer_name").value = customerName;
        document.getElementById("customer_phone").value = customerPhone;
        document.getElementById("customer_id").value = customerId;

        document.getElementById("customer_suggestions").style.display = 'none';
    }


  const cart = {}; // item_id => { name, price, qty }

  document.querySelectorAll('.add-item-btn').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.dataset.id;
      const name = btn.dataset.name;
      const price = parseFloat(btn.dataset.price);

      if (!cart[id]) {
        cart[id] = { name, price, qty: 1 };
      } else {
        cart[id].qty++;
      }

      renderCart();
    });
  });

  function renderCart() {
    const tbody = document.getElementById('cart-body');
    tbody.innerHTML = '';
    let total = 0;

    Object.entries(cart).forEach(([id, item]) => {
      const lineTotal = item.qty * item.price;
      total += lineTotal;

      const tr = document.createElement('tr');
      tr.className = 'text-center';
      tr.innerHTML = `
        <td>${item.qty}</td>
        <td>${id}</td>
        <td>${item.name}</td>
        <td>
          <button class="btn btn-sm btn-secondary" onclick="updateQty('${id}', -1)">-</button>
          ${item.qty}
          <button class="btn btn-sm btn-secondary" onclick="updateQty('${id}', 1)">+</button>
        </td>
        <td>${item.price.toFixed(2)}</td>
        <td>${lineTotal.toFixed(2)}</td>
        <td><button class="btn btn-sm btn-danger" onclick="removeItem('${id}')">X</button></td>
      `;
      tbody.appendChild(tr);
    });

    document.getElementById('total-input').value = total.toFixed(2);
    recalculateDiscount();
    recalculateCashReturn();
  }

  function updateQty(id, delta) {
    if (!cart[id]) return;
    cart[id].qty += delta;
    if (cart[id].qty <= 0) delete cart[id];
    renderCart();
  }

  function removeItem(id) {
    delete cart[id];
    renderCart();
  }

  document.querySelectorAll('.category-btn').forEach(btn => {
    btn.addEventListener('click', () => {
      const cat = btn.dataset.category;
      document.querySelectorAll('.product-item').forEach(prod => {
        prod.style.display = prod.dataset.category === cat ? 'block' : 'none';
      });
    });
  });

  document.getElementById('bill-amount').addEventListener('input', recalculateDiscount);
  document.getElementById('cash_received').addEventListener('input', recalculateCashReturn);

  function recalculateDiscount() {
    const total = parseFloat(document.getElementById('total-input').value) || 0;
    const bill = parseFloat(document.getElementById('bill-amount').value) || 0;
    const discountAmount = total - bill;
    const discountPercent = total > 0 ? (discountAmount / total) * 100 : 0;

    document.getElementById('discount_amount').value = discountAmount.toFixed(2);
    document.getElementById('discount_percent').value = discountPercent.toFixed(2);
  }

  function recalculateCashReturn() {
    const bill = parseFloat(document.getElementById('bill-amount').value) || 0;
    const received = parseFloat(document.getElementById('cash_received').value) || 0;
    const cashReturn = received - bill;
    document.getElementById('cash_return').value = cashReturn.toFixed(2);
  }
  
  document.querySelector('form').addEventListener('submit', function () {
  document.getElementById('productData').value = JSON.stringify(cart);
});
</script>




<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>