<?php
include("../db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'] ?? 0;
    $userRole = $_SESSION['user_role'] ?? 0;
    $outletaddress = $_SESSION['outlet_address'] ?? 0;
    $outletname = $_SESSION['outlet_name'] ?? 0;
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}
if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT cr_name, cr_id, phone_number FROM credit_note WHERE cr_name LIKE '%$customerName%' LIMIT 5";

    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-customer-name='" . $row['cr_name'] . "' data-customer-id='" . $row['cr_id'] . "' data-customer-phone='" . $row['phone_number'] . "'>" . $row['cr_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cart_data'])) {
  $cartData = json_decode($_POST['cart_data'], true);

  $user_name = $userName;
  $user_role = $userRole;
  $outlet_name = $outletaddress;
  $outlet_address = $outletname;
  $date_time = date('d-m-Y');
  $delivery_amount = $_POST["delivery_amount"];
  $disc_amount = $_POST["disc_amount"];
  $t_time = date('H:i:s');
  
  // Assuming all items have the same order_id
  $orderId = 'OR-' . str_pad(mt_rand(0, 99999), 5, '0', STR_PAD_LEFT);
  foreach ($cartData as $item) {
    $note = $item['note'] ?? '';

    $stmt = $connection->prepare("INSERT INTO log_user_sale (
      product_name, product_price, product_quantity, total_amount,
      wat_name, paid_by, delivery_amount, disc_amount, category, note, date_time, t_time,
      order_id, user_name, user_role, outlet_name, outlet_address
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param(
      "sdidsssssssssssss",
      $item['product_name'],
      $item['product_price'],
      $item['product_quantity'],
      $item['total_amount'],
      $item['wat_name'],
      $item['paid_by'],
      $delivery_amount,
      $disc_amount,
      $item['category'],
      $note,
      $date_time,
      $t_time,
      $orderId,
      $user_name,
      $user_role,
      $outlet_name,
      $outlet_address
    );

    $stmt->execute();
}
  echo "<script>window.location.href = 'printpos.php?order_id=" . urlencode($orderId) . "';</script>";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
      <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
       <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
       <link href="https://fonts.googleapis.com/css2?family=Noto+Nastaliq+Urdu&display=swap" rel="stylesheet">

  <title>SNAPPY - Food & More</title>
  <style>
    body {
  margin: 0;
  font-family: 'Quicksand', sans-serif;
  background-color: #f4f4f4;
}

.bg {
  background: linear-gradient(270deg, #060606, #951E12);
}

.top-bar {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 20px;
  background-color: #fff;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.search-bar input {
  padding: 8px 12px;
  width: 250px;
  border: 1px solid #ccc;
  border-radius: 4px;
}

.logout-button {
  background-color: #e74c3c;
  color: white;
  border: none;
  padding: 8px 15px;
  border-radius: 4px;
  cursor: pointer;
}

.container {
  display: flex;
  padding: 20px;
  gap: 20px;
}

.left-section {
  flex: 3;
  padding-right: 20px;
}

.right-section {
  flex: 1;
  background-color: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.1);
  height: 100%;
}

.category-tabs {
  display: flex;
  gap: 10px;
  margin-bottom: 20px;
  flex-wrap: wrap; /* wrap instead of scroll */
  white-space: normal;
  justify-content: flex-start;
}

.category-tabs button {
  flex: 0 0 auto;
  min-width: 100px;
  white-space: nowrap;
  padding: 10px 15px;
  background-color: #ddd;
  border: none;
  border-radius: 6px;
  cursor: pointer;
}

.category-tabs .active {
  background-color: #2c3e50;
  color: white;
}

.product-grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
  gap: 20px;
}

.product-card {
  background-color: white;
  padding: 15px;
  border-radius: 10px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.1);
  text-align: center;
}

.product-card img {
  width: 180px;
  height: 90px;
  object-fit: auto;
  margin-bottom: 10px;
  border-radius: 0%;
  display: block;
  margin-left: auto;
  margin-right: auto;
}

.cart-items h3 {
  margin-top: 0;
  font-size: 18px;
}

.cart-item {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 10px;
  border-bottom: 1px solid #ddd;
  padding-bottom: 5px;
}

.cart-item-name {
  flex: 1;
  font-size: 14px;
}

.cart-item-controls {
  display: flex;
  align-items: center;
  gap: 5px;
}

.cart-item-controls button {
  border: none;
  background-color: #1abc9c;
  color: white;
  padding: 5px;
  border-radius: 50%;
  cursor: pointer;
}

.cart-item-controls .remove {
  background-color: #e74c3c;
}

.total {
  background-color: #18A688;
  color: white;
  font-weight: bold;
  font-size: 18px;
  padding: 10px 15px;
  border-radius: 6px;
  margin-top: 15px;
  display: flex;
  justify-content: flex-end;
}

.comment-box {
  width: 100%;
  margin: 15px 0;
  padding: 10px;
  border: 1px solid #ccc;
  border-radius: 4px;
  resize: vertical;
}

.confirm-btn, .cancel-btn {
  width: 90%;
  padding: 10px;
  border: none;
  border-radius: 4px;
  color: white;
  font-size: 16px;
  margin-bottom: 10px;
  cursor: pointer;
}

.confirm-btn {
  background-color: #1abc9c;
}

.cancel-btn {
  background-color: #e74c3c;
}

@media (max-width: 768px) {
  .container {
    flex-direction: column;
    gap: 15px;
  }

  .left-section {
    padding-right: 0;
  }

  .right-section {
    padding: 15px;
    max-width: 100%;
  }

  .cart-items h3 {
    font-size: 16px;
  }

  .cart-item {
    flex-direction: column;
    align-items: flex-start;
    margin-bottom: 10px;
    padding-bottom: 10px;
  }

  .cart-item-name {
    font-size: 16px;
  }

  .cart-item-controls button {
    padding: 6px;
  }

  .comment-box {
    height: 80px;
  }
}

@media (max-width: 480px) {
  .search-bar input {
    width: 200px;
  }

  .product-card img {
    height: 80px;
  }

  .product-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    height: 700px;
  }

  .cart-item-controls button {
    padding: 4px;
  }
}

.size-options {
  display: flex;
  gap: 5px;
  justify-content: center;
  margin-top: 8px;
}

.size-button {
  padding: 5px 10px;
  background-color: #1AB395;
  color: white;
  border: none;
  border-radius: 6px;
  font-size: 12px;
  cursor: pointer;
}

.size-button:hover {
  background-color: #17a085;
}

.category-wrapper {
  background-color: white;
  padding: 10px;
  border-radius: 10px;
  box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  margin-bottom: 20px;
  width: 100%;
  overflow-x: hidden; /* no scroll */
}

.total-row {
  display: flex;
  justify-content: space-between;
  font-weight: bold;
  margin-bottom: 15px;
}

.finish-scale {
  border-top: 2px solid #ccc;
  padding-top: 15px;
  margin-top: 15px;
}

.comment-box textarea {
  width: 100%;
  padding: 10px;
  margin-top: 5px;
  resize: vertical;
}

.finish-buttons {
  margin-top: 10px;
  display: flex;
  gap: 10px;
}

label {
  font-weight: 700;
}

#product_con {
  max-height: 610px;
  overflow-y: auto;
}

#cart_con {
  max-height: 500px;
  overflow-y: auto;
}

.btn {
  font-weight: 700;
}

#cat_con {
  overflow-x: hidden; /* remove horizontal scroll */
  border: 1px solid #ddd;
}

.category-tabs {
  display: flex;
  flex-wrap: wrap; /* allow wrapping */
  gap: 8px;
  white-space: normal;
  width: 100%;
  justify-content: flex-start;
}

.category-tabs button {
  white-space: nowrap;
}
  </style>
</head>
<body>

  <!-- Top Bar -->
  <!--<div class="top-bar bg">-->
  <!--  <div class="search-bar">-->
  <!--      <img src="../img/logo231.png" style="margin-top:5px;" width="62" height="58">-->
  <!--  </div>-->
  <!-- <a href="addproduct.php"> <button class="logout-button" style="font-weight:700;"><i class="fas fa-arrow-left fa-1x"></i></button></a>-->
  <!--</div>-->
  <!-- Main Content -->
  <form id="sale-form" method="POST">
  
<div class="container-fluid" style="margin-top:7px;">
  <div class="row">
    <!-- Left Section -->
    <div class="col-8" >
        
      <!-- Category Tabs -->
      <div class="category-wrapper" id="cat_con" style="border:3px solid #A8162B;">
          <div class="row">
              <div class="col-1">
              <a href="addproduct.php" class="btn btn-dark" data-bs-toggle="tooltip" 
              data-bs-placement="top" title="Go Back ">
    <i class="fas fa-arrow-left fa-1x"></i>
</a>

              </div>
          <div class="form-group col-11">
         
            <input type="text" name="product_search" id="product_search" style="color:#A8162B;
            
            border:2px solid #A8162B;" class="form-control font-weight-bold"  placeholder="Serach Product By Name:-">
        </div>
          </div>
  <div class="category-tabs">
    <button style="font-weight:700;padding:5px;font-size:13px;" type="button" class="active" data-category="all">All</button>
    <?php
    $re = mysqli_query($connection, "SELECT * FROM category WHERE status = 'Yes' ORDER BY category ASC");
    while ($r = mysqli_fetch_array($re)) {
    ?>
      <button 
        type="button" 
        class="btn btn-dark btn-sm text-uppercase category-btn" 
        style="font-weight:700;background:#A10300; color:#fff; padding:5px;font-size:13px;" 
        data-category="<?php echo $r['category']; ?>">
       <?php echo $r["category"]; ?>
      </button>
    <?php } ?>
  </div>
</div>

      <div class="row" col="3" id="product_con" style="padding:10px; border:3px solid #951E12;margin-top:-12px; border-radius:7px;">
          <?php
            // Fetch only active products
            $rec = mysqli_query($connection, "SELECT * FROM products WHERE active='Yes' ");
            while ($pro = mysqli_fetch_array($rec)) {
          ?>
           <div 
              class="col-3 product-card ms-auto text-end" 
              dir="rtl"
              data-category="<?php echo $pro['category']; ?>" 
              style="border:1px solid #951E12;">
              
              <!-- Image clickable for add-to-cart -->
              <img src="<?php echo $pro['img_upload']; ?>" 
                   alt="Product"
                   class="add-item-btn"
                   style="cursor:pointer; width:100%;"
                   data-id="<?php echo $pro['id']; ?>" 
                   data-name="<?php echo $pro['product_name']; ?>" 
                   data-price="<?php echo $pro['retail_price']; ?>" />
        
              <h6 class="card-title text-truncate text-capitalize" style="font-weight:700; font-size:10px;">
                <?php echo $pro['product_name']; ?>
              </h6>
        
              <p class="card-text fw-bold text-dark" style="font-weight:700; text-transform:capitalize;">
                روپے <?php echo $pro['retail_price']; ?> - <?php echo $pro['product_unit']; ?>
              </p>
        
              <!-- Optional: Keep button if you still want -->
              <!--<button type="button"-->
              <!--  class="btn btn-outline-dark add-item-btn" -->
              <!--  style="background:#A10300; color:#fff; width:42px; height:42px; border-radius:50px;"-->
              <!--  data-id="<?php echo $pro['id']; ?>" -->
              <!--  data-name="<?php echo $pro['product_name']; ?>" -->
              <!--  data-price="<?php echo $pro['retail_price']; ?>">-->
              <!--  <i class="fas fa-cart-plus fa-1x"></i>-->
              <!--</button>-->
            </div>
          <?php } ?>
        </div>


    </div>

    <!-- Right Section -->
    <div class="col-4 bg-white" style="padding:20px;">
     <div class="row">
    <div class="">
        
         </div>
    <div class="col-6">
        <div class="form-group">
        <a href="order_detail_v.php" class=" form-control btn btn-dark btn-sm" target="blank"
        style="font-size:12px;" >View Delivery Orders</a>
        </div>
    </div>
    <div class="col-6">
        <div class="form-group">
        <a href="order_detail_v1.php" class=" form-control btn btn-danger btn-sm " style="font-size:12px;">View Online Orders</a>
        </div>
    </div>
</div> 
<div class="cart-items" >
        <h3 style="width:100%; background:#A10300;color:#fff; font-weight:700;padding:10px;border-radius:7px;">Cart Items</h3>
        <div id="cart_con">
        <div id="cart-list" style="height:300px;"></div>
        </div>
        <div class="row total" style="background:#353535;">
            <div class="col-6"><div class="" >Total: Rs </div></div>
            <div class="col-6 text-right"><span id="cart-total">0</span></div>
</div>
<div class="row" style="margin-top:7px;">
<div class="form-group col-6">
    <label>Delivery-PKR</label>
    <input type="text" name="delivery_amount" id="delivery_amount" class="form-control form-control-sm" required>
  </div>    
<div class="form-group col-6">
    <label>Discount-PKR</label>
    <input type='text' name="disc_amount" id="disc_amount" class="form-control form-control-sm"  >
</div>
<div class="form-group col-12">
    <label>Total-PKR</label>
    <input type='text' name="t_amount" id="t_amount" style="background:#353535; color:#fff; font-weight:700;padding:5px;" class="form-control">
</div>
</div>
<?php
$w = mysqli_query($connection,"select * from wat");
?>

        <div class="row">
          <div class="">
              <div class="">
                  <input type="hidden" class="form-control"  id="waiter-select" value="Online Order">
              </div>
          </div>
          <div class="col-6">
     <div class="form-group">
         <label>Note</label>
         <textarea class="form-control form-control-sm" name="note" id="note-field" required ></textarea>
     </div>
  </div>
          <div class="col-6">
             <div class="form-group">
                  <label>Payment Method</label>
                  <select class="form-control form-control-sm" id="payment-select" style="height:40px; font-weight:700;" required>
                      <option value="cash">Cash</option>
                      <option value="cash">Cash On Delivery</option>
                      <option value="cash">Bank Transfer</option>
                      <option value="cash">Easy Paisa</option>
                      <option value="cash">Jazz Cash</option>
                      <option value="cash">Foodpanda</option>
                      <option value="cash">On Account</option>
                  </select>
              </div>
          </div>
 </div>

<div class="row">
  <div class="col-6">
    <button type="button" id="parcel-btn" class="btn btn-dark btn-sm" style="width:100%; 
    font-weight:700;font-size:14px;">
        Delivery Order</button>
  </div>
  <div class="col-6">
    <button type="button" id="waiter-btn" 
    class="btn btn-danger btn-sm" style="width:100%; font-weight:700;font-size:12px; ">Online Order</button>
  </div>
   <div class="">
    <button type="button" id="delivery-btn" class="btn btn-warningbtn-sm " style="width:100%;
    font-weight:700;font-size:15px; display:none;">Delivery</button>
  </div>
</div>  
<br>

      </div>
    </div>
  </div>
</div>
<input type="hidden" name="waiter" id="waiter-field" />
<input type="hidden" name="paid_by" id="paid-by-field" />
<input type="hidden" name="user_name" value="Admin" />
<input type="hidden" name="user_role" value="Cashier" />
<input type="hidden" name="outlet_name" value="Main Outlet" />
<input type="hidden" name="outlet_address" value="Main Street" />
<input type="hidden" name="cart_data" id="cart-data" />
</form>
  <!--<footer style="background-color: #353535; color: #fff; text-transform:capitalize; text-align: center; padding: 10px 0; position: fixed; bottom: 0; width: 100%; font-size: 16px; font-weight:700;">-->
  <!--  <p>Copyright &copy; powered by <span style='color:#CD9505;'>ATR Sales & Marketing</span> 2025</p>-->
  <!--</footer>-->
 <script>
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>

  <script>
document.getElementById('product_search').addEventListener('input', function () {
  const searchTerm = this.value.trim().toLowerCase();
  const productCards = document.querySelectorAll('.product-card');

  productCards.forEach(card => {
    const title = card.querySelector('.card-title')?.innerText.toLowerCase();
    card.style.display = title.includes(searchTerm) ? 'block' : 'none';
  });
});
</script>
  <script>
  const categoryButtons = document.querySelectorAll(".category-btn, .category-tabs .active");
  const products = document.querySelectorAll(".product-card");

  categoryButtons.forEach(button => {
    button.addEventListener("click", () => {
      // Remove active class from all
      categoryButtons.forEach(btn => btn.classList.remove("active"));
      button.classList.add("active");

      const selectedCategory = button.dataset.category;

      products.forEach(product => {
        const productCategory = product.dataset.category;
        const showAll = selectedCategory === "all";

        product.style.display = showAll || productCategory === selectedCategory
          ? "block"
          : "none";
      });
    });
  });
</script>

  <script>
const cart = {};
function updateTotal() {
  let cartTotal = 0;
  Object.values(cart).forEach(item => {
    cartTotal += item.price * item.qty;
  });

  const discount = parseFloat(document.getElementById("disc_amount").value) || 0;
  const delivery = parseFloat(document.getElementById("delivery_amount").value) || 0;

  const finalAmount = Math.max(cartTotal - discount + delivery, 0).toFixed(2);
  document.getElementById("t_amount").value = finalAmount;
  document.getElementById("cart-total").textContent = cartTotal.toFixed(2);
}

function updateCartItem(id, field, value) {
  if (!cart[id]) return;
  value = parseFloat(value) || 0;

  if (field === "qty") {
    cart[id].qty = value > 0 ? value : 1;
  } else if (field === "total") {
    if (cart[id].qty > 0) {
      cart[id].price = value / cart[id].qty; // adjust unit price
    }
  }

  renderCart();
}

function renderCart() {
  const cartList = document.getElementById("cart-list");
  cartList.innerHTML = "";
  for (const id in cart) {
    const item = cart[id];
    const div = document.createElement("div");
    div.className = "cart-item d-flex justify-content-between align-items-center mb-2";
    div.innerHTML = `
      <div class="cart-item-name text-capitalize" style="font-weight:700;font-size:15px;">
        ${item.name}
      </div>
      <div class="cart-item-controls d-flex align-items-center gap-1">
        
        <!-- Quantity input -->
        <input 
          type="number" 
          value="${item.qty}" 
          min="1" 
          class="form-control form-control-sm text-center" 
          style="width: 90px; height:50px; font-weight:700;" 
          onchange="updateCartItem('${id}', 'qty', this.value)" 
        />

        <!-- Editable total input -->
        <input 
          type="number" 
          value="${(item.qty * item.price).toFixed(2)}" 
          class="form-control form-control-sm text-center text-success fw-bold" 
          style="width: 130px; height:50px; font-weight:700;" 
          onchange="updateCartItem('${id}', 'total', this.value)" 
        />

        <!-- Remove button -->
        <button class="btn-sm btn-danger" 
          style="background:red; color:#fff; padding:0px; width:30px;height:30px" 
          onclick="removeFromCart('${id}')">x</button>
      </div>
    `;
    cartList.appendChild(div);
  }
  updateTotal();
}

// function updateTotal() {
//   let cartTotal = 0;
//   Object.values(cart).forEach(item => {
//     cartTotal += item.price * item.qty;
//   });

//   const discount = parseFloat(document.getElementById("disc_amount").value) || 0;
//   const delivery = parseFloat(document.getElementById("delivery_amount").value) || 0;

//   const finalAmount = Math.max(cartTotal - discount + delivery, 0).toFixed(2);
//   document.getElementById("t_amount").value = finalAmount;
//   document.getElementById("cart-total").textContent = cartTotal.toFixed(2);
// }

// function renderCart() {
//   const cartList = document.getElementById("cart-list");
//   cartList.innerHTML = "";
//   for (const id in cart) {
//     const item = cart[id];
//     const div = document.createElement("div");
//     div.className = "cart-item d-flex justify-content-between align-items-center mb-2";
//     div.innerHTML = `
//       <div class="cart-item-name text-capitalize" style="font-weight:700;font-size:15px;">${item.name}</div>
//       <div class="cart-item-controls d-flex align-items-center gap-1">
//         <input 
//           type="number" 
//           value="${item.qty}" 
//           min="1" 
//           class="form-control form-control-sm text-center" 
//           style="width: 130px;height:50px;font-weight:700;" 
//           onchange="setQty('${id}', this.value)" 
//         />&nbsp;&nbsp;
//         <div class="text-success fw-bold" style="font-weight:700;font-size:15px;">Rs ${(item.qty * item.price).toFixed(2)}&nbsp;&nbsp;&nbsp;</div>
//         <button class="btn-sm btn-danger" style="background:red; color:#fff; padding:0px; width:30px;height:30px" onclick="removeFromCart('${id}')">x</button>
//       </div>
//     `;
//     cartList.appendChild(div);
//   }
//   updateTotal();
// }

function setQty(id, value) {
  const qty = parseInt(value);
  if (qty >= 1) {
    cart[id].qty = qty;
    renderCart();
  }
}

function removeFromCart(id) {
  delete cart[id];
  renderCart();
}

document.querySelectorAll(".add-item-btn").forEach(btn => {
  btn.addEventListener("click", () => {
    const id = btn.dataset.id;
    const name = btn.dataset.name;
    const price = parseFloat(btn.dataset.price);
    if (!cart[id]) {
      cart[id] = { name, price, qty: 1 };
    } else {
      cart[id].qty++;
    }
    renderCart();
  });
});

document.getElementById("disc_amount").addEventListener("input", updateTotal);
document.getElementById("delivery_amount").addEventListener("input", updateTotal);
</script>

<script>
document.getElementById("disc_amount").addEventListener("input", function () {
  const discount = parseFloat(this.value) || 0;
  const cartTotal = parseFloat(document.getElementById("cart-total").innerText) || 0;

  const finalAmount = Math.max(cartTotal - discount, 0).toFixed(2);
  document.getElementById("t_amount").value = finalAmount;
});
</script>
<script>
let saleMode = "parcel"; // default

document.getElementById("parcel-btn").addEventListener("click", () => {
  saleMode = "parcel";
  document.getElementById("sale-form").requestSubmit();
});

document.getElementById("waiter-btn").addEventListener("click", () => {
  saleMode = "waiter";
  document.getElementById("sale-form").requestSubmit();
});

document.getElementById("delivery-btn").addEventListener("click", () => {
  saleMode = "delivery";
  document.getElementById("sale-form").requestSubmit();
});

document.getElementById("sale-form").addEventListener("submit", function (e) {
  e.preventDefault();

  const waiter = document.getElementById("waiter-select").value;
  const paidBy = document.getElementById("payment-select").value;
  const note = document.getElementById("note-field").value || "";

  if (saleMode === "waiter") {
  const deliveryCharge = parseFloat(document.getElementById("delivery_amount").value);
  if (isNaN(deliveryCharge) || deliveryCharge <= 0) {
    alert("Delivery charges are required for Online Orders.");
    return;
  }
}

  const orderId = 'ORDER' + Date.now();
  const cartItems = Object.entries(cart).map(([id, item]) => {
    const card = document.querySelector(`[data-id="${id}"]`)?.closest(".product-card");
    const category = card?.dataset.category || '';

    return {
      product_name: item.name,
      product_price: item.price,
      product_quantity: item.qty,
      total_amount: (item.qty * item.price).toFixed(2),
      category: category,
      wat_name: saleMode === "waiter" ? waiter : (saleMode === "delivery" ? "Delivery" : "Take Away"),
      paid_by: paidBy,
      order_id: orderId,
      note: note
    };
  });

  document.getElementById("waiter-field").value =
    saleMode === "waiter" ? waiter : (saleMode === "delivery" ? "Online Order" : "Online Order");

  document.getElementById("paid-by-field").value = paidBy;
  document.getElementById("cart-data").value = JSON.stringify(cartItems);

  this.submit();
});
</script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>
