<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include("../db/cn.php");
ob_start();

// Check session
if (isset($_SESSION['user_name'], $_SESSION['user_role'], $_SESSION['outlet_name'], $_SESSION['outlet_address'])) {
    $userName       = $_SESSION['user_name'];
    $userRole       = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name    = $_SESSION['outlet_name'];
} else {
    echo "Session variables not set. Please log in.";
    exit;
}

$alertScript = ""; // JS script ko variable me store karenge



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Common fields
    $product_id     = mysqli_real_escape_string($connection, $_POST['product_id']);
    $product_name   = mysqli_real_escape_string($connection, $_POST['product_name']);
    $company        = mysqli_real_escape_string($connection, $_POST['company']);
    $quantity       = (int)$_POST['quantity'];
    $color          = mysqli_real_escape_string($connection, $_POST['color']);
    $retail_price   = (float)$_POST['retail_price'];
    $percentage     = (float)$_POST['percentage'];
    $trade_price    = (float)$_POST['trade_price'];
    $total_amount   = (float)$_POST['total_amount'];
    $supplier       = mysqli_real_escape_string($connection, $_POST['supplier']);
    $product_unit   = mysqli_real_escape_string($connection, $_POST['product_unit']);
    $category       = mysqli_real_escape_string($connection, $_POST['category']);
    $total_purchase = $trade_price * $quantity;
    $date_time      = date("Y-m-d");

    // Check duplicate product_id first
    $check_query  = "SELECT * FROM products WHERE product_id = '$product_id'";
    $check_result = mysqli_query($connection, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        $alertScript = "
            Swal.fire({
                icon: 'warning',
                title: 'Duplicate Entry',
                text: 'Product ID: $product_id and Product Name: $product_name already exist!'
            });
        ";
    } else {
        // Loop through each size
        foreach ($_POST['size'] as $index => $size_value) {
            $size    = mysqli_real_escape_string($connection, $size_value);
            $size_id = mysqli_real_escape_string($connection, $_POST['size_id'][$index]);
            $qty = mysqli_real_escape_string($connection, $_POST['qty'][$index]);

            // Insert into products
            $insert_product_query = "
                INSERT INTO products 
                (product_id, product_name, size, size_id, category, company, quantity, qty, color, retail_price, percentage, trade_price, total_amount, total_purchase, product_unit, supplier, date_time, login_user, user_role, outlet_name, outlet_address) 
                VALUES 
                ('$product_id', '$product_name', '$size', '$size_id', '$category', '$company', '$quantity', '$qty', '$color', '$retail_price', '$percentage', '$trade_price', '$total_amount', '$total_purchase', '$product_unit', '$supplier', '$date_time', '$userName', '$userRole', '$outlet_name', '$outlet_address')
            ";

            if (!mysqli_query($connection, $insert_product_query)) {
                $alertScript = "
                    Swal.fire({
                        icon: 'error',
                        title: 'Error inserting product',
                        text: '" . addslashes(mysqli_error($connection)) . "'
                    });
                ";
                break; // stop loop if error occurs
            }

            // Insert into opening_products
            $insert_opening_product_query = "
                INSERT INTO opening_products 
                (product_id, product_name, size, size_id, category, company, quantity, color, retail_price, percentage, trade_price, total_amount, product_unit, supplier, date_time, login_user, user_role, outlet_name, outlet_address) 
                VALUES 
                ('$product_id', '$product_name', '$size', '$size_id', '$category', '$company', '$quantity', '$color', '$retail_price', '$percentage', '$trade_price', '$total_amount', '$product_unit', '$supplier', '$date_time', '$userName', '$userRole', '$outlet_name', '$outlet_address')
            ";

            if (!mysqli_query($connection, $insert_opening_product_query)) {
                $alertScript = "
                    Swal.fire({
                        icon: 'error',
                        title: 'Error inserting opening product',
                        text: '" . addslashes(mysqli_error($connection)) . "'
                    });
                ";
                break;
            }
        }

        // Agar sab insert successful
        if (!isset($alertScript)) {
            $alertScript = "
                Swal.fire({
                    icon: 'success',
                    title: 'Product saved successfully!',
                    showConfirmButton: false,
                    timer: 2000
                }).then(() => {
                    window.location.href = 'addproduct.php';
                });
            ";
        }
    }
}

$pr_id2 = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
$barcodeUrl = "https://barcode.tec-it.com/barcode.ashx?data={$pr_id2}&code=Code128&dpi=96";
$barcodeFilename = "barcode_$pr_id2.png";


$company_q  = mysqli_query($connection, "SELECT * FROM company");
$category_q = mysqli_query($connection, "SELECT * FROM category");


ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Opening Product / Stock</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.form-control, option{
	  	font-weight:700;
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
 <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <h3 style="color:#212529; font-weight:700;"> Add Opening Stock</h3>
                
            </div>

        </div>

    </div><br />
    <br />
  <div class="container">
        <div class="row">
                <div class="col-sm-1"></div>
                <div class="col-sm-5">
                    <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
                        <div class="form-group">
                            <label>Product ID</label>
                            <?php $ran = rand(1000, 9999);?>
                            <input type="text" name="product_id" class="form-control" value="<?php echo $ran ;?>" readonly> 
                        </div>
                        <div class="form-group">
                            <label>Product Name</label>
                            <input type="text" name="product_name" class="form-control" required />
                        </div>
                        <div class="form-group">
                            <label>Category</label>
                            <input type="text" name="category" class="form-control" />
                        </div>
                        <div class="form-group">
                            <label>Company</label>
                            <input type="text" name="company" class="form-control" />
                        </div>
                        <div class="form-group">
                            <label>Quantity</label>
                            <input type="number" name="quantity" id="quantity" class="form-control" readonly />
                        </div>
                      <div class="form-group">
        <label>Color</label>
        <select name="color" class="form-control" required>
            <option value="">Select Color</option>
            <?php while($cat = mysqli_fetch_assoc($category_q)) { ?>
                <option value="<?php echo $cat['category']; ?>"><?php echo $cat['category']; ?></option>
            <?php } ?>
        </select>
    </div>
                 <div id = "sizeContainer" class="form-group">
                     
     <div class="form-group row align-items-center">
      <div class="form-group col-sm-3">
        <label>Size</label>
        <input type="number" name="size[]" class="form-control" />
      </div>
      <div class="form-group col-sm-3">
        <label>Qty</label>
        <input type="number" name="qty[]" class="form-control" />
      </div>
      <div class="form-group col-sm-3">
        <label>Barcode</label>
        <input type="number" name="size_id[]" class="form-control" readonly />
      </div>
      <div class="form-group col-sm-3 m-0 mt-2">
        <button type="button" class="btn btn-success btn-sm addRow">+</button>
        <button type="button" class="btn btn-danger btn-sm removeRow">-</button>
      </div>
                       
                </div>
                 </div>
                 </div>
            
                <div class="col-sm-5">
                     <div class="form-group">
                            <label>Sale Price</label>
                            <input type="number" name="retail_price" id="retail_price" class="form-control" />
                        </div>
                    <div class="form-group">
                        <label>% Apply</label>
                        <input type="text" name="percentage" id="percentage" class="form-control" readonly />
                    </div>
                    <div class="form-group">
                        <label>Purchase Price</label>
                        <input type="number" name="trade_price" id="trade_price" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Total Amount</label>
                        <input type="number" name="total_amount" id="total_amount" class="form-control" readonly />
                    </div>
                    <div class="form-group">
                        <label>Supplier</label>
                        <input type="text" name="supplier" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Product Unit</label>
                        <select name="product_unit" class="form-control">
                            <option value="">Select Unit</option>
                            <option value="Pcs">Pcs</option>
                        </select>
                    </div>
                    <hr />
                    <button class="btn btn-dark form-control" type="submit">Save Product</button>
                </div>
            </div>
           
    </div>
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">Ã—</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
    
  <script>
// 🔹 Random ID Generator
function generateRandomId() {
  return Math.floor(1000000 + Math.random() * 9000000);
}

document.addEventListener("DOMContentLoaded", function() {
  const firstId = document.querySelector("input[name='size_id[]']");
  if (firstId) firstId.value = generateRandomId();

  const sizeContainer = document.getElementById("sizeContainer");
  const quantityInput = document.getElementById("quantity");

  // 🔹 Function: Create a new row
  function createRow() {
    const newRow = document.createElement("div");
    newRow.className = "form-group row align-items-center";
    newRow.innerHTML = `
      <div class="form-group col-sm-3">
        <label>Size</label>
        <input type="number" name="size[]" class="form-control" />
      </div>
      <div class="form-group col-sm-3">
        <label>Qty</label>
        <input type="number" name="qty[]" class="form-control" />
      </div>
      <div class="form-group col-sm-3">
        <label>Size Id</label>
        <input type="number" name="size_id[]" class="form-control" value="${generateRandomId()}" readonly />
      </div>
      <div class="form-group col-sm-3 m-0 mt-2">
        <button type="button" class="btn btn-success btn-sm addRow">+</button>
        <button type="button" class="btn btn-danger btn-sm removeRow">-</button>
      </div>
    `;

    // Add listeners for buttons
    newRow.querySelector(".addRow").addEventListener("click", function() {
      sizeContainer.appendChild(createRow());
      attachQtyListener();
    });

    newRow.querySelector(".removeRow").addEventListener("click", function() {
      if (sizeContainer.children.length > 1) newRow.remove();
      updateTotalQuantity();
    });

    return newRow;
  }

  // 🔹 Attach main buttons for first row
  document.querySelector(".addRow").addEventListener("click", function() {
    sizeContainer.appendChild(createRow());
    attachQtyListener();
  });

  document.querySelector(".removeRow").addEventListener("click", function() {
    if (sizeContainer.children.length > 1)
      this.closest(".form-group.row").remove();
    updateTotalQuantity();
  });

  // 🔹 Function: Calculate total qty
  function updateTotalQuantity() {
    let total = 0;
    document.querySelectorAll('input[name="qty[]"]').forEach(input => {
      total += parseFloat(input.value) || 0;
    });
    quantityInput.value = total;
  }

  // 🔹 Function: Attach input event listener to all qty fields
  function attachQtyListener() {
    document.querySelectorAll('input[name="qty[]"]').forEach(input => {
      input.removeEventListener("input", updateTotalQuantity);
      input.addEventListener("input", updateTotalQuantity);
    });
  }

  // Initial call
  attachQtyListener();
});


// 🔹 Calculate Total Amount & % Difference
function calculateTotalAmount() {
  let quantity = parseFloat(document.querySelector('input[name="quantity"]').value) || 0;
  let trade_price = parseFloat(document.getElementById("trade_price").value) || 0;

  if (quantity > 0 && trade_price > 0) {
    let total_amount = (quantity * trade_price).toFixed(2);
    document.getElementById("total_amount").value = total_amount;
  } else {
    document.getElementById("total_amount").value = '';
  }
}

function calculateTradePercentage() {
  let retail_price = parseFloat(document.getElementById("retail_price").value) || 0;
  let trade_price = parseFloat(document.getElementById("trade_price").value) || 0;

  if (retail_price > 0 && trade_price > 0) {
    let percentage = ((retail_price - trade_price) * 100 / retail_price).toFixed(2);
    document.getElementById("percentage").value = percentage;
  } else {
    document.getElementById("percentage").value = '';
  }
}

document.addEventListener('DOMContentLoaded', () => {
  document.querySelector('input[name="quantity"]').addEventListener('input', calculateTotalAmount);
  document.getElementById("retail_price").addEventListener('input', calculateTradePercentage);
  document.getElementById("trade_price").addEventListener('input', () => {
    calculateTradePercentage();
    calculateTotalAmount();
  });
});
</script>

   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>