<?php
include("../db/cn.php");
include("common/tx.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start();
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
} else {
    // Redirect to login page or handle the error
       echo "<script>window.location.href = 'logout.php';</script>";
       exit;
}

function generateOrderId(mysqli $connection): string {
    $connection->query("INSERT INTO order_sequence () VALUES ()");
    return str_pad($connection->insert_id, 5, "0", STR_PAD_LEFT);
}


if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

if (isset($_GET['query'])) {
    $query = $connection->real_escape_string($_GET['query']);
    $sql = "SELECT product_id, product_name, size_id, retail_price, trade_price, size, color, supplier, company, product_unit, quantity FROM products WHERE size_id LIKE '%$query%'";

    $result = $connection->query($sql);

    $suggestions = "";
    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-product-id='" . $row['size_id'] . "' data-product-quantity='" . $row['quantity'] . "' data-retail-price='" . $row['retail_price'] . "' data-trade-price='" . $row['trade_price'] . "' data-supplier='" . $row['supplier'] . "' data-company='" . $row['company'] . "' data-product-unit='" . $row['product_unit'] . "' data-product-size='" . $row['size'] . "' data-product-color='" . $row['color'] . "'>" . $row['product_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}

if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT cr_name, cr_id, phone_number FROM credit_note WHERE cr_name LIKE '%$customerName%' LIMIT 5";
    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $crName = $row['cr_name'];
        $crId = $row['cr_id'];
        $phone = $row['phone_number'];

        // Fetch remain_balance from creditor_closing
        $remainSql = "SELECT remain_balance FROM creditor_closing WHERE creditor_name = '$crName' ORDER BY id DESC LIMIT 1";
        $remainResult = $connection->query($remainSql);
        $remainBalance = "0";
        if ($remainResult && $remainResult->num_rows > 0) {
            $remainRow = $remainResult->fetch_assoc();
            $remainBalance = $remainRow['remain_balance'];
        }

        $suggestions .= "<div class='dropdown-item' data-customer-name='$crName' data-customer-id='$crId' data-customer-phone='$phone' data-remain-balance='$remainBalance'>$crName</div>";
    }

    echo $suggestions;
    exit;
}


if (isset($_GET['order_id'])) {
   

    // Get the search term
    $order_id = $_GET['order_id'];

    if (!empty($order_id)) {
        // Query to search for order_ids in the log_user_sales table
        $stmt = $connection->prepare("SELECT order_id FROM log_user_sales WHERE order_id LIKE ? GROUP BY order_id");
        $like_order_id = "%" . $order_id . "%";
        $stmt->bind_param("s", $like_order_id);
        $stmt->execute();
        $result = $stmt->get_result();

        // Generate HTML output
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo '<div class="dropdown-item" data-order-id="' . $row['order_id'] . '">Order #' . $row['order_id'] . '</div>';
            }
        } else {
            echo '<div class="dropdown-item">No orders found</div>';
        }

        $stmt->close();
    }

    $connection->close();
    exit;
}

$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["bill"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $orderId = generateOrderId($connection);
    $paidBy = $_POST['method'];
    $bill_amount = $_POST["BillAmount"];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
	$r_order_id = $_POST["r_order_id"];
	$pre_amount = $_POST["pre_amount"];
	$grand_amount = $_POST["grand_amount"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $discAmount = $product['discAmount'];
        $tax = $product['tax'];
        $color = $product['color'];
        $size = $product['size'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = $tradePrice * $productQuantity;
		$tp = $sale_cost;
        $sql = "INSERT INTO log_user_sales (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            disc_amount,
            tax,
            net_amount,
            BillAmount,
            total_amount,
            pre_amount,
            grand_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
			r_order_id,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time,
            color,
            size
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '',
            '$discount',
            $discAmount,
            '$tax',
            '$netAmount',
            '$bill_amount',
            '$productTotal',
            '$pre_amount',
            '$grand_amount',
            '$paidBy',
            
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
			'$r_order_id',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time',
            '$color',
            '$size'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }
 // Update product quantity based on payment type
            
                $updateSql = "UPDATE products SET qty = qty - $productQuantity, 
                total_amount = total_amount - $tp  WHERE size_id = '$productId'";
          
            if ($connection->query($updateSql) !== TRUE) {
                throw new Exception("Error updating product quantity: " . $connection->error);
            }
        }

    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'printtypep.php?order_id=$orderId';</script>";
}




if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["refund"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $paidBy = $_POST["method"];
    $status = 'Refund';
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $r_order_id = $_POST["r_order_id"];
    $pre_amount = $_POST["pre_amount"];
	$grand_amount = $_POST["grand_amount"];
    $date_time = date("Y-m-d");
    $orderId = $r_order_id;

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $discAmount = $product['discAmount'];
        $tax = $product['tax'];
        $color = $product['color'];
        $size = $product['size'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        
        // Calculate the sale cost to add to total_amount on refund
        $refundAmount = $tradePrice * $productQuantity; // Total amount for the refund

        // Insert refund entry into log_user_sales
        $sql = "INSERT INTO log_user_sales (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            disc_amount,
            tax,
            net_amount,
            total_amount,
            pre_amount,
            grand_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            r_order_id,
            status,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time,
            color,
            size
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '-$productQuantity', -- Negative for refund
            '$productTotal',
            '',
            '$discount',
            '$discAmount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$pre_amount',
            '$grand_amount',
            '$paidBy',
            '$pre_amount',
            '$grand_amount',
            '$refundAmount',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$r_order_id',
            '$status',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time',
              '$color',
                '$size'
        )";

        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        // Update the products table to increase both quantity and total_amount for the refund
        $updateSql = "UPDATE products 
                      SET quantity = quantity + $productQuantity, 
                          total_amount = total_amount + $refundAmount 
                      WHERE size_id = '$productId'";

        if ($connection->query($updateSql) !== TRUE) {
            throw new Exception("Error updating product quantity: " . $connection->error);
        }
    }

    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}



if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["hold"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $orderId = generateOrderId($connection);
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
	$r_order_id = $_POST["r_order_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $discAmount = $product['discAmount'];
        $tax = $product['tax'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = (int)$tradePrice * (int)$productQuantity;
       
        $sql = "INSERT INTO pay_hold (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            disc_amount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '',
            '$discount',
            $discAmount
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }
            
        }
   
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}

$company_q  = mysqli_query($connection, "SELECT * FROM company");
$category_q = mysqli_query($connection, "SELECT * FROM category");
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $tx; ?></title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
    
    
 #table-container-wrapper {
    max-height: 390px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
tr{
    font-weight:700;
    background:#fff;
}
.form-control{
    font-weight:700;
    height: 32px
}
.btn-group .btn {
    margin-right: 5px; /* space between buttons */
  }
  .btn-group .btn:last-child {
    margin-right: 0; /* no space on last */
  }
.btn-primary{
    background:#0A4657;
    color:#fff;
    border:1px solid #0A4657;
}
.btn-primary:hover{
    background:#fff;
    color:#0A4657;
    border:1px solid #0A4657;
}
.form-control{
    font-size:15px;
}  
</style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/logo231.png" style="margin-top:5px;border-radius:50px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;line-height:60px;"><?php echo $tx; ?></h3>
        
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php" class="btn btn-light" style="margin-top:20px; float:right;" >Back</a>
                
        </div>
    </div>
</div>
<div class="container-fluid">
    <form action="mainpos.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-3" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Product</span>
                    </div>
                    <input type="text" class="form-control" id="productInput" placeholder="Start typing a product name..." autocomplete="off">
                    <div class="dropdown-menu" id="suggestions"></div>
                </div>
                      
        <div class="row">
        <div class="input-group mb-3 col-6 ">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Color</span>
                    </div>
                     <input type="text" id="color" name="color" class="form-control" >
                </div>
         <div class="input-group mb-3 col-6">
                     <input type="text" id="size" name="size" class="form-control" >
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Size</span>
                    </div>
                </div>
        </div>
        <div class="row">
      <div class="input-group mb-3 col-6 ">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">P.Price</span>
                    </div>
                    <input type="text" id="p_price" name="p_price" class="form-control" placeholder="" readonly>
                </div>
                <div class="input-group mb-3 col-6 ">
                    
                    <input type="text" id="remain_quantity" name="remain_quantity" class="form-control" 
                    placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">R.Qty</span>
                    </div>
                </div>
          </div>      
                <hr>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Quantity</span>
                    </div>
                    <input type="text" id="quantity" name="quantity" class="form-control" placeholder="">
                </div>
                
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Price / Unit</span>
                    </div>
                    <input type="text" id="retail_price" name="retail_price" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="total_amount" name="total_amount" class="form-control" placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">-/ PKR</span>
                    </div>
                </div>
               <div class="row">
                <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis %</span>
                    </div>
                    <input type="text" id="percentage" name="percentage" class="form-control"  placeholder="">
                </div>
                <div class="input-group mb-3 col-6">
                    <input type="text" id="disc_amount" name="disc_amount" class="form-control"  placeholder="">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis PKR</span>
                    </div>
                </div>
               </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="trade_price" name="trade_price" class="form-control" placeholder="" readonly>
                </div>
                <br>
                <button type="button" class="form-control btn btn-dark" id="makeEntry">Make Entry</button>
                <hr>
                <div class="row">
                <div class="col-6">
                <button type="button" class="form-control btn btn-dark" onclick="location.reload();">Refresh</button>
                </div>
                <div class="col-6">
                    <a href="order_detail_v.php" class="btn btn-primary form-control">View Sales </a>
                </div>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                  <div class="col-sm-3">
                      <div class="form-group">
                        <label>Customer Type</label>
                        <select id="customer_select" name="customer_type" class="form-control">
                          <option value="walkin" selected>Walk-in Customer</option>
                          <option value="credit">Paid by Credit</option>
                        </select>
                      </div>
                    </div>
                    
                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Customer Name</label>
                        <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                        <div class="dropdown-menu" id="customer_suggestions"></div>
                      </div>
                    </div>
                    
                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Customer Phone</label>
                        <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                      </div>
                    </div>
                    
                    <div class="">
                      <div class="">
                   
                        <input type="hidden" id="customer_id" name="customer_id" class="form-control in_form">
                      </div>
                    </div>
                    
                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Refund ID</label>
                        <input type="text" id="r_order_id" name="r_order_id" class="form-control in_form">
                        <div id="order_suggestions" class="dropdown-menu" style="display: none;"></div>
                      </div>
                    </div>
                </div>
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12" style="height:400px;" id="table-container-wrapper">
                        <table class="table table-borderless table-sm text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#0A4657;">
                                <td>Item Code</td>
                                <td>Description</td>
                                <td>Qty</td>
                                <td>Unit Price</td>
                                <td>Amount</td>
                                <td>Dis%</td>
                                <td>Dis PKR</td>
                                <td>Tax</td>
                                <td>Net Amount</td>
                                <td>Action</td>
                                <td>Edit</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Total</label>
                                    <input type="text" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Previous</label>
                                    <input type="text" id="pre_amount" name="pre_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Grand Total</label>
                                    <input type="text" id="grand_amount" name="grand_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount" name="discount_amount" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                   <label>Discount %</label>
                                    <input type="number" id="discount_percent" name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Received</label>
                                    <input type="number" id="cash_received" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Remaining</label>
                                    <input type="number" id="cash_return" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                                 
                                    <input type="hidden" id="tax" name="tax" class="form-control in_form input-height"  readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method" class="form-control in_form">
                                        <option value="cash">Cash</option>
                                        <option value="credit">Credit</option>
                                        <option value="bank1">Bank 1</option>
                                    <option value="bank2">Bank 2 </option>
                                    <option value="bank3">Bank 3</option>
                                       
                                        <option value="others">Others</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-4">
                                <hr>
                                <div class="btn-group w-30 " role="group">
                                  <button type="submit" name="bill" class="btn btn-dark btn-sm font-weight-bold">
                                    Generate Invoice
                                  </button>
                                  <a href="mainpos.php" class="btn btn-primary btn-sm font-weight-bold" target="_blank">
                                    New Sale
                                  </a>
                                  <button type="submit" name="refund" class="btn btn-danger btn-sm font-weight-bold">
                                    Refund
                                  </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
  document.getElementById("method").addEventListener("change", function () {
    const customerType = document.getElementById("customer_select")?.value;

    if (this.value === "credit" && customerType !== "credit") {
      alert("Please Select Customer Type Credit");
      this.value = "";
    }
  });
</script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const generateInvoiceButton = document.querySelector("button[name='bill']");
    const refundButton = document.querySelector("button[name='refund']");

    generateInvoiceButton.addEventListener("click", function(event) {
        const method = document.getElementById("method").value;
        const customerName = document.getElementById("customer_name").value.trim();

        if (method === "credit" && customerName === "") {
            event.preventDefault();
            alert("Please fill in the Customer Name for Credit method.");
        }
    });

    refundButton.addEventListener("click", function(event) {
        const refundId = document.getElementById("r_order_id").value.trim();

        if (refundId === "") {
            event.preventDefault(); 
            alert("Please enter a Refund ID.");
        }
    });
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    let currentFocus = -1;

    document.getElementById("r_order_id").addEventListener("input", function() {
        var orderIdInput = this.value;
        if (orderIdInput.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?order_id=" + encodeURIComponent(orderIdInput), true); 
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("order_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("order_suggestions").style.display = 'none';
        }
    });

    document.getElementById("order_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectOrder(e.target);
        }
    });

    document.getElementById("r_order_id").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("order_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectOrder(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectOrder(item) {
        var orderId = item.getAttribute('data-order-id');
        document.getElementById("r_order_id").value = orderId;
        document.getElementById("order_suggestions").style.display = 'none';
    }

    document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

function selectCustomer(item) {
    var customerName = item.getAttribute('data-customer-name');
    var customerId = item.getAttribute('data-customer-id');
    var customerPhone = item.getAttribute('data-customer-phone');
    var remainBalance = item.getAttribute('data-remain-balance');

    document.getElementById("customer_name").value = customerName;
    document.getElementById("customer_phone").value = customerPhone;
    document.getElementById("customer_id").value = customerId;
    document.getElementById("pre_amount").value = remainBalance; 

    document.getElementById("customer_suggestions").style.display = 'none';
}


    function calculateTotalPrice(triggeredBy = null) {
    let quantity = parseFloat(document.getElementById("quantity").value) || 0;
    let pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;

    let totalPrice = quantity * pricePerUnit;

    let discountPercent = parseFloat(document.getElementById("percentage").value) || 0;
    let discountAmount = parseFloat(document.getElementById("disc_amount").value) || 0;

    if (triggeredBy === "percentage") {
        discountAmount = (totalPrice * discountPercent) / 100;
        document.getElementById("disc_amount").value = discountAmount.toFixed(0);
    }

    if (triggeredBy === "disc_amount") {
        discountPercent = (discountAmount * 100) / totalPrice;
        if (!isFinite(discountPercent)) discountPercent = 0; 
        document.getElementById("percentage").value = discountPercent.toFixed(2);
    }

    let finalPrice = totalPrice - discountAmount;
    if (finalPrice < 0) finalPrice = 0;

    document.getElementById("total_amount").value = totalPrice.toFixed(2);
    document.getElementById("trade_price").value = finalPrice.toFixed(2);  
}

document.getElementById("quantity").addEventListener("input", () => calculateTotalPrice());
document.getElementById("retail_price").addEventListener("input", () => calculateTotalPrice());
document.getElementById("percentage").addEventListener("input", () => calculateTotalPrice("percentage"));
document.getElementById("disc_amount").addEventListener("input", () => calculateTotalPrice("disc_amount"));


    document.getElementById("suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectProduct(e.target);
        }
    });

    document.getElementById("productInput").addEventListener("input", function() {
        var query = this.value;
        if (query.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?query=" + query, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("suggestions").style.display = 'none';
        }
    });

    document.getElementById("productInput").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectProduct(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

const productInput = document.getElementById("productInput");

productInput.addEventListener("keypress", function (e) {
    if (e.key === "Enter") {
        e.preventDefault(); 
        document.getElementById("makeEntry").click();
    }
});

function selectProduct(item) {
    const selectedProduct = item.textContent;
    const retailPrice = item.getAttribute('data-retail-price');
    const productcolor = item.getAttribute('data-product-color');
     const productsize = item.getAttribute('data-product-size');
      const productQuantity = item.getAttribute('data-product-quantity');
    const tradePrice = item.getAttribute('data-trade-price');
    const productId = item.getAttribute('data-product-id');
    const supplier = item.getAttribute('data-supplier');
    const company = item.getAttribute('data-company');
    const productUnit = item.getAttribute('data-product-unit');

    const input = document.getElementById("productInput");
    input.value = selectedProduct;
    input.setAttribute('data-product-id', productId);
    input.setAttribute('data-product-quantity', productQuantity);
    input.setAttribute('data-supplier', supplier);
    input.setAttribute('data-company', company);
    input.setAttribute('data-trade-price', tradePrice);
    input.setAttribute('data-product-unit', productUnit);

    document.getElementById("remain_quantity").value = productQuantity;
    document.getElementById("size").value = productsize;
    document.getElementById("color").value = productcolor;
    document.getElementById("p_price").value = tradePrice;
    document.getElementById("retail_price").value = retailPrice;
    document.getElementById("suggestions").style.display = 'none';

    calculateTotalPrice();
}

document.getElementById("makeEntry").addEventListener("click", function () {
    const productInput = document.getElementById("productInput");
    const productId = productInput.getAttribute('data-product-id');
    const supplier = productInput.getAttribute('data-supplier');
    const company = productInput.getAttribute('data-company');
    const tradePrice = productInput.getAttribute('data-trade-price');

    const description = productInput.value;
    const quantity = parseFloat(document.getElementById("quantity").value) || 0;
    const color = document.getElementById("color").value || 0;
    const size = document.getElementById("size").value || 0;
    const pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
    const totalPrice = parseFloat(document.getElementById("total_amount").value) || 0;
    const discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
    const discAmount = parseFloat(document.getElementById("disc_amount").value) || 0;
    const netAmount = parseFloat(document.getElementById("trade_price").value) || 0;

    if (productId && description && quantity && pricePerUnit && totalPrice && netAmount) {
        const table = document.getElementById("productsTable");
        const row = table.insertRow();
        row.innerHTML = `
            <td style="display:none;">${quantity}</td>
            <td>${productId}</td>
            <td style="color:#0A5064;font-weight:700px;">${description}</td>
            <td>${quantity}</td>
            <td>${pricePerUnit}</td>
            <td>${totalPrice}</td>
            <td>${discountPercentage.toFixed(2)}</td>
            <td>${discAmount.toFixed(2)}</td>
            <td>0</td>
            <td>${netAmount}</td>
            <td style="display:none;">${supplier}</td>
            <td style="display:none;">${company}</td>
            <td style="display:none;">${tradePrice}</td>
            <td style="display:none;">${size}</td>
            <td style="display:none;">${color}</td>
            <td><button class="btn btn-danger btn-sm delete-row">X</button></td>
            <td><button class="btn btn-danger btn-sm edit-row">+</button></td>
        `;
     

        row.querySelector(".delete-row").addEventListener("click", function () {
            row.remove();
            calculateTotalAmount();
        });
        
        

        row.querySelector(".edit-row").addEventListener("click", function () {
            const cells = row.querySelectorAll("td");

            productInput.value = cells[2].innerText;
            productInput.setAttribute('data-product-id', cells[1].innerText);
            productInput.setAttribute('data-supplier', cells[9].innerText);
            productInput.setAttribute('data-company', cells[10].innerText);
            productInput.setAttribute('data-trade-price', cells[11].innerText);

            document.getElementById("quantity").value = cells[3].innerText;
            document.getElementById("retail_price").value = cells[4].innerText;
            document.getElementById("total_amount").value = cells[5].innerText;
            document.getElementById("percentage").value = cells[6].innerText;
            document.getElementById("disc_amount").value = cells[7].innerText;
            document.getElementById("trade_price").value = cells[8].innerText;
            

            
            row.remove();
            calculateTotalAmount();

            productInput.focus();
        });

        calculateTotalAmount();

        const rows = document.querySelectorAll("#productsTable tr:not(:first-child)");
        const productData = [];
        rows.forEach(function (row) {
            const cells = row.querySelectorAll("td");
            const product = {
                productId: cells[1].innerText,
                description: cells[2].innerText,
                quantity: cells[3].innerText,
                pricePerUnit: cells[4].innerText,
                totalPrice: cells[5].innerText,
                discountPercentage: cells[6].innerText,
                discAmount: cells[7].innerText,
                tax: cells[8].innerText,
                netAmount: cells[9].innerText,
                supplier: cells[10].innerText,
                company: cells[11].innerText,
                tradePrice: cells[12].innerText,
                size: cells[13].innerText,
                color: cells[14].innerText
            };
            productData.push(product);
        });

        document.getElementById("productData").value = JSON.stringify(productData);

        resetProductFields();
        productInput.focus();
    }
});

// document.querySelectorAll("#productInput, #quantity, #retail_price, #total_amount, #dis_percent, #percentage, #trade_price").forEach(function(input) {
//     input.addEventListener("keydown", function(e) {
//         if (e.key === "Enter") {
//             e.preventDefault(); 
//             document.getElementById("makeEntry").click(); 
//         }
//     });
// });
document.querySelector("form").addEventListener("keydown", function(e) {
    if (e.key === "Enter" && e.target.type !== "submit") {
        e.preventDefault();
    }
});


    function resetProductFields() {
        document.getElementById("productInput").value = '';
        document.getElementById("remain_quantity").value = '';
        document.getElementById("quantity").value = '';
        document.getElementById("retail_price").value = '';
        document.getElementById("total_amount").value = '';
        document.getElementById("percentage").value = '';
        document.getElementById("disc_amount").value = '';
        document.getElementById("trade_price").value = '';
        document.getElementById("p_price").value = '';
        document.getElementById("size").value = '';
        document.getElementById("color").value = '';
        document.getElementById("productInput").removeAttribute('data-product-id');
        document.getElementById("productInput").removeAttribute('data-product-quantity');
        document.getElementById("productInput").removeAttribute('data-supplier');
        document.getElementById("productInput").removeAttribute('data-company');
        document.getElementById("productInput").removeAttribute('data-trade-price');
        document.getElementById("productInput").removeAttribute('data-product-unit');
    }

function calculateTotalAmount() {
    var table = document.getElementById("productsTable");
    var rows = table.getElementsByTagName("tr");
    var total = 0;

    for (var i = 1; i < rows.length; i++) {
        var netAmountCell = rows[i].cells[9];
        var netAmount = parseFloat(netAmountCell.textContent.trim());
        if (!isNaN(netAmount)) {
            total += netAmount;
        }
    }

    var totalInput = document.getElementById("total-input");
    var billAmountInput = document.getElementById("bill-amount");

    totalInput.value = total.toFixed(2);
    billAmountInput.value = total.toFixed(2);

    updateDiscountAmount();
    updateGrandAmount();
}

function updateDiscountAmount() {
    var total = parseFloat(document.getElementById("total-input").value) || 0;
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var discountAmountInput = document.getElementById("discount_amount");
    var discountPercentInput = document.getElementById("discount_percent");

    if (!isNaN(billAmount) && !isNaN(total)) {
        var discountAmount = total - billAmount;
        discountAmountInput.value = Math.round(discountAmount);

        if (total > 0) {
            var discountPercent = (discountAmount / total) * 100;
            discountPercentInput.value = discountPercent.toFixed(2);
        } else {
            discountPercentInput.value = "0.00";
        }
    }
}

function updateGrandAmount() {
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var preAmount = parseFloat(document.getElementById("pre_amount").value) || 0;
    var grandAmountInput = document.getElementById("grand_amount");

    var grandAmount = billAmount + preAmount;
    grandAmountInput.value = grandAmount.toFixed(2);

    calculateCashReturn();
}

function calculateCashReturn() {
    var grandAmount = parseFloat(document.getElementById("grand_amount").value) || 0;
    var cashReceived = parseFloat(document.getElementById("cash_received").value) || 0;
    var cashReturnInput = document.getElementById("cash_return");

    if (!isNaN(grandAmount) && !isNaN(cashReceived)) {
        var cashReturn = grandAmount - cashReceived;
        cashReturnInput.value = cashReturn.toFixed(2);
    }
}

function attachInputListener(id, callback) {
    var el = document.getElementById(id);
    if (el) {
        el.addEventListener("input", callback);
    }
}

attachInputListener("bill-amount", function() {
    updateDiscountAmount();
    updateGrandAmount();
});

attachInputListener("pre_amount", updateGrandAmount);
attachInputListener("cash_received", calculateCashReturn);

(function watchPreAmount() {
    var preAmountEl = document.getElementById("pre_amount");
    var lastValue = preAmountEl ? preAmountEl.value : null;

    setInterval(function () {
        if (!preAmountEl) return;
        if (preAmountEl.value !== lastValue) {
            lastValue = preAmountEl.value;
            updateGrandAmount();
        }
    }, 300);
})();

window.addEventListener("DOMContentLoaded", function () {
    calculateTotalAmount();
    updateGrandAmount();
});
});
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>