<?php
include("../db/cn.php");
include("common/tx.php");
ob_start();
//session_start(); // ✅ Needed to access $_SESSION

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
} else {
    echo '<script type="text/javascript">window.location.href="logout.php";</script>';
    exit();
}

if (isset($_GET["id"])) {
    $supplier_id = (int) $_GET["id"]; // ✅ Always treat IDs as integers

    // ✅ Fix 1: supplier_id is INT → bind_param("i", ...)
    // ✅ Fix 2: remove extra WHERE conditions that blocked deletion
    
    $stmt = $connection->prepare("DELETE FROM supplier WHERE supplier_id = ?");
    $stmt->bind_param("i", $supplier_id);

    if ($stmt->execute()) {
        echo '<script type="text/javascript">window.location.href="supplier_view.php";</script>';
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    
    
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
tr{
	  font-weight:500;	
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
                <div class="container">
<div class="row">
<div class="col-sm-7">
<h3 style="color:#212529;font-weight:700;">Supplier Ledger Detail</h3>

</div>
<?php
// Query: get supplier name and closing balance
$query = "
    SELECT s.supplier_name, sc.closing_balance 
    FROM supplier_closing sc
    JOIN supplier s ON s.supplier_name = sc.supplier_name
";

$result = mysqli_query($connection, $query);
if (!$result) {
    die("Query Failed: " . mysqli_error($connection));
}

$total_sum = 0;
?>
<div class="col-sm-2"></div>
<div class="col-sm-3" style="background:#0A4657;color:#fff; padding:7px; border-radius:7px; font-weight:700;" >
<center>
    <?php 
    while ($row = mysqli_fetch_assoc($result)) { 
        $total_sum += $row['closing_balance'];
    ?>
       
    <?php } ?>
   
    <p style="font-weight:700; font-size:20px;">
        Total Payable Rs <?php echo number_format(round($total_sum, 2), 2); ?>
    </p>
</center>
</div>
</div>
<div class="row">
    
    <div class="col-sm-12" id="supplier-container-wrapper">
       
	<input type="text" id="searchInput" class="form-control" placeholder="Search..." style="width:305px;">
	<table class="table text-center table-hover bg-white" style="margin-top:5px;">
    <thead style="background:#212529; color: white; font-size:14px;">
        <tr>
        <th>Sr</th>
            <th>ID</th>
            <th> Name</th>
            <th>Cell</th>
            <th>Company</th>
            <th>Closing Balance(Rs)</th>
            <th>Detail</th>
            <th>Delete</th>
        </tr>
    </thead>
    <tbody id="supplierTableBody">
        <?php   
        // Join the supplier table with the supplier_closing table and retrieve necessary fields
        $rec = mysqli_query($connection, "
            SELECT supplier.supplier_id, supplier.supplier_name, supplier.supplier_phone, supplier.supplier_company, supplier_closing.closing_balance 
            FROM supplier 
            LEFT JOIN supplier_closing ON supplier.supplier_name = supplier_closing.supplier_name 
            
            
        ");
        $sr_no = 1;
        while($row = mysqli_fetch_array($rec)) {		   
        ?>
        <tr style="color:#000; font-weight:700;">
        <td><?php echo $sr_no++; ?></td>
            <td><?php echo $row["supplier_id"]; ?></td>
            <td><?php echo $row["supplier_name"]; ?></td>
            <td><?php echo $row["supplier_phone"]; ?></td>
            <td class="text-uppercase"><?php echo $row["supplier_company"]; ?></td>
            <td><?php echo  number_format(round($row["closing_balance"], 2), 2); ?></td> <!-- Display the closing_balance -->
            <td><a href="supplier_detail.php?supplier_name=<?php echo $row["supplier_name"]; ?>">
            <button class="btn btn-dark btn-sm"><i class="fas fa-clipboard-check fa-1x"></i></button></a></td>
           <!--<td><a href="supplier_edit.php?supplier_name=<?php echo $row["supplier_name"]; ?>">-->
           <!-- <button class="btn btn-dark btn-sm">Edit</button></a></td>-->
            <td><button class="btn btn-danger btn-sm deleteBtn" data-id="<?php echo $row['supplier_id']; ?>">x</button></td>
        </tr>
        <?php  } 
        ob_end_flush();
        ?>
    </tbody>
</table>
        
    </div>
    
</div>
</div>

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
            var searchInput = document.getElementById('searchInput');
            var rows = document.querySelectorAll("#supplierTableBody tr");
        
            searchInput.addEventListener("keyup", function(event) {
                var term = event.target.value.toLowerCase();
                rows.forEach(function(row) {
                    var cells = row.getElementsByTagName("td");
                    var found = false;
                    Array.from(cells).forEach(function(cell) {
                        if (cell.textContent.toLowerCase().indexOf(term) > -1) {
                            found = true;
                        }
                    });
                    if (found) {
                        row.style.display = "";
                    } else {
                        row.style.display = "none";
                    }
                });
            });
        });
        </script>
        <script src="../vendor/jquery/jquery.min.js"></script>
        <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    
        <!-- Core plugin JavaScript-->
        <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    
        <!-- Custom scripts for all pages-->
        <script src="../js/sb-admin-2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    // Sab delete buttons ke liye
    document.querySelectorAll(".deleteBtn").forEach(function (button) {
        button.addEventListener("click", function (e) {
            e.preventDefault();
            let supplierId = this.getAttribute("data-id");

            Swal.fire({
                title: "Are you sure?",
                text: "Do you want to delete this ledger?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "supplier_view.php?id=" + supplierId;
                }
            });
        });
    });
});
</script>

</body>

</html>