<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Check if session variables are set
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
} else {
    // Redirect to login page or handle the error
    echo "Session variables not set. Please log in.";
    exit;
}

// Handle AJAX request to fetch route_com and account_type based on the selected route
if (isset($_POST['ajax']) && isset($_POST['distribution'])) {
    $route = mysqli_real_escape_string($connection, $_POST['distribution']);
    
    // Fetch route_com and account_type based on the route from the database
    $query = "SELECT route_com, account_type FROM dist WHERE dist_name = '$route'";
    $result = mysqli_query($connection, $query);

    if ($row = mysqli_fetch_assoc($result)) {
        // Combine route_com and account_type into a single response array
        echo json_encode([
            'route_com' => $row['route_com'],
            'account_type' => $row['account_type']
        ]);
    } else {
        // Return empty values if no matching record found
        echo json_encode([
            'route_com' => '',
            'account_type' => ''
        ]);
    }
    exit;
}


// Handle AJAX request to fetch plt_type1_com based on the selected plt_type1
if (isset($_POST['ajax']) && isset($_POST['plt'])) {  // Fixed 'plt' in $_POST to match the AJAX request
    $plt = mysqli_real_escape_string($connection, $_POST['plt']);
    
    // Fetch plt_type1_com based on the plt_type1 from the database
    $query = "SELECT plt_type1_com FROM plt WHERE plt_type1 = '$plt'";
    $result = mysqli_query($connection, $query);
    
    if ($result && mysqli_num_rows($result) > 0) { // Check if query succeeded and returned rows
        $row = mysqli_fetch_assoc($result);
        
        // Return the plt_type1_com value as JSON
        echo json_encode(['plt_type1_com' => $row['plt_type1_com']]);
    } else {
        // Return an empty value if no results are found
        echo json_encode(['plt_type1_com' => '']);
    }
    exit;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['dispatch_btn'])) {
    $dispatch_date = $_POST["dispatch_date"];
    $bility_no = $_POST["bility_no"];
    $vehicle_no = $_POST["vehicle_no"];
    $driver = $_POST["driver"];
    $distribution = $_POST["distribution"];
    $palet_no = $_POST["palet_no"];
    $plt_com = $_POST["plt_com"];
    $route_no = $_POST["route"];
    $route_com = $_POST["route_com"];
    $route_com1 = (int)$route_com * (int)$palet_no;
    $dispatch_id = uniqid('D-ID');
    $date_time = date('Y-m-d');
    $account_type = $_POST["account_type"];

    // Check if the bility_no already exists in the dispatch table
    $check_query = "SELECT * FROM dispatch WHERE bility_no = '$bility_no'";
    $check_result = mysqli_query($connection, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        // If bility_no exists, echo a JavaScript alert and stop execution
        echo "<script>alert('Bility number already exists in the dispatch records.');</script>";
        exit;
    }


    $sale_order = $_POST["sale_order"] ?? [];
    $item = $_POST["item"] ?? [];
    $quantity = $_POST["qty"] ?? [];
    $empty_slip = $_POST["empty_slip"] ?? [];
    $empty_case = $_POST["empty_case"] ?? [];
    $empty_quantity = $_POST["empty_quantity"] ?? [];

    $values = [];

    // Ensure both tables have default values when data is missing
    $max_rows = max(count($sale_order), count($empty_slip));

    for ($i = 0; $i < $max_rows; $i++) {
        $sale_order_item = $sale_order[$i] ?? 0;
        $item_name = $item[$i] ?? 0;
        $qty = $quantity[$i] ?? 0;
        $empty_s = $empty_slip[$i] ?? 0;
        $empty_c = $empty_case[$i] ?? 0;
        $empty_qty = $empty_quantity[$i] ?? 0;

        $values[] = "(
            '$dispatch_date', 
            '$bility_no', 
            '$vehicle_no', 
            '$driver', 
            '$distribution', 
            '$palet_no', 
            '$plt_com', 
            '$route_no', 
            '$route_com1', 
            '$dispatch_id',
            '$account_type',
            '$date_time', 
            " . ($sale_order_item ? "'$sale_order_item'" : "0") . ",
            " . ($item_name ? "'$item_name'" : "0") . ",
            '$qty',
            " . ($empty_s ? "'$empty_s'" : "0") . ",
            " . ($empty_c ? "'$empty_c'" : "0") . ",
            '$empty_qty',
            '" . $_SESSION['user_name'] . "',
            '" . $_SESSION['user_role'] . "',
            '" . $_SESSION['outlet_name'] . "',
            '" . $_SESSION['outlet_address'] . "'
        )";
    }

    $query = "INSERT INTO dispatch (
        dispatch_date, bility_no, truck_no, driver_name, dist_name, palet_no, plt_com, 
        route_name, route_com, dispatch_id, account_type, date_time, sale_order, item_name, quantity, 
        empty_slip, empty_case, emp_quantity, user_name, user_role, outlet_name, outlet_address
    ) VALUES " . implode(", ", $values);

    if (mysqli_query($connection, $query)) {
        echo "";
    } else {
        echo "Error: " . mysqli_error($connection);
    }
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Add DIS-PATCH</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
label{
	  	font-weight:600;
	  	color:#000;
		}
				.btn-dark{
		    background:#0A4657;
		    color:#fff;
		    border:1px solid #0A4657;
		    
		}
		.btn-dark:hover{
		    background:#fff;
		    color:#0A4657;
		    border:1px solid #0A4657;
		}
		
		.form-control{
		    color:#000;
		    font-weight:500;
		}
		option{
		    font-weight:400;
		    color:#000;
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <?php
                $veh = mysqli_query($connection,"select * from truck");
                $dri = mysqli_query($connection,"select * from driver");
                $rt = mysqli_query($connection,"select * from route");
                $dist = mysqli_query($connection,"select * from dist");
                $plt1 = mysqli_query($connection,"select * from plt");
                ?>
                <?php
    // Current date
    $currentDate = date('d-M-Y');
    $formattedDate = strtoupper($currentDate);
    ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-9">
            <h3 style="color:#212529; font-weight:700;"> Add Dispatch</h3>
        </div>
        <div class="col-sm-3"></div>
    </div>
    <br>
    <form action="add_dispatch.php" method="post" id="dispatchForm">
    <div class="container-fluid">
        <div class="row" style="background:#EEEEF2; padding:21px; border:1px solid #E1E1E2;border-radius:7px;">
                    <div class="col-2">
                        <div class="form-group">
                            <label>Dispatch Date</label>
                            <input type="date" name="dispatch_date" class="form-control" style="background:#5B838F;color:#fff;" required />
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <label>Bility No.</label>
                            <input type="text" name="bility_no" class="form-control" />
                        </div>
                    </div>
                    <div class="col-3">
                        
                    <div class="row">
                        <div class="form-group col-sm-6">
                            <label>Vehicle No.</label>
                            <select name="vehicle_no" class="form-control">
                                <option value="">Select</option>
                                <?php
                                while($row = mysqli_fetch_array($veh)){
                                ?>
                                <option value="<?php echo $row["truck_num"]; ?>"><?php echo $row["truck_num"]; ?></option>
                                <?php
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group col-sm-6">
                            <label>Driver</label>
                            <select name="driver" class="form-control">
                                <option value="">Select</option>
                                <?php
                                while($row1 = mysqli_fetch_array($dri)){
                                ?>
                                <option value="<?php echo $row1["driver_name"]; ?>"><?php echo $row1["driver_name"]; ?></option>
                                <?php
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    </div>
                    <div class="col-2">
    <div class="form-group">
        <label>Distribution</label>
        <select name="distribution" class="form-control" id="route-select">
            <option value="">Select</option>
            <?php
            while ($row4 = mysqli_fetch_array($dist)) {
                echo '<option value="' . htmlspecialchars($row4["dist_name"]) . '">' . htmlspecialchars($row4["dist_name"]) . '</option>';
            }
            ?>
        </select>
    </div>
    <div class="form-group">
   
        <input type="hidden" id="route_com" name="route_com" class="form-control" readonly>
        <input type="hidden" id="account_type" name="account_type" class="form-control" readonly>
    </div>
</div>
                    <div class="col-2">
                        <div class="form-group">
                            <label>Palet No.</label>
                            <select  name="palet_no" class="form-control"  id="plt-select" >
                                <option value="">Select</option>
                                 <?php
                                while($row5 = mysqli_fetch_array($plt1)){
                                ?>
                                <option value="<?php echo $row5["plt_type1"]; ?>"><?php echo $row5["plt_type1"]; ?></option>
                                <?php
                                }
                                ?>
                            </select>
                              <input type="hidden" name="plt_com" id="plt_type1_com" class="form-control">
                        </div>
                    </div>
                    <hr>
                    <div class="">
                        <div class="form-group">
                           
                            <input type="hidden" name="route" class="form-control" value="0" >
                               
                        </div>
                      
                    </div>
                    <div class="col-2">
                           <button type="submit" name="dispatch_btn" class="btn btn-dark form-control"
        style="background:#0A4657;color:#fff;border:1px #0A4657 solid;font-weight:700;">
        Dispatch Now
    </button>
                    </div>
                  
                </div>
    </div>
    <br>
    
    <?php
    $it = mysqli_query($connection,"select * from  item_case");
    $et = mysqli_query($connection,"select * from  empty_case");
    ?>
    <div class="container-fluid">
        <div class="row">
            
            <div class="col-sm-6">
                <h3 style="width:100%;padding:7px; background:#0A4657;color:#fff;font-weight:600 ;text-align:center;border-radius:7px;">ITEMS</h3>
                <div id="items-container">
                    <div class="row item-row" style="padding:10px;">
                        <div class="form-group col-4">
                            <label>Sale Order.#</label>
                            <input type="text" name="sale_order[]" class="form-control" />
                        </div>
                        <div class="form-group col-4">
                            <label>Item</label>
                            
                            <select name="item[]" class="form-control" >
                            <option vlaue="">Select</option>
                            <?php
                            while($it_row = mysqli_fetch_array($it)){
                            ?>
                            <option value="<?php echo $it_row["item_name"]; ?>"><?php echo $it_row["item_name"]; ?></option>
                            <?php
                            
                            }?>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label>Qty</label>
                            <input type="text" name="qty[]" class="form-control" />
                        </div>
                        <div class="form-group col-2">
                            <button type="button" class="btn btn-dark add-row" style="border-radius:40px; margin-top:30px;">+</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <h3 style="width:100%;padding:7px; background:#0A4657;color:#fff;font-weight:600 ;text-align:center;border-radius:7px;">EMPTY ITEMS</h3>
                <div id="items-container1">
                    <div class="row item-row1" style="padding:10px;">
                        <div class="form-group col-4">
                            <label>Empty Slip.#</label>
                            <input type="text" name="empty_slip[]" class="form-control" />
                        </div>
                        <div class="form-group col-4">
                            <label>Item</label>
                            <select name="empty_case[]" class="form-control" >
                                <option value="">Select</option>
                                <?php
                            while($et_row = mysqli_fetch_array($et)){
                            ?>
                            <option value="<?php echo $et_row["item_case"]; ?>"><?php echo $et_row["item_case"]; ?></option>
                            <?php
                            
                            }?>
                                </select>
                        </div>
                        <div class="form-group col-2">
                            <label>Qty</label>
                            <input type="text" name="empty_quantity[]" class="form-control" />
                        </div>
                        <div class="form-group col-2">
                            <button type="button" class="btn btn-dark add-row1" style="border-radius:40px; margin-top:30px;">+</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </form>
</div>
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.getElementById('dispatchForm').addEventListener('keydown', function(event) {
        if (event.key === 'Enter') {
            event.preventDefault(); // Prevent form submission on Enter
        }
    });

    document.querySelector('button[name="dispatch_btn"]').addEventListener('click', function() {
        document.getElementById('dispatchForm').submit(); // Allow submission on button click
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    // Dynamic Row Addition for Items
    const itemsContainer = document.getElementById("items-container");
    const itemsContainer1 = document.getElementById("items-container1");

    if (itemsContainer) {
        itemsContainer.addEventListener("click", function (e) {
            if (e.target && e.target.classList.contains("add-row")) {
                const newRow = document.createElement("div");
                newRow.classList.add("row", "item-row");
                newRow.style.padding = "10px";

                newRow.innerHTML = `
                <?php
                 $its = mysqli_query($connection,"select * from  item_case");
                ?>
                    <div class="form-group col-4">
                        <label>Sale Order.#</label>
                        <input type="text" name="sale_order[]" class="form-control" />
                    </div>
                    <div class="form-group col-4">
                        <label>Item</label>
                        <select name="item[]" class="form-control">
                            <option value="">Select</option>
                            <?php
                           
                            while ($its_row = mysqli_fetch_array($its)) {
                                echo '<option value="' . $its_row["item_name"] . '">' . $its_row["item_name"] . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group col-2">
                        <label>Qty</label>
                        <input type="text" name="qty[]" class="form-control" />
                    </div>
                    <div class="form-group col-2">
                        <button type="button" class="btn btn-dark add-row" style="border-radius:40px; margin-top:30px;">+</button>
                    </div>
                `;

                itemsContainer.appendChild(newRow);
            }
        });
    }

    if (itemsContainer1) {
        itemsContainer1.addEventListener("click", function (e) {
            if (e.target && e.target.classList.contains("add-row1")) {
                const newRow = document.createElement("div");
                newRow.classList.add("row", "item-row1");
                newRow.style.padding = "10px";

                newRow.innerHTML = `
                <?php
                   $ets = mysqli_query($connection,"select * from  empty_case");
                ?>
                    <div class="form-group col-4">
                        <label>Empty Slip.#</label>
                        <input type="text" name="empty_slip[]" class="form-control" />
                    </div>
                    <div class="form-group col-4">
                        <label>Item</label>
                        <select name="empty_case[]" class="form-control">
                            <option value="">Select</option>
                            <?php
                            while ($ets_row = mysqli_fetch_array($ets)) {
                                echo '<option value="' . $ets_row["item_case"] . '">' . $ets_row["item_case"] . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="form-group col-2">
                        <label>Qty</label>
                        <input type="text" name="empty_quantity[]" class="form-control" />
                    </div>
                    <div class="form-group col-2">
                        <button type="button" class="btn btn-dark add-row1" style="border-radius:40px; margin-top:30px;">+</button>
                    </div>
                `;

                itemsContainer1.appendChild(newRow);
            }
        });
    }
});
</script>

   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <script>
$(document).ready(function() {
    $('#route-select').change(function() {
        var selectedRoute = $(this).val();
        var selectedAccount = $(this).val();

        // Make an AJAX request to fetch the route_com based on the selected route
        $.ajax({
            url: 'add_dispatch.php',  // Same file
            method: 'POST',
            data: { distribution: selectedRoute, selectedAccount, ajax: true },  // Send route and ajax flag
            dataType: 'json',
            success: function(response) {
                if (response.route_com) {
                    // Set the route_com value in the input field
                    $('#route_com').val(response.route_com);
                } else {
                    $('#route_com').val(''); // Clear if no data found
                }
                if (response.account_type) {
                    // Set the route_com value in the input field
                    $('#account_type').val(response.account_type);
                } else {
                    $('#account_type').val(''); // Clear if no data found
                }
            },
            error: function() {
                alert('Error fetching route_com.');
            }
        });
    });
});
    
$(document).ready(function() {
    $('#plt-select').change(function() {
        var selectedPlt = $(this).val();

        // Make an AJAX request to fetch the plt_type1_com based on the selected plt_type1
        $.ajax({
            url: 'add_dispatch.php',  // Same file
            method: 'POST',
            data: { plt: selectedPlt, ajax: true },  // Send plt and ajax flag
            dataType: 'json',
            success: function(response) {
                if (response.plt_type1_com) {
                    // Set the plt_type1_com value in the input field
                    $('#plt_type1_com').val(response.plt_type1_com);  // Corrected key to match response
                } else {
                    $('#plt_type1_com').val('');
                }
            },
            error: function() {
                alert('Error fetching plt_type1_com.');
            }
        });
    });
});

    </script>
      

</body>

</html>