<?php 
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check session variables
if (isset($_SESSION['user_name'], $_SESSION['user_role'], $_SESSION['outlet_name'], $_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
} else {
    echo json_encode(['error' => 'Session variables not set. Please log in.']);
    exit;
}

// Fetch matching dispatch IDs
if (isset($_GET['query'])) {
    $query = mysqli_real_escape_string($connection, $_GET['query']);
    $result = mysqli_query($connection, "SELECT DISTINCT dispatch_id FROM dispatch WHERE dispatch_id LIKE '%$query%'");
    $dispatchIds = [];

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $dispatchIds[] = $row['dispatch_id'];
        }
        echo json_encode($dispatchIds);
    } else {
        echo json_encode(['error' => mysqli_error($connection)]);
    }
    exit;
}

// Fetch dispatch details
if (isset($_GET['dispatch_id'])) {
    $dispatch_id = mysqli_real_escape_string($connection, $_GET['dispatch_id']);
    $result = mysqli_query($connection, "SELECT * FROM dispatch WHERE dispatch_id = '$dispatch_id'");

    if ($result && $dispatch = mysqli_fetch_assoc($result)) {
        $orders_result = mysqli_query($connection, "SELECT * FROM dispatch WHERE dispatch_id = '$dispatch_id'");
        $orders = [];

        while ($row = mysqli_fetch_assoc($orders_result)) {
            $orders[] = $row;
        }

        $dispatch['orders'] = $orders;
        echo json_encode($dispatch);
    } else {
        echo json_encode(['error' => 'No data found for this dispatch_id']);
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Debug: Print all POST data to ensure multiple rows are received

    
    // Validate database connection
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    // Generate a unique return ID for the entire batch
    $return_id = uniqid();

    // Get current date and time
    $date_time = date("Y-m-d");

    // Collect static POST data (dispatch information)
    $dispatch_id = $connection->real_escape_string($_POST['dispatch_id'] ?? '');
    $bility_no = $connection->real_escape_string($_POST['bility_no'] ?? '');
    $truck_no = $connection->real_escape_string($_POST['truck_no'] ?? '');
    $driver_name = $connection->real_escape_string($_POST['driver_name'] ?? '');
    $palet_no = $connection->real_escape_string($_POST['palet_no'] ?? '');
    $route_name = $connection->real_escape_string($_POST['route_name'] ?? '');

    // Decode dynamic_data from JSON
$dynamic_data = json_decode($_POST['dynamic_data'] ?? '[]', true);



// Validate dynamic_data
if (!is_array($dynamic_data) || empty($dynamic_data)) {
    die("No valid dynamic row data received.");
}

    // Debug: Log the number of rows to process
    $row_count = count($dynamic_data);
    

    // Initialize success and error counters
    $success_count = 0;
    $error_count = 0;

    // Prepare the SQL statement for inserting rows
    $stmt = $connection->prepare(
        "INSERT INTO `return_emp` 
        (`dispatch_id`, `bility_no`, `truck_no`, `driver_name`, `palet_no`, `route_name`, 
        `empty_slip`, `item_name`, `item_cases`, `return_id`, `date_time`, `user_name`, 
        `user_role`, `outlet_name`, `outlet_address`) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
    );

    if (!$stmt) {
        die("Prepared statement creation failed: " . $connection->error);
    }

    // Bind parameters to the prepared statement
    $stmt->bind_param(
        'sssssssssssssss', 
        $dispatch_id, 
        $bility_no, 
        $truck_no, 
        $driver_name, 
        $palet_no, 
        $route_name, 
        $empty_slip, 
        $item_name, 
        $item_cases, 
        $return_id, 
        $date_time, 
        $userName, 
        $userRole, 
        $outlet_name, 
        $outlet_address
    );

    // Loop through the dynamic row data and insert each row into the database
    foreach ($dynamic_data as $key => $row) {
        $empty_slip = $connection->real_escape_string($row['empty_slip'] ?? '');
        $item_name = $connection->real_escape_string($row['item_name'] ?? '');
        $item_cases = $connection->real_escape_string($row['item_cases'] ?? '');

        // Debug: Log the current row data
       // echo "Processing row $key: Empty Slip: $empty_slip, Item Name: $item_name, Item Cases: $item_cases<br>";

        // Skip rows where required fields are truly missing
        if (empty($empty_slip) || empty($item_name) || $item_cases === '') {
            echo "";
            continue;
        }

        // Execute the prepared statement
        if ($stmt->execute()) {
            $success_count++;
            echo "";
        } else {
            $error_count++;
            echo "Error inserting row $key: " . $stmt->error . "<br>";
        }
    }

    // Display final success and error messages
    if ($success_count > 0) {
        echo "";
    }

    if ($error_count > 0) {
        echo "";
    }

    // Close the prepared statement and database connection
    $stmt->close();
    $connection->close();
}



?>

<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Add Return Cases</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
 #product-container-wrapper {
    max-height: 200px; /* Adjust the maximum height as needed */
    overflow-y: auto; /* Enable vertical scroll when content overflows */
}

 #item-container-wrapper {
    max-height: 500px; /* Adjust the maximum height as needed */
    overflow-y: auto; /* Enable vertical scroll when content overflows */
}

		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
label{
	  font-weight:600;
	  color:#000;
		}
		.btn-dark{
		    background:#0A4657;
		    color:#fff;
		    border:5px solid #0A4657;
		    
		}
		.btn-dark:hover{
		    background:#fff;
		    color:#0A4657;
		    border:5px solid #0A4657;
		}
		
		 #dispatch-dropdown {
            position: absolute;
            z-index: 1000;
            background: white;
            border: 1px solid #ccc;
            width: 80%;
            max-height: 200px;
            overflow-y: auto;
            display: none;
        }

        .dropdown-item {
            padding: 5px;
            cursor: pointer;
        }

        .dropdown-item:hover {
            background-color: #f0f0f0;
        }
		
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
 <div class="container-fluid">
        <div class="row">
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;" > Add Return Cases(Empty)</h3>
                
            </div>
            <div class="col-sm-3">
               
            </div>
        </div>
       
    </div>
    <br><br>

<form action="add_return.php" method="post">
     <input type="hidden" name="dynamic_data" id="dynamic_data">
    <!-- Static fields like dispatch_id, bility_no, etc. -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-4" style="background:#E1E1E2;padding:10px;border-radius:7px;">
                <div class="form-group">
                    <label>Dispatch - ID</label>
                    <input type="text" name="dispatch_id" id="dispatch_id" class="form-control" style="background:#0A4657; color:#fff;">
                    <div id="dispatch-dropdown"></div>
                </div>
                <div class="form-group">
                    <label>Bility No.</label>
                    <input type="text" name="bility_no" id="bility_no" class="form-control" style="color:#000;">
                </div>
                <div class="form-group">
                    <label>Vehicle No.</label>
                    <input type="text" name="truck_no" id="truck_no" class="form-control" style="color:#000;">
                </div>
                <div class="form-group">
                    <label>Driver</label>
                    <input type="text" name="driver_name" id="driver_name" class="form-control" style="color:#000;">
                </div>
                <div class="form-group">
                    <label>Palet No.</label>
                    <input type="text" name="palet_no" id="palet_no" class="form-control" style="color:#000;">
                </div>
                <div class="form-group">
                    <label>Route</label>
                    <input type="text" name="route_name" id="route_name" class="form-control" style="color:#000;">
                </div>
                <!-- Submit Button -->
        <div class="form-group">
            <button type="submit" class="btn btn-dark form-control" style="font-weight:700;">Add Return Cases</button>
        </div>
            </div>

            <div class="col-sm-7">
                <h3 style="background:#0A4657;color:#fff;padding:10px; font-size:22px; font-weight:700; text-align:center; border-radius:7px; ">Return Cases</h3>
                <!-- Dynamic Rows Container -->
                <div id="dynamic-row-container">
                    <div class="row dynamic-row">
                        
                        <div class="col-sm-4">
                            <div class="form-group">
                                <input type="text" name="empty_slip[]" class="form-control" placeholder="Empty Slip No.">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <input type="text" name="item_name[]" class="form-control" placeholder="Item Name">
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <input type="text" name="item_cases[]" class="form-control" placeholder="Item Cases">
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <button type="button" class="btn btn-primary add-row" style="float:right; border-radius:40px;">+</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
    </div>
</form>

                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content-->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>


<script>
    const dispatchInput = document.getElementById("dispatch_id");
    const dispatchDropdown = document.getElementById("dispatch-dropdown");

    // Fetch matching dispatch IDs and show in dropdown
    dispatchInput.addEventListener("input", function () {
        const query = this.value.trim();

        if (query.length > 0) {
            fetch(`?query=${query}`)
                .then(response => response.json())
                .then(data => {
                    dispatchDropdown.innerHTML = "";
                    if (data.error) {
                        console.error(data.error);
                        return;
                    }

                    data.forEach(id => {
                        const item = document.createElement("div");
                        item.classList.add("dropdown-item");
                        item.textContent = id;
                        item.dataset.id = id; // Store dispatch_id for selection
                        dispatchDropdown.appendChild(item);
                    });

                    dispatchDropdown.style.display = "block";
                })
                .catch(error => console.error("Error fetching dispatch IDs:", error));
        } else {
            dispatchDropdown.style.display = "none";
        }
    });

    // Handle dropdown item selection
    dispatchDropdown.addEventListener("click", function (e) {
        const selectedItem = e.target;
        if (selectedItem.classList.contains("dropdown-item")) {
            const dispatchId = selectedItem.dataset.id;
            dispatchInput.value = dispatchId; // Set input value
            dispatchDropdown.style.display = "none"; // Hide dropdown

            // Fetch and populate dispatch details
            fetch(`?dispatch_id=${dispatchId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        alert(data.error);
                        return;
                    }

                    // Populate input fields
                    document.getElementById("bility_no").value = data.bility_no || '';
                    document.getElementById("truck_no").value = data.truck_no || '';
                    document.getElementById("driver_name").value = data.driver_name || '';
                    document.getElementById("palet_no").value = data.palet_no || '';
                    document.getElementById("route_name").value = data.route_name || '';

                    // Populate the table
                    const tableBody = document.querySelector("#dispatchTable tbody");
                    tableBody.innerHTML = ""; // Clear existing rows
                    data.orders.forEach(order => {
                        const row = document.createElement("tr");
                        row.innerHTML = `
                            <td style="color:#000; font-weight:700; ">${order.sale_order || ''}</td>
                            <td style="color:#000; font-weight:700; text-transfrom:capitalize; ">${order.item_name || ''}</td>
                            <td style="color:#000; font-weight:700; ">${order.quantity || ''}</td>
                        `;
                        tableBody.appendChild(row);
                    });
                })
                .catch(error => console.error("Error fetching dispatch details:", error));
        }
    });

    // Close dropdown if clicked outside
    document.addEventListener("click", function (e) {
        if (!dispatchDropdown.contains(e.target) && e.target !== dispatchInput) {
            dispatchDropdown.style.display = "none";
        }
    });
    


</script>

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
<script>

$(document).ready(function () {
    // Add new row functionality
    $(document).on('click', '.add-row', function () {
        const newRow = `
            <div class="row dynamic-row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <input type="text" name="empty_slip[]" class="form-control" placeholder="Empty Slip No.">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <input type="text" name="item_name[]" class="form-control" placeholder="Item Name">
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <input type="text" name="item_cases[]" class="form-control" placeholder="Item Cases">
                    </div>
                </div>
                <div class="col-sm-2">
                    <button type="button" class="btn btn-danger remove-row" style="float:right;">-</button>
                </div>
            </div>`;
        
        $('#dynamic-row-container').append(newRow);
    });

    // Remove row functionality
    $(document).on('click', '.remove-row', function () {
        $(this).closest('.dynamic-row').remove();
    });

    // Form submission handler
    $('form').on('submit', function (e) {
        e.preventDefault();

        const dynamicRows = [];
        $('#dynamic-row-container .dynamic-row').each(function () {
            const emptySlip = $(this).find('input[name="empty_slip[]"]').val().trim();
            const itemName = $(this).find('input[name="item_name[]"]').val().trim();
            const itemCases = $(this).find('input[name="item_cases[]"]').val().trim();

            if (emptySlip && itemName && itemCases) {
                dynamicRows.push({ empty_slip: emptySlip, item_name: itemName, item_cases: itemCases });
            }
        });

        // Debug: Log collected rows
        console.log('Collected Rows:', dynamicRows);

        if (dynamicRows.length > 0) {
            const jsonData = JSON.stringify(dynamicRows);
            $('#dynamic_data').val(jsonData); // Populate hidden input
            console.log('Serialized Form Data:', $(this).serialize());
            this.submit(); // Submit the form after populating dynamic_data
        } else {
            alert('No rows to submit!');
        }
    });
});



</script>
</body>

</html>