<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Driver Ledger Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
    
    
 #table-container{
    max-height: 1190px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Driver Ledger Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>



<?php

$driver_name = isset($_GET['driver_name']) ? $_GET['driver_name'] : '';
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

if (!empty($driver_name)) {  // ✅ Report works only when a driver is selected

    // Initialize totals for each type with zero
    $totals = [
        "Opening Balance" => [],
        "Salary Payable" => [],
        "Commission Payable" => [],
        "IBL Stock Commission" => [],
        "Clearance Commission" => [],
        "Salary Paid" => [],
        "Commission Paid" => []
    ];

    $closing_balance = 0;

    // Define the tables, columns, and types
    $tables = [
        "opening_salari" => ["emp_name1", "emp_amount", "Opening Balance"],
        "adv_salari" => ["emp_name", "emp_adv", "Salary Payable"],
        "dispatch" => ["driver_name", "plt_com", "dispatch_date", "dispatch_id", "Commission Payable"],  // Updated dispatch query
        "ibl_stock" => ["driver_name", "plt_com", "IBL Stock Commission"],
        "cl_stock" => ["driver_name", "driver_total_amount", "Clearance Commission"],
        "salari_paid" => ["emp_name", "emp_paid", "Salary Paid"],
        "plt_paid" => ["emp_name", "amount", "Commission Paid"]
    ];

    foreach ($tables as $table => $columns) {
        $col_name = $columns[0];
        $amount_col = $columns[1];
        $type = $columns[2];

        // Special case for dispatch table to include grouping by dispatch_id and ordering by dispatch_date
        if ($table === 'dispatch') {
            $dispatch_date_col = $columns[2];
            $dispatch_id_col = $columns[3];
            $type = $columns[4];

            $query = "SELECT $dispatch_date_col, $dispatch_id_col, '$type' AS type, COALESCE(SUM($amount_col), 0) AS total 
                      FROM $table 
                      WHERE $col_name='$driver_name'";

            if (!empty($start_date) && !empty($end_date)) {
                $query .= " AND $dispatch_date_col BETWEEN '$start_date' AND '$end_date'";
            }

            $query .= " GROUP BY $dispatch_id_col ORDER BY $dispatch_date_col ASC";
        } else {
            // SQL Query with COALESCE to return 0 if no rows match
            $query = "SELECT date_time, '$type' AS type, COALESCE(SUM($amount_col), 0) AS total 
                      FROM $table 
                      WHERE $col_name='$driver_name'";

            if (!empty($start_date) && !empty($end_date)) {
                $query .= " AND date_time BETWEEN '$start_date' AND '$end_date'";
            }

            $query .= " GROUP BY date_time";
        }

        $result = mysqli_query($connection, $query);

        // Fetch and add rows to totals
        while ($row = mysqli_fetch_assoc($result)) {
            $totals[$type][] = [
                'date_time' => $row['date_time'] ?? $row[$dispatch_date_col],
                'amount' => $row['total']
            ];

            // Adjust the closing balance
            if (in_array($type, ["Opening Balance", "Salary Payable", "Commission Payable", "IBL Stock Commission", "Clearance Commission"])) {
                $closing_balance += $row['total'];
            } else { // For Salary Paid and Commission Paid
                $closing_balance -= $row['total'];
            }
        }

        // If no data is returned, ensure the type is present with default values
        if (empty($totals[$type])) {
            $totals[$type][] = [
                'date_time' => 'No Data',
                'amount' => 0
            ];
        }
    }
}
?>

<div class="container-fluid" style="padding:50px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Driver Ledger Report</h3>
        </div>
    </div>

    <?php
    $d = mysqli_query($connection, "SELECT * FROM driver");
    ?>

    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Select Driver</label>
                    <select name="driver_name" class="form-control">
                        <option value="">Select</option>
                        <?php
                        while ($r = mysqli_fetch_array($d)) {
                            echo '<option value="' . $r["driver_name"] . '" ' . ($driver_name == $r["driver_name"] ? "selected" : "") . '>' . $r["driver_name"] . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $start_date ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $end_date ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_driverl.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button id="downloadExcel" class="btn btn-dark" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

    <?php if (!empty($driver_name)) { ?>
        <div id="table-container">
            <table id="patientTable" class="table table-bordered text-center bg-white">
                <tr class="bg-dark text-white text-bold">
                    <th>Date</th>
                    <th>Type</th>
                    <th>Amount</th>
                </tr>
                <?php foreach ($totals as $type => $entries) { ?>
                    <?php foreach ($entries as $entry) { ?>
                        <tr>
                            <td><?= $entry['date_time'] ?></td>
                            <td><?= $type ?></td>
                            <td><?= $entry['amount'] ?></td>
                        </tr>
                    <?php } ?>
                <?php } ?>
                <tr class="bg-light text-bold">
                    <td><strong>Closing Balance</strong></td>
                    <td colspan="2"><strong><?= $closing_balance ?></strong></td>
                </tr>
            </table>
        </div>
    <?php } ?>
</div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Driver Ledger" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Driver Ledger Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>