<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Vehicle Wise Dispatch Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
   
 #table-container{
    max-height: 1190px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Vehicle Wise Dispatch Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>

<div class="container-fluid" style="padding:50px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Vehicle Wise Dispatch Report</h3>
        </div>
    </div>
    <?php
    $d = mysqli_query($connection, "SELECT DISTINCT truck_num FROM truck ");
    ?>
    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Select Vehicle</label>
                    <select name="truck_num" class="form-control">
                        <option value="">Select</option>
                        <option value="ALL">All</option>
                        <?php
                        while ($r = mysqli_fetch_array($d)) {
                        ?>
                            <option value="<?php echo $r["truck_num"]; ?>" <?php echo isset($_GET['truck_num']) && $_GET['truck_num'] == $r["truck_num"] ? '' : ''; ?>>
                                <?php echo $r["truck_num"]; ?>
                            </option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo isset($_GET['start_date']) ? $_GET['start_date'] : ''; ?>">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
                </div>
            </div>
            
              <div class="col-sm-2">
                <div class="form-group">
                    <label>Search</label>
                    <input type="text" name="search_in" class="form-control">
                </div>
            </div>
            <div class="col-sm-3">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_disroute.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id="downloadExcel" type="button" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

    <div id="table-container">
        <table id="patientTable" class="table table-bordered text-center bg-white">
            <thead>
            <tr class="bg-dark text-white text-bold">
                <th>Sr#</th>
                <th>Vehicle</th>
                <th>Distributor</th>
                <th>Date</th>
                <th>6</th>
                <th>7</th>
                <th>8</th>
                <th>9</th>
                <th>10</th>
                <th>11</th>
                <th>12</th>
                <th>13</th>
                <th>14</th>
                <th>15</th>
                <th>16</th>
                <th>17</th>
                <th>18</th>
                <th>19</th>
                <th>20</th>
                <th>21</th>
                <th>22</th>
                <th>Total Trip</th>
            </tr>
            </thead>
            <tbody>
<?php
$sr_no = 1;

// Building the query based on filters
$filters = [];
if (!empty($_GET['truck_num']) && $_GET['truck_num'] !== "ALL") {
    $filters[] = "truck_no = '" . mysqli_real_escape_string($connection, $_GET['truck_num']) . "'";
}
if (!empty($_GET['start_date'])) {
    $filters[] = "DATE(dispatch_date) >= '" . mysqli_real_escape_string($connection, $_GET['start_date']) . "'";
}
if (!empty($_GET['end_date'])) {
    $filters[] = "DATE(dispatch_date) <= '" . mysqli_real_escape_string($connection, $_GET['end_date']) . "'";
}

// Constructing the WHERE clause
$filter_query = !empty($filters) ? "WHERE " . implode(" AND ", $filters) : "";

// Query with truck_no and distinct dispatch_id filtering
$query = "SELECT truck_no, dist_name, dispatch_date as report_date1, palet_no, COUNT(DISTINCT dispatch_id) as dispatch_count 
          FROM dispatch 
          $filter_query 
          AND palet_no BETWEEN 6 AND 22  
          GROUP BY truck_no, dist_name, dispatch_date, palet_no
          ORDER BY truck_no, dist_name, report_date1";
$result = mysqli_query($connection, $query);

// Initialize variables to store grouped data and pallet sums
$data = [];
$grand_totals = array_fill(6, 17, 0);

// Process query results
while ($row = mysqli_fetch_assoc($result)) {
    $truck_no = $row['truck_no'];
    $dist_name = $row['dist_name'];
    $report_date = $row['report_date1'];
    $palet_no = $row['palet_no'];
    $dispatch_count = $row['dispatch_count'];

    if (!isset($data[$truck_no])) {
        $data[$truck_no] = [];
    }

    if (!isset($data[$truck_no][$dist_name])) {
        $data[$truck_no][$dist_name] = [];
    }

    if (!isset($data[$truck_no][$dist_name][$report_date])) {
        $data[$truck_no][$dist_name][$report_date] = array_fill(6, 17, null);
    }

    $data[$truck_no][$dist_name][$report_date][$palet_no] = $dispatch_count;
    $grand_totals[$palet_no] += $dispatch_count;
}

// Render the grand total row
echo "<tr class='bg-light' style='font-weight:700;'>";
echo "<td colspan='4'><strong>Total</strong></td>";
for ($i = 6; $i <= 22; $i++) {
    echo "<td><strong>{$grand_totals[$i]}</strong></td>";
}
echo "<td><strong>" . array_sum($grand_totals) . "</strong></td>";
echo "</tr>";

// Render the grouped data in the table
foreach ($data as $truck_no => $distributors) {
    foreach ($distributors as $dist_name => $dates) {
        foreach ($dates as $report_date => $counts) {
            $total_pallets = array_sum(array_filter($counts));
            echo "<tr style='font-weight:500;'>";
            echo "<td>{$sr_no}</td>";
            echo "<td>{$truck_no}</td>";
            echo "<td style='COLOR:#0A4657; font-weight:700;'>{$dist_name}</td>";
            echo "<td>{$report_date}</td>";
            
            for ($i = 6; $i <= 22; $i++) {
                echo "<td>" . (!empty($counts[$i]) ? $counts[$i] : '') . "</td>";
            }

            echo "<td>{$total_pallets}</td>";
            echo "</tr>";
            $sr_no++;
        }
    }
}
?>
</tbody>
</table>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true); 
        var rows = clone.querySelectorAll('tr');
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Vehicle Wise Dispatch" });
        try {
            XLSX.writeFile(workbook, 'Vehicle Wise Dispatch Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $('input[name="search_in"]').on('keyup', function() {
            var searchValue = $(this).val().toLowerCase();
            $('#patientTable tbody tr').each(function() {
                var rowText = $(this).text().toLowerCase();
                $(this).toggle(rowText.indexOf(searchValue) > -1);
            });
        });
    });
</script>
</body>
</html>
