<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Check if session variables are set
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
} else {
    // Redirect to login page or handle the error
    echo "Session variables not set. Please log in.";
    exit;
}

// Handle AJAX request to fetch plt_type1_com based on the selected plt_type1
if (isset($_POST['ajax']) && isset($_POST['plt'])) {  // Fixed 'plt' in $_POST to match the AJAX request
    $plt = mysqli_real_escape_string($connection, $_POST['plt']);
    
    // Fetch plt_type1_com based on the plt_type1 from the database
    $query = "SELECT plt_type1_com FROM plt WHERE plt_type1 = '$plt'";
    $result = mysqli_query($connection, $query);
    
    if ($result && mysqli_num_rows($result) > 0) { // Check if query succeeded and returned rows
        $row = mysqli_fetch_assoc($result);
        
        // Return the plt_type1_com value as JSON
        echo json_encode(['plt_type1_com' => $row['plt_type1_com']]);
    } else {
        // Return an empty value if no results are found
        echo json_encode(['plt_type1_com' => '']);
    }
    exit;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $ibl_id = $_POST["ibl_id"];
    $date_time = $_POST["date_time"];
    $month = $_POST["month"];
    $bility_no = $_POST["bility_no"];
    $truck_no = $_POST["truck_no"];
    $driver_name = $_POST["driver_name"];
    $post_order = $_POST["post_order"];
    $palet_no = $_POST["palet_no"];
    $plt_com = $_POST["plt_com"];
    $load = $_POST["load_no"];
    $fre = $_POST["fre"];
    $pp = $_POST["pp"];
    $wp = $_POST["wp"];
    $green = $_POST["green"];
    $blue = $_POST["blue"];
    $red = $_POST["red"];
    $std = $_POST["std"];
    $sting = $_POST["sting"];
    mysqli_query($connection,"insert into ibl_stock(ibl_id,date_time,month,bility_no,truck_no,driver_name,post_order,palet_no,plt_com,load_no,fre,pp,wp,green,blue,red,std,sting,user_name,user_role,outlet_name,outlet_address)
    values('$ibl_id','$date_time','$month','$bility_no','$truck_no','$driver_name','$post_order','$palet_no','$plt_com','$load','$fre','$pp','$wp','$green','$blue','$red','$std','$sting','$userName','$userRole','$outlet_name','$outlet_address')");
  
}


ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Add IBL Stock</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
Label{
	 color:#000;
	 font-weight:700;
		}

 .form-control{
		    color:#000;
		    font-weight:500;
		}
		option{
		    font-weight:400;
		    color:#000;
		}
		.btn-dark{
		    color:#fff;
		}
	
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
 <div class="container">
        <div class="row">
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;"> Add IBL-Stock</h3>
                
            </div>
            <div class="col-sm-3">
               
            </div>
        </div>
       
    </div>
    <br>
    <?php

    ?>
    <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
    <div class="container-fluid" style="margin-left:20px;">
        
        <div class="row">
           
            <div class="col-sm-3" style="background:#E1E1E2; padding:20px; border-radius:7px; border:1px solid #ccc; ">
                
                    <div class="form-group">
                        <label>IBL Stock ID</label>
                        <input type="text" name="ibl_id" class="form-control"
                        value="<?php
			  $pr_id2 = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
			   echo $pr_id2; ?>" readonly> 
                    </div>
                    <div class="form-group">
                        <label>Date</label>
                        <input type="date" name="date_time" class="form-control" required />
                    </div>
                    <div class="form-group">
                        <label>Month</label>
                        <select name="month" class="form-control">
                            <option value="">Select</option>
                            <option value="january">January</option>
                            <option value="february">February</option>
                            <option value="march">March</option>
                            <option value="april">April</option>
                            <option value="may">May</option>
                            <option value="june">June</option>
                            <option value="july">July</option>
                            <option value="august">August</option>
                            <option value="september">September</option>
                            <option value="october">October</option>
                            <option value="november">November</option>
                            <option value="december">December</option>
                        </select>
                    </div>
<div class="form-group">
                        <label>Bility No.</label>
                        <input type="text" name="bility_no" class="form-control" />
                    </div>
                    <?php 
                    $vr = mysqli_query($connection,"select * from truck"); 
                    ?>
                    <div class="form-group">
                        <label>Vehicle No.</label>
                        
                        <select type="text" name="truck_no" class="form-control" >
                        <option value="">Select</option>
                        <?php  
                        while($r = mysqli_fetch_array($vr)){
                        ?>
                        <option value="<?php echo $r["truck_num"]; ?>"><?php echo $r["truck_num"]; ?></option>
                        <?php }
                        ?>
                        </select>
                    </div>
                    <?php 
                    $dr = mysqli_query($connection,"select * from driver"); 
                    ?>
                    <div class="form-group">
                        <label>Driver Name</label>
                        <Select  name="driver_name" class="form-control" >
                            <option value="">Select</option>
                            <?php while($row = mysqli_fetch_array($dr)){ ?>
                            <option value="<?php echo $row["driver_name"] ;?>"><?php echo $row["driver_name"]; ?></option>
                            <?php 
                            }
                            ?>
                            </select>
                    </div>
                    <div class="form-group">
                        <label>Posting Order#</label>
                        <input type="text" name="post_order" class="form-control" />
                    </div>
                    <?php
                    $plt_rec = mysqli_query($connection,"select * from plt");
                       ?>
                    <div class="form-group">
                        <label>Palet</label>
                        <select  name="palet_no" class="form-control"  id="plt-select" >
                                <option value="">Select</option>
                                 <?php
                                while($row5 = mysqli_fetch_array($plt_rec)){
                                ?>
                                <option value="<?php echo $row5["plt_type1"]; ?>"><?php echo $row5["plt_type1"]; ?></option>
                                <?php
                                }
                                ?>
                            </select>
                              
                    </div>
                    <div class="form-group">
                        <label>PLT - Com</label>
                        <input type="text" name="plt_com"  class="form-control">
                    </div>
                    <div class="form-group ">
                        <label>FREIGHT</label>
                        <input type="text" class="form-control inp" name="fre">
                    </div>
                    <div class="form-group">
                        <label>Load</label>
                        <input type="text" name="load_no" class="form-control" />
                    </div>
                    
                    
                
                    <hr />
                    <button class="btn btn-dark form-control" type="submit">Save IBL Stock</button>
                </div>
                 <div class="col-sm-9 ">
                <h3 class="text-center" style="width:100%; background:#0A4657; color:#fff; 
                padding:10px; border-radius:7px; font-weight:700;">IBL-Stock Items</h3>
                
                <div class="row">
                    
                    
                    <div class="form-group col-2">
                        <label>P.P</label>
                        <input type="text" class="form-control inp" name="pp">
                    </div>
                    
                    <div class="form-group col-2">
                        <label>W.P</label>
                        <input type="text" class="form-control inp" name="wp">
                    </div>
                    
                    <div class="form-group col-2">
                        <label>GREEN</label>
                        <input type="text" class="form-control inp" name="green">
                    </div>
                    
                    <div class="form-group col-2">
                        <label>BLUE</label>
                        <input type="text" class="form-control inp" name="blue">
                    </div>
                    
                    <div class="form-group col-2">
                        <label>RED</label>
                        <input type="text" class="form-control inp" name="red">
                    </div>
                    
                    <div class="form-group col-2">
                        <label>STD</label>
                        <input type="text" class="form-control inp" name="std">
                    </div>
                    <div class="form-group col-2">
                        <label>STING</label>
                        <input type="text" class="form-control inp" name="sting">
                    </div>
                    
                  
                </div>
            </div>
              
            </div>
              
           
            
        </div>
           </form>
           
    
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

      
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
<script>
$(document).ready(function() {
    $('#plt-select').change(function() {
        var selectedPlt = $(this).val();

        // Make an AJAX request to fetch the plt_type1_com based on the selected plt_type1
        $.ajax({
            url: 'add_ibl.php',  // Same file
            method: 'POST',
            data: { plt: selectedPlt, ajax: true },  // Send plt and ajax flag
            dataType: 'json',
            success: function(response) {
                if (response.plt_type1_com) {
                    // Set the plt_type1_com value in the input field
                    $('#plt_type1_com').val(response.plt_type1_com);  // Corrected key to match response
                } else {
                    $('#plt_type1_com').val('');
                }
            },
            error: function() {
                alert('Error fetching plt_type1_com.');
            }
        });
    });
});
    
</script>
</body>

</html>