<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Distribution Wise Dispatch Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
        font-family: 'Quicksand', sans-serif;
    }
    #table-container{
        max-height: 1190px; 
        overflow-y: auto; 
    }
    .bg {
        background: linear-gradient(270deg, #060606, #0A4657);
    }
    label {
        font-size: 13.5px;
        font-weight: 700;
    }
    .text-bold {
        font-weight: 700;
    }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
            <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Distribution Wise Dispatch Report</h3>
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>

<div class="container-fluid" style="padding:50px;">
    <div class="row">
        <div class="col-sm-12">
            <h3 style="font-weight:800; color:#000; font-size:35px;">Distribution Wise Dispatch Report</h3>
        </div>
    </div>
    <?php
    $d = mysqli_query($connection, "SELECT DISTINCT dist_name FROM dist  ");
    ?>
    <form method="GET" action="">
        <div class="row">
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Select Distributor</label>
                    <select name="dist_name" class="form-control">
                        <option value="">Select</option>
                        <option value="ALL">All</option>
                        <?php
                        while ($r = mysqli_fetch_array($d)) {
                        ?>
                            <option value="<?php echo $r["dist_name"]; ?>" <?php echo isset($_GET['dist_name']) && $_GET['dist_name'] == $r["dist_name"] ? '' : ''; ?>>
                                <?php echo $r["dist_name"]; ?>
                            </option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?php echo isset($_GET['start_date']) ? $_GET['start_date'] : ''; ?>">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?php echo isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Search</label>
                    <input type="text" name="search_in" class="form-control">
                </div>
            </div>
            <div class="col-sm-2">
                <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
                <a href="report_disroute.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                <button class="btn btn-dark" id="downloadExcel" style="margin-top:30px;">Download</button>
            </div>
        </div>
    </form>

    <div id="table-container">
        <table id="patientTable" class="table table-bordered text-center bg-white">
            <thead>
                
            <tr class="bg-dark text-white text-bold">
                <th>Sr#</th>
                <th>Distributor</th>
                <th>Vehicle No</th>
                <th>Driver</th>
                <th>Date</th>
                <th>6</th>
                <th>7</th>
                <th>8</th>
                <th>9</th>
                <th>10</th>
                <th>11</th>
                <th>12</th>
                <th>13</th>
                <th>14</th>
                <th>15</th>
                <th>16</th>
                <th>17</th>
                <th>18</th>
                <th>19</th>
                <th>20</th>
                <th>21</th>
                <th>22</th>
                <th>Total Trip</th>
            </tr>
            </thead>
            <tbody>
<?php
$sr_no = 1;

// Building the query based on filters
$filters = [];
if (!empty($_GET['dist_name']) && $_GET['dist_name'] !== "ALL") {
    $filters[] = "dist_name = '" . mysqli_real_escape_string($connection, $_GET['dist_name']) . "'";
}
if (!empty($_GET['start_date'])) {
    $filters[] = "DATE(dispatch_date) >= '" . mysqli_real_escape_string($connection, $_GET['start_date']) . "'";
}
if (!empty($_GET['end_date'])) {
    $filters[] = "DATE(dispatch_date) <= '" . mysqli_real_escape_string($connection, $_GET['end_date']) . "'";
}

// Constructing the WHERE clause
$filter_query = !empty($filters) ? "WHERE " . implode(" AND ", $filters) : "";

// Updated query to count distinct dispatch_id for dist_name

$query = "SELECT 
            dispatch_id, 
            dist_name, 
            truck_no, 
            driver_name, 
            DATE(dispatch_date) as report_date, 
            palet_no, 
            COUNT(DISTINCT dispatch_id) as dispatch_count 
          FROM dispatch 
          $filter_query AND palet_no BETWEEN 6 AND 22  
          GROUP BY dispatch_id, palet_no ";



$result = mysqli_query($connection, $query);

// Initialize variables to store grouped data and pallet sums
$data = [];
$grand_totals = array_fill(6, 17, 0); // Stores sum for each pallet number (6 to 22)

while ($row = mysqli_fetch_assoc($result)) {
    $dist_name = $row['dist_name'];
    $driver_name = $row['driver_name'];  // Ensure correct variable
    $truck_no = $row['truck_no'];        // Ensure correct variable
    $report_date = $row['report_date'];
    $palet_no = $row['palet_no'];
    $dispatch_count = $row['dispatch_count'];

    if (!isset($data[$dist_name])) {
        $data[$dist_name] = [];
    }

    if (!isset($data[$dist_name][$report_date])) {
        $data[$dist_name][$report_date] = [
            'driver_name' => [],
            'truck_no' => [],
            'pallets' => array_fill(6, 17, null)
        ];
    }

    // Store driver_name & truck_no uniquely
    if (!in_array($driver_name, $data[$dist_name][$report_date]['driver_name'])) {
        $data[$dist_name][$report_date]['driver_name'][] = $driver_name;
    }
    if (!in_array($truck_no, $data[$dist_name][$report_date]['truck_no'])) {
        $data[$dist_name][$report_date]['truck_no'][] = $truck_no;
    }

    $data[$dist_name][$report_date]['pallets'][$palet_no] = $dispatch_count;
    $grand_totals[$palet_no] += $dispatch_count;
}

// Render the grand total row
echo "<tr class='bg-light'>";
echo "<td colspan='5'><strong>Total</strong></td>";
for ($i = 6; $i <= 22; $i++) {
    echo "<td><strong>{$grand_totals[$i]}</strong></td>";
}
echo "<td><strong>" . array_sum($grand_totals) . "</strong></td>";
echo "</tr>";

foreach ($data as $dist_name => $dates) {
    foreach ($dates as $report_date => $details) {
        $total_pallets = array_sum(array_filter($details['pallets']));
        echo "<tr>";
        echo "<td>{$sr_no}</td>";
        echo "<td style='color:#0A4657; font-weight:700;'>{$dist_name}</td>";

        // Join multiple drivers/trucks into a single cell
        echo "<td style='color:#0A4657; font-weight:700;'>" . implode(", ", $details['truck_no']) . "</td>";
        echo "<td style='color:#0A4657; font-weight:700;'>" . implode(", ", $details['driver_name']) . "</td>";

        echo "<td>{$report_date}</td>";

        for ($i = 6; $i <= 22; $i++) {
            echo "<td>" . (!empty($details['pallets'][$i]) ? $details['pallets'][$i] : '') . "</td>";
        }

        echo "<td>{$total_pallets}</td>";
        echo "</tr>";
        $sr_no++;
    }
}

?>
</tbody>
        </table>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>

<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        var table = document.getElementById('patientTable');
        var clone = table.cloneNode(true); 
        var rows = clone.querySelectorAll('tr');
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Patients" });
        try {
            XLSX.writeFile(workbook, 'Distribution Wise Disptach Report_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $('input[name="search_in"]').on('keyup', function() {
            var searchValue = $(this).val().toLowerCase();
            $('#patientTable tbody tr').each(function() {
                var rowText = $(this).text().toLowerCase();
                $(this).toggle(rowText.indexOf(searchValue) > -1);
            });
        });
    });
</script>

</body>
</html>