<?php
include("db/cn.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start();
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ob_end_flush();

// Fetch employee list for dropdown
$employees = mysqli_query($connection, "SELECT DISTINCT emp_name FROM e_salary");

if (isset($_POST['filter'])) {
    $emp_name = $_POST['supplier'];
    $startDate = $_POST['startDate'];
    $endDate = $_POST['endDate'];

    // Query to fetch the last opening salary before or on the exact start date
    $query_opening = "SELECT emp_amount AS opening, amount_type, date_time AS trans_date 
                      FROM opening_salari 
                      WHERE emp_name1 = '$emp_name' 
                      AND date_time >= '$startDate'
                      ORDER BY date_time DESC 
                      LIMIT 1";

    $result_opening = mysqli_query($connection, $query_opening);

    // Check if the query succeeded and returned rows
    if ($result_opening && mysqli_num_rows($result_opening) > 0) {
        $opening_row = mysqli_fetch_assoc($result_opening);
        $opening_salary = $opening_row['opening'];

        // Adjust the opening salary based on the amount_type
        if ($opening_row['amount_type'] === 'dr') {
            $opening_salary = -abs($opening_salary);
        } elseif ($opening_row['amount_type'] === 'cr') {
            $opening_salary = abs($opening_salary);
        }
    } else {
        $opening_salary = 0; // Default to zero if no opening balance is found
    }

    // Fetch payable transactions for the employee within the date range
    $query_payable = "SELECT date_time AS trans_date, emp_adv AS amount, 'Payable' AS description 
                      FROM adv_salari 
                      WHERE emp_name = '$emp_name' AND date_time >= '$startDate' AND date_time <= '$endDate'";
    $payable_transactions = mysqli_query($connection, $query_payable);

    // Fetch paid transactions for the employee within the date range
    $query_paid = "SELECT date_time AS trans_date, emp_paid AS amount, 'Paid' AS description 
                   FROM salari_paid 
                   WHERE emp_name = '$emp_name' AND date_time >= '$startDate' AND date_time <= '$endDate'";
    $paid_transactions = mysqli_query($connection, $query_paid);

    // Initialize totals
    $total_payable = 0;
    $total_paid = 0;
    $running_balance = $opening_salary; // Start with adjusted opening balance

    // Combine opening, payable, and paid transactions into one array
    $transactions = [];

    // Add the opening balance to the transactions array with the start date
    $transactions[] = [
        'trans_date' => $startDate,
        'description' => 'Opening Balance',
        'amount' => $opening_salary
    ];

    // Add all payable transactions if query succeeded
    if ($payable_transactions) {
        while ($row = mysqli_fetch_assoc($payable_transactions)) {
            $transactions[] = $row;
        }
    }

    // Add all paid transactions if query succeeded
    if ($paid_transactions) {
        while ($row = mysqli_fetch_assoc($paid_transactions)) {
            $transactions[] = $row;
        }
    }

    // Sort transactions by date
    usort($transactions, function($a, $b) {
        return strcmp($a['trans_date'], $b['trans_date']);
    });

    // Logic to carry over the closing balance as the opening of the next day
    $last_date = null;  // Track the date of the last processed transaction
    $carried_balance = $running_balance; // Track the carried-over balance
    $final_transactions = []; // Store the final sequence with balance carried over

    foreach ($transactions as $transaction) {
        $current_date = $transaction['trans_date'];

        // If the date changes, insert a new opening balance for the next day
        if ($last_date && $current_date != $last_date) {
            $next_day = date('Y-m-d', strtotime($last_date . ' +1 day'));
            $final_transactions[] = [
                'trans_date' => $next_day,
                'description' => 'Opening Balance',
                'amount' => 0, // Opening balance does not have an amount, just the balance carried over
                'balance' => $carried_balance
            ];
        }

        // Update the running balance based on the transaction type
        if ($transaction['description'] === 'Payable') {
            $total_payable += $transaction['amount'];
            $carried_balance += $transaction['amount'];
        } elseif ($transaction['description'] === 'Paid') {
            $total_paid += (int)$transaction['amount'];
            $carried_balance -= (int)$transaction['amount'];
        }

        // Add the transaction to the final list, including the running balance
        $transaction['balance'] = $carried_balance;
        $final_transactions[] = $transaction;

        // Update the last_date for the next iteration
        $last_date = $current_date;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Salary Ledger Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
 #table-container-wrapper {
    max-height: 460px; /* Adjust the maximum height as needed */
    overflow-y: auto; /* Enable vertical scroll when content overflows */
}

body {
    font-family: 'Quicksand', sans-serif;
    
}
.bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }

        label {
            font-size: 13.5px;
            font-weight: 700;
        }
.text-bold{
    font-weight:700;
}
  </style>

<body id="page-top">

<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/d.png" style="margin-top:5px;" width="56" height="56">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;margin-top:20px;">Salary ledger Report</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="dashboard.php" class="btn btn-light" style="margin-top:20px; float:right;font-weight:700;" >Back</a>
        </div>
    </div>
</div>  
                
                      <div class="container mt-5" style="max-width:1400px;">
            <div class="row">
        <div class="col-sm-3">
    <h3 style="font-weight:700; color:#060606;">Salary Ledger Report</h3>
        </div>
        <div class="col-sm-6"></div>
        <div class="col-sm-3">

        </div>
    </div>
        <br>
            <form method="post">
                <div class="row">
                    <div class="col-md-3">
    <div class="form-group">
        <label for="supplier">Employee Name:</label>
        <select class="form-control" name="supplier" required>
            <option value="">Select Employee</option>
            <?php while($row = mysqli_fetch_array($employees)): ?>
                <option class="text-capitalize" value="<?= $row['emp_name'] ?>" <?= isset($emp_name) && $emp_name == $row['emp_name'] ? 'selected' : '' ?>>
                    <?= $row['emp_name'] ?>
                </option>
            <?php endwhile; ?>
        </select>
    </div>
</div>

                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="startDate">Start Date:</label>
                            <input type="date" class="form-control" name="startDate" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="endDate">End Date:</label>
                            <input type="date" class="form-control" name="endDate" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                    <div class="form-group">
                        
                        <button type="submit" class="btn btn-dark" name="filter" style="margin-top:30px;">Filter</button>
                         <button id="downloadExcel" class="btn btn-dark " style="margin-top:30px;">Download </button>
                         <a href="report_salari.php"><button type="button" class="btn btn-dark"  style="margin-top:30px;"><i class="fas fa-sync-alt fa-1x"></i></button></a>


                    </div>
                    
                </div>
                </div>
<br>
                <!-- Show selected employee name -->
                <?php if(isset($emp_name)): ?>
                    <h5 class="text-center" style="background:#0A4657;color:#fff; padding:20px; border-radius:10px;">
                        Salary Ledger Report: <strong style="text-transform:capitalize;"><?= $emp_name ?></strong></h5>
                <?php endif; ?>

                <?php if(isset($final_transactions)): ?>
                    <div class="col-sm-12" id="table-container-wrapper">
<table id="patientTable" class="table table-striped table-hover text-center table-sm bg-white"> 
    <thead>
        <tr class="bg-dark text-white">
            <th>Date</th>
            <th>Description</th>
            <th>Debit Amount (Rs)</th>
            <th>Credit Amount (Rs)</th>
            <th>Balance (Rs)</th>
        </tr>
    </thead>
<tbody>
    <?php foreach ($final_transactions as $transaction): ?>
        <?php 
        // Initialize variables to hold debit (paid) and credit (payable) amounts
        $debitAmount = '';  // Paid amount goes to Debit
        $creditAmount = ''; // Payable amount goes to Credit
        
        // Special handling for the opening balance
        if ($transaction['description'] === 'Opening Balance') {
            // Check the amount_type: 'dr' goes to Debit, 'cr' goes to Credit
            if (isset($opening_row['amount_type'])) {
                if ($opening_row['amount_type'] === 'dr') {
                    $debitAmount = number_format(abs((float)$transaction['amount']), 2); // 'dr' shows in Debit
                } elseif ($opening_row['amount_type'] === 'cr') {
                    $creditAmount = number_format(abs((float)$transaction['amount']), 2); // 'cr' shows in Credit
                }
            }
        } else {
            // Assign the correct amount to the appropriate column based on the description for paid and payable
            if ($transaction['description'] === 'Paid') {
                $debitAmount = is_numeric($transaction['amount']) ? number_format((float)$transaction['amount'], 2) : '0.00';  // Paid amount in Debit
            } elseif ($transaction['description'] === 'Payable') {
                $creditAmount = is_numeric($transaction['amount']) ? number_format((float)$transaction['amount'], 2) : '0.00'; // Payable amount in Credit
            }
        }

        // Display the transaction row
        ?>
        <tr style="color:#060606;">
            <td><?= htmlspecialchars($transaction['trans_date']) ?></td>
            <td><?= htmlspecialchars($transaction['description']) ?></td>
            <td><?= $debitAmount ?></td>
            <td><?= $creditAmount ?></td>
            <td><?= is_numeric($transaction['balance']) ? number_format((float)$transaction['balance'], 2) : '0.00' ?></td>
        </tr>
    <?php endforeach; ?>
</tbody>


</table>





</div>


                    <div class="row">
                        <div class="col-sm-12">
                            <table class="table bg-white" style="color:#060606;">
                                <tfoot>
                                    <tr>
                                        <th>Opening Salary:</th>
                                        <td>Rs <?= number_format($opening_salary, 2) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Total Payable:</th>
                                        <td>Rs <?= number_format($total_payable, 2) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Total Paid:</th>
                                        <td>Rs <?= number_format($total_paid, 2) ?></td>
                                    </tr>
                                    <tr>
                                        <th>Final Balance:</th>
                                        <td>Rs <?= number_format($carried_balance, 2) ?></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>

            </form>
        </div>


    
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

         
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Salary Ledger" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Salary_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
</script>
      
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>