<?php
include("../db/cn.php");
ob_start();

// Fetch order details (kept from your original)
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = null;

if ($orderId) {
    $query = "SELECT * FROM add_challan WHERE order_id = '$orderId' && status='' && r_order_id = ''";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
    }
}

$content = ob_get_clean();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Delivery Challan - <?= htmlspecialchars($orderId) ?></title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300;500;600&display=swap" rel="stylesheet">

    <style>
        /* A4 portrait print */
        @page { size: A4 portrait; margin: 18mm 14mm; }
        html, body {
            font-family: 'Quicksand', system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
            color: #222;
            background: #fff;
            -webkit-print-color-adjust: exact;
        }
        .challan {
            max-width: 210mm;
            margin: 0 auto;
            padding: 12mm;
            box-sizing: border-box;
        }

        .header {
            display: flex;
            align-items: center;
            gap: 12px;
            border-bottom: 2px solid #222;
            padding-bottom: 8px;
        }
        .logo {
            width: 90px;
            height: 90px;
            object-fit: contain;
        }
        .store-info {
            flex: 1;
        }
        .store-name {
            font-size: 20px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.6px;
        }
        .store-address {
            font-size: 12.5px;
            margin-top: 4px;
            line-height: 1.25;
        }
        .meta {
            text-align: right;
            min-width: 160px;
        }
        .meta .meta-row { margin-bottom: 6px; font-weight: 600; }

        .title {
            text-align: center;
            margin: 14px 0;
            font-size: 18px;
            font-weight:700;
            text-transform: uppercase;
            letter-spacing: .6px;
        }

        .customer {
            display: flex;
            justify-content: space-between;
            gap: 12px;
            margin-bottom: 10px;
        }
        .customer .left, .customer .right { font-size: 13px; }
        .customer strong { font-weight:700; }

        table.products {
            width: 100%;
            border-collapse: collapse;
            margin-top: 6px;
            margin-bottom: 8px;
            font-size: 13px;
        }
        table.products thead th {
            border: 1px solid #222;
            padding: 6px 8px;
            background: #f1f1f1;
            font-weight:700;
            text-align: center;
        }
        table.products tbody td {
            border: 1px solid #222;
            padding: 6px 8px;
            vertical-align: middle;
            font-size: 12.8px;
        }
        .right { text-align: right; }
        .center { text-align: center; }

        .summary {
            margin-top: 8px;
            display: flex;
            justify-content: flex-end;
            gap: 12px;
            font-size: 13px;
        }
        .summary .box {
            min-width: 220px;
            border: 1px solid #222;
            padding: 8px;
            background: #fafafa;
        }
        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            gap: 12px;
        }
        .sig {
            width: 32%;
            border-top: 1px dashed #666;
            padding-top: 6px;
            text-align: center;
            font-size: 13px;
        }

        .notes {
            margin-top: 18px;
            font-size: 12px;
        }

        /* Buttons (hidden in print) */
        .actions {
            margin: 12px 0;
            display:flex;
            gap:8px;
        }
        .no-print { display:inline-block; }
        @media print {
            .no-print { display: none !important; }
            .challan { padding: 0; margin: 0; }
        }
    </style>
</head>
<body>
<div class="challan" id="challan">
    <div class="header">
        <div>
            <img src="../img/logo231.png" alt="Logo" class="logo">
        </div>

        <div class="store-info">
            <!-- Keep your Urdu store name / branding -->
            <div class="store-name" style="font-family: 'Quicksand', sans-serif;">
                باؤ جی بیٹری سنٹر
            </div>
            <div class="store-address">
                دکان نمبر 77 اے شعیب بلال مارکیٹ بالمقابل میاں ٹرسٹ مارکیٹ کمرشل روڈ فیصل آباد<br>
                M.Usman: 0321-7176596 | 0313-7176576
            </div>
        </div>

        <div class="meta">
            <div class="meta-row">Date: <span style="font-weight:600;"><?= htmlspecialchars($dateTime) ?></span></div>
            <div class="meta-row">Challan # : <span style="font-weight:600;"><?= htmlspecialchars($orderId) ?></span></div>
            <?php if(!empty($outletName)): ?>
            <div class="meta-row">Outlet: <span style="font-weight:600;"><?= htmlspecialchars($outletName) ?></span></div>
            <?php endif; ?>
        </div>
    </div>

    <div class="title">Delivery Challan</div>

    <div class="customer">
        <div class="left">
            <div><strong>Name:</strong> <?= htmlspecialchars($customerName) ?></div>
            <div><strong>Phone:</strong> <?= htmlspecialchars($customerPhone) ?></div>
        </div>
        <div class="right">
            <div><strong>Prepared By:</strong> <?= htmlspecialchars($loginUser) ?></div>
            <div><strong>Role:</strong> <?= htmlspecialchars($userRole) ?></div>
        </div>
    </div>

    <table class="products" role="table" aria-label="Products">
        <thead>
            <tr>
                <th style="width:6%;">Sr#</th>
                <th style="width:48%;">Product</th>
                <th style="width:12%;">Unit</th>
                <th style="width:12%;">Price</th>
                <th style="width:12%;">Qty</th>
                <th style="width:10%;">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $sr = 1;
                $grandTotal = 0;
                if (!empty($orderDetails)) {
                    foreach ($orderDetails as $item) {
                        $unit = isset($item['product_unit']) ? $item['product_unit'] : '-';
                        $price = isset($item['product_price']) ? $item['product_price'] : $item['price'] ?? 0;
                        $qty = isset($item['product_quantity']) ? $item['product_quantity'] : $item['quantity'] ?? 0;
                        $total = isset($item['net_amount']) ? $item['net_amount'] : ($price * $qty);
                        $grandTotal += (float)$total;
                        ?>
                        <tr>
                            <td class="center"><?= $sr++ ?></td>
                            <td><?= htmlspecialchars($item['product_name']) ?></td>
                            <td class="center"><?= htmlspecialchars($unit) ?></td>
                            <td class="right"><?= htmlspecialchars($price) ?></td>
                            <td class="center"><?= htmlspecialchars($qty) ?></td>
                            <td class="right"><?= htmlspecialchars($total) ?></td>
                        </tr>
                    <?php
                    }
                } else { ?>
                    <tr>
                        <td colspan="6" class="center">No items found for this order</td>
                    </tr>
                <?php } ?>
        </tbody>
    </table>

    <div class="summary">
        <div class="box">
            <div><strong>Sub Total:</strong> Rs <?= number_format($grandTotal,2) ?></div>
            <?php if(!empty($discounted) || !empty($discountedAmount)): ?>
                <div><strong>Discount:</strong> Rs <?= htmlspecialchars($discounted) ?> (<?= htmlspecialchars($discountPer) ?>%)</div>
                <div><strong>Net Total:</strong> Rs <?= htmlspecialchars($discountedAmount) ?></div>
            <?php endif; ?>
        </div>
    </div>

    <div class="notes">
        <strong>Notes:</strong>
        <ol>
            <li>This delivery challan is proof of goods dispatched. It is not a tax invoice.</li>
            <li>Please check the goods at the time of delivery and sign below if accepted.</li>
            <li>For any discrepancy contact the store within 24 hours.</li>
        </ol>
    </div>

    <div class="signatures">
        <div class="sig">Prepared By<br><small><?= htmlspecialchars($loginUser) ?></small></div>
        <div class="sig">Received By<br><small>Customer / Representative</small></div>
        <div class="sig">Authorized Signature<br><small>Store</small></div>
    </div>

    <div style="margin-top:18px; display:flex; gap:8px;">
        <button class="no-print" onclick="window.print()">Print</button>
        <!--<button type="button" class="no-print" onclick="downloadPDF()">Download PDF</button>-->
        <a class="no-print" href="order_detail_c.php" style="text-decoration:none;"><button>Exit</button></a>
    </div>
</div>

<!-- jsPDF (using html() method). Make sure the library is available. -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
    async function downloadPDF() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF('p', 'mm', 'a4');
        // Use html method (may need additional polyfills for fonts/images)
        await doc.html(document.getElementById('challan'), {
            x: 10,
            y: 10,
            html2canvas: { scale: 1.2 },
            callback: function (doc) {
                doc.save('delivery_challan_<?= preg_replace("/[^A-Za-z0-9]/", "_", $orderId) ?: "challan" ?>.pdf');
            }
        });
    }
</script>
</body>
</html>
