<?php
include('../db/cn.php');

$search = "";
if (isset($_GET['q'])) {
    $search = trim($_GET['q']);
    $stmt = $connection->prepare("SELECT * FROM products WHERE product_id LIKE ? OR product_name LIKE ?");
    $like = "%$search%";
    $stmt->bind_param("ss", $like, $like);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $connection->query("SELECT * FROM products");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Product Barcodes</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class="p-4 bg-light">
  <div class="container">
    <h2 class="mb-4">Product Barcodes</h2>
    <a href="addproduct.php" class="btn btn-dark">Back</a>
    <br>
    <form class="mb-4" method="get" action="">
      <div class="input-group">
        <input type="text" class="form-control" name="q" placeholder="Search by Product ID or Name" value="<?= htmlspecialchars($search) ?>">
        <button class="btn btn-primary">Search</button>
      </div>
    </form>

    <table class="table table-bordered table-striped align-middle text-center">
      <thead class="table-dark">
        <tr>
          <th>Product ID</th>
          <th>Product Name</th>
          <th>Retail Price</th>
          <th>Size</th>
          <th>Color</th>
          <th>Barcode</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php
      if ($result->num_rows > 0) {
          while ($row = $result->fetch_assoc()) {
              $barcode_url = "https://barcodeapi.org/api/code128/" . urlencode($row['product_id']);
              echo "
              <tr style='font-weight:700; text-transform:capitalize;'>
                <td>{$row['product_id']}</td>
                <td>{$row['product_name']}</td>
                <td>{$row['retail_price']}</td>
                <td>{$row['size']}</td>
                <td>{$row['color']}</td>
                <td><img src='{$barcode_url}' width='150'></td>
                <td>
                  <button class='btn btn-success btn-sm print-btn' 
                    data-id='{$row['product_id']}' 
                    data-name='{$row['product_name']}' 
                    data-price='{$row['retail_price']}'
                    data-barcode='{$barcode_url}'>
                    Print
                  </button>
                </td>
              </tr>
              ";
          }
      } else {
          echo "<tr><td colspan='7'>No products found</td></tr>";
      }
      ?>
      </tbody>
    </table>
  </div>

  <script>
  $(".print-btn").click(function() {
    const id = $(this).data("id");
    const name = $(this).data("name");
    const price = $(this).data("price");
    const barcode = $(this).data("barcode");


    const win = window.open('', '', 'height=600,width=800');
    win.document.write(`
      <html>
        <head>
          <title>Print Barcode</title>
          <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
          <style>
            @media print {
              .no-print { display: none !important; }
              body { margin-top:-10px; padding:; }
            }
            body {
              font-family: Arial, sans-serif;
              text-align: center;
              margin: 40px;
            }
            .label-box {
              border: ;
              padding: 0px;
              width: ;
              margin-top:-20px;
              text-align: center;
            }
            .title {
              font-weight: bold;
              font-size: 16px;
            }
            .barcode {
              margin: 10px 0;
            }
            .product-id {
              font-size: 14px;
              margin-bottom: 2px;
            }
            .product-name {
              font-size: 17px;
              text-transform: uppercase;
              font-weight:700;
           
            }
            .price {
              font-weight: bold;
              font-size: 20.5px;
              margin-top: 2px;
            }
          </style>
        </head>
        <body>
          <div class="label-box">
           <div class="product-name">${name}</div>
            <div class="barcode"><img src="${barcode}" width="300" height="66" alt="barcode"></div>
            
            <div class="price">RS. ${price} </div>
          </div>
          <br>
          <button onclick="window.print()" class="btn btn-primary no-print">Print</button>
        </body>
      </html>
    `);
    win.document.close();
  });
  </script>
</body>
</html>

<?php $connection->close(); ?>
