<?php
include("../db/cn.php");
include("common/tx.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

if (isset($_GET['query'])) {
    $query = $connection->real_escape_string($_GET['query']);
    $sql = "SELECT product_id, product_name, retail_price, trade_price, supplier, 
    company, product_unit, quantity FROM products WHERE product_name LIKE '%$query%' || product_id LIKE '%$query%'";

    $result = $connection->query($sql);

    $suggestions = "";
    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-product-id='" . $row['product_id'] . "' data-product-quantity='" . $row['quantity'] . "' data-retail-price='" . $row['trade_price'] . "' data-trade-price='" . $row['trade_price'] . "' data-trade-prices='" . $row['trade_price'] . "' data-supplier='" . $row['supplier'] . "' data-company='" . $row['company'] . "' data-product-unit='" . $row['product_unit'] . "'>" . $row['product_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}



if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT supplier_name, supplier_id, supplier_phone FROM supplier WHERE supplier_name LIKE '%$customerName%' LIMIT 5";
    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $crName = $row['supplier_name'];
        $crId = $row['supplier_id'];
        $phone = $row['supplier_phone'];

        // Fetch remain_balance from creditor_closing
        $remainSql = "SELECT closing_balance FROM supplier_closing WHERE supplier_name = '$crName' ORDER BY id DESC LIMIT 1";
        $remainResult = $connection->query($remainSql);
        $remainBalance = "0";
        if ($remainResult && $remainResult->num_rows > 0) {
            $remainRow = $remainResult->fetch_assoc();
            $remainBalance = $remainRow['closing_balance'];
        }

        $suggestions .= "<div class='dropdown-item' data-customer-name='$crName' data-customer-id='$crId' data-customer-phone='$phone' data-remain-balance='$remainBalance'>$crName</div>";
    }

    echo $suggestions;
    exit;
}


$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;



if (isset($_GET['inv_id'])) {
   

    // Get the search term
    $order_id = $_GET['inv_id'];

    if (!empty($order_id)) {
        // Query to search for order_ids in the log_user_sales table
        $stmt = $connection->prepare("SELECT inv_id FROM purchase WHERE inv_id LIKE ? GROUP BY inv_id");
        $like_order_id = "%" . $order_id . "%";
        $stmt->bind_param("s", $like_order_id);
        $stmt->execute();
        $result = $stmt->get_result();

        // Generate HTML output
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo '<div class="dropdown-item" data-order-id="' . $row['inv_id'] . '">' . $row['inv_id'] . '</div>';
            }
        } else {
            echo '<div class="dropdown-item">No Invoice found</div>';
        }

        $stmt->close();
    }

    $connection->close();
    exit; // End the PHP processing for AJAX request here
}


if ($_SERVER['REQUEST_METHOD'] === 'POST'&& isset($_POST['inv_bill'])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
	
    $orderId = 'INV-' . random_int(1000000, 9999999);
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $preAmount = $_POST['pre_amount'];
    $grandAmount = $_POST['grand_amount'];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['extraPer'];
        $disAmount = $product['disAmount'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = $tradePrice * $productQuantity;
		$tp = $productTotal / $productQuantity;
		
        $sql = "INSERT INTO purchase (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            dis_amount,
            tax,
            net_amount,
            total_amount,
            pre_amount,
            grand_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            inv_id,
			r_inv_id,
			status,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '',
            '$discount',
            '$disAmount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$preAmount',
            '$grandAmount',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
			'',
			'',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        $updateSql = "UPDATE products SET quantity = quantity + $productQuantity, total_amount = total_amount + $netAmount, trade_price =  $tp  WHERE product_name = '$productName'";
        if ($connection->query($updateSql) !== TRUE) {
            echo "Error updating product quantity: " . $connection->error;
            ob_end_flush();
            exit;
        }
    }
    ob_end_clean();
     echo "<script type='text/javascript'>window.location.href = 'print_invoice_p.php?inv_id=$orderId';</script>";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST'&& isset($_POST['return_bill'])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
	$r_inv_id = $_POST["r_inv_id"];
    $orderId = $r_inv_id ;
	$status = 'return';
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['extraPer'];
         $disAmount = $product['disAmount'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = $tradePrice * $productQuantity;
        $sql = "INSERT INTO purchase (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            dis_amount,
            tax,
            net_amount,
            total_amount,
            pre_amount,
            grand_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            inv_id,
			r_inv_id,
			status,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '',
            '$discount',
            '$disAmount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$preAmount',
            '$grandAmount',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
			'$r_inv_id',
			'$status',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        $updateSql = "UPDATE products SET quantity = quantity - $productQuantity, total_amount = total_amount - $netAmount WHERE product_name = '$productName'";
        if ($connection->query($updateSql) !== TRUE) {
            echo "Error updating product quantity: " . $connection->error;
            ob_end_flush();
            exit;
        }
    }
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'purchase_n.php';</script>";
}


ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $tx; ?></title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
 #table-container-wrapper {
    max-height: 390px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
tr{
    font-weight:700;
    background:#fff;
}
.form-control{
    font-weight:700;
}
.btn, .input-group-prepend{
 font-weight:700;   
}
.btn-primary{
    background:#0A4657;
    color:#fff;
    border:1px solid #0A4657;
}
.btn-primary:hover{
    background:#fff;
    color:#0A4657;
    border:1px solid #0A4657;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/logo231.png" style="margin-top:5px; background:#fff; border-radius:60px;" width="56" height="56" ></a>
        </div>
        <div class="col-sm-6">
        <h3 style="color:#fff; font-weight:700; text-transform:uppercase; text-align:center; line-height:60px; font-size:33px;">
            <?php echo $tx; ?></h3>
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php">
            <button type="button" class="btn btn-light mt-3" style="float:right;" >Back</button>
            </a>
        </div>
    </div>
</div>
<div class="container-fluid">
    <form action="purchase_n.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-3" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Product</span>
                    </div>
                    <input type="text" class="form-control" id="productInput" placeholder="Start typing a product name..." autocomplete="off">
                    <div class="dropdown-menu" id="suggestions"></div>
                </div>
                <hr>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Quantity</span>
                    </div>
                    <input type="text" id="quantity" name="quantity" class="form-control" placeholder="">
                </div>
                 <div class="">
                    <!--<div class="input-group-prepend">-->
                        <!--<span class="input-group-text bg-dark text-white">R.P</span>-->
                    <!--</div>-->
                    <input type="hidden" id="retail_prices" name="retail_prices" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Price / Unit</span>
                    </div>
                    <input type="text" id="trade_prices" name="trade_prices" class="form-control" placeholder="">
                </div>
                <div class="">
                    <div class="">
                       
                    </div>
                    <input type="hidden" id="retail_price" name="retail_price" class="form-control" placeholder="">
                </div>
               
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="total_amount" name="total_amount" class="form-control" placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">-/ PKR</span>
                    </div>
                </div>
                <div class="row">
                 <div class="input-group mb-3 col-6">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis %</span>
                    </div>
                    <input type="text" id="percentage" name="percentage" class="form-control"  placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3 col-6">
                   
                    <input type="text" id="dis_amount" name="dis_amount" class="form-control" 
                    placeholder="" style="font-weight:700;">
                     <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis PKR</span>
                    </div>
                </div>
                </div>
                <div class="">
                    <div class="">
                       
                    </div>
                    <input type="hidden" id="sale_tax" name="sale_tax" class="form-control"  placeholder="" style="font-weight:700;">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="trade_price" name="trade_price" class="form-control" placeholder="" readonly>
                </div>
                <br>
                <button type="button" class="form-control btn btn-dark" id="makeEntry">Make Entry</button>
                <hr>
                <div class="row">
                <div class="col-6">
                <button type="button" class="form-control btn btn-dark" onclick="location.reload();">Refresh</button>
                </div>
                <div class="col-6">
                    <a href="purchase_detail_v.php" class="btn btn-primary form-control ">View Purchase</a>
                </div>
                </div>
            </div>
            <div class="col-sm-9">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="">
                        <div class="form-group">
                            
                            <input type="hidden" class="form-control in_form" name="customer_type">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Supplier Name</label>
                            <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                            <div class="dropdown-menu" id="customer_suggestions"></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Supplier Phone</label>
                            <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                        </div>
                    </div>
                    <div class="">
                        <div class="">
                  
                            <input type="hidden" id="customer_id" name="customer_id" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-3">
                    <div class="form-group">
                        <label>Return ID</label>
                        <input type="text" id="r_order_id" name="r_inv_id" class="form-control in_form">
                        <div id="order_suggestions" class="dropdown-menu" style="display: none;"></div>
                    </div>
                </div>
                </div>
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12" style="height:400px;">
                        <table class="table table-borderless table-sm text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#0A4657;">
                               <td>Item Code</td>
                                <td>Description</td>
                                <td>Qty</td>
                                <td>Unit Price</td>
                                <td>Amount</td>
                                <td>% Dis</td>
                                <td>Dis.PKR</td>
                                <td>Tax</td>
                                <td>Net Amount</td>
                                <td>Action</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="">
                                <div class="">
                                    
                                    <input type="hidden" step="0.01" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" step="0.01" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Previous</label>
                                    <input type="text" id="pre_amount" step="0.01" name="pre_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Grand Total</label>
                                    <input type="text" id="grand_amount"
                                    step="0.01" name="grand_amount" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount" step="0.01" name="discount_amount" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount %</label>
                                    <input type="number" id="discount_percent" step="0.01" name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Paid</label>
                                    <input type="number" id="cash_received" step="0.01" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Remaining</label>
                                    <input type="number" id="cash_return" step="0.01" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="">
                                <div class="">
                                    <input type="hidden" id="tax" name="tax" class="form-control in_form input-height"  readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method" class="form-control in_form">
                                        <option value="cash">Cash</option>
                                        <option value="credit">Credit</option>
                                        <option value="bank1">Bank 1</option>
                                        <option value="bank2">Bank 2 </option>
                                        <option value="bank3">Bank 3</option>
                                        <option value="others">Others</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-4">
                                <hr>
                                <button type="submit" class="btn btn-dark btn-sm" name="inv_bill" id="generateInvoiceBtn">Generate Invoice</button>
                                <button type="submit" class="btn btn-danger btn-sm" name="return_bill">Return Invoice</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const generateInvoiceButton = document.querySelector("button[name='inv_bill']");
    const returnInvoiceButton = document.querySelector("button[name='return_bill']");

    generateInvoiceButton.addEventListener("click", function(event) {
        const method = document.getElementById("method2").value;
        const supplierName = document.getElementById("customer_name").value.trim();

        // Check if method is "Credit" and supplier name is empty
        if (method === "Credit" && supplierName === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please fill in the Supplier Name for Credit method.");
        }
    });

    returnInvoiceButton.addEventListener("click", function(event) {
        const returnId = document.getElementById("r_order_id").value.trim();

        // Check if Return ID is empty when "Return Invoice" button is clicked
        if (returnId === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please enter a Return ID.");
        }
    });
});
</script>
<script>
    
document.addEventListener("DOMContentLoaded", function() {
    let currentFocus = -1;

    // Event listener for input field to trigger AJAX request
    document.getElementById("r_order_id").addEventListener("input", function() {
        var orderIdInput = this.value;
        if (orderIdInput.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?inv_id=" + encodeURIComponent(orderIdInput), true); // Sends request to the same page
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("order_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("order_suggestions").style.display = 'none';
        }
    });

    // Handle clicking on suggestion items
    document.getElementById("order_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectOrder(e.target);
        }
    });

    // Add keyboard navigation for dropdown items
    document.getElementById("r_order_id").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("order_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectOrder(items[currentFocus]);
                    }
                }
            }
        }
    });
    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectOrder(item) {
        var orderId = item.getAttribute('data-order-id');
        document.getElementById("r_order_id").value = orderId;
        document.getElementById("order_suggestions").style.display = 'none';
    }


       document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

  function selectCustomer(item) {
    var customerName = item.getAttribute('data-customer-name');
    var customerId = item.getAttribute('data-customer-id');
    var customerPhone = item.getAttribute('data-customer-phone');
    var remainBalance = item.getAttribute('data-remain-balance');

    document.getElementById("customer_name").value = customerName;
    document.getElementById("customer_phone").value = customerPhone;
    document.getElementById("customer_id").value = customerId;
    document.getElementById("pre_amount").value = remainBalance; // populate remain_balance

    document.getElementById("customer_suggestions").style.display = 'none';
}

function updatePriceFromPercentage() {
const quantity = parseFloat(document.getElementById("quantity").value);
const pricePerUnit = parseFloat(document.getElementById("trade_prices").value);
const discountPercentage = parseFloat(document.getElementById("percentage").value);


if (isNaN(quantity) || isNaN(pricePerUnit) || isNaN(discountPercentage)) return;


const totalAmount = quantity * pricePerUnit;
const discountAmount = (totalAmount * discountPercentage) / 100;
const afterDiscount = totalAmount - discountAmount;


document.getElementById("total_amount").value = totalAmount.toFixed(2);
document.getElementById("dis_amount").value = discountAmount.toFixed(2);


applyFinalPrice(afterDiscount);
}


function updatePriceFromAmount() {
const quantity = parseFloat(document.getElementById("quantity").value);
const pricePerUnit = parseFloat(document.getElementById("trade_prices").value);
const discountAmount = parseFloat(document.getElementById("dis_amount").value);


if (isNaN(quantity) || isNaN(pricePerUnit) || isNaN(discountAmount)) return;


const totalAmount = quantity * pricePerUnit;
const discountPercentage = (discountAmount / totalAmount) * 100;
const afterDiscount = totalAmount - discountAmount;


document.getElementById("total_amount").value = totalAmount.toFixed(2);
document.getElementById("percentage").value = discountPercentage.toFixed(2);


applyFinalPrice(afterDiscount);
}


function calculateTotalPrice() {
const quantity = parseFloat(document.getElementById("quantity").value);
const pricePerUnit = parseFloat(document.getElementById("trade_prices").value);


if (isNaN(quantity) || isNaN(pricePerUnit)) return;


const totalAmount = quantity * pricePerUnit;
document.getElementById("total_amount").value = totalAmount.toFixed(2);


applyFinalPrice(totalAmount);
}


function applyFinalPrice(baseAmount) {
const saleTaxPercentage = parseFloat(document.getElementById("sale_tax").value);
const saleTaxAmount = isNaN(saleTaxPercentage) ? 0 : (baseAmount * saleTaxPercentage) / 100;
const finalPrice = baseAmount + saleTaxAmount;


document.getElementById("trade_price").value = finalPrice.toFixed(2);
}


// Event Listeners with Debounce
document.getElementById("quantity").addEventListener("input", debounce(calculateTotalPrice));
document.getElementById("trade_prices").addEventListener("input", debounce(calculateTotalPrice));
document.getElementById("percentage").addEventListener("input", debounce(updatePriceFromPercentage));
document.getElementById("dis_amount").addEventListener("input", debounce(updatePriceFromAmount));
document.getElementById("sale_tax").addEventListener("input", debounce(() => {
    
const totalAmount = parseFloat(document.getElementById("total_amount").value);
if (!isNaN(totalAmount)) applyFinalPrice(totalAmount);
}));

// Debounce helper
function debounce(fn, delay = 300) {
    let timer;
    return function (...args) {
        clearTimeout(timer);
        timer = setTimeout(() => fn.apply(this, args), delay);
    };
}

    document.getElementById("suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectProduct(e.target);
        }
    });

    document.getElementById("productInput").addEventListener("input", function() {
        var query = this.value;
        if (query.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?query=" + query, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("suggestions").style.display = 'none';
        }
    });

    document.getElementById("productInput").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectProduct(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectProduct(item) {
        var selectedProduct = item.textContent;
        var retailPrice = item.getAttribute('data-retail-price');
        var productQuantity = item.getAttribute('data-product-quantity');
        var tradePrice = item.getAttribute('data-trade-price');
        var tradePrices = item.getAttribute('data-trade-prices');
        var productId = item.getAttribute('data-product-id');
        var supplier = item.getAttribute('data-supplier');
        var company = item.getAttribute('data-company');
        var productUnit = item.getAttribute('data-product-unit');

        document.getElementById("productInput").value = selectedProduct;
        document.getElementById("retail_price").value = retailPrice;
        document.getElementById("trade_prices").value = tradePrices;
        document.getElementById("productInput").setAttribute('data-product-id', productId);
        document.getElementById("productInput").setAttribute('data-product-quantity', productQuantity);
        document.getElementById("productInput").setAttribute('data-supplier', supplier);
        document.getElementById("productInput").setAttribute('data-company', company);
        document.getElementById("productInput").setAttribute('data-trade-price', tradePrice);
        document.getElementById("productInput").setAttribute('data-product-unit', productUnit);

        document.getElementById("suggestions").style.display = 'none';
        calculateTotalPrice();
    }

 document.getElementById("makeEntry").addEventListener("click", function() {
        var productInput = document.getElementById("productInput");
        var productId = productInput.getAttribute('data-product-id');
        var productQuantity = parseFloat(document.getElementById("quantity").value) || 0; // Parse the quantity and ensure it's a number
        var supplier = productInput.getAttribute('data-supplier');
        var company = productInput.getAttribute('data-company');

        var description = productInput.value;
        var quantity = productQuantity;
        var pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
        var totalPrice = parseFloat(document.getElementById("total_amount").value) || 0;
        var discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
        var netAmount = parseFloat(document.getElementById("trade_price").value) || 0;
        var disAmount = parseFloat(document.getElementById("dis_amount").value) || 0;
        var extraPer = parseFloat(document.getElementById("sale_tax").value) || 0;
        var tradePrice = productInput.getAttribute('data-trade-price');

        // Check if quantity is zero or negative before making the entry
        if (quantity <= 0) {
            alert("Product is not in stock. Cannot add entry.");
            return; // Stop execution if quantity is zero or negative
        }

        if (productId && description && quantity && pricePerUnit && totalPrice && netAmount) {
            var table = document.getElementById("productsTable");
            var row = table.insertRow();
            row.innerHTML = `
                <td style="display:none;">${quantity}</td>
                <td>${productId}</td>
                <td style="color:#0A5064;font-weight:700px;">${description}</td>
                <td>${quantity}</td>
                <td>${pricePerUnit}</td>
                <td>${totalPrice}</td>
                <td>${discountPercentage || '0.00'}</td>
                <td>${disAmount || '0.00'}</td>
                <td>${extraPer || '0.00'}</td>
                <td>${netAmount}</td>
                <td style="display:none;">${supplier}</td>
                <td style="display:none;">${company}</td>
                <td style="display:none;">${tradePrice}</td>
                <td><button class="btn btn-danger btn-sm delete-row">X</button></td>
            `;

            row.querySelector(".delete-row").addEventListener("click", function() {
                row.remove();
                calculateTotalAmount();
            });

            calculateTotalAmount();

            var rows = document.querySelectorAll("#productsTable tr:not(:first-child)");
            var productData = [];
            rows.forEach(function(row) {
                var cells = row.querySelectorAll("td");
                var product = {
                    productId: cells[1].innerText,
                    description: cells[2].innerText,
                    quantity: cells[3].innerText,
                    pricePerUnit: cells[4].innerText,
                    totalPrice: cells[5].innerText,
                    discountPercentage: cells[6].innerText,
                    disAmount: cells[7].innerText,
                    extraPer: cells[8].innerText,
                    netAmount: cells[9].innerText,
                    supplier: cells[10].innerText,
                    company: cells[11].innerText,
                    tradePrice: cells[12].innerText
                };
                productData.push(product);
            });

            document.getElementById("productData").value = JSON.stringify(productData);

            // Reset product fields after making an entry
            resetProductFields();
            
            
            productInput.focus();
            
        } else {
            alert("Some required fields are missing");
        }
    });

    function resetProductFields() {
        document.getElementById("productInput").value = '';
        document.getElementById("quantity").value = '';
        document.getElementById("retail_price").value = '';
        document.getElementById("total_amount").value = '';
        document.getElementById("percentage").value = '';
        document.getElementById("trade_price").value = '';
        document.getElementById("trade_prices").value = '';
        document.getElementById("dis_amount").value = '';
        document.getElementById("sale_tax").value = '';
        // Remove data attributes for the next product
        document.getElementById("productInput").removeAttribute('data-product-id');
        document.getElementById("productInput").removeAttribute('data-product-quantity');
        document.getElementById("productInput").removeAttribute('data-supplier');
        document.getElementById("productInput").removeAttribute('data-company');
        document.getElementById("productInput").removeAttribute('data-trade-price');
        document.getElementById("productInput").removeAttribute('data-product-unit');
    }

 function calculateTotalAmount() {
    var table = document.getElementById("productsTable");
    var rows = table.getElementsByTagName("tr");
    var total = 0;

    for (var i = 1; i < rows.length; i++) {
        var netAmountCell = rows[i].cells[9];
        var netAmount = parseFloat(netAmountCell.textContent.trim());
        if (!isNaN(netAmount)) {
            total += netAmount;
        }
    }

    var totalInput = document.getElementById("total-input");
    var billAmountInput = document.getElementById("bill-amount");

    totalInput.value = total.toFixed(2);
    billAmountInput.value = total.toFixed(2);

    updateDiscountAmount();
    updateGrandAmount();
}

// Updates discount amount and percent
function updateDiscountAmount() {
    var total = parseFloat(document.getElementById("total-input").value) || 0;
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var discountAmountInput = document.getElementById("discount_amount");
    var discountPercentInput = document.getElementById("discount_percent");

    if (!isNaN(billAmount) && !isNaN(total)) {
        var discountAmount = total - billAmount;
        discountAmountInput.value = Math.round(discountAmount);

        if (total > 0) {
            var discountPercent = (discountAmount / total) * 100;
            discountPercentInput.value = discountPercent.toFixed(2);
        } else {
            discountPercentInput.value = "0.00";
        }
    }
}

// Computes and updates grand total
function updateGrandAmount() {
    var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
    var preAmount = parseFloat(document.getElementById("pre_amount").value) || 0;
    var grandAmountInput = document.getElementById("grand_amount");

    var grandAmount = billAmount + preAmount;
    grandAmountInput.value = grandAmount.toFixed(2);

    calculateCashReturn();
}

// Calculates the change due
function calculateCashReturn() {
    var grandAmount = parseFloat(document.getElementById("grand_amount").value) || 0;
    var cashReceived = parseFloat(document.getElementById("cash_received").value) || 0;
    var cashReturnInput = document.getElementById("cash_return");

    if (!isNaN(grandAmount) && !isNaN(cashReceived)) {
        var cashReturn = grandAmount - cashReceived;
        cashReturnInput.value = cashReturn.toFixed(2);
    }
}

// Event Listeners
function attachInputListener(id, callback) {
    var el = document.getElementById(id);
    if (el) {
        el.addEventListener("input", callback);
    }
}

// Existing listeners
attachInputListener("bill-amount", function () {
    updateDiscountAmount();
    updateGrandAmount();
});

attachInputListener("pre_amount", updateGrandAmount);
attachInputListener("cash_received", calculateCashReturn);

// ✅ NEW: When user types discount amount
attachInputListener("discount_amount", function () {
    const total = parseFloat(document.getElementById("total-input").value) || 0;
    const discountAmount = parseFloat(document.getElementById("discount_amount").value) || 0;

    const newBillAmount = total - discountAmount;
    document.getElementById("bill-amount").value = newBillAmount.toFixed(2);

    const discountPercent = (discountAmount / total) * 100;
    document.getElementById("discount_percent").value = discountPercent.toFixed(2);

    updateGrandAmount();
    calculateCashReturn();
});

// ✅ NEW: When user types discount percent
attachInputListener("discount_percent", function () {
    const total = parseFloat(document.getElementById("total-input").value) || 0;
    const discountPercent = parseFloat(document.getElementById("discount_percent").value) || 0;

    const discountAmount = (discountPercent / 100) * total;
    document.getElementById("discount_amount").value = Math.round(discountAmount);

    const newBillAmount = total - discountAmount;
    document.getElementById("bill-amount").value = newBillAmount.toFixed(2);

    updateGrandAmount();
    calculateCashReturn();
});

// Watch for programmatic changes to pre_amount value
(function watchPreAmount() {
    var preAmountEl = document.getElementById("pre_amount");
    var lastValue = preAmountEl ? preAmountEl.value : null;

    setInterval(function () {
        if (!preAmountEl) return;
        if (preAmountEl.value !== lastValue) {
            lastValue = preAmountEl.value;
            updateGrandAmount();
        }
    }, 300);
})();

// Initial calculation on page load
window.addEventListener("DOMContentLoaded", function () {
    calculateTotalAmount();
    updateGrandAmount();
});
});
</script>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>