<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include("../db/cn.php");
include("common/tx.php");
ob_start();

// Check session
if (!isset($_SESSION['user_name'], $_SESSION['user_role'], $_SESSION['outlet_name'], $_SESSION['outlet_address'])) {
    echo "Session variables not set. Please log in.";
    exit;
}

$userName       = $_SESSION['user_name'];
$userRole       = $_SESSION['user_role'];
$outlet_name    = $_SESSION['outlet_name'];
$outlet_address = $_SESSION['outlet_address'];

$alertScript = ""; // ✅ SweetAlert script store karenge

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect POST safely
    $product_id     = $_POST['product_id']     ?? '';
    $product_name   = $_POST['product_name']   ?? '';
    $company        = $_POST['company']        ?? '';
    $quantity       = $_POST['quantity']       ?? 0;
    $retail_price   = $_POST['retail_price']   ?? 0;
    $percentage     = $_POST['percentage']     ?? 0;
    $ex_percentage  = $_POST['ex_percentage']  ?? 0;
    $wh_percentage  = $_POST['wh_percentage']  ?? 0;
    $trade_price    = $_POST['trade_price']    ?? 0;
    $total_amount   = $_POST['total_amount']   ?? 0;
    $supplier       = $_POST['supplier']       ?? '';
    $product_unit   = $_POST['product_unit']   ?? '';
    $vehicle        = $_POST['size']           ?? '';
    $category       = $_POST['category']       ?? '';
    $bonus_quantity = $_POST['bonus_quantity'] ?? 0;
    $mini_quantity  = $_POST['mini_quantity']  ?? 0;
    $noofunit       = $_POST['noofunit']       ?? 0;
    $rpperpack      = $_POST['rpperpack']      ?? 0;
    $tpperpack      = $_POST['tpperpack']      ?? 0;
    $total_quantity = $_POST['total_quantity'] ?? 0;
    $t_price        = $_POST['t_price']        ?? 0;
    $t_perprice     = $_POST['t_perprice']     ?? 0;
    $batch_no       = $_POST['batch_no']       ?? '';
    $expiry_d       = $_POST['expiry_d']       ?? null;

    $total_purchase = (float)$trade_price * (float)$quantity;
    $date_time      = date("Y-m-d");

    // Check if product_id exists
    $check_sql = "SELECT product_id FROM products WHERE product_id = '$product_id'";
    $check_res = mysqli_query($connection, $check_sql);

    if (mysqli_num_rows($check_res) > 0) {
        // ✅ SweetAlert error for duplicate
        $alertScript = "
            Swal.fire({
                icon: 'error',
                title: 'Duplicate Entry!',
                text: 'Product ID: $product_id and Product Name: $product_name already exist.'
            }).then(() => {
                window.location.href = 'addproduct.php';
            });
        ";
    } else {
        // ✅ Insert into products
        $insert_sql = "INSERT INTO products 
        (product_id, product_name, size, category, company, quantity, retail_price, percentage, ex_percentage, wh_percentage, trade_price, total_amount, bonus_quantity, mini_quantity, noofunit, rpperpack, tpperpack, total_quantity, t_price, t_perprice, total_purchase, product_unit, supplier, batch_no, expiry_d, date_time, login_user, user_role, outlet_name, outlet_address) 
        VALUES (
            '$product_id','$product_name','$vehicle','$category','$company',
            '$quantity','$retail_price','$percentage','$ex_percentage','$wh_percentage',
            '$trade_price','$total_amount','$bonus_quantity','$mini_quantity','$noofunit',
            '$rpperpack','$tpperpack','$total_quantity','$t_price','$t_perprice',
            '$total_purchase','$product_unit','$supplier','$batch_no','$expiry_d',
            '$date_time','$userName','$userRole','$outlet_name','$outlet_address'
        )";

        if (!mysqli_query($connection, $insert_sql)) {
            $alertScript = "
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'Error inserting into products: " . addslashes(mysqli_error($connection)) . "'
                });
            ";
        } else {
            // ✅ Insert into opening_products
            $insert_opening_sql = "INSERT INTO opening_products
            (product_id, product_name, size, category, company, quantity, retail_price, percentage, trade_price, total_amount, bonus_quantity, noofunit, rpperpack, tpperpack, total_quantity, t_price, t_perprice, product_unit, supplier, date_time, login_user, user_role, outlet_name, outlet_address) 
            VALUES (
                '$product_id','$product_name','$vehicle','$category','$company',
                '$quantity','$retail_price','$percentage','$trade_price','$total_amount',
                '$bonus_quantity','$noofunit','$rpperpack','$tpperpack',
                '$total_quantity','$t_price','$t_perprice','$product_unit',
                '$supplier','$date_time','$userName','$userRole','$outlet_name','$outlet_address'
            )";

            if (!mysqli_query($connection, $insert_opening_sql)) {
                $alertScript = "
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Error inserting into opening_products: " . addslashes(mysqli_error($connection)) . "'
                    });
                ";
            } else {
                // ✅ SweetAlert success
                $alertScript = "
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Product saved successfully.',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = 'addproduct.php';
                    });
                ";
            }
        }
    }
}
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
.chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-dark{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-dark:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.form-control{
    font-weight:500;
    color:#000;
}
  </style>

<body id="page-top">

    <div id="wrapper">

        <?php
        include("common/sd.php");
		?>
        <div id="content-wrapper" class="d-flex flex-column">

            <div id="content">

                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

  <?php include('common/log.php'); 
  $s = mysqli_query($connection,"select * from supplier");
  ?>
                    
                </nav>
                
 <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <h3 style="color:#212529; font-weight:700;"> Add Opening Stock</h3>
                
            </div>
        </div>
    </div><br />
    <br />

    <div class="container">
        <div class="row">
    <div class="col-sm-1"></div>
    <div class="col-sm-10">
        <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data">
            
            <div class="row">
                <!-- Left Column -->
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Product ID</label>
                        <input type="text" name="product_id" class="form-control"
                               value="<?php echo str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT); ?>"
                               readonly style="font-weight:700; color:#000;">
                    </div>

                    <div class="form-group">
                        <label>Product Name</label>
                        <input type="text" name="product_name" class="form-control" required>
                    </div>

                    <div class="row">
                        <div class="form-group col-6">
                            <label>Category</label>
                            <input type="text" name="category" class="form-control">
                        </div>
                        <div class="form-group col-6">
                            <label>Company</label>
                            <input type="text" name="company" id="company" class="form-control">
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group col-6">
                            <label>Pack Quantity</label>
                            <input type="number" name="quantity" class="form-control">
                        </div>
                        <div class="form-group col-6">
                            <label>Loose Qty</label>
                            <input type="number" name="bonus_quantity" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Min Quantity</label>
                        <input type="number" name="mini_quantity" id="mini_quantity" class="form-control">
                    </div>

                    <div class="form-group">
                        <label>Sale Price (MRP)</label>
                        <input type="number" step="0.01" name="retail_price" id="retail_price" class="form-control">
                    </div>

                    <input type="hidden" name="t_price" id="t_price">

                    <div class="form-group">
                        <label>% Apply()</label>
                        <input type="number" step="0.01" name="percentage" id="percentage" class="form-control">
                    </div>
                    <div class="row">
                    <div class="form-group col-6">
                        <label>Extra %</label>
                        <input type="number" step="0.01" name="ex_percentage" id="ex_percentage" class="form-control">
                    </div>

                    <div class="form-group col-6">
                        <label>WH %</label>
                        <input type="number" step="0.01" name="wh_percentage" id="wh_percentage" class="form-control">
                    </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Purchase Price</label>
                        <input type="number" step="0.01" name="trade_price" id="trade_price" class="form-control" readonly>
                    </div>

                    <div class="form-group">
                        <label>No. of Unit</label>
                        <input type="number" name="noofunit" id="noofunit" class="form-control">
                    </div>
                    <div class="row">
                    <div class="form-group col-6">
                        <label>Sale Price Per Unit</label>
                        <input type="number" step="0.01" name="rpperpack" id="rpperpack" class="form-control">
                    </div>

                    <input type="hidden" name="t_perprice" id="t_perprice">

                    <div class="form-group col-6">
                        <label>Purchase Price Per Unit</label>
                        <input type="number" step="0.01" name="tpperpack" id="tpperpack" class="form-control">
                    </div>
                    </div>
                    <div class="row">
                    <div class="form-group col-6">
                        <label>Total Quantity</label>
                        <input type="number" name="total_quantity" id="total_quantity" class="form-control" readonly>
                    </div>

                    <div class="form-group col-6">
                        <label>Total Amount</label>
                        <input type="number" step="0.01" name="total_amount" id="total_amount" class="form-control" readonly>
                    </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-6">
                            <label>Supplier</label>
                            <select name="supplier" class="form-control">
                                <option value="">Select</option>
                                <?php
                                 while($sup = mysqli_fetch_array($s)){
                                ?>
                                <option value="<?php echo $sup['supplier_name']; ?>"><?php echo $sup['supplier_name']; ?></option>
                                
                                <?php
                                 }
                                ?>
                                </select>
                        </div>
                        <div class="form-group col-6">
                            <label>Product Unit</label>
                            <select name="product_unit" class="form-control">
                                <option value="">Select Unit</option>
                                <option value="Pcs">Pcs</option>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group col-6">
                            <label>Batch #</label>
                            <input type="text" name="batch_no" class="form-control">
                        </div>
                        <div class="form-group col-6">
                            <label>Expiry</label>
                            <input type="date" name="expiry_d" class="form-control">
                        </div>
                    </div>

                    <!-- Single hidden size field -->
                    <input type="hidden" value="0" name="size">

                    <hr>
                    <button class="btn btn-dark w-100 font-weight-bold" type="submit" >Save Product</button>
                </div>
            </div>
        </form>
    </div>
</div>
            <div class="col-sm-1"></div>
        </div>
           
    
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
    <script>
   document.addEventListener("DOMContentLoaded", function () {
       <?php if (!empty($alertScript)) { echo $alertScript; } ?>
   });
   </script>
<script>
function calculateValues() {
    const packQuantity = parseFloat(document.querySelector('input[name="quantity"]').value) || 0;
    const bonusQuantity = parseFloat(document.querySelector('input[name="bonus_quantity"]').value) || 0;
    let noOfUnit = parseFloat(document.getElementById("noofunit").value) || 1;

    const baseSalePrice = parseFloat(document.getElementById("retail_price").value) || 0;
    const whPercentage = parseFloat(document.getElementById("wh_percentage").value) || 0;
    const percentage = parseFloat(document.getElementById("percentage").value) || 0;
    const exPercentage = parseFloat(document.getElementById("ex_percentage").value) || 0;

    noOfUnit = noOfUnit > 0 ? noOfUnit : 1;

    const totalQuantity = (packQuantity * noOfUnit) + bonusQuantity;
    document.getElementById("total_quantity").value = totalQuantity;

    // Step 1: Subtract percentage from baseSalePrice
    let afterPercentage = baseSalePrice - (baseSalePrice * percentage / 100);

    // Step 2: Add whPercentage on BASE retail_price (not discounted)
    let afterWh = afterPercentage + (baseSalePrice * whPercentage / 100);

    // Step 3: Subtract exPercentage from afterWh
    let finalPrice = afterWh - (afterWh * exPercentage / 100);

    const tradePrice = finalPrice;

    const salePricePerUnit = (baseSalePrice / noOfUnit).toFixed(2);
    document.getElementById("rpperpack").value = salePricePerUnit;

    const purchasePricePerUnit = (tradePrice / noOfUnit).toFixed(2);
    document.getElementById("tpperpack").value = purchasePricePerUnit;

    const totalAmount = (totalQuantity * (tradePrice / noOfUnit)).toFixed(2);
    document.getElementById("total_amount").value = totalAmount;

    document.getElementById("trade_price").value = tradePrice.toFixed(2);
}

function calculateTradePriceFromPercentage() {
    const baseSalePrice = parseFloat(document.getElementById("retail_price").value) || 0;
    const whPercentage = parseFloat(document.getElementById("wh_percentage").value) || 0;
    const percentage = parseFloat(document.getElementById("percentage").value) || 0;
    const exPercentage = parseFloat(document.getElementById("ex_percentage").value) || 0;

    let afterPercentage = baseSalePrice - (baseSalePrice * percentage / 100);
    let afterWh = afterPercentage + (baseSalePrice * whPercentage / 100);
    let finalPrice = afterWh - (afterWh * exPercentage / 100);

    document.getElementById("trade_price").value = finalPrice.toFixed(2);
    calculateValues();
}

let percentageTimer;
document.getElementById("percentage").addEventListener("input", () => {
    clearTimeout(percentageTimer);
    percentageTimer = setTimeout(() => {
        calculateTradePriceFromPercentage();
    }, 500);
});

document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('input').forEach(input => {
        input.addEventListener('input', calculateValues);
    });
});
</script>
   
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>